/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CircleBookCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ICircleBookCellHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsNormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.NormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IFindInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;

public class FindNormalInfo
implements IFindInfo {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindNormalInfo.class);
    private DBHandler dao;

    public FindNormalInfo(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsNormalBasePoint.class).is(basePoint);
    }

    public <T> Collection<T> parse(Sheet sheet, int[] startPos, int[] endPos, IBasePoint basePoint, final IInfoHandler<T> handler) {
        new CircleBookCell().circle(sheet, startPos, endPos, new ICircleBookCellHandler(){

            @Override
            public int cell(Book book, Sheet sheet, Cell cell) {
                if (cell.getSheet() == null) {
                    return 0;
                }
                Object itemFormula = cell.getUserObjectValue("ITEM");
                if (!(itemFormula instanceof ItemFormula)) {
                    return 0;
                }
                ItemFormula itemFormulaInfo = (ItemFormula)itemFormula;
                if (!handler.checkItemFormula(itemFormulaInfo)) {
                    return 0;
                }
                handler.put(itemFormulaInfo, null, cell, null);
                return 0;
            }
        });
        return handler.infos();
    }

    @Override
    public <T> Collection<T> parse(IBasePoint basePoint, IInfoHandler<T> handler) {
        NormalBasePoint normalBasePoint = (NormalBasePoint)basePoint;
        if (normalBasePoint.getSheet() == null) {
            return new ArrayList();
        }
        return this.parse(normalBasePoint.getSheet(), new int[]{normalBasePoint.getStartRow(), normalBasePoint.getStartCol()}, new int[]{normalBasePoint.getEndRow(), normalBasePoint.getEndCol()}, basePoint, handler);
    }

    protected FormulaSchemeInfo create(Cell cell, Object itemFormula) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        if (scheme == null) {
            return null;
        }
        return scheme;
    }
}

