/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FindBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.EliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IReportEntity;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillSheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAsstData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.BuildElimItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.BuildElimValueFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationAsstNum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationItemKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoFillElimSheet
implements IFillSheet {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", AutoFillElimSheet.class);
    private DBHandler dao;

    public AutoFillElimSheet(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public Map<AutoItemItemFormula, Cell> exec(FormulaCalcContextInfo calcContext, OrgUnitInfo company, IReportEntity report, Sheet sheet) throws BOSException {
        HashMap<AutoItemItemFormula, Cell> returnItemFormulas = new HashMap<AutoItemItemFormula, Cell>();
        this.exec(company, report, sheet, returnItemFormulas);
        return returnItemFormulas;
    }

    public void exec(OrgUnitInfo company, IReportEntity report, Sheet sheet, Map<AutoItemItemFormula, Cell> returnItemFormulas) throws BOSException {
        FindBasePoint find = new FindBasePoint(report);
        find.limitScanBasePointTypes(new Class[]{EliminationBasePoint.class});
        List<IBasePoint> basePoints = find.scan(sheet);
        if (basePoints.isEmpty()) {
            return;
        }
        EliminationBasePoint elimBasePoint = null;
        for (IBasePoint basePoint : basePoints) {
            if (!(basePoint instanceof EliminationBasePoint)) continue;
            elimBasePoint = (EliminationBasePoint)basePoint;
            try {
                this.fill(company, elimBasePoint, returnItemFormulas);
            }
            catch (EASBizException e) {
                LOG.error("elimination's base point fill fail.company:{0},report: {1},sheet:{2},basepoint:({3},{4})", new Object[]{company.getName(), report, elimBasePoint.getSheet(), elimBasePoint.getRow(), elimBasePoint.getCol()});
            }
        }
    }

    public void fill(OrgUnitInfo company, EliminationBasePoint basePoint, Map<AutoItemItemFormula, Cell> returnItemFormulas) throws EASBizException, BOSException {
        int spreadStyle = 0;
        Sheet sheet = basePoint.getSheet();
        Cell cell = null;
        Cell valueFormulaCell = null;
        int[] valueFormulaPos = null;
        ItemFormula itemFormula = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        int[] pos = new int[]{basePoint.getRow(), basePoint.getCol()};
        ArrayList<ItemFormula> itemFormulas = new ArrayList<ItemFormula>();
        ArrayList<String> valueFormulas = new ArrayList<String>();
        String BLANK_FORMULA = "";
        while ((cell = sheet.getCell((pos = nextCell.circle(pos, spreadStyle, true))[0], pos[1], false)) != null && (itemFormula = CellUtil.getItemFormula(cell)) != null && itemFormula.getFormula() != null) {
            itemFormulas.add(itemFormula);
            LOG.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            valueFormulaPos = nextCell.circle(pos, spreadStyle, false);
            valueFormulaCell = sheet.getCell(valueFormulaPos[0], valueFormulaPos[1], false);
            if (valueFormulaCell == null || valueFormulaCell.getFormula() == null || BLANK_FORMULA.equals(valueFormulaCell.getFormula()) || !valueFormulaCell.getFormula().toUpperCase().startsWith("=ACCTAC")) {
                LOG.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                valueFormulas.add(BLANK_FORMULA);
                continue;
            }
            valueFormulas.add(valueFormulaCell.getFormula());
        }
        int fillPosRow = basePoint.getRow() + 1;
        int fillPosCol = basePoint.getCol();
        String itemKey = new GetEliminationItemKey().exec(basePoint.getEnvParam().getReportClass());
        String asstNum = new GetEliminationAsstNum().exec(itemKey);
        BuildElimItemFormula buildEItemFormula = ActionFactory.get(BuildElimItemFormula.class);
        BuildElimValueFormula replaceValueFormula = ActionFactory.get(BuildElimValueFormula.class);
        List<AsstActObject> asstObjs = new QueryAsstData(this.dao, company, new DynaParameters()).exec(asstNum);
        QueryDataElement queryDataElement = new QueryDataElement(this.dao);
        Map<String, Integer> allDataElements = queryDataElement.exec();
        Cell fillCell = null;
        Cell nameCell = null;
        Cell asstCell = null;
        AsstActObject asstObj = null;
        String elimItemFormula = null;
        HashSet<String> existAsstObjIds = new HashSet<String>();
        int asstIndex = 0;
        int asstSize = asstObjs.size();
        while (asstIndex < asstSize) {
            block7: {
                block9: {
                    block8: {
                        asstObj = asstObjs.get(asstIndex);
                        if (existAsstObjIds.contains(asstObj.getId())) break block7;
                        fillCell = sheet.getCell(fillPosRow, fillPosCol, false);
                        if (fillCell != null) break block8;
                        CellUtil.insertRow(fillPosRow, sheet);
                        fillCell = sheet.getCell(fillPosRow, fillPosCol, true);
                        break block9;
                    }
                    if (this.checkExistFilledCell(fillCell, existAsstObjIds)) break block7;
                }
                nameCell = fillCell;
                this.fillNameCellAndItemFormula(nameCell, asstObj);
                String cellValueformulas = null;
                String cellItemFormula = null;
                int formulaSize = valueFormulas.size();
                for (int formulaIndex = 0; formulaIndex < formulaSize; ++formulaIndex) {
                    cellValueformulas = (String)valueFormulas.get(formulaIndex);
                    asstCell = sheet.getCell(fillPosRow, nameCell.getCol() + 1 + formulaIndex, true);
                    sheet.getRange(asstCell).setIgnoreProtected(true);
                    asstCell.setFormula(replaceValueFormula.exec(cellValueformulas, asstObj.getNumber()));
                    sheet.getRange(asstCell).setIgnoreProtected(false);
                    cellItemFormula = ((ItemFormula)itemFormulas.get(formulaIndex)).getFormula();
                    elimItemFormula = buildEItemFormula.exec(itemKey, cellItemFormula, asstObj.getId());
                    returnItemFormulas.put(new AutoItemItemFormula(elimItemFormula, allDataElements), asstCell);
                }
            }
            ++asstIndex;
            ++fillPosRow;
        }
    }

    private boolean checkExistFilledCell(Cell fillCell, Set<String> existAsstObjIds) {
        ItemFormula itemFormula = (ItemFormula)fillCell.getUserObjectValue("ITEM");
        if (itemFormula == null || itemFormula.getExt("16") == null) {
            return false;
        }
        existAsstObjIds.add(itemFormula.getExt("16"));
        return false;
    }

    protected void fillNameCellAndItemFormula(Cell nameCell, AsstActObject asstObj) {
        nameCell.getSheet().getRange(nameCell).setIgnoreProtected(true);
        nameCell.setValue(new Variant((Object)(asstObj.getNumber() + "-" + asstObj.getName())));
        ItemFormula itemFormula = new ItemFormula();
        itemFormula.putExt("16", asstObj.getId());
        nameCell.setUserObject("ITEM", (Object)itemFormula);
        nameCell.getSheet().getRange(nameCell).setIgnoreProtected(false);
    }
}

