/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ExcelCalcMethod;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CalculateExcelFormula {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CalculateExcelFormula.class);
    private static final Map<String, ExcelCalcMethod> calcFormulas = new HashMap<String, ExcelCalcMethod>();

    protected static void initCalcExcelMethod() {
        Method[] methods = ExcelFuncProvider.class.getMethods();
        ExcelFuncProvider funcProvider = new ExcelFuncProvider();
        ExcelCalcMethod excelMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            excelMethod = calcFormulas.containsKey(m.getName()) ? calcFormulas.get(m.getName()) : new ExcelCalcMethod(m.getName(), funcProvider);
            excelMethod.addMethod(m);
            calcFormulas.put(m.getName().toUpperCase(), excelMethod);
        }
    }

    public void exec(Map<String, SortedParameterArray> methods) {
        SortedParameterArray params = null;
        ExcelCalcMethod calcExcelMethod = null;
        String formulaName = null;
        for (Map.Entry<String, SortedParameterArray> method : methods.entrySet()) {
            formulaName = method.getKey().toUpperCase();
            if (!CalculateExcelFormula.isExcelFormula(formulaName)) continue;
            params = method.getValue();
            calcExcelMethod = calcFormulas.get(formulaName);
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                try {
                    Object[] args = ((Parameter)params.get(i)).getArgs();
                    for (int j = 0; j < args.length; ++j) {
                        if (!(args[j] instanceof Variant) || !(((Variant)args[j]).getValue() instanceof IFormula)) continue;
                        ((Variant)args[j]).setObject(((IFormula)((Variant)args[j]).getValue()).getResult());
                    }
                    Object result = calcExcelMethod.run((Parameter)params.get(i));
                    if (result instanceof Variant) {
                        result = ((Variant)result).getValue();
                    }
                    ((Parameter)params.get(i)).setValue(result);
                    continue;
                }
                catch (InvocationTargetException e) {
                    LOG.info("excel formula 's calculate error.{0}", new Object[]{params.get(i)});
                }
            }
        }
    }

    public static boolean isExcelFormula(String methodName) {
        if (methodName == null) {
            return false;
        }
        return calcFormulas.containsKey(methodName.toUpperCase());
    }

    static {
        CalculateExcelFormula.initCalcExcelMethod();
    }
}

