/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ExcelCalcMethod {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ExcelCalcMethod.class);
    protected String methodName;
    protected Set<Method> runMethods = new HashSet<Method>();
    protected Object invokeObj;

    public ExcelCalcMethod(String methodName, Object invokeObj) {
        this.methodName = methodName;
        this.invokeObj = invokeObj;
    }

    public Object run(Parameter param) throws InvocationTargetException {
        Object[] paramObjs = param.getArgs();
        try {
            for (Method runMethod : this.runMethods) {
                if (runMethod.getParameterTypes().length == 1 && runMethod.getParameterTypes()[0].isAssignableFrom(paramObjs.getClass())) {
                    return runMethod.invoke(this.invokeObj, new Object[]{paramObjs});
                }
                if (runMethod.getParameterTypes().length != paramObjs.length) continue;
                Class[] paramObjTypes = new Class[paramObjs.length];
                boolean match = true;
                int size = paramObjTypes.length;
                for (int i = 0; i < size; ++i) {
                    if (runMethod.getParameterTypes()[i].isAssignableFrom(paramObjs[i].getClass())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return runMethod.invoke(this.invokeObj, paramObjs);
            }
        }
        catch (Exception e) {
            LOG.error("", e);
            throw new InvocationTargetException(e);
        }
        throw new InvocationTargetException(new RuntimeException("Error"));
    }

    public void addMethod(Method m) {
        this.runMethods.add(m);
    }
}

