/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class QueryItemValueTable {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryItemValueTable.class);
    private DBHandler dao;

    public QueryItemValueTable(DBHandler dao) {
        this.dao = dao;
    }

    public Map<String, String> exec(Collection<String> rptItemNums) throws BOSException {
        HashMap<String, String> items = new HashMap<String, String>(rptItemNums.size());
        if (rptItemNums.isEmpty()) {
            return items;
        }
        FileSQL queryFieldInfoSql = new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/queryItemTableInfo.sql");
        String sql = MessageFormat.format(queryFieldInfoSql.sql(), StringUtil.getSQLVariable(rptItemNums.size()));
        IRowSet rs = this.dao.getExecuteSQL().executeQuery(sql, rptItemNums.toArray());
        String tableName = null;
        String fieldName = null;
        String itemNumber = null;
        try {
            while (rs.next()) {
                tableName = rs.getString("TABLE_NAME");
                fieldName = rs.getString("FIELD_NAME");
                itemNumber = rs.getString("ITEM_NUMBER");
                items.put(itemNumber, tableName + "." + fieldName);
            }
            if (items.isEmpty()) {
                LOG.info("report item number({0}) is unValid.", new Object[]{rptItemNums});
                return null;
            }
            if (items.size() != rptItemNums.size()) {
                HashSet<String> missTableInfosItems = new HashSet<String>(rptItemNums.size() - items.size());
                for (String itemNum : rptItemNums) {
                    if (items.containsKey(itemNum)) continue;
                    missTableInfosItems.add(itemNum);
                }
                LOG.info("report item number({0}) is unValid.", new Object[]{missTableInfosItems});
            }
            return items;
        }
        catch (SQLException e) {
            LOG.error("", e);
            throw new SQLDataException(e);
        }
    }
}

