/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IQueryItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.ElimEntryItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.SplitedElimEntryItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.CircleSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryElimItemData
implements IQueryItem<ElimEntryItemQueryUnit> {
    private static final ILog LOG = LogFactory.getLog("AUTO_ITEM", QueryElimItemData.class);
    private DBHandler dao;

    public QueryElimItemData(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public Map<ElimEntryItemQueryUnit, ItemResult> queryValues(Set<ElimEntryItemQueryUnit> rptQueryInfos, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        HashMap<ElimEntryItemQueryUnit, ItemResult> itemValues = new HashMap<ElimEntryItemQueryUnit, ItemResult>();
        if (rptQueryInfos.isEmpty()) {
            return itemValues;
        }
        HashSet<String> rptItemNums = new HashSet<String>();
        HashMap<String, Collection<ElimEntryItemQueryUnit>> itemNum2QueryUnit = new HashMap<String, Collection<ElimEntryItemQueryUnit>>();
        ObjectMatcher<ElimEntryItemQueryUnit> itemMatcher = new ObjectMatcher<ElimEntryItemQueryUnit>();
        for (ElimEntryItemQueryUnit queryUnit : rptQueryInfos) {
            rptItemNums.add(queryUnit.getNumber());
            if (!itemNum2QueryUnit.containsKey(queryUnit.getType() + "|" + queryUnit.getNumber())) {
                itemNum2QueryUnit.put(queryUnit.getType() + "|" + queryUnit.getNumber(), new HashSet(5));
            }
            ((Collection)itemNum2QueryUnit.get(queryUnit.getType() + "|" + queryUnit.getNumber())).add(queryUnit);
            itemMatcher.add(queryUnit, new Object[]{queryUnit.getOrgUnit().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getCurrency().getId().toString(), queryUnit.getYear(), queryUnit.getPeriod(), queryUnit.getDataElement(), queryUnit.getNumber()});
        }
        Collection<SuperSQL> executeSqls = this.buildSqls(itemNum2QueryUnit, fixedSourceTypes);
        String sql = null;
        for (SuperSQL executeSql : executeSqls) {
            try {
                sql = executeSql.sql();
                LOG.debug("query item's sql:\n{0}", new Object[]{sql});
                IRowSet dataRs = this.dao.getExecuteSQL().executeQuery(sql, executeSql.params());
                if (dataRs.size() == 0) {
                    LOG.debug("no item value be queryed with sql:{0}/*param:{1}*/", new Object[]{sql, executeSql.params()});
                    continue;
                }
                while (dataRs.next()) {
                    this.matchData(itemValues, itemMatcher, dataRs);
                }
            }
            catch (SQLException e) {
                LOG.error("", e);
                throw new SQLDataException(e);
            }
            finally {
                executeSql.clear();
            }
        }
        return itemValues;
    }

    protected void matchData(Map<ElimEntryItemQueryUnit, ItemResult> itemValues, ObjectMatcher<ElimEntryItemQueryUnit> itemMatcher, IRowSet dataRs) throws SQLException {
        Set<ElimEntryItemQueryUnit> finds = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        ItemResult preResult = null;
        boolean debitOrCredit = true;
        finds = itemMatcher.get(new Object[]{dataRs.getString("forgunit"), dataRs.getInt("fperiodType"), dataRs.getString("fCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getString("FItemNumber")});
        if (finds != null) {
            if (finds.size() > 1) {
                LOG.debug("too many matcher exception.", new Object[0]);
            }
            newValue = dataRs.getBigDecimal("debit_value");
            debitOrCredit = true;
            if (newValue == null) {
                newValue = dataRs.getBigDecimal("credit_value");
                debitOrCredit = false;
            }
            sourceType = dataRs.getInt("sourceType");
            for (ElimEntryItemQueryUnit find : finds) {
                SplitedElimEntryItemQueryUnit newQueryUnit = new SplitedElimEntryItemQueryUnit(find);
                preResult = new HandleMultiItemValue().newResult(newValue, sourceId, sourceType);
                preResult.setDebitOrCredit(debitOrCredit);
                itemValues.put(newQueryUnit, preResult);
            }
        }
    }

    public Collection<SuperSQL> buildSqls(Map<String, Collection<ElimEntryItemQueryUnit>> itemNum2QueryUnit, Collection<Integer> fixedSourceTypes) {
        Collection<ElimEntryItemQueryUnit> queryUnits = null;
        HashSet<SuperSQL> sqls = new HashSet<SuperSQL>();
        SuperSQL sql = null;
        String sourceTypeCondition = "";
        if (!fixedSourceTypes.isEmpty()) {
            sourceTypeCondition = " and entry.FDataSource in ( " + StringUtil.toSql(fixedSourceTypes, false) + " ) ";
        }
        for (String itemKey : itemNum2QueryUnit.keySet()) {
            queryUnits = itemNum2QueryUnit.get(itemKey);
            for (ElimEntryItemQueryUnit queryUnit : queryUnits) {
                if (sql != null && ((CircleSQL)sql.getFormats().get(0)).params().length > 1000) {
                    sqls.add(sql);
                    sql = null;
                }
                if (sql == null) {
                    sql = new SuperSQL(this.defineMainQuerySQL());
                    CircleSQL subSql2 = new CircleSQL(this.defineCircleEntrySQL());
                    subSql2.setJoinChar("or");
                    subSql2.setWithBlockChar(true);
                    sql.set(new Object[]{subSql2, sourceTypeCondition}, new Object[0]);
                }
                Object[] whereFormat = new Object[]{queryUnit.getChecked() == null ? "" : "and e.fcheckedStatus = " + (queryUnit.getChecked() != false ? 2 : 1)};
                ((CircleSQL)sql.getFormats().get(0)).add(whereFormat, new Object[]{queryUnit.getOrgTree().getId().toString(), queryUnit.getOrgUnit().getId().toString(), queryUnit.getNumber(), queryUnit.getValueType().getValue(), queryUnit.getDataElement(), queryUnit.getCurrency().getId().toString(), queryUnit.getPeriodType().getValue(), queryUnit.getYear(), queryUnit.getPeriod()});
            }
            if (sql == null) continue;
            sqls.add(sql);
        }
        return sqls;
    }

    protected String defineCircleEntrySQL() {
        return new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/item/csl/queryElimItemData_circle_condition.sql").sql();
    }

    protected String defineMainQuerySQL() {
        return new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/item/csl/queryElimItemData.sql").sql();
    }

    @Override
    public ItemResult queryValue(ElimEntryItemQueryUnit rptQueryInfo, Collection<Integer> fixedSourceTypes, OrgType orgType) throws BOSException {
        return null;
    }
}

