/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckAndSupplyTemplateForFormulaCalc;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FindBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindDynaArfiFillClassificInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindDynaArficFillNormalInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindDynaBaseFillInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindEliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindNormalInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoStrategy;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.LinkedList;
import java.util.List;

public class QueryItemDefineFromTemplate<T> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QueryItemDefineFromTemplate.class);
    protected DBHandler dao;
    private IInfoStrategy<T> infoStrategy;

    public QueryItemDefineFromTemplate(DBHandler dao, IInfoStrategy<T> infoStrategy) {
        this.dao = dao;
        this.infoStrategy = infoStrategy;
    }

    public List<T> action(TemplateInfo template) throws EASBizException, BOSException {
        LOG.info("start check template");
        new CheckAndSupplyTemplateForFormulaCalc(this.dao).exec(template);
        QuerySheetParams querySheetParams = new QuerySheetParams(this.dao);
        List<IBasePoint> itemFormulaAreaes = new FindBasePoint(new ReportEntityForTemplate(template, querySheetParams)).scan();
        LOG.info("find {0} base point {1}", new Object[]{itemFormulaAreaes.size(), itemFormulaAreaes});
        this.emptyDataHandle(itemFormulaAreaes.isEmpty(), template);
        FindNormalInfo findNormal = new FindNormalInfo(this.dao);
        FindEliminationInfo findElimination = new FindEliminationInfo(this.dao);
        FindDynaBaseFillInfo findDynaBaseFill = new FindDynaBaseFillInfo(this.dao);
        FindDynaArfiFillClassificInfo findDynaArfiFillClassificInfo = new FindDynaArfiFillClassificInfo(this.dao);
        FindDynaArficFillNormalInfo findDynaArficFillNormalInfo = new FindDynaArficFillNormalInfo(this.dao);
        LinkedList<T> schemes = new LinkedList<T>();
        for (IBasePoint point : itemFormulaAreaes) {
            if (findNormal.isMeet(point)) {
                schemes.addAll(findNormal.parse(point, this.infoStrategy.getNormalInfoHandler(this.dao, point)));
                continue;
            }
            if (findElimination.isMeet(point)) {
                schemes.addAll(findElimination.parse(point, this.infoStrategy.getEliminationInfoHandler(this.dao, point)));
                continue;
            }
            if (findDynaBaseFill.isMeet(point)) {
                schemes.addAll(findDynaBaseFill.parse(point, this.infoStrategy.getDynaBaseFillInfoHandler(this.dao, point)));
                continue;
            }
            if (findDynaArfiFillClassificInfo.isMeet(point)) {
                schemes.addAll(findDynaArfiFillClassificInfo.parse(point, this.infoStrategy.getDynaArfiFillClassificInfoHandler(this.dao, point)));
                continue;
            }
            if (!findDynaArficFillNormalInfo.isMeet(point)) continue;
            schemes.addAll(findDynaArficFillNormalInfo.parse(point, this.infoStrategy.getDynaArficFillNormalInfo(this.dao, point)));
        }
        LOG.info("start save formula scheme(size:{0})", new Object[]{new Integer(schemes.size())});
        this.emptyDataHandle(schemes.isEmpty(), template);
        return schemes;
    }

    protected void emptyDataHandle(boolean empty, TemplateInfo template) throws AutoItemException {
        if (!empty) {
            return;
        }
        throw new AutoItemException(AutoItemException.INVALID_FORMULA_DEFINE, new Object[]{template.getName()});
    }
}

