/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.MultiOperationExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ParenthesisExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;

public class CellExprUtil {
    public static boolean isFunctionExpr(Expression expr) {
        if (expr instanceof FunctionExpr) {
            return true;
        }
        if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr;
            return CellExprUtil.isFunctionExpr(binaryExpr.left) || CellExprUtil.isFunctionExpr(binaryExpr.right);
        }
        if (expr instanceof MultiOperationExpr) {
            MultiOperationExpr binaryExpr = (MultiOperationExpr)expr;
            for (int i = 0; i < binaryExpr.getParams().size(); ++i) {
                if (!CellExprUtil.isFunctionExpr(binaryExpr.getParams().get(i))) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof ParenthesisExpr) {
            ParenthesisExpr parenthesisExpr = (ParenthesisExpr)expr;
            return CellExprUtil.isFunctionExpr(parenthesisExpr.operand);
        }
        if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr parenthesisExpr = (UnaryOperationExpr)expr;
            return CellExprUtil.isFunctionExpr(parenthesisExpr.operand);
        }
        return false;
    }

    public static boolean isNumberExpr(Expression expr) {
        if (expr instanceof NumberExpr) {
            return true;
        }
        if (expr instanceof IntExpr) {
            return true;
        }
        if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr;
            return CellExprUtil.isNumberExpr(binaryExpr.left) && CellExprUtil.isNumberExpr(binaryExpr.right);
        }
        return false;
    }

    public static boolean isEmptyExpr(Expression expr) {
        return expr instanceof EmptyArgExpr;
    }

    public static void setCellValue(Cell cell, Expression expr) {
        if (expr instanceof IntExpr) {
            cell.setValue(new Variant(Integer.parseInt(((IntExpr)expr).toString())));
        } else if (expr instanceof NumberExpr) {
            cell.setValue(new Variant(Double.parseDouble(((NumberExpr)expr).toString())));
        } else if (expr instanceof BoolExpr) {
            cell.setValue(new Variant(Boolean.parseBoolean(((BoolExpr)expr).toString())));
        } else if (expr instanceof StringExpr) {
            cell.setValue(new Variant((Object)expr.toString()));
        }
    }
}

