/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogTrace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class LogFactory {
    private static final Logger LOG = Logger.getLogger(LogFactory.class);
    public static final Integer DEBUG = new Integer(1);
    public static final Integer INFO = new Integer(2);
    public static final Integer ERROR = new Integer(3);
    public static final Integer WARN = new Integer(4);
    private static Class<? extends LogTrace> logClass = LogTrace.class;
    private static ILog log;

    public static void set(Class<? extends LogTrace> type) {
        logClass = type;
        log = null;
    }

    public static void set(ILog type) {
        logClass = null;
        log = type;
    }

    public static void reDefault() {
        logClass = LogTrace.class;
    }

    public static ILog getLog(String flag, Class<?> type) {
        if (log != null) {
            return log;
        }
        if (LogTrace.class.equals(logClass)) {
            return new LogTrace(flag, type);
        }
        try {
            Constructor<? extends LogTrace> constructor = logClass.getConstructor(String.class, Class.class);
            constructor.setAccessible(true);
            return constructor.newInstance(flag, type);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return null;
    }
}

