/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.SuperSQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CircleSQL
extends SuperSQL {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CircleSQL.class);
    private String joinChar;
    private boolean withBlockChar;
    private List<SuperSQL> sqls = new ArrayList<SuperSQL>();

    public CircleSQL(String mainSql) {
        super(mainSql);
    }

    public void setJoinChar(String joinChar) {
        this.joinChar = joinChar;
    }

    public void setWithBlockChar(boolean withBlockChar) {
        this.withBlockChar = withBlockChar;
    }

    @Override
    public Object[] params() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (SuperSQL sql : this.sqls) {
            params.addAll(Arrays.asList(sql.params()));
        }
        return params.toArray();
    }

    @Override
    public String sql() {
        StringBuffer allSql = new StringBuffer();
        for (SuperSQL sql : this.sqls) {
            allSql.append(this.joinChar);
            if (this.withBlockChar) {
                allSql.append('(');
            }
            allSql.append(sql.sql());
            if (!this.withBlockChar) continue;
            allSql.append(')');
        }
        String sql = (this.withBlockChar ? "(" : "") + allSql.substring(this.joinChar.length()) + (this.withBlockChar ? ")" : "");
        return sql;
    }

    public void add(Object[] formatParams, Object[] valueParams) {
        SuperSQL subSql = new SuperSQL(this.mainSql);
        subSql.set(formatParams, valueParams);
        this.sqls.add(subSql);
    }

    @Override
    public void clear() {
        super.clear();
        for (SuperSQL sql : this.sqls) {
            sql.clear();
        }
        this.sqls.clear();
        this.sqls = new ArrayList<SuperSQL>();
    }
}

