/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.supersql.IParameterSQL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperSQL
implements IParameterSQL {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", SuperSQL.class);
    protected String mainSql;
    private List<Object> formats = new ArrayList<Object>(0);
    private List<Object> allParams = new ArrayList<Object>(0);
    private Object[] currentParams;
    private List<String> formatAndParamOrder = new ArrayList<String>(0);

    public SuperSQL(String mainSql) {
        this.mainSql = mainSql;
        this.parseFormatAndParamOrder();
    }

    public List<String> parseFormatAndParamOrder() {
        this.formatAndParamOrder.clear();
        Matcher matcher = Pattern.compile("(\\{[0-9]+\\})|(\\?)").matcher(this.mainSql);
        String find = null;
        int formatIndex = 0;
        int paramIndex = 0;
        while (matcher.find()) {
            find = this.mainSql.substring(matcher.start(), matcher.end());
            if (find.matches("\\{[0-9]+\\}")) {
                this.formatAndParamOrder.add("[f]" + paramIndex);
                ++paramIndex;
                continue;
            }
            if (find.matches("(\\?)")) {
                this.formatAndParamOrder.add("[p]" + formatIndex);
                ++formatIndex;
                continue;
            }
            throw new RuntimeException("debug error");
        }
        return this.formatAndParamOrder;
    }

    public void set(Object[] formatParams, Object[] params) {
        this.formats.clear();
        this.formats.addAll(Arrays.asList(formatParams));
        this.currentParams = params;
    }

    @Override
    public String sql() {
        if (this.formats.isEmpty()) {
            return this.mainSql;
        }
        List<Object> formatParams = this.assembleFormatParams();
        return MessageFormat.format(this.mainSql, formatParams.toArray());
    }

    @Override
    public Object[] params() {
        if (this.allParams.isEmpty()) {
            this.assembleParams();
        }
        return this.allParams.toArray();
    }

    protected boolean assembleParams() {
        int formatIndex = -1;
        this.allParams.clear();
        int paramIndex = 0;
        for (String key : this.formatAndParamOrder) {
            if (key.startsWith("[p]")) {
                this.allParams.add(this.currentParams[paramIndex]);
                ++paramIndex;
                continue;
            }
            if (!key.startsWith("[f]")) continue;
            this.allParams.add(key);
        }
        for (Object format : this.formats) {
            ++formatIndex;
            if (format instanceof IParameterSQL) {
                int formatParamsIndex = this.allParams.indexOf("[f]" + formatIndex);
                if (formatParamsIndex == -1) continue;
                int insertIndex = formatParamsIndex;
                for (Object param : ((IParameterSQL)format).params()) {
                    this.allParams.add(insertIndex, param);
                    ++insertIndex;
                }
                this.allParams.remove(insertIndex);
                continue;
            }
            this.allParams.remove("[f]" + formatIndex);
        }
        return true;
    }

    protected List<Object> assembleFormatParams() {
        ArrayList<Object> formatParams = new ArrayList<Object>();
        for (Object format : this.formats) {
            if (format instanceof IParameterSQL) {
                formatParams.add(((IParameterSQL)format).sql());
                continue;
            }
            formatParams.add(format);
        }
        return formatParams;
    }

    public List<Object> getFormats() {
        return this.formats;
    }

    @Override
    public void clear() {
        for (Object format : this.formats) {
            if (!(format instanceof IParameterSQL)) continue;
            ((IParameterSQL)format).clear();
        }
        this.formats.clear();
        this.allParams.clear();
    }
}

