/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustControlFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class AdjustControlFilterUI
extends AbstractAdjustControlFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustControlFilterUI.class);
    private boolean hasLoadInitData;
    private ICSLContext cslCtx = null;
    private String AdjElimRes = "com.kingdee.eas.fi.gr.cslrpt.AdjElimCtrlResource";

    public AdjustControlFilterUI() throws Exception {
        this.initComponent();
    }

    public AdjustControlFilterUI(ICSLContext cslCtx) throws Exception {
        this.cslCtx = cslCtx;
        this.initComponent();
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        }
        return this.cslCtx;
    }

    public void initComponent() throws Exception {
        for (int i = 1; i <= 6; ++i) {
            this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.getEnum((int)i));
        }
        this.cbxPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
        this.cbxPeriodType.setEnabled(false);
        this.initDate();
        this.rptDate.setSupportedEmpty(false);
    }

    private void initDate() throws Exception {
        int[] yp = RPTDateUtil.getRptYearAndPeriod(this.getCSLContext().getCurRptYear(), this.getCSLContext().getCurRptPeriod(), this.getCSLContext().getCurRptPeriodType().getValue(), 0, -1);
        Date periodDate = RPTDateUtil.getPeriodLastDate(yp[0], yp[1], this.getCSLContext().getCurRptPeriodType());
        this.kDSpYear.setEnabled(false);
        this.kDSpPeriod.setEnabled(false);
        this.rptDate.setValue((Object)periodDate);
        this.refreshTimeInfo(periodDate);
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.rptDate.getSqlDate());
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.kDSpYear.setValue((Object)new Integer(times.get(0).toString()));
        this.kDSpPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.rptDate.setValue(times.get(2));
        this.setPeriodForJT13(times);
    }

    private void setPeriodForJT13(List times) throws BOSException {
        String dataCollectNumber;
        DataCollectInfo dataCollect = this.getCSLContext().getCurDataCollect();
        String string = dataCollectNumber = dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA";
        if (dataCollectNumber.equals("ACTUALDATA")) {
            CslRptUtil.setPeriodForJT13(times, (Date)this.rptDate.getValue(), (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem(), this.kDSpPeriod, this.getCSLContext().getCurRptPeriod());
        } else {
            this.kDSpPeriod.setEnabled(false);
            this.kDSpPeriod.setValue((Object)new Integer(times.get(1).toString()));
            CslRptUIUtil.setSpineRange(this.kDSpPeriod, 0, 365);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException, Exception {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.pp.setString("treeID", this.getCSLContext().getCurOrgBound().getId().toString());
        this.pp.setString("orgUnitID", this.getCSLContext().getCurOrgGroup().getId().toString());
        MergeModeEnum mergeType = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound());
        this.pp.setString("mergeType", String.valueOf(mergeType.getValue()));
        this.pp.setString("company", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this.pp.setObject("dataCollect", CSLContextHelper.getCSLContext().getCurDataCollect());
        this.pp.setString("periodType", String.valueOf(this.getCSLContext().getCurRptPeriodType().getValue()));
        for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
            if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != this.getCSLContext().getCurRptPeriodType().getValue()) continue;
            this.cbxPeriodType.setSelectedIndex(j);
        }
        this.initDate();
        this.pp.setString("year", this.kDSpYear.getValue().toString());
        this.pp.setString("period", this.kDSpPeriod.getValue().toString());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
        this.pp.setObject("rptDate", dateFormat.format(this.rptDate.getValue()));
        this.pp.setString("curYear", "0");
        this.pp.setString("curPeriod", "0");
    }

    private void fillDataToUI() throws Exception {
        if (this.pp.containsKey("periodType")) {
            int periodType = Integer.parseInt(this.pp.getString("periodType"));
            for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
                if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != periodType) continue;
                this.cbxPeriodType.setSelectedIndex(j);
            }
        }
        if (this.pp.containsKey("year")) {
            int year = Integer.parseInt(this.pp.getString("year"));
            this.kDSpYear.setValue((Object)new Integer(year));
        }
        if (this.pp.containsKey("period")) {
            int period = Integer.parseInt(this.pp.getString("period"));
            this.kDSpPeriod.setValue((Object)new Integer(period));
        }
        if (this.pp.containsKey("rptDate")) {
            Date date = new SimpleDateFormat("yy-MM-dd").parse(this.pp.getObject("rptDate").toString());
            this.rptDate.setValue((Object)date);
        }
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public RptProperties getCustomCondition() {
        SimpleDateFormat dateFormat;
        Integer selectyear = new Integer(this.kDSpYear.getValue().toString());
        Integer selectperiod = new Integer(this.kDSpPeriod.getValue().toString());
        int defaultyear = selectyear;
        int defaultPeriod = selectperiod;
        try {
            defaultyear = this.getCSLContext().getCurRptYear();
            defaultPeriod = this.getCSLContext().getCurRptPeriod();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (selectyear > defaultyear || selectyear == defaultyear && selectperiod >= defaultPeriod) {
            if ("true".equals(this.pp.getString("ListUIIsopened"))) {
                if (this.pp.getString("year") != null) {
                    this.kDSpYear.setValue((Object)Integer.valueOf(this.pp.getString("year")));
                }
                if (this.pp.getString("period") != null) {
                    this.kDSpPeriod.setValue((Object)Integer.valueOf(this.pp.getString("period")));
                }
                dateFormat = new SimpleDateFormat("yy-MM-dd");
                try {
                    this.rptDate.setValue((Object)dateFormat.parse(this.pp.getObject("rptDate").toString()));
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.AdjElimRes, (String)"Period_Error"));
            SysUtil.abort();
        }
        this.pp.setString("periodType", String.valueOf(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue()));
        this.pp.setString("year", this.kDSpYear.getValue().toString());
        this.pp.setString("period", this.kDSpPeriod.getValue().toString());
        dateFormat = new SimpleDateFormat("yy-MM-dd");
        this.pp.setObject("rptDate", dateFormat.format(this.rptDate.getValue()));
        this.pp.setString("ListUIIsopened", "true");
        this.pp.setString("curYear", "0");
        this.pp.setString("curPeriod", "0");
        return this.pp;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        try {
            this.fillDataToUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.pp = null;
        try {
            this.loadInitData();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

