/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReportServiceFacade;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustEditReportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AdjustEditUI;
import com.kingdee.eas.fi.gr.dynamic.client.DynaRangeProvider;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.RptItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class AdjustEditReportUI
extends AbstractAdjustEditReportUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustEditReportUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private SpreadContext afterAdjustSpreedContainer = null;
    private SpreadContext adjustDataSpreedContainer = null;
    private CurrencyInfo currency = null;
    private CurrencyInfo srcCurrency = null;
    private OrgUnitInfo orgUnit = null;
    private ICSLContext cslCtx = null;
    private boolean changeIsFormF7 = false;
    private boolean changeIsAfterCell = false;
    private boolean changeIsAdjustCell = false;
    private CslReportInfo cslReportInfo = null;
    private boolean isSaveOK = false;
    private boolean isDynamic = false;
    private OrgTreeInfo orgTreeInfo = null;

    public void onShow() throws Exception {
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
        super.onShow();
        int width = this.kDSplitPane1.getWidth() / 2;
        this.kDSplitPane1.setDividerLocation(width);
        this.kDSplitPane1.setResizeWeight(0.5);
    }

    public void onLoad() throws Exception {
        this.cslCtx = (ICSLContext)this.getUIContext().get("cslContext");
        this.orgUnit = (OrgUnitInfo)this.getUIContext().get("orgUnit");
        if (this.orgUnit instanceof CompanyOrgUnitInfo) {
            this.orgUnit = ((CompanyOrgUnitInfo)this.orgUnit).castToFullOrgUnitInfo();
        }
        this.currency = (CurrencyInfo)this.getUIContext().get("currency");
        this.srcCurrency = (CurrencyInfo)this.getUIContext().get("srcCurrency");
        this.orgTreeInfo = this.cslCtx.getCurOrgBound();
        super.onLoad();
        this.afterAdjustSpreedContainer = this.createSpreadContextAddToPanel(this.afterAdjustSpreedContainer, this.AfterAdjustSpreadPanel);
        this.adjustDataSpreedContainer = this.createSpreadContextAddToPanel(this.adjustDataSpreedContainer, this.AdjustDataSpreadPanel);
        this.afterAdjustSpreedContainer.getFacadeManager().setErrorMessageBox(new FacadeManager.IErrorMessageBox(){

            public boolean show(Component parent, String title, String msg, int msgType) {
                if (msgType == 2) {
                    AdjustEditReportUI.this.showWarningMsg(msg);
                } else if (msgType == 0) {
                    AdjustEditReportUI.this.showErrorMsg(msg);
                } else {
                    AdjustEditReportUI.this.showWarningMsg(msg);
                }
                return false;
            }
        });
        this.initReportF7();
        this.addBookListener();
    }

    public void showErrorMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void showWarningMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(Color.yellow);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void addBookListener() {
        this.afterAdjustSpreedContainer.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive() && !AdjustEditReportUI.this.changeIsAfterCell) {
                    AdjustEditReportUI.this.changeIsAfterCell = true;
                    AdjustEditReportUI.this.onSheetActive(AdjustEditReportUI.this.afterAdjustSpreedContainer, AdjustEditReportUI.this.adjustDataSpreedContainer);
                    AdjustEditReportUI.this.changeIsAfterCell = false;
                }
            }
        });
        this.adjustDataSpreedContainer.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive() && !AdjustEditReportUI.this.changeIsAdjustCell) {
                    AdjustEditReportUI.this.changeIsAdjustCell = true;
                    AdjustEditReportUI.this.onSheetActive(AdjustEditReportUI.this.adjustDataSpreedContainer, AdjustEditReportUI.this.afterAdjustSpreedContainer);
                    AdjustEditReportUI.this.changeIsAdjustCell = false;
                }
            }
        });
        this.afterAdjustSpreedContainer.addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (!AdjustEditReportUI.this.changeIsAfterCell) {
                    AdjustEditReportUI.this.changeIsAfterCell = true;
                    AdjustEditReportUI.this.onSheetSelectCellActive(e.getSheet(), AdjustEditReportUI.this.adjustDataSpreedContainer);
                    AdjustEditReportUI.this.changeIsAfterCell = false;
                }
            }
        });
        this.adjustDataSpreedContainer.addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (!AdjustEditReportUI.this.changeIsAdjustCell) {
                    AdjustEditReportUI.this.changeIsAdjustCell = true;
                    AdjustEditReportUI.this.onSheetSelectCellActive(e.getSheet(), AdjustEditReportUI.this.afterAdjustSpreedContainer);
                    AdjustEditReportUI.this.changeIsAdjustCell = false;
                }
            }
        });
    }

    private void onSheetActive(SpreadContext activeSpread, SpreadContext spread) {
        if (!this.changeIsFormF7) {
            String sheetName = activeSpread.getBook().getActiveSheet().getSheetName();
            Book book = spread.getBook();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                book.getISheet(i).setSelected(false);
            }
            spread.getBook().setActiveSheet(spread.getBook().getSheet(sheetName));
        }
        this.setActiveCell(0, 0);
    }

    private void onSheetSelectCellActive(Sheet sheet, SpreadContext spread) {
        Cell activeCell = sheet.getActiveCell();
        if (!this.changeIsFormF7 && activeCell != null) {
            Range range = sheet.getActiveCellRange();
            int rowIndex = activeCell.getRow();
            int colIndex = activeCell.getCol();
            spread.getBook().getActiveSheet().getRange(rowIndex, colIndex).select();
            range.select();
        }
    }

    private SpreadContext createSpreadContextAddToPanel(SpreadContext spreadContext, KDPanel sheetsPanel) {
        if (spreadContext == null) {
            spreadContext = new SpreadContext();
            SpreadManager.registerRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
            final ItemFormulaPanel itemFormulaPanel = new ItemFormulaPanel(spreadContext, false);
            itemFormulaPanel.setEnabled(false);
            itemFormulaPanel.setPanelVisible(false);
            spreadContext.getFacadeManager().getPromptPanel().setRightComponent((JComponent)itemFormulaPanel);
            itemFormulaPanel.setFormulaProvider((IItemFormulaProvider)new RptItemFormulaProvider());
            spreadContext.addSheetChangeListener(new SheetChangeListener(){

                public void changed(SheetChangeEvent e) {
                    itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), 10);
                }
            });
            UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
            ItemDisplayProvider itemDisplayProvider = new ItemDisplayProvider();
            userCellDisplayProvider.setDisplayValueProvider((IDisplayValueProvider)itemDisplayProvider);
            spreadContext.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)userCellDisplayProvider);
            sheetsPanel.setLayout((LayoutManager)new KDLayout());
            sheetsPanel.add((Component)spreadContext, (Object)new KDLayout.Constraints(0, 0, 530, 628, 325));
        }
        return spreadContext;
    }

    private void initReportF7() throws BOSException {
        this.adjustReportF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.CSLReportF7Query");
        this.adjustReportF7.setEditFormat("$name$");
        this.adjustReportF7.setDisplayFormat("$name$");
        this.adjustReportF7.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currency.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)this.srcCurrency.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.cslCtx.getCurRptYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.cslCtx.getCurRptPeriod()));
        filter.getFilterItems().add(new FilterItemInfo("adjustStatus", (Object)0));
        if (this.getUIContext().get("isFromCompanyEdit") == null && this.getUIContext().get("isFromAdjustWorkTableEdit") == null) {
            filter.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)3));
        }
        filter.getFilterItems().add(new FilterItemInfo("sourceType", this.getUIContext().get("rptType"), CompareType.INCLUDE));
        try {
            if (this.orgTreeInfo != null && this.orgTreeInfo.getId() != null) {
                String orgTreeid = this.orgTreeInfo.getId().toString();
                filter.mergeFilter(new FilterInfo("CSLREPORT.id in (select freportid from t_csl_rptreceived where forgtreeid='" + orgTreeid + "')"), "and");
            }
            filter.mergeFilter(new FilterInfo("CSLREPORT.id in (select freportid from t_rpt_rptsheetpara where freportclass=1 )"), "and");
        }
        catch (Exception e) {
            logger.error((Object)"initReportF7 error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        evi.setFilter(filter);
        this.adjustReportF7.setEntityViewInfo(evi);
        this.adjustReportF7.setEnabledMultiSelection(false);
        this.adjustReportF7.setMyCommonUseEnabled(false);
        this.adjustReportF7.setHistoryRecordEnabled(false);
        this.adjustReportF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (eventObj.getNewValue() == null) {
                        SysUtil.abort();
                    }
                    AdjustEditReportUI.this.changeIsFormF7 = true;
                    AdjustEditReportUI.this.adjustReportF7DataChange((CslReportInfo)eventObj.getNewValue());
                    AdjustEditReportUI.this.changeIsFormF7 = false;
                }
                catch (Exception e) {
                    if (e instanceof ServerException) {
                        MsgBox.showError((String)((ServerException)((Object)e)).getMessage());
                    }
                    logger.error((Object)"adjust Report F7 change error", (Throwable)e);
                }
            }
        });
    }

    private boolean isDynaReport(CslReportInfo cslReportInfo) {
        return RptSrcTypeEnum.DYNAMICNORMALREPORT.getValue() == cslReportInfo.getSourceType().getValue() || RptSrcTypeEnum.DYNAMICSUMREPORT.getValue() == cslReportInfo.getSourceType().getValue() || RptSrcTypeEnum.DYNAMICCSLREPORT.getValue() == cslReportInfo.getSourceType().getValue();
    }

    private Book initAfterAdjustBook(CslReportInfo cslReport, boolean calc, String calcSheetName) throws Exception {
        int i;
        if (cslReport == null) {
            return null;
        }
        HashMap<String, Protection> proSheets = new HashMap<String, Protection>();
        HashMap<String, String> proPassMap = new HashMap<String, String>();
        this.isDynamic = this.isDynaReport(cslReport);
        this.cslReportInfo = this.getAfterAdjustReportBook(cslReport.getId(), calcSheetName);
        Book book = this.cslReportInfo.getCatchBook();
        if (book == null) {
            return null;
        }
        book.setAutoCalculate(false);
        if (calc) {
            this.registerFormulaAndCalcBook(this.cslReportInfo.getCatchBook());
        }
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        for (i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            SheetOption so = sheet.getSheetOption();
            so.setCellDisplayMode(0);
            Protection pro = sheet.getSheetOption().getProtection(false);
            String proPass = null;
            if (pro == null || !pro.isProtected()) continue;
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
            pro.setOperations(2079);
            proSheets.put(sheet.getSheetName(), pro);
            proPassMap.put(sheet.getSheetName(), proPass);
        }
        if (this.isDynamic) {
            // empty if block
        }
        book.setAutoCalculate(false);
        book.setActiveSheet(0);
        for (i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            sheet.setEnableCalculation(true);
            if (proSheets.get(sheet.getSheetName()) == null) continue;
            ((Protection)proSheets.get(sheet.getSheetName())).startWithEncryptedPassword((String)proPassMap.get(sheet.getSheetName()));
        }
        this.afterAdjustSpreedContainer.setBook(book);
        return book;
    }

    private void adjustReportF7DataChange(CslReportInfo f7CslReport) throws Exception {
        String msg = EASResource.getString((String)this.resClassName, (String)"114_adjustDataReportHasDataSelectReport");
        int flag = this.hasNoSaveDataIsContinue(msg);
        if (0 == flag) {
            this.saveData();
        } else if (2 == flag) {
            SysUtil.abort();
        }
        this.isSaveOK = false;
        Book book = this.initAfterAdjustBook(f7CslReport, true, null);
        this.setAdjustDataSpreedContainerBook(book);
    }

    private CslReportInfo getAfterAdjustReportBook(BOSUuid cslReportId, String calcSheetName) throws Exception {
        ICslReportServiceFacade bizInterface = CslReportServiceFacadeFactory.getRemoteInstance();
        OrgTreeInfo orgTreeInfo = this.cslCtx.getCurOrgBound();
        if (this.getUIContext().get("isFromCompanyEdit") != null || this.getUIContext().get("isFromAdjustWorkTableEdit") != null) {
            orgTreeInfo.put("isFromAdjustCompany", (Object)true);
        }
        CslReportInfo cslReportInfo = bizInterface.getAfterAdjustReportCslReportInfo(cslReportId.toString(), orgTreeInfo, false);
        cslReportInfo.setOrgTree(this.cslCtx.getCurOrgBound());
        cslReportInfo.setCompany(this.orgUnit);
        cslReportInfo.setOrgType(OrgType.Company);
        cslReportInfo.setId(cslReportId);
        return cslReportInfo;
    }

    private void setAdjustDataSpreedContainerBook(Book book) throws Exception {
        Book adjustBook = SpreadHelper.copyBook((Book)book);
        for (int i = 0; i < adjustBook.getSheetCount(); ++i) {
            Sheet sheet = adjustBook.getSheet(i);
            Protection pro = sheet.getSheetOption().getProtection(false);
            String proPass = null;
            if (pro == null || !pro.isProtected()) continue;
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
        }
        if (this.isDynamic) {
            this.clearAdjustDataSpreedContainerBookForDyna(adjustBook, false);
        } else {
            this.clearAdjustDataSpreedContainerBookForNor(adjustBook);
        }
        adjustBook.setAutoCalculate(true);
        this.adjustDataSpreedContainer.setBook(adjustBook);
    }

    private void clearAdjustDataSpreedContainerBookForNor(Book book) throws Exception {
        int maxRowIndex = 0;
        int maxColIndex = 0;
        Sheet sheet = null;
        ItemFormula itemFormula = null;
        Cell cell = null;
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            maxRowIndex = sheet.getMaxRowIndex() + 1;
            maxColIndex = sheet.getMaxColIndex() + 1;
            for (int j = 0; j < maxRowIndex; ++j) {
                for (int j2 = 0; j2 < maxColIndex; ++j2) {
                    cell = sheet.getCell(j, j2, false);
                    itemFormula = UserObjectHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null) continue;
                    cell.setValue(new Variant(null));
                    cell.setFormula(null);
                }
            }
        }
    }

    private void clearAdjustDataSpreedContainerBookForDyna(Book book, boolean onlyIsNotAcctItem) throws Exception {
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        ArrayList basePointList = null;
        Point basePoint = null;
        Point endPoint = null;
        DynaRangeProvider dynaRangeProvider = new DynaRangeProvider();
        Range clearValueRange = null;
        Range clearFormulaRange = null;
        String firstFormula = null;
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            DynaParameters parameters = null;
            for (int j = 0; j < basePointList.size(); ++j) {
                basePoint = (Point)basePointList.get(j);
                parameters = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
                endPoint = dynaRangeProvider.getDynaRange(sheet, basePoint);
                int startRow = basePoint.y + 1;
                int startCol = basePoint.x + 1;
                clearValueRange = sheet.getRange(startRow, basePoint.x + 1, endPoint.y < startRow ? startRow : endPoint.y, endPoint.x < startCol ? startCol : endPoint.x);
                firstFormula = sheet.getRange(basePoint.y + 1, basePoint.x + 1).getFormula();
                if (parameters.isIncludeSum()) {
                    if (parameters.getSpreadStyle() == 0) {
                        if (parameters.getPosition() == 1) {
                            clearFormulaRange = sheet.getRange(basePoint.y + 2, basePoint.x + 1, endPoint.y, endPoint.x);
                            firstFormula = sheet.getRange(basePoint.y + 2, basePoint.x + 1).getFormula();
                        } else {
                            clearFormulaRange = sheet.getRange(basePoint.y + 1, basePoint.x + 1, endPoint.y - 1, endPoint.x);
                            firstFormula = sheet.getRange(basePoint.y + 1, basePoint.x + 1).getFormula();
                        }
                    } else if (parameters.getPosition() == 1) {
                        clearFormulaRange = sheet.getRange(basePoint.y + 1, basePoint.x + 2, endPoint.y, endPoint.x);
                        firstFormula = sheet.getRange(basePoint.y + 1, basePoint.x + 2).getFormula();
                    } else {
                        clearFormulaRange = sheet.getRange(basePoint.y + 1, basePoint.x + 1, endPoint.y, endPoint.x - 1);
                        firstFormula = sheet.getRange(basePoint.y + 1, basePoint.x + 1).getFormula();
                    }
                } else {
                    clearFormulaRange = clearValueRange;
                }
                if (onlyIsNotAcctItem) {
                    Locale locale = SysContext.getSysContext().getLocale();
                    if (StringUtils.isEmpty((String)firstFormula) || firstFormula.toLowerCase(locale).startsWith("=acctitem") || firstFormula.toLowerCase(locale).startsWith("=dyitem")) continue;
                    clearValueRange.setValue(new Variant(null));
                    clearFormulaRange.setFormula(null);
                    continue;
                }
                clearValueRange.setValue(new Variant(null));
                clearFormulaRange.setFormula(null);
            }
        }
    }

    private void registerFormula(Book book) throws Exception {
        final ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ICalculateContextProvider(){

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(AdjustEditReportUI.this.cslReportInfo, null);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return variables;
            }

            public Context getServerContext() {
                return null;
            }
        });
    }

    private void registerFormulaAndCalcBook(Book book) throws Exception {
        this.registerFormula(book);
        book.calc();
    }

    @Override
    public void actionCalcAllSheet_actionPerformed(ActionEvent e) throws Exception {
        this.calc(false, false);
    }

    @Override
    public void actionUnCalcAllSheet_actionPerformed(ActionEvent e) throws Exception {
        this.calc(false, true);
    }

    private void setActiveCell(int row, int col) {
        Sheet selectSheet = this.afterAdjustSpreedContainer.getBook().getActiveSheet();
        selectSheet.getRange(row, col).select();
        selectSheet = this.afterAdjustSpreedContainer.getBook().getActiveSheet();
        selectSheet.getRange(row, col).select();
    }

    private void setActiveSheet(Sheet sheetSheet) {
        String sheetName = sheetSheet.getSheetName();
        this.afterAdjustSpreedContainer.getBook().setActiveSheet(sheetName);
        this.adjustDataSpreedContainer.getBook().setActiveSheet(sheetName);
        this.setActiveCell(0, 0);
    }

    private void calc(boolean isCalcSelectSheet, boolean isUnCalc) throws Exception {
        int i;
        HashMap<String, Protection> proSheets = new HashMap<String, Protection>();
        HashMap<String, String> proPassMap = new HashMap<String, String>();
        Book book = this.afterAdjustSpreedContainer.getBook();
        Sheet selectSheet = book.getActiveSheet();
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        for (i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            sheet.setEnableCalculation(!isCalcSelectSheet);
            Protection pro = sheet.getSheetOption().getProtection(false);
            String proPass = null;
            if (pro == null || !pro.isProtected()) continue;
            proPass = pro.getEncryptedPassword();
            pro.setPassword(proPass);
            pro.stop(proPass);
            proSheets.put(sheet.getSheetName(), pro);
            proPassMap.put(sheet.getSheetName(), proPass);
        }
        if (isCalcSelectSheet) {
            selectSheet.setEnableCalculation(true);
            this.setAdjustDataToFormula(selectSheet, isUnCalc);
        } else {
            for (i = 0; i < sheetCount; ++i) {
                this.setAdjustDataToFormula(book.getSheet(i), isUnCalc);
            }
        }
        this.registerFormulaAndCalcBook(book);
        this.setActiveSheet(selectSheet);
        for (i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            sheet.setEnableCalculation(true);
            if (proSheets.get(sheet.getSheetName()) == null) continue;
            ((Protection)proSheets.get(sheet.getSheetName())).startWithEncryptedPassword((String)proPassMap.get(sheet.getSheetName()));
        }
    }

    private void setAdjustDataToFormula(Sheet sheet, boolean isUnCalc) {
        Cell cell = null;
        Range adjustRange = null;
        ItemFormula itemFormula = null;
        String formula = null;
        String adjustFormula = null;
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        int maxColIndex = sheet.getMaxColIndex() + 1;
        Sheet adjustSheet = this.adjustDataSpreedContainer.getBook().getSheet(sheet.getSheetIndex());
        for (int i = 0; i < maxRowIndex; ++i) {
            for (int j = 0; j < maxColIndex; ++j) {
                cell = sheet.getCell(i, j, false);
                itemFormula = UserObjectHelper.getItemFormula((Cell)cell);
                if (itemFormula == null || 3 == itemFormula.getValueType()) continue;
                if (!isUnCalc) {
                    formula = (String)cell.getUserObjectValue("formulaForAdjust");
                    if (StringUtils.isEmpty((String)formula)) {
                        formula = cell.getFormula();
                        cell.setUserObject("formulaForAdjust", (Object)formula);
                    }
                } else {
                    formula = (String)cell.getUserObjectValue("formulaForAdjust");
                }
                if (!isUnCalc && (adjustRange = adjustSheet.getRange(i, j)).getValue().getValue() instanceof BigDecimal && !BigDecimal.ZERO.equals(adjustRange.getValue().getValue())) {
                    adjustFormula = adjustRange.getValue().getValue().toString();
                    if (StringUtils.isEmpty((String)formula)) {
                        formula = formula + "=";
                    }
                    formula = formula + "+(" + adjustFormula + ")";
                }
                if (StringUtils.isEmpty((String)formula)) continue;
                cell.setFormula(formula);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.isSaveOK = this.saveData();
        if (this.isSaveOK) {
            this.getUIWindow().close();
        }
    }

    private boolean saveData() throws BOSException {
        return ((AdjustEditUI)this.getUIContext().get("Owner")).addLineByReportEditData(this.afterAdjustSpreedContainer.getBook(), this.adjustDataSpreedContainer.getBook(), this.isDynamic);
    }

    public boolean destroyWindow() {
        if (!this.isSaveOK) {
            String msg = EASResource.getString((String)this.resClassName, (String)"106_adjustDataReportHasData");
            int flag = this.hasNoSaveDataIsContinue(msg);
            if (0 == flag) {
                try {
                    this.saveData();
                }
                catch (Exception e) {
                    logger.error((Object)"close ui save data error:", (Throwable)e);
                }
            } else if (2 == flag) {
                SysUtil.abort();
            }
        }
        return super.destroyWindow();
    }

    public int hasNoSaveDataIsContinue(String msg) {
        int flag = -100;
        Book book = this.adjustDataSpreedContainer.getBook();
        int maxRowIndex = 0;
        int maxColIndex = 0;
        Sheet sheet = null;
        ItemFormula itemFormula = null;
        Cell cell = null;
        int sheetCount = book.getSheetCount();
        block0: for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            maxRowIndex = sheet.getMaxRowIndex() + 1;
            maxColIndex = sheet.getMaxColIndex() + 1;
            for (int j = 0; j < maxRowIndex; ++j) {
                for (int j2 = 0; j2 < maxColIndex; ++j2) {
                    cell = sheet.getCell(j, j2, false);
                    itemFormula = UserObjectHelper.getItemFormula((Cell)cell);
                    if (itemFormula == null || !(cell.getValue().getValue() instanceof BigDecimal) || BigDecimal.ZERO.equals(cell.getValue().getValue())) continue;
                    flag = MsgBox.showConfirm3((String)msg);
                    break block0;
                }
            }
        }
        return flag;
    }

    @Override
    public void actionCalcSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        this.calc(true, false);
    }

    @Override
    public void actionUnCalcSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        this.calc(true, true);
    }
}

