/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AdjustAfterRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AdjustNoteInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AdjustRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ViewAdjRptOldVersionListUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.newrpt.IReportBatchCalculateFacade;
import com.kingdee.eas.fi.newrpt.ReportBatchCalculateFacadeFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class AdjustRptListUI
extends AbstractAdjustRptListUI
implements ICSLContextUI,
Runnable {
    private static final Logger logger = CoreUIObject.getLogger(AdjustRptListUI.class);
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private OrgUnitInfo company = null;
    private OrgTreeInfo orgBound = null;
    private CommonQueryDialog commqueryDialog = null;
    GroupRptFilterUI conditionPanel = null;
    private boolean isSupportOtherDS;
    private Set orgIDSet;
    private boolean isDisplayAdjustRptByOrg = false;
    private CslReportCollection reportCalcColl;
    private boolean isAdjustSeparate = false;

    public AdjustRptListUI() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_ADJUSTRPTDISPLAYBYORG", "GR_CSL_SupportOtherDS", "GR_CSL_AdjustSeparate"});
        this.isDisplayAdjustRptByOrg = values[0];
        this.isSupportOtherDS = values[1];
        this.isAdjustSeparate = values[2];
    }

    public String getReportUIName() {
        return ReportProcessUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.menuItemOldVersion.setEnabled(true);
        this.menuItemOldVersion.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.company = this.ctx.getCurOrgGroup();
        this.orgBound = this.ctx.getCurOrgBound();
        this.initTree(this.company);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 4);
        this.menuSwitch.setVisible(false);
        this.menuItemParamManage.setVisible(false);
        this.btnBatchQueueCalc.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
            this.rptArchive();
        }
        if (this.isSupportOtherDS) {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("datacollect").getStyleAttributes().setHided(true);
        }
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.comboBoxCompany.removeAllItems();
        if (company != null) {
            this.comboBoxCompany.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod(cslCtx, this.spCurYear, this.spCurPeriod);
        this.mainQueryPK = this.initQueryBudget();
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent event) {
                int keyCode = event.getKeyCode();
                if (keyCode == 122 && event.isControlDown() && event.isShiftDown()) {
                    CslRptUtil cslrpt = new CslRptUtil();
                    cslrpt.exportReportByKDS(AdjustRptListUI.this.exportReoprtByKDS());
                }
            }

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyTyped(KeyEvent event) {
            }
        });
    }

    private Map exportReoprtByKDS() {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        try {
            String selectId = this.getSelectedKeyValue();
            ICslReport iReport = (ICslReport)this.getBizInterface();
            CslReportInfo reportInfo = iReport.getCslReportInfo("select * where id = '" + selectId + "'");
            byte[] repPackData = reportInfo.getZipData();
            params.put("ids", this.getSelectIds());
            params.put("selectId", selectId);
            params.put("repPackData", repPackData);
        }
        catch (Exception e) {
            logger.error((Object)"exportReoprtByKDS", (Throwable)e);
        }
        return params;
    }

    private ArrayList getSelectIds() throws Exception {
        int selectRowCount = this.tblMain.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        ArrayList<Object> selectIds = new ArrayList<Object>();
        for (int i = 0; i < selectRowCount; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                String id = this.tblMain.getRow(j).getCell("id").getValue().toString();
                if (id == null) continue;
                selectIds.add(this.tblMain.getRow(j).getCell("id").getValue());
            }
        }
        return selectIds;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (CslRptUtil.isQueryBudget() == 1) {
            return HisCslReportFactory.getRemoteInstance();
        }
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return AdjustRptEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getSelectors());
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    private void doRefresh(IUIWindow uiWindow, ActionEvent e) {
        final CoreUI editUI = (CoreUI)uiWindow.getUIObject();
        final ActionEvent fe = e;
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    if ("TRUE".equals(editUI.getUIContext().get("isSaved"))) {
                        AdjustRptListUI.this.refresh(fe);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        boolean isShowCompany = false;
        OrgUnitInfo selectedCompany = this.getSelectedCompany();
        if (this.isDisplayAdjustRptByOrg && !this.orgIDSet.contains(selectedCompany.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getStringWithFormat("NoBizOrgPermission", new Object[]{selectedCompany.getName()}));
            SysUtil.abort();
        }
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        OrgTreeInfo orgBound = CSLContextHelper.getCSLContext().getCurOrgBound();
        orgBound = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgBound.getId().toString()));
        if (selectedCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            SysUtil.abort();
        } else if (selectedCompany.isIsCompanyOrgUnit() && isShowCompany) {
            String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Not_IsBasic");
            MsgBox.showError((Component)((Object)this), (String)res);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        TreeModel model = this.treeCompany.getModel();
        DefaultKingdeeTreeNode n = (DefaultKingdeeTreeNode)model.getRoot();
        ArrayList lst = new ArrayList();
        this.getOrgTree(n, lst, isShowCompany);
        uiContext.put((Object)"CSL_ORGS", lst);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow newWindow = uiFactory.create(this.getEditUIName(), (Map)uiContext, null);
        this.doRefresh(newWindow, e);
        newWindow.show();
    }

    private void getOrgTree(DefaultKingdeeTreeNode node, List lst, boolean isShowCompany) {
        FullOrgUnitInfo orgUnit = ((OrgStructureInfo)node.getUserObject()).getUnit();
        if (!isShowCompany || !orgUnit.isIsCompanyOrgUnit()) {
            lst.add(orgUnit.getId().toString());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.getOrgTree(child, lst, isShowCompany);
        }
    }

    protected void rptArchive() {
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemExportData.setEnabled(false);
        this.menuItemImportData.setEnabled(false);
        this.menuItemPublishReport.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        CslReportInfo info;
        ICslReport iCslReport;
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        try {
            this.getBizInterface().getValue((IObjectPK)pk, selectors);
        }
        catch (Exception ex) {
            this.refresh(e);
            throw ex;
        }
        UIContext uiContext = new UIContext((Object)this);
        if (!this.ctx.isQueryBudget() && (iCslReport = CslReportFactory.getRemoteInstance()).isExistsSameReport((IObjectPK)pk, (IObjectValue)(info = iCslReport.getCslReportInfo((IObjectPK)pk)))) {
            int isok = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"309_AdjustRptListUI"));
            if (isok == 0) {
                uiContext.put((Object)"isView", (Object)Boolean.TRUE);
            } else {
                return;
            }
        }
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow newWindow = factory.create(this.getProcessUIName(), (Map)uiContext, null, OprtState.VIEW);
        this.doRefresh(newWindow, e);
        newWindow.show();
    }

    private String getProcessUIName() {
        return AdjustAfterRptProcessUI.class.getName();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUIName(), (Map)uiContext, null, OprtState.EDIT);
        curUIWindow.show();
    }

    private void buildTreeFilter() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent();
        OrgUnitInfo obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)treeNode);
        FilterInfo filterInfo = this.mainQuery.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterItemCollection col = filterInfo.getFilterItems();
        StringBuffer maskString = new StringBuffer();
        if (!StringUtils.isEmpty((String)filterInfo.getMaskString())) {
            maskString.append("(" + filterInfo.getMaskString() + ") and ");
        }
        int filterParamsIndex = filterInfo.getFilterItems().size();
        try {
            col.add(new FilterItemInfo("orgTree.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS));
            maskString.append("#" + filterParamsIndex++);
            col.add(new FilterItemInfo("year", (Object)new Integer(this.ctx.getCurRptYear()), CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)maskString.toString())) {
                maskString.append(" and ");
            }
            maskString.append(" #" + filterParamsIndex++);
            col.add(new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod()), CompareType.EQUALS));
            maskString.append(" and #" + filterParamsIndex++);
            col.add(new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
            maskString.append(" and #" + filterParamsIndex++);
            if (this.isSupportOtherDS) {
                FilterItemInfo filterItem4 = new FilterItemInfo("dataCollect.number", (Object)this.ctx.getCurDataCollect().getNumber(), CompareType.EQUALS);
                col.add(filterItem4);
                maskString.append(" and #" + filterParamsIndex++);
            } else {
                FilterItemInfo filterItem5 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
                col.add(filterItem5);
                maskString.append(" and #" + filterParamsIndex++);
            }
            if (this.isAdjustSeparate) {
                col.add(new FilterItemInfo("Cslreport.orgTree.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS));
                maskString.append(" and #" + filterParamsIndex++);
            }
            if (obj != null && obj instanceof OrgUnitInfo) {
                OrgUnitInfo orgUnit = obj;
                col.add(new FilterItemInfo("orgUnit.id", (Object)orgUnit.getId().toString()));
                maskString.append(" and #" + filterParamsIndex++);
            }
            if (CSLContextHelper.getCSLContext().getCurPublishedStatus()) {
                this.rptArchive();
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
        filterInfo.setMaskString(maskString.toString());
        this.mainQuery.setFilter(filterInfo);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (e.getSource() == this.btnAddNew || e.getSource() == this.menuItemAddNew) {
            OrgUnitInfo selectedCompany = this.getSelectedCompany();
            if (selectedCompany == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
                SysUtil.abort();
            }
            uiContext.put((Object)"company", (Object)selectedCompany);
        }
    }

    private OrgUnitInfo getSelectedCompany() {
        OrgUnitInfo selectedCompany = null;
        if (this.treeCompany.getSelectionCount() > 0) {
            OrgUnitInfo obj;
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeCompany.getLastSelectedPathComponent();
            selectedCompany = obj = OrgClientUtils.getOrgUnitFromTreeNode((DefaultKingdeeTreeNode)treeNode);
        }
        return selectedCompany;
    }

    private void initTree(OrgUnitInfo currCompany) {
        try {
            this.viewCompany.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            DefaultKingdeeTreeNode rootNode = CslOrgTreeUtil.getUnionDebtTree(currCompany, this.orgBound, false);
            if (this.isDisplayAdjustRptByOrg) {
                this.orgIDSet = CslOrgTreeUtil.getPermOrgUnitSetForClient(this.orgBound.getId().toString(), currCompany.getId().toString(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            }
            AdjustNoteInfo.displayAdjustRptMBySystemParam(rootNode, this.isDisplayAdjustRptByOrg, this.orgIDSet);
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
            this.treeCompany.setModel((TreeModel)model);
            this.treeCompany.setSelectionNode(rootNode);
            model.setAsksAllowsChildren(true);
            this.processNodeIcon(rootNode);
            this.treeCompany.expandAllNodes(true, (TreeNode)rootNode);
            if (MergeModeEnum.ORDINAL.equals((Object)CslRptUtil.getMergeMode(this.ctx.getCurOrgBound()))) {
                int n = rootNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.treeCompany.removeAllChildrenFromParent((MutableTreeNode)((DefaultKingdeeTreeNode)rootNode.getChildAt(i)));
                }
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.commqueryDialog == null) {
            this.commqueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commqueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commqueryDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK queryPK = this.initQueryBudget();
            this.commqueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.commqueryDialog.setShowFilter(false);
            this.commqueryDialog.setShowSorter(false);
            this.commqueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.ConditionFilter"));
            this.commqueryDialog.setWidth(320);
            this.commqueryDialog.setHeight(250);
            this.commqueryDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.commqueryDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.AdjustRptListUI");
        }
        return this.commqueryDialog;
    }

    public GroupRptFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new GroupRptFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.setReportType(4);
        }
        return this.conditionPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String dateTime;
        String queryName;
        this.mainQueryPK = this.initQueryBudget();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = AdjustRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.commqueryDialog == null) {
                this.commqueryDialog = this.initCommonQueryDialog();
                this.commqueryDialog.setProcessor((IProcessor)new CommonQueryProcessor(){

                    public void process() throws Exception {
                        String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                        if (fieldProperty.equalsIgnoreCase("sourceType")) {
                            KDComboBox cmbxSourceType = (KDComboBox)this.get("CURRENT_EDITOR");
                            for (int i = cmbxSourceType.getItemCount() - 1; i > 0; --i) {
                                RptSrcTypeEnum rptSrcType = (RptSrcTypeEnum)cmbxSourceType.getItemAt(i);
                                if (rptSrcType.getValue() == 1 || rptSrcType.getValue() == 2 || rptSrcType.getValue() == 3 || rptSrcType.getValue() == 10 || rptSrcType.getValue() == 11 || rptSrcType.getValue() == 12) continue;
                                cmbxSourceType.removeItemAt(i);
                            }
                        }
                    }
                });
            }
            if (this.commqueryDialog.show()) {
                this.doQuery(this.commqueryDialog);
                this.mainQuery = this.commqueryDialog.getEntityViewInfoResult();
                this.buildTreeFilter();
                this.execQuery();
            } else {
                SysUtil.abort();
            }
        }
        if ((dateTime = CslRptUIUtil.getNationalTimeFormatString()) != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("period").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dateTime);
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dateTime);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    private void processNodeIcon(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnit;
        if (node == null) {
            return;
        }
        boolean isGroup = false;
        Object orgStructure = node.getUserObject();
        if (orgStructure != null && (orgUnit = ((OrgStructureInfo)orgStructure).getUnit()) != null) {
            isGroup = orgUnit.isIsGrouping();
        }
        if (!node.isLeaf() || isGroup) {
            node.setAllowsChildren(true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.processNodeIcon((DefaultKingdeeTreeNode)node.getChildAt(i));
            }
        } else {
            node.setAllowsChildren(false);
        }
    }

    @Override
    protected void treeCompany_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeCompany_valueChanged(e);
        if (this.commqueryDialog != null) {
            EntityViewInfo info = this.commqueryDialog.getEntityViewInfoResult();
            if (info == null) {
                if (this.getDefaultEntityViewInfo() != null) {
                    info = (EntityViewInfo)this.getDefaultEntityViewInfo().clone();
                } else {
                    info = new EntityViewInfo();
                    info.setFilter(new FilterInfo());
                }
            }
            this.mainQuery = info;
        } else if (this.getDefaultEntityViewInfo() != null) {
            this.mainQuery = (EntityViewInfo)this.getDefaultEntityViewInfo().clone();
        } else {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(new FilterInfo());
        }
        this.buildTreeFilter();
        this.execQuery();
    }

    @Override
    public void actionOldVersion_actionPerformed(ActionEvent e) throws Exception {
        String reportId = this.getSelectedKeyValue();
        if (reportId == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"CompanyRptList_Dialog_RptSelect"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)reportId);
            IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ViewAdjRptOldVersionListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            curUIWindow.show();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    protected void execQuery() {
        if (this.isDisplayAdjustRptByOrg && this.orgIDSet != null && !this.orgIDSet.contains(this.getSelectedCompany().getId().toString())) {
            this.tblMain.removeRows(false);
            return;
        }
        super.execQuery();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        CslReportInfo info = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)pk);
        ObjectUuidPK treePK = new ObjectUuidPK(BOSUuid.read((String)info.getOrgTree().getId().toString()));
        OrgTreeInfo tree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)treePK);
        if (!tree.getNumber().equals(this.ctx.getCurOrgBound().getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"310_AdjustRptListUI"));
            return;
        }
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), this.getSelectedIdValues(), true, false);
        super.actionRemove_actionPerformed(e);
    }

    private MetaDataPK initQueryBudget() {
        MetaDataPK mdPK = null;
        try {
            if (CSLContextHelper.getCSLContext().isQueryBudget()) {
                mdPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"HisAdjustAfterRptQuery");
                this.actionAddNew.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionAddNew.setVisible(false);
                this.actionEdit.setVisible(false);
                this.actionRemove.setVisible(false);
                this.menuEdit.setEnabled(false);
                this.menuEdit.setVisible(false);
                this.actionOldVersion.setEnabled(false);
                this.actionOldVersion.setVisible(false);
            } else {
                mdPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"AdjustAfterRptQuery");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"initQueryBudget", (Throwable)e);
        }
        return mdPK;
    }

    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        this.initQueryBudget();
    }

    @Override
    public void actionBatchQueueCalc_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectIds();
        int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)RptUtil.getReportResource((String)"AdjustRptBatchCalcIntoQueue"));
        if (!MsgBox.isYes((int)confirm)) {
            SysUtil.abort();
        }
        this.reportCalcColl = CslRptUIUtil.getdRptCollByIdsAndauditeStatus(ids, null);
        Thread t = new Thread(this);
        t.setName("report batch calc");
        t.start();
    }

    @Override
    public void run() {
        try {
            if (this.reportCalcColl == null || this.reportCalcColl.size() == 0) {
                return;
            }
            CslReportCollection needCalRptColl = CslRptUIUtil.getNeedCalCslRportColl((CoreUIObject)this, this.reportCalcColl);
            if (needCalRptColl.size() == 0) {
                return;
            }
            logger.info((Object)"rptreport queue calc start");
            IReportBatchCalculateFacade iBatchCalc = ReportBatchCalculateFacadeFactory.getRemoteInstance();
            int size = needCalRptColl.size();
            ArrayList<CslReportInfo> needCalList = new ArrayList<CslReportInfo>(size);
            for (int i = 0; i < size; ++i) {
                needCalList.add(needCalRptColl.get(i));
            }
            List returnList = iBatchCalc.batchQueueCalcCslReport(needCalList, null);
            if (null != returnList) {
                for (int i = 0; i < returnList.size(); ++i) {
                    String jobInstExtId;
                    Map jobMap = (Map)returnList.get(i);
                    if (jobMap.get("isStart") == null || !((Boolean)jobMap.get("isStart")).booleanValue() || (jobInstExtId = (String)jobMap.get("jobInstExtId")) == null) continue;
                    JobMonitorManager.getInstance().addMonitorInfo(jobInstExtId, (String)jobMap.get("title"));
                }
            }
            logger.info((Object)"report queue calc end");
        }
        catch (Exception e1) {
            logger.error((Object)"run", (Throwable)e1);
        }
    }
}

