/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustTemplateUnDispenseUI;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdjustTemplateUnDispenseUI
extends AbstractAdjustTemplateUnDispenseUI {
    private static final long serialVersionUID = 2438333052178139745L;
    Set userTreeId = null;

    private void loadOrgBound() throws EASBizException, BOSException {
        this.kDBizPrmptOrgTree.setValue(null);
        UnionVersion2F7 unionF7 = new UnionVersion2F7();
        unionF7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"341_CSLReportExportFilterUI"));
        this.kDBizPrmptOrgTree.setSelector((KDPromptSelector)unionF7);
        this.kDBizPrmptOrgTree.setEditable(false);
        this.kDBizPrmptOrgTree.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.OrgBoundVersionQuery");
    }

    private void refreshOrgUnit(String treeID) {
        this.kDBizPrmptOrgUnit.setValue(null);
        String title = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg.Company");
        if (treeID == null) {
            NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.setNeedAddOrgRange(false);
            f7.setTitle(title);
            this.kDBizPrmptOrgUnit.setSelector((KDPromptSelector)f7);
        } else {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setTreeID(treeID);
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.setTitle(title);
            this.kDBizPrmptOrgUnit.setSelector((KDPromptSelector)f7);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadOrgBound();
        this.refreshOrgUnit(null);
        this.kDBizPrmptOrgUnit.setEditable(false);
        super.setDataObject((IObjectValue)new EntityViewInfo());
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeselectAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.kdtQueryAdjustTempletUnDispenseQuery.checkParsed();
        this.userTreeId = this.getCurrentUserUnionTree();
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public EntityViewInfo getMainQuery() {
        if (this.queryAdjustTempletUnDispenseQuery == null) {
            this.queryAdjustTempletUnDispenseQuery = new EntityViewInfo();
        }
        return this.queryAdjustTempletUnDispenseQuery;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.kdtQueryAdjustTempletUnDispenseQuery.removeRows();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        List dispenseIds = this.getDispenseIds();
        if (dispenseIds.size() == 0) {
            return;
        }
        ObjectUuidPK[] pks = new ObjectUuidPK[dispenseIds.size()];
        for (int i = 0; i < dispenseIds.size(); ++i) {
            ObjectUuidPK pk;
            pks[i] = pk = new ObjectUuidPK(dispenseIds.get(i).toString());
        }
        AdjustAndElimDispenseFactory.getRemoteInstance().delete((IObjectPK[])pks);
        this.actionRefresh_actionPerformed(e);
    }

    private FilterInfo getFilter() {
        FilterInfo fInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("dispenseSrcID", (Object)this.getUIContext().get("tempId").toString());
        fInfo.getFilterItems().add(item);
        item = this.userTreeId.isEmpty() ? new FilterItemInfo("orgBound.id", (Object)"''") : new FilterItemInfo("orgBound.id", (Object)this.userTreeId, CompareType.INCLUDE);
        fInfo.getFilterItems().add(item);
        return fInfo;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private List getDispenseIds() {
        ArrayList<String> result = new ArrayList<String>();
        IRow curRow = null;
        boolean isSelected = false;
        for (int i = 0; i < this.kdtQueryAdjustTempletUnDispenseQuery.getRowCount(); ++i) {
            curRow = this.kdtQueryAdjustTempletUnDispenseQuery.getRow(i);
            isSelected = (Boolean)curRow.getCell("select").getValue();
            if (!isSelected) continue;
            result.add(curRow.getCell("id").getValue().toString());
        }
        return result;
    }

    @Override
    public void actionDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable(this.kdtQueryAdjustTempletUnDispenseQuery, "select", Boolean.FALSE);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable(this.kdtQueryAdjustTempletUnDispenseQuery, "select", Boolean.TRUE);
    }

    @Override
    protected void kDBizPrmptOrgTree_dataChanged(DataChangeEvent e) throws Exception {
        FilterInfo filter = this.getFilter();
        Object data = this.kDBizPrmptOrgTree.getData();
        OrgTreeInfo orgBound = null;
        if (!(data instanceof OrgTreeInfo)) {
            this.kDBizPrmptOrgTree.setData(null);
        } else {
            orgBound = (OrgTreeInfo)data;
        }
        data = this.kDBizPrmptOrgUnit.getData();
        OrgUnitInfo orgUnit = null;
        if (!(data instanceof OrgUnitInfo)) {
            this.kDBizPrmptOrgUnit.setData(null);
        } else {
            orgUnit = (OrgUnitInfo)data;
        }
        if (orgBound != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgBound.getId()));
            this.kDBizPrmptOrgUnit.setEnabled(true);
            this.refreshOrgUnit(orgBound.getId().toString());
        } else {
            if (orgUnit != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)orgUnit.getNumber()));
            }
            this.refreshOrgUnit(null);
        }
        this.getMainQuery().setFilter(filter);
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void kDBizPrmptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        FilterInfo filter = this.getFilter();
        OrgTreeInfo orgBound = (OrgTreeInfo)this.kDBizPrmptOrgTree.getData();
        OrgUnitInfo orgUnit = (OrgUnitInfo)this.kDBizPrmptOrgUnit.getData();
        if (orgBound != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgBound.getId()));
        }
        if (orgUnit != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)orgUnit.getNumber()));
        }
        this.getMainQuery().setFilter(filter);
        this.actionRefresh_actionPerformed(null);
    }

    private Set getCurrentUserUnionTree() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
        OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                String id = treeCol.get(i).getId().toString();
                ids.add(id);
            }
        }
        return ids;
    }
}

