/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustAndElimDispense;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustTempletDispenseUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustTempletDispenseUI
extends AbstractAdjustTempletDispenseUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustTempletDispenseUI.class);
    private static final int UNIT_NUM = 0;
    private static final int UNIT_NAME = 1;
    private static final int UNIT_ID = 2;
    private static final int ORGTREE = 3;
    private static final int ORG_NUM = 4;
    private static final int ORG_NAME = 5;
    private static final int ORG_ID = 6;
    private static final int ORG_STARTDATE = 7;
    private static final int ORG_ENDDATE = 8;
    private OrgTreeCollection orgTreeForSelect = null;
    private OrgTreeCollection orgTreeSelected = null;
    private AdjustAndElimDispenseCollection adjustAndElimDisCollection = null;
    SelectorItemCollection sic = new SelectorItemCollection();
    private String dispenseSrcId = null;

    public AdjustTempletDispenseUI() throws Exception {
        this.sic.add(new SelectorItemInfo("id"));
        this.sic.add(new SelectorItemInfo("number"));
        this.sic.add(new SelectorItemInfo("name"));
        this.tblOrgTreeForSelect.getStyleAttributes().setLocked(true);
        this.tblOrgTreeForSelect.getSelectManager().setSelectMode(10);
        this.tblOrgTreeSelected.getStyleAttributes().setLocked(true);
        this.tblOrgTreeSelected.getSelectManager().setSelectMode(10);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadOrgBound();
        this.btnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnUnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnUnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.dispenseSrcId = this.getUIContext().get("ID").toString();
        this.loadOrgTreeSelected();
    }

    private void loadOrgBound() throws Exception {
        this.prmptOrgBound.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    AdjustTempletDispenseUI.this.prmptOrgBound_dataChanged(e);
                }
                catch (Exception exc) {
                    AdjustTempletDispenseUI.this.handUIException(exc);
                }
            }
        });
        this.prmptOrgBound.setValue(null);
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource.sorgse"));
        this.prmptOrgBound.setEditable(false);
        this.prmptOrgBound.setSelector((KDPromptSelector)f7);
    }

    private void loadOrgTreeSelected() {
        AdjustAndElimDispenseCollection dispenseCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)this.dispenseSrcId, CompareType.EQUALS));
        view.setFilter(filter);
        OrgTreeCollection orgTreeCollection = new OrgTreeCollection();
        try {
            this.adjustAndElimDisCollection = dispenseCollection = this.getBizInterface().getAdjustAndElimDispenseCollection(view);
            if (dispenseCollection != null && dispenseCollection.size() > 0) {
                ArrayList companys = this.getBizInterface().getUnitByDispenseSrcID(this.dispenseSrcId);
                int count = companys.size();
                for (int i = 0; i < count; ++i) {
                    HashMap row = (HashMap)companys.get(i);
                    OrgTreeInfo cmpTree = new OrgTreeInfo();
                    cmpTree.setId(BOSUuid.read((String)row.get("unitID").toString()));
                    cmpTree.setName(row.get("unitName").toString());
                    cmpTree.setNumber(row.get("unitNum").toString());
                    cmpTree.setString("orgID", row.get("orgID").toString());
                    cmpTree.setString("orgNum", row.get("orgNum").toString());
                    cmpTree.setString("orgName", row.get("orgName").toString());
                    cmpTree.setString("orgStartDate", row.get("startDate") != null ? row.get("startDate").toString() : "");
                    cmpTree.setString("orgEndDate", row.get("endDate") != null ? row.get("endDate").toString() : "");
                    orgTreeCollection.add(cmpTree);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (orgTreeCollection != null && orgTreeCollection.size() > 0) {
            this.orgTreeSelected = orgTreeCollection;
            this.addCollectionToTable(orgTreeCollection, this.tblOrgTreeSelected);
            String format = CslRptUIUtil.getNationalDateFormatString();
            if (format == null) {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            } else {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{" + format + "}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{" + format + "}t");
            }
        }
    }

    private void loadOrgTreeSelected(OrgTreeInfo orgTreeInfo) {
        this.tblOrgTreeSelected.removeRows();
        String orgID = orgTreeInfo.getId().toString();
        AdjustAndElimDispenseCollection dispenseCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgBound", (Object)orgID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)this.dispenseSrcId, CompareType.EQUALS));
        view.setFilter(filter);
        OrgTreeCollection orgTreeCollection = new OrgTreeCollection();
        try {
            this.adjustAndElimDisCollection = dispenseCollection = this.getBizInterface().getAdjustAndElimDispenseCollection(view);
            if (dispenseCollection != null && dispenseCollection.size() > 0) {
                ArrayList companys = this.getBizInterface().getUnitBySrcIDAndOrgID(this.dispenseSrcId, orgID);
                int count = companys.size();
                HashMap row = null;
                for (int i = 0; i < count; ++i) {
                    row = (HashMap)companys.get(i);
                    OrgTreeInfo cmpTree = new OrgTreeInfo();
                    cmpTree.setId(BOSUuid.read((String)row.get("unitID").toString()));
                    cmpTree.setName(row.get("unitName").toString());
                    cmpTree.setNumber(row.get("unitNum").toString());
                    cmpTree.setString("orgID", row.get("orgID").toString());
                    cmpTree.setString("orgNum", row.get("orgNum").toString());
                    cmpTree.setString("orgName", row.get("orgName").toString());
                    Timestamp orgStartDate = orgTreeInfo.getStartDate();
                    Timestamp orgEndDate = orgTreeInfo.getEndDate();
                    cmpTree.setString("orgStartDate", orgStartDate != null ? orgStartDate.toString() : "");
                    cmpTree.setString("orgEndDate", orgEndDate != null ? orgEndDate.toString() : "");
                    orgTreeCollection.add(cmpTree);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        OrgTreeCollection orgTreeUniqueCollection = CslRptUIUtil.getOrgTreeUniqueCollection(orgTreeCollection);
        if (orgTreeUniqueCollection != null && orgTreeUniqueCollection.size() > 0) {
            this.orgTreeSelected = orgTreeUniqueCollection;
            this.addCollectionToTable(orgTreeUniqueCollection, this.tblOrgTreeSelected);
            String format = CslRptUIUtil.getNationalDateFormatString();
            if (format == null) {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            } else {
                this.tblOrgTreeSelected.getColumn(7).getStyleAttributes().setNumberFormat("%{" + format + "}t");
                this.tblOrgTreeSelected.getColumn(8).getStyleAttributes().setNumberFormat("%{" + format + "}t");
            }
        } else {
            this.orgTreeSelected = null;
        }
    }

    protected void prmptOrgBound_dataChanged(DataChangeEvent e) throws Exception {
        this.tblOrgTreeForSelect.removeRows();
        OrgTreeInfo orgTreeInfo = null;
        if (this.prmptOrgBound.getValue() != null) {
            orgTreeInfo = (OrgTreeInfo)this.prmptOrgBound.getValue();
            Map companyIDMap = PermissionFactory.getRemoteInstance().getUnionUnits((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgTreeInfo.getId()));
            Iterator it = companyIDMap.entrySet().iterator();
            StringBuffer sbIDS = new StringBuffer();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                sbIDS.append("'");
                sbIDS.append(key);
                sbIDS.append("',");
            }
            sbIDS.deleteCharAt(sbIDS.length() - 1);
            ArrayList companys = this.getBizInterface().getUnitByID(sbIDS.toString());
            this.tblOrgTreeForSelect.removeRows();
            int count = companys.size();
            this.orgTreeForSelect = new OrgTreeCollection();
            HashMap unitMap = null;
            for (int i = 0; i < count; ++i) {
                unitMap = (HashMap)companys.get(i);
                OrgTreeInfo cmpTree = new OrgTreeInfo();
                cmpTree.setId(BOSUuid.read((String)unitMap.get("unitID").toString()));
                cmpTree.setName(unitMap.get("unitName").toString());
                cmpTree.setNumber(unitMap.get("unitNum").toString());
                cmpTree.setString("orgID", orgTreeInfo.getId().toString());
                cmpTree.setString("orgNum", orgTreeInfo.getNumber());
                cmpTree.setString("orgName", orgTreeInfo.getName());
                Timestamp orgStartDate = orgTreeInfo.getStartDate();
                Timestamp orgEndDate = orgTreeInfo.getEndDate();
                cmpTree.setString("orgStartDate", orgStartDate != null ? orgStartDate.toString() : "");
                cmpTree.setString("orgEndDate", orgEndDate != null ? orgEndDate.toString() : "");
                IRow row = this.tblOrgTreeForSelect.addRow();
                row.getCell(0).setValue((Object)cmpTree.getNumber());
                row.getCell(1).setValue((Object)cmpTree.getName());
                row.getCell(2).setValue((Object)cmpTree.getId());
                row.getCell(3).setValue((Object)cmpTree);
                row.getCell(4).setValue(cmpTree.get("orgNum"));
                row.getCell(5).setValue(cmpTree.get("orgName"));
                row.getCell(6).setValue(cmpTree.get("orgID"));
                row.getCell(7).setValue((Object)cmpTree.getString("orgStartDate"));
                row.getCell(8).setValue((Object)cmpTree.getString("orgEndDate"));
                this.orgTreeForSelect.add(cmpTree);
            }
            this.tblOrgTreeForSelect.getSelectManager().select(0, 0, 0, 0);
            this.loadOrgTreeSelected(orgTreeInfo);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        OrgTreeCollection orgTreeCollection = this.getSelectedCollectionFromTable(this.tblOrgTreeForSelect);
        this.getOrgTreeSelected().addCollection(orgTreeCollection);
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }

    @Override
    public void actionUnSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSelect_actionPerformed(e);
        OrgTreeCollection orgTreeCollection = this.getSelectedCollectionFromTable(this.tblOrgTreeSelected);
        this.getOrgTreeForSelect().addCollection(orgTreeCollection);
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }

    protected IAdjustAndElimDispense getBizInterface() throws Exception {
        return AdjustAndElimDispenseFactory.getRemoteInstance();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Result result;
        super.actionConfirm_actionPerformed(e);
        if (this.adjustAndElimDisCollection != null && this.adjustAndElimDisCollection.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[this.adjustAndElimDisCollection.size()];
            for (int i = 0; i < this.adjustAndElimDisCollection.size(); ++i) {
                ObjectUuidPK pk;
                pks[i] = pk = new ObjectUuidPK(this.adjustAndElimDisCollection.get(i).getId());
            }
            this.getBizInterface().delete((IObjectPK[])pks);
        }
        int count = this.tblOrgTreeSelected.getRowCount();
        CoreBaseCollection infos = new CoreBaseCollection();
        for (int i = 0; i < count; ++i) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)this.tblOrgTreeSelected.getRow(i).getCell(6).getValue().toString()));
            orgTree.setName(this.tblOrgTreeSelected.getRow(i).getCell(5).getValue().toString());
            orgTree.setNumber(this.tblOrgTreeSelected.getRow(i).getCell(4).getValue().toString());
            OrgUnitInfo unitTree = new OrgUnitInfo();
            unitTree.setId(BOSUuid.read((String)this.tblOrgTreeSelected.getRow(i).getCell(2).getValue().toString()));
            unitTree.setName(this.tblOrgTreeSelected.getRow(i).getCell(1).getValue().toString());
            unitTree.setNumber(this.tblOrgTreeSelected.getRow(i).getCell(0).getValue().toString());
            AdjustAndElimDispenseInfo info = new AdjustAndElimDispenseInfo();
            info.setSourceType(AdjustAndElimDispenseTypeEnum.ADJUSTTEMPLET);
            info.setDispenseSrcID(this.dispenseSrcId);
            info.setOrgBound(orgTree);
            info.setCompany(unitTree.castToFullOrgUnitInfo());
            infos.add((CoreBaseInfo)info);
        }
        if (infos.size() > 0 && (result = this.getBizInterface().addnew(infos)).getResult() != 1) {
            StringBuffer errMsg = new StringBuffer();
            String msg = null;
            Object[] oParamater = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.getLineResult(i).isSucess()) continue;
                Exception ex = result.getLineResult(i).getException();
                if (e == null) {
                    oParamater = new Object[]{i + 1};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"17_AdjustTempletDispenseUI");
                } else {
                    oParamater = new Object[]{i + 1, ex.getMessage()};
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"18_AdjustTempletDispenseUI");
                }
                errMsg.append(MessageFormat.format(msg, new Object[]{oParamater})).append("\\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"313_AdjustTempletDispenseUI"), (String)errMsg.toString(), (int)8188);
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.getOrgTreeSelected().addCollection(this.getOrgTreeForSelect());
        this.getOrgTreeForSelect().clear();
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }

    @Override
    public void actionUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSelectAll_actionPerformed(e);
        this.getOrgTreeForSelect().addCollection(this.getOrgTreeSelected());
        this.getOrgTreeSelected().clear();
        this.addCollectionToTable(this.getOrgTreeSelected(), this.tblOrgTreeSelected);
        this.addCollectionToTable(this.getOrgTreeForSelect(), this.tblOrgTreeForSelect);
    }

    private OrgTreeCollection getOrgTreeForSelect() {
        if (this.orgTreeForSelect == null) {
            this.orgTreeForSelect = new OrgTreeCollection();
        }
        return this.orgTreeForSelect;
    }

    private OrgTreeCollection getOrgTreeSelected() {
        if (this.orgTreeSelected == null) {
            this.orgTreeSelected = new OrgTreeCollection();
        }
        return this.orgTreeSelected;
    }

    private void addCollectionToTable(OrgTreeCollection orgTreeCollection, KDTable table) {
        table.checkParsed();
        table.getSelectManager().setSelectMode(10);
        table.removeRows();
        int count = orgTreeCollection.size();
        for (int i = 0; i < count; ++i) {
            OrgTreeInfo orgTree = orgTreeCollection.get(i);
            IRow r = table.addRow();
            r.getCell(0).setValue((Object)orgTree.getNumber());
            r.getCell(1).setValue((Object)orgTree.getName());
            r.getCell(2).setValue((Object)orgTree.getId());
            r.getCell(3).setValue((Object)orgTree);
            r.getCell(4).setValue(orgTree.get("orgNum"));
            r.getCell(5).setValue(orgTree.get("orgName"));
            r.getCell(6).setValue(orgTree.get("orgID"));
            r.getCell(7).setValue(orgTree.get("orgStartDate"));
            r.getCell(8).setValue(orgTree.get("orgEndDate"));
        }
        if (count > 0) {
            table.getSelectManager().select(0, 0, 0, 0);
        }
    }

    private OrgTreeCollection getOrgTreeCollection(KDTable table) {
        OrgTreeCollection orgTreeCol = null;
        if (table.equals(this.tblOrgTreeForSelect)) {
            orgTreeCol = this.getOrgTreeForSelect();
        } else if (table.equals(this.tblOrgTreeSelected)) {
            orgTreeCol = this.getOrgTreeSelected();
        }
        return orgTreeCol;
    }

    private OrgTreeCollection getSelectedCollectionFromTable(KDTable table) throws Exception {
        OrgTreeCollection orgTreeCollection = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock sb = KDTSelectBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = sb.getTop(); j >= 0 && j <= sb.getBottom(); ++j) {
                if (orgTreeCollection == null) {
                    orgTreeCollection = new OrgTreeCollection();
                }
                OrgTreeInfo orgTreeInfo = (OrgTreeInfo)table.getRow(j).getCell(3).getValue();
                String orgID = table.getRow(j).getCell(6).getValue().toString();
                String orgNum = table.getRow(j).getCell(4).getValue().toString();
                String orgName = table.getRow(j).getCell(5).getValue().toString();
                orgTreeInfo.setString("orgID", orgID);
                orgTreeInfo.setString("orgNum", orgNum);
                orgTreeInfo.setString("orgName", orgName);
                orgTreeCollection.add(orgTreeInfo);
                this.getOrgTreeCollection(table).remove(orgTreeInfo);
            }
        }
        return orgTreeCollection;
    }
}

