/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustTempleInfo;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustTemple;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustTempletEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AdjustTempletEditUI
extends AbstractAdjustTempletEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustTempletEditUI.class);
    private String TB_SUMMARY = "summary";
    private String TB_ITEM_NUMBER = "itemNumber";
    private String TB_ITEM_NAME = "itemName";
    private String TB_DATAELEMENT = "dataElement";
    private String TB_DEBITFORMULA = "debitFormula";
    private String TB_CREDITFORMULA = "creditFormula";
    private boolean isCopy;
    private String resName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.Adjust_DebitAndCredit";

    public AdjustTempletEditUI() throws Exception {
        this.initHeadData();
        this.initEntryTable();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.item.*"));
        sic.add(new SelectorItemInfo("CheckedStatus"));
        sic.add(new SelectorItemInfo("trackRecordCreator.id"));
        sic.add(new SelectorItemInfo("entries.dataElement"));
        return sic;
    }

    private void initHeadData() {
        AdjustModeCollection adjustModeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        try {
            CslGradeManageUtil.filterAdjustModeGradeManage(null, (EntityViewInfo)viewInfo, null);
            IAdjustMode iAdjustMode = AdjustModeFactory.getRemoteInstance();
            adjustModeCollection = iAdjustMode.getAdjustModeCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.comboAdjustMode.removeAllItems();
        if (adjustModeCollection != null && adjustModeCollection.size() > 0) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.comboAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
            this.comboAdjustMode.setSelectedIndex(0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSubmit.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.btnSubmit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.menuItemSubmit.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.menuItemSubmit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"314_AdjustTempletEditUI"));
        this.menuWorkflow.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        for (int i = 0; i < this.comboValueType.getItemCount(); ++i) {
            ValueTypeEnum value = (ValueTypeEnum)((Object)this.comboValueType.getItemAt(i));
            if (value.getValue() != 3) continue;
            this.comboValueType.removeItem(this.comboValueType.getItemAt(i));
        }
    }

    private void initEntryTable() throws Exception {
        this.kdtEntries.checkParsed();
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, true));
        prmtBox.setEditable(true);
        KDTDefaultCellEditor formulaEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
        this.getDetailTable().getColumn(this.TB_DEBITFORMULA).setEditor((ICellEditor)formulaEditor);
        this.getDetailTable().getColumn(this.TB_CREDITFORMULA).setEditor((ICellEditor)formulaEditor);
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        this.getDetailTable().getColumn(this.TB_ITEM_NUMBER).setEditor((ICellEditor)itemEditor);
        KDBizPromptBox bizBoxDataElement = new KDBizPromptBox();
        bizBoxDataElement.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        bizBoxDataElement.setEditFormat("$number$");
        bizBoxDataElement.setDisplayFormat("$number$");
        bizBoxDataElement.setEditable(true);
        bizBoxDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)bizBoxDataElement, null, (boolean)true);
        this.kdtEntries.getColumn(this.TB_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxDataElement));
        this.kdtEntries.getColumn(this.TB_ITEM_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    AdjustTempletEditUI.this.tableValueChanged(e);
                }
                catch (EASBizException e1) {
                    logger.error((Object)"tableValueChanged_EASBizException", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"tableValueChanged_BOSException", (Throwable)e1);
                }
            }
        });
        this.kdtEntries.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                AdjustTempletEditUI.this.fillFormula(e);
            }
        });
    }

    private void fillFormula(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > this.kdtEntries.getRowCount() || rowIndex < 0) {
            return;
        }
        this.putClientProperty("clientProperty_formula_debit", null);
        this.putClientProperty("clientProperty_formula_credit", null);
        int colIndex = e.getColumnIndex();
        Object formulaObj = this.kdtEntries.getRow(rowIndex).getCell(colIndex).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        }
    }

    private void checkFormulaFormat(String formulaString) throws CheckFormulaException {
        Expression expression;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
        }
        this.checkFormulaExpression(expression);
    }

    private void checkFormulaExpression(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            String funName = ((FunctionExpr)expression).funcionName;
            String pattern = "^[+-]?\\d+(\\.\\d+)?$|^([+-]?(AcctItem|AdjustData|CsRef|Acct|IF|Round)\\([^\\s^\\)]{1,}\\))+$|[-+*/][0-9]+(\\.[0-9]{1,4})?$";
            Pattern patt = Pattern.compile(pattern.toUpperCase());
            Matcher matcher = patt.matcher(funName);
            if (!matcher.find()) {
                throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)expression).left;
            this.checkFormulaExpression(expr);
            expr = ((BinaryOperationExpr)expression).right;
            this.checkFormulaExpression(expr);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)expression).operand;
            this.checkFormulaExpression(expr);
        } else if (expression instanceof NameExpr) {
            throw new CheckFormulaException(CheckFormulaException.ACCTITEMFORMULA_FORMAT_ERROR);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
        this.initBizDataStatus();
        if (this.editData == null) {
            return;
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.isCitedByLater.setSelectedIndex(0);
        }
        if (this.editData.getAdjustMode() != null) {
            for (int i = 0; i < this.comboAdjustMode.getItemCount(); ++i) {
                AdjustModeInfo adjustMode = (AdjustModeInfo)this.comboAdjustMode.getItemAt(i);
                if (!this.editData.getAdjustMode().getId().equals((Object)adjustMode.getId())) continue;
                this.comboAdjustMode.setSelectedIndex(i);
                break;
            }
        }
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            AdjustTempleEntryInfo entryInfo = this.editData.getEntries().get(i);
            this.loadEntries(this.kdtEntries, row, entryInfo);
        }
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    private void initBizDataStatus() {
        if ("VIEW".equals(this.getOprtState()) && this.editData != null && this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            this.btnEdit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    private void loadEntries(KDTable kdtEntries, IRow row, AdjustTempleEntryInfo entryInfo) {
        if (entryInfo != null) {
            row.getCell(this.TB_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(entryInfo.getDataElement()));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            AdjustTempleEntryInfo entryInfo = this.editData.getEntries().get(i);
            this.storeEntries(this.kdtEntries, row, entryInfo);
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        boolean b = this.editData.isSyncOldValue();
        this.editData.setSyncOldValue(true);
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        this.editData.setSyncOldValue(b);
    }

    private void storeEntries(KDTable kdtEntries, IRow row, AdjustTempleEntryInfo entryInfo) {
        entryInfo.setDataElement(((DataElementInfo)row.getCell(this.TB_DATAELEMENT).getValue()).getInterSeq());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        AdjustTempleEntryInfo lineInfo = new AdjustTempleEntryInfo();
        lineInfo.setDataElement(4);
        return lineInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        AdjustTempleInfo templetInfo = new AdjustTempleInfo();
        templetInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        templetInfo.setValueType(ValueTypeEnum.MONEY);
        return templetInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AdjustTempleFactory.getRemoteInstance();
    }

    void tableValueChanged(KDTEditEvent e) throws BOSException, EASBizException {
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = kdtEntry.getRow(selectRow);
        if (e.getColIndex() == row.getCell(this.TB_ITEM_NUMBER).getColumnIndex() && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.TB_CREDITFORMULA).setValue(null);
            row.getCell(this.TB_DEBITFORMULA).setValue(null);
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            row.getCell(this.TB_ITEM_NAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            IRPTItem ir = RPTItemFactory.getRemoteInstance();
            DataElementInfo dataElement = ir.getReportClassDataElement(rptItem.getId().toString());
            if (dataElement == null) {
                dataElement = DataElementProvider.getDataElementInfo("ENDBALANCE");
                row.getCell(this.TB_DATAELEMENT).setValue((Object)dataElement);
            } else {
                row.getCell(this.TB_DATAELEMENT).setValue((Object)dataElement);
            }
        }
        if (e.getColIndex() == row.getCell(this.TB_DEBITFORMULA).getColumnIndex() || e.getColIndex() == row.getCell(this.TB_CREDITFORMULA).getColumnIndex()) {
            Object formulaObj;
            Object debitFormula = row.getCell(this.TB_DEBITFORMULA).getValue();
            Object creditFormula = row.getCell(this.TB_CREDITFORMULA).getValue();
            if (debitFormula != null && creditFormula != null && debitFormula.toString().trim() != null && creditFormula.toString().trim() != null) {
                row.getCell(this.TB_DEBITFORMULA).setValue(null);
                row.getCell(this.TB_CREDITFORMULA).setValue(null);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName));
                return;
            }
            if (debitFormula != null && debitFormula.toString().length() != 0) {
                try {
                    this.checkFormulaFormat(debitFormula.toString());
                }
                catch (CheckFormulaException e1) {
                    row.getCell(this.TB_DEBITFORMULA).setValue(null);
                    super.handleException((Exception)((Object)e1));
                }
            }
            if (creditFormula != null && creditFormula.toString().length() != 0) {
                try {
                    this.checkFormulaFormat(creditFormula.toString());
                }
                catch (CheckFormulaException e1) {
                    row.getCell(this.TB_CREDITFORMULA).setValue(null);
                    super.handleException((Exception)((Object)e1));
                }
            }
            if ((formulaObj = this.kdtEntries.getRow(selectRow).getCell(e.getColIndex()).getValue()) != null && formulaObj.toString().trim().length() > 0) {
                this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
            } else {
                this.putClientProperty("clientProperty_formula_credit", null);
            }
        }
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        AdjustTempleEntryInfo lineInfo = (AdjustTempleEntryInfo)obj;
        lineInfo.setSummary(row.getCell(this.TB_SUMMARY).getValue() == null ? null : row.getCell(this.TB_SUMMARY).getValue().toString());
        lineInfo.setItem((RPTItemInfo)row.getCell(this.TB_ITEM_NUMBER).getValue());
        lineInfo.setDataElement(((DataElementInfo)row.getCell(this.TB_DATAELEMENT).getValue()).getInterSeq());
        lineInfo.setDebitFormula(row.getCell(this.TB_DEBITFORMULA).getValue() == null ? null : row.getCell(this.TB_DEBITFORMULA).getValue().toString());
        lineInfo.setCreditFormula(row.getCell(this.TB_CREDITFORMULA).getValue() == null ? null : row.getCell(this.TB_CREDITFORMULA).getValue().toString());
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        AdjustTempleEntryInfo lineInfo = (AdjustTempleEntryInfo)obj;
        row.getCell(this.TB_SUMMARY).setValue((Object)lineInfo.getSummary());
        row.getCell(this.TB_ITEM_NUMBER).setValue((Object)(lineInfo.getItem() == null ? null : lineInfo.getItem()));
        row.getCell(this.TB_ITEM_NAME).setValue(lineInfo.getItem() == null ? null : lineInfo.getItem().getName(this.getCurrentLocale()));
        row.getCell(this.TB_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo(lineInfo.getDataElement()));
        row.getCell(this.TB_DEBITFORMULA).setValue((Object)lineInfo.getDebitFormula());
        row.getCell(this.TB_CREDITFORMULA).setValue((Object)lineInfo.getCreditFormula());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnPCVoucher.setVisible(false);
        this.btnDelPCVoucher.setVisible(false);
        this.actionPCVoucher.setVisible(false);
        this.actionDelPCVoucher.setVisible(false);
        this.menuBiz.setVisible(false);
        this.hideUnuseableButtons();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
            if (this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
                this.btnEdit.setEnabled(false);
                this.actionEdit.setEnabled(false);
            }
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
        this.isCitedByLater.setEnabled(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionAddLine_actionPerformed(null);
            this.actionAddLine_actionPerformed(null);
        }
        this.isCopy = false;
        this.initRowMoveListener();
    }

    private void initRowMoveListener() {
        final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.kdtEntries);
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rowMoveAction.moveSelectedRowToTail();
            }
        });
    }

    protected void hideUnuseableButtons() {
        this.btnSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.menuItemSave.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.actionCopyFrom.setEnabled(false);
        this.menuSubmitOption.setVisible(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equals("")) {
            throw new AdjustException(AdjustException.NUMBER_BLANK);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().equals("")) {
            throw new AdjustException(AdjustException.NAME_BLANK);
        }
        if (this.editData.getAdjustMode() == null) {
            throw new AdjustException(AdjustException.ADJUSTMODE_BLANK);
        }
        if (this.editData.getEntries() == null || this.editData.getEntries().size() == 0) {
            throw new AdjustException(AdjustException.LINE_NOT_EXIST);
        }
        AdjustTempleEntryCollection col = this.editData.getEntries();
        for (int i = 0; i < col.size(); ++i) {
            AdjustTempleEntryInfo info = col.get(i);
            if (info.getDebitFormula() != null && info.getDebitFormula().length() > 2000) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongDebitFormula")), new Object[]{new Integer(i + 1)});
            }
            if (info.getCreditFormula() == null || info.getCreditFormula().length() <= 2000) continue;
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AdjustTemplet_TooLongCreditFormula")), new Object[]{new Integer(i + 1)});
        }
    }

    @Override
    protected void kdtEntries_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getSelectBlock() == null) {
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setUITitle(this.getUITitle().split("-")[0] + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.actionAddLine_actionPerformed(e);
        this.actionAddLine_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        IAdjustTemple iElimTemplet;
        if (this.oprtState == OprtState.EDIT && (iElimTemplet = (IAdjustTemple)this.getBizInterface()).getAdjustTempleInfo((IObjectPK)(pk = new ObjectUuidPK(this.editData.getId()))) != null && iElimTemplet.getAdjustTempleInfo((IObjectPK)pk).getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new AdjustException(AdjustException.HAVE_AUDITED);
        }
        super.actionSubmit_actionPerformed(e);
        if (this.isCopy) {
            this.actionAddNew_actionPerformed(e);
        }
        this.isCopy = false;
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        try {
            this.actionAddLine_actionPerformed(null);
            this.actionAddLine_actionPerformed(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        AdjustTempleInfo templetInfo = (AdjustTempleInfo)newData;
        templetInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.isCopy = true;
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText(null);
    }

    protected BOSObjectType getBOSObjectType() {
        return null;
    }
}

