/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustWorkSheetUI;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationHandEditUI;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.newrpt.RptNewUIHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.RptItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class AdjustWorkSheetUI
extends AbstractAdjustWorkSheetUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustWorkSheetUI.class);
    private SpreadContext AdjustSpreedContainer = null;
    private HashSet idSet = new HashSet();
    private CslReportInfo cslReportInfo = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    private ShareStyleAttributes ssaOfReverse = null;
    private ShareStyleAttributes ssaOfInvoice = null;
    private HashMap sheetFormula = null;
    private ICSLContext cslCtx = null;

    public void onShow() throws Exception {
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        this.AdjustSpreedContainer = this.createSpreadContextAddToPanel(this.AdjustSpreedContainer, this.kDPanel2);
        this.AdjustSpreedContainer.getFacadeManager().setErrorMessageBox(new FacadeManager.IErrorMessageBox(){

            public boolean show(Component parent, String title, String msg, int msgType) {
                if (msgType == 2) {
                    AdjustWorkSheetUI.this.showWarningMsg(msg);
                } else if (msgType == 0) {
                    AdjustWorkSheetUI.this.showErrorMsg(msg);
                } else {
                    AdjustWorkSheetUI.this.showWarningMsg(msg);
                }
                return false;
            }
        });
        this.getAuthorizedOrg();
        this.initReportF7();
        this.btnReverse.setEnabled(true);
        this.btnInvoice.setEnabled(true);
        this.initOfssa();
        this.ReportF7.setEditable(false);
        this.ReportF7.setMyCommonUseEnabled(false);
    }

    private void initOfssa() {
        StyleAttributes saOfReverse = Styles.getEmptySA();
        StyleAttributes saOfInverice = Styles.getEmptySA();
        saOfReverse.setBackground(Color.green);
        saOfInverice.setBackground(Color.red);
        this.ssaOfReverse = Styles.getSSA((StyleAttributes)saOfReverse);
        this.ssaOfInvoice = Styles.getSSA((StyleAttributes)saOfInverice);
    }

    private SpreadContext createSpreadContextAddToPanel(SpreadContext spreadContext, KDPanel sheetsPanel) {
        if (spreadContext == null) {
            spreadContext = new SpreadContext();
            SpreadManager.registerRenderProvider((IRenderProvider)new DefaultItemRenderProvider());
            final ItemFormulaPanel itemFormulaPanel = new ItemFormulaPanel(spreadContext, false);
            itemFormulaPanel.setEnabled(false);
            itemFormulaPanel.setPanelVisible(false);
            spreadContext.getFacadeManager().getPromptPanel().setRightComponent((JComponent)itemFormulaPanel);
            itemFormulaPanel.setFormulaProvider((IItemFormulaProvider)new RptItemFormulaProvider());
            spreadContext.addSheetChangeListener(new SheetChangeListener(){

                public void changed(SheetChangeEvent e) {
                    itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), 10);
                }
            });
            UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
            ItemDisplayProvider itemDisplayProvider = new ItemDisplayProvider();
            userCellDisplayProvider.setDisplayValueProvider((IDisplayValueProvider)itemDisplayProvider);
            spreadContext.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)userCellDisplayProvider);
            sheetsPanel.setLayout((LayoutManager)new KDLayout());
            sheetsPanel.add((Component)spreadContext, (Object)new KDLayout.Constraints(0, 0, 1078, 630, 15));
        }
        spreadContext.getPopMenuManager().getPopMenu().hide();
        return spreadContext;
    }

    public void showWarningMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(Color.yellow);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void showErrorMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void initReportF7() throws BOSException {
        this.ReportF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.CSLWorkF7Query");
        this.ReportF7.setEditFormat("$name$");
        this.ReportF7.setDisplayFormat("$name$");
        this.ReportF7.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)4));
        try {
            CurrencyInfo currency;
            OrgUnitInfo info = (OrgUnitInfo)this.getUIContext().get("orgUnit");
            String longNumber = info.getLongNumber();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            if (this.idSet != null && this.idSet.size() > 0) {
                if (this.idSet.size() == 1) {
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.idSet));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.idSet, CompareType.INCLUDE));
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", null, CompareType.EQUALS));
            }
            if (this.cslCtx != null) {
                filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(this.cslCtx.getCurRptYear()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.cslCtx.getCurRptPeriod()), CompareType.EQUALS));
                if (this.cslCtx.getCurRptPeriodType() != null && this.cslCtx.getCurRptPeriodType() == RptPeriodTypeEnum.MONTHLY) {
                    filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("periodType", null, CompareType.EQUALS));
                }
            }
            if ((currency = (CurrencyInfo)this.getUIContext().get("currency")) == null) {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString(), CompareType.EQUALS));
            }
        }
        catch (Exception e) {
            logger.error((Object)"initReportF7()", (Throwable)e);
        }
        evi.setFilter(filter);
        this.ReportF7.setEntityViewInfo(evi);
        this.ReportF7.setEnabledMultiSelection(false);
        this.ReportF7.setMyCommonUseEnabled(false);
        this.ReportF7.setHistoryRecordEnabled(false);
        this.ReportF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (eventObj.getNewValue() == null) {
                        SysUtil.abort();
                    }
                    AdjustWorkSheetUI.this.cslReportInfo = (CslReportInfo)eventObj.getNewValue();
                    AdjustWorkSheetUI.this.ReportF7DataChange((CslReportInfo)eventObj.getNewValue());
                    AdjustWorkSheetUI.this.initItemAndDataElement();
                }
                catch (Exception e) {
                    logger.error((Object)"adjust Report F7 change error", (Throwable)e);
                }
            }
        });
    }

    private void ReportF7DataChange(CslReportInfo f7CslReport) throws Exception {
        Book book = f7CslReport.getBook();
        if (book == null) {
            return;
        }
        book.setAutoCalculate(true);
        Sheet sheet = null;
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            Range r = sheet.getRange(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex());
            sheet.getRange(0, 0).select();
            sheet.setEnableCalculation(true);
            ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
            vs.setFirstCol(0);
            vs.setFirstRow(0);
            StyleAttributes protectStyle = Styles.getEmptySA();
            protectStyle.setLocked(true);
            r.getStyle(Styles.getEmptySA(), protectStyle);
            r.setCellLocked(true);
            sheet.getSheetOption().setCellDisplayMode(0);
            sheet.getSheetOption().getProtection(true).start("auto^Protection");
            sheet.getSheetOption().getProtection(true).setOperations(15);
        }
        book.setActiveSheet(0);
        this.AdjustSpreedContainer.setBook(book);
    }

    private void getAuthorizedOrg() throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        String[] permItems = new String[]{"isFromAdjustWorkSheet", "csl_workingrpt_view"};
        OrgType orgType = OrgType.UnionDebt;
        IRowSet rs = RptNewUIHandleFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, permItems, orgType);
        while (rs.next()) {
            if (rs.getString("FID") == null) continue;
            this.idSet.add(rs.getString("FID"));
        }
    }

    private void creatLineInfo(boolean isReverse) throws BOSException {
        if (this.ReportF7.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"967_Adjust_FirstSelectWork"));
            SysUtil.abort();
        }
        ArrayList<EliminationEntryInfo> lineInfos = new ArrayList<EliminationEntryInfo>();
        Book book = this.AdjustSpreedContainer.getBook();
        boolean isHasFormla = false;
        HashSet<String> dataElementNumbers = new HashSet<String>();
        HashSet<String> itemNumbers = new HashSet<String>();
        Sheet sheet = book.getActiveSheet();
        Range range = this.AdjustSpreedContainer.getRangeManager().getAppropriateSelectionRange(sheet);
        int size = range.size();
        if (size == 0) {
            isHasFormla = false;
        }
        HashMap map = (HashMap)this.sheetFormula.get(book.getActiveSheetIndex());
        HashMap itemMap = (HashMap)map.get("KEY_ITEMS");
        HashMap formulaMap = (HashMap)map.get("KEY_PARAMS");
        HashMap companyID = (HashMap)map.get("KEY_COMPANY_ID");
        HashSet companyIDSet = new HashSet();
        for (int j = 0; j < size; ++j) {
            CellBlock cb = range.getBlock(j);
            int r2 = cb.getRow2();
            for (int r = cb.getRow(); r <= r2; ++r) {
                int c2 = cb.getCol2();
                for (int c = cb.getCol(); c <= c2; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    if (cell == null || !(cell.getValue().getValue() instanceof BigDecimal) || BigDecimal.ZERO.equals(cell.getValue().getValue()) || itemMap.get(r) == null || formulaMap.get(c) == null) continue;
                    String itemNumber = (String)itemMap.get(r);
                    String dataElementNumber = (String)formulaMap.get(c);
                    isHasFormla = true;
                    if (isReverse) {
                        cell.setSSA(this.ssaOfReverse);
                    } else {
                        cell.setSSA(this.ssaOfInvoice);
                    }
                    EliminationEntryInfo lineInfo = new EliminationEntryInfo();
                    lineInfo.setIsVisible(true);
                    lineInfo.setDebit((BigDecimal)cell.getValue().getValue());
                    lineInfo.put("rptItemNumber", itemMap.get(r));
                    lineInfo.put("dataElementNumber", formulaMap.get(c));
                    if (companyID.get(c) != null) {
                        lineInfo.put("companyID", companyID.get(c));
                        companyIDSet.add(companyID.get(c));
                    }
                    lineInfos.add(lineInfo);
                    if (!itemNumbers.contains(itemNumber)) {
                        itemNumbers.add(itemNumber);
                    }
                    if (dataElementNumbers.contains(dataElementNumber)) continue;
                    dataElementNumbers.add(dataElementNumber);
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getCompanySelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        HashMap<String, FullOrgUnitInfo> companyMap = null;
        if (coll != null) {
            companyMap = new HashMap<String, FullOrgUnitInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                String id = coll.get(i).getId().toString();
                companyMap.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        if (!isHasFormla) {
            MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"966_Adjust_NoSelectFormla"));
            SysUtil.abort();
        }
        ((EliminationHandEditUI)this.getUIContext().get("Owner")).addLineByWorkEditData(isReverse, lineInfos, itemNumbers, dataElementNumbers, companyMap);
        ((EliminationHandEditUI)this.getUIContext().get("Owner")).getUIWindow().show();
    }

    @Override
    public void actionCreateReverse_actionPerformed(ActionEvent e) throws Exception {
        this.creatLineInfo(true);
    }

    @Override
    public void actionCreateInvoice_actionPerformed(ActionEvent e) throws Exception {
        this.creatLineInfo(false);
    }

    private void initItemAndDataElement() {
        this.sheetFormula = new HashMap();
        Book book = this.AdjustSpreedContainer.getBook();
        if (book == null) {
            return;
        }
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            this.sheetFormula.put(i, this.constructMnsTableMap(sheet));
        }
    }

    private HashMap constructMnsTableMap(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        HashMap result = new HashMap();
        HashMap items = null;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        int left = CslRptUtil.getBasePosition_Left(sheet);
        int top = CslRptUtil.getBasePosition_Top(sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        items = this.getItemsMap(sheet, rowCount, top + 1, left);
        boolean isIncludeAdjust = MnsRptGuideHelper.isIncludeAdjust(sheet, sheet.getCell(top, left, false));
        Integer[] adjustDataSrc = null;
        if (items.size() > 0) {
            HashMap<Integer, String> formulas = new HashMap<Integer, String>();
            HashMap<Integer, String> companyID = new HashMap<Integer, String>();
            for (int columnIndex = left + 1; columnIndex < colCount; ++columnIndex) {
                ItemFormula curFormula = (ItemFormula)sheet.getRange(top, columnIndex).getUserObject("ITEM");
                if (curFormula == null) continue;
                curFormula.setCell(null);
                if (isIncludeAdjust && curFormula.getExt("DataSrc") != null && (1 == Integer.valueOf(curFormula.getExt("DataSrc")) || 2 == Integer.valueOf(curFormula.getExt("DataSrc")) || 3 == Integer.valueOf(curFormula.getExt("DataSrc")))) {
                    adjustDataSrc = MnsRptGuideHelper.getAdjustDataSrc(curFormula);
                    if (adjustDataSrc != null) {
                        for (int i = 0; i < adjustDataSrc.length; ++i) {
                            curFormula = (ItemFormula)curFormula.clone();
                            curFormula.putExt("DATASRCFORADJUST", String.valueOf(adjustDataSrc[i]));
                            formulas.put(new Integer(columnIndex + i), curFormula.getDataElementNumber());
                            if (curFormula.getExt("Company") == null) continue;
                            companyID.put(new Integer(columnIndex + i), curFormula.getExt("Company").toString());
                        }
                        continue;
                    }
                    formulas.put(new Integer(columnIndex), curFormula.getDataElementNumber());
                    if (curFormula.getExt("Company") == null) continue;
                    companyID.put(new Integer(columnIndex), curFormula.getExt("Company").toString());
                    continue;
                }
                formulas.put(new Integer(columnIndex), curFormula.getDataElementNumber());
                if (curFormula.getExt("Company") == null) continue;
                companyID.put(new Integer(columnIndex), curFormula.getExt("Company").toString());
            }
            if (formulas.size() > 0) {
                result.put("KEY_ITEMS", items);
                result.put("KEY_PARAMS", formulas);
                result.put("KEY_COMPANY_ID", companyID);
            }
        }
        return result;
    }

    private HashMap getItemsMap(Sheet sheet, int rowCount, int top, int left) {
        HashMap<Integer, String> items = new HashMap<Integer, String>(8);
        for (int rowIndex = top; rowIndex < rowCount; ++rowIndex) {
            ItemFormula curFormula = (ItemFormula)sheet.getRange(rowIndex, left).getUserObject("ITEM");
            if (curFormula == null) continue;
            curFormula.setCell(null);
            if (curFormula.getItemNumber() == null) continue;
            items.put(new Integer(rowIndex), curFormula.getItemNumber());
        }
        return items;
    }

    private SelectorItemCollection getCompanySelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("id"));
        return selector;
    }
}

