/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimRelaOrgTreeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IElimRelaOrgTree;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.client.IElimImportBasicTree;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AllCompanyImport
implements IElimImportBasicTree {
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    IElimRelaOrgTree iElimRela = ElimRelaOrgTreeFactory.getRemoteInstance();
    private Object sourceCurrencyinfo = null;
    private Object currencyinfo = null;
    private Object elimType = null;
    private Object elimMode = null;

    @Override
    public void addRecordToTable(EntityViewInfo eliminationImportQuery, List companyIds) throws BOSException, EASBizException {
        IOrgStructure structure = OrgStructureFactory.getRemoteInstance();
        EntityViewInfo structureView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.orgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.orgTreeInfo.getId().toString(), CompareType.EQUALS));
        structureView.setFilter(filterInfo);
        CoreBaseCollection collection = structure.getCollection(structureView);
        OrgStructureInfo base = null;
        StringBuffer companys = new StringBuffer("");
        for (int i = 0; i < collection.size(); ++i) {
            base = (OrgStructureInfo)collection.get(i);
            companys.append("'").append(base.getUnit().getId().toString()).append("'").append(",");
            companyIds.add(base.getUnit().getId().toString());
        }
        if (companys.lastIndexOf(",") != -1) {
            companys.deleteCharAt(companys.lastIndexOf(","));
        }
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        Date rptDate = this.getPeriodLastDate();
        OrgTreeCollection orgBoundList = iOrgTree.getOrgTreeCollection("SELECT id WHERE basic = 1 and type = 8 and startdate <= '" + new Timestamp(rptDate.getTime()) + "' and (enddate is null or enddate >= '" + new Timestamp(rptDate.getTime()) + "')");
        StringBuffer basicOrgTrees = new StringBuffer("");
        OrgTreeInfo tree = null;
        if (orgBoundList != null && orgBoundList.size() > 0) {
            tree = orgBoundList.get(0);
            basicOrgTrees.append("'" + tree.getId().toString() + "'");
        }
        FilterInfo filter = null;
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        param.put("periodType", new Integer(this.periodType.getValue()));
        param.put("orgBound.id", basicOrgTrees.toString());
        param.put("entries.company.id", companys.toString());
        IElimination iElim = EliminationFactory.getRemoteInstance();
        List list = iElim.getElimId(param);
        StringBuffer sql = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                sql.append(list.get(i)).append(",");
            }
            if (sql.length() > 0) {
                sql.deleteCharAt(sql.length() - 1);
            }
        } else {
            sql.append("");
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INCLUDE));
        if (this.currencyinfo != null) {
            CurrencyInfo currency = (CurrencyInfo)this.currencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
        }
        if (this.sourceCurrencyinfo != null) {
            CurrencyInfo currency = (CurrencyInfo)this.sourceCurrencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)currency.getId().toString()));
        }
        if (this.elimType != null) {
            ElimTypeEnum type = (ElimTypeEnum)((Object)this.elimType);
            filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)new Integer(type.getValue())));
        }
        if (this.elimMode != null) {
            if ("".equals(this.elimMode)) {
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", null));
            } else {
                EliminationModeInfo eliminationModeInfo = (EliminationModeInfo)this.elimMode;
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", (Object)eliminationModeInfo.getId().toString()));
            }
        }
        eliminationImportQuery.setFilter(filter);
    }

    private Date getPeriodLastDate() throws EASBizException, BOSException {
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, this.periodType)) {
            periods = FiscalPeriodHelper.getPeriodCollection(null, this.orgTreeInfo);
        }
        return FiscalPeriodHelper.getPeriodLastDate(periods, this.year, this.period, this.periodType, isMergeByFiscalPeriod);
    }

    private boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodType) {
        return FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType);
    }

    @Override
    public void setBasicParam(HashMap param) {
        this.orgUnitInfo = (OrgUnitInfo)param.get("orgUnitInfo");
        this.year = new Integer(param.get("year").toString());
        this.period = new Integer(param.get("period").toString());
        this.periodType = (RptPeriodTypeEnum)param.get("periodType");
        this.orgTreeInfo = (OrgTreeInfo)param.get("orgTreeInfo");
    }

    @Override
    public void setCurrency(HashMap map) {
        this.sourceCurrencyinfo = map.get("sourceCurrency");
        this.currencyinfo = map.get("currency");
    }

    @Override
    public void setElimType(Object elimType) {
        this.elimType = elimType;
    }

    @Override
    public void setElimMode(Object elimMode) {
        this.elimMode = elimMode;
    }
}

