/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAnalysisFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnlysisClientHelper;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class AnalysisFilterUI
extends AbstractAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisFilterUI.class);
    private static final String SELECT_ALL = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");

    public void onLoad() throws Exception {
        super.onLoad();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - 1);
        this.spinCurrentYear.setValue((Object)new Integer(calendar.get(1)));
        this.spinCurrentPeriod.setValue((Object)new Integer(calendar.get(2)));
        this.spinCurrentYear.setEnabled(false);
        this.spinCurrentPeriod.setEnabled(false);
        this.initPeriodType();
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AnalysisFilterUI.this.refreshDate();
            }
        });
        this.cbxQueryStatus.removeAllItems();
        this.cbxQueryStatus.addItem((Object)CommittedStatusEnum.GROUPCOMMITTED);
        this.pkReortDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                AnalysisFilterUI.this.refreshDate();
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    private void refreshDate() {
        Object type = this.comboPeriodType.getSelectedItem();
        if (type == null || type.equals(SELECT_ALL)) {
            return;
        }
        List times = null;
        if (this.pkReortDate.getSqlDate() != null) {
            times = RPTDateUtil.getRptPeriod(this.pkReortDate.getSqlDate(), (RptPeriodTypeEnum)type);
            this.spinCurrentYear.setValue((Object)new Integer(times.get(0).toString()));
            this.spinCurrentPeriod.setValue((Object)new Integer(times.get(1).toString()));
            this.pkReortDate.setValue(times.get(2));
        }
    }

    private void initPeriodType() {
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        this.comboPeriodType.setSelectedIndex(0);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        if (this.comboPeriodType.getSelectedItem() != null && !this.comboPeriodType.getSelectedItem().equals(SELECT_ALL)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemPeriodType);
            Integer year = (Integer)this.spinCurrentYear.getValue();
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)year, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            Integer period = (Integer)this.spinCurrentPeriod.getValue();
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)period, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
        }
        CommittedStatusEnum queryStatus = (CommittedStatusEnum)this.cbxQueryStatus.getSelectedItem();
        FilterItemInfo item = new FilterItemInfo("committedStatus", (Object)new Integer(queryStatus.getValue()));
        this.filterInfo.getFilterItems().add(item);
        FilterItemInfo dataCollectItem = new FilterItemInfo("dataCollect.id", (Object)DataCollectConstant.getBudgetDC().getId().toString());
        this.filterInfo.getFilterItems().add(dataCollectItem);
        StringBuffer maskString = new StringBuffer();
        int size = this.filterInfo.getFilterItems().size();
        for (int index = 0; index < size; ++index) {
            maskString.append(" #").append(index);
            if (index + 1 == size) continue;
            maskString.append(" and ");
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public void clear() {
        super.clear();
        this.comboPeriodType.setSelectedIndex(0);
        int[] value = AnlysisClientHelper.getLastPeriod(RptPeriodTypeEnum.MONTHLY, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - 1);
        this.spinCurrentYear.setValue((Object)new Integer(value[0]));
        this.spinCurrentPeriod.setValue((Object)new Integer(value[1]));
        this.spinCurrentYear.setEnabled(false);
        this.spinCurrentPeriod.setEnabled(false);
        this.pkReortDate.setValue((Object)calendar.getTime());
    }

    public void loadData(EntityViewInfo v) {
        super.loadData(v);
        FilterItemCollection currentFilterItemCollection = v.getFilter() == null ? new FilterItemCollection() : v.getFilter().getFilterItems();
        Integer year = null;
        Integer period = null;
        RptPeriodTypeEnum periodType = null;
        CommittedStatusEnum queryStatus = null;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodTypeInt = (Integer)filterItemInfo.getCompareValue();
                periodType = RptPeriodTypeEnum.getEnum((int)periodTypeInt);
                this.comboPeriodType.setSelectedItem((Object)periodType);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                year = (Integer)filterItemInfo.getCompareValue();
                this.spinCurrentYear.setValue((Object)year);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                period = (Integer)filterItemInfo.getCompareValue();
                this.spinCurrentPeriod.setValue((Object)period);
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("queryStatus")) continue;
            Integer queryStatusValue = (Integer)filterItemInfo.getCompareValue();
            queryStatus = CommittedStatusEnum.getEnum((int)queryStatusValue);
            this.cbxQueryStatus.setSelectedItem((Object)queryStatus);
        }
        if (periodType != null && year != null && period != null) {
            this.pkReortDate.setValue((Object)RPTDateUtil.getPeriodLastDate(year, period, periodType));
        }
    }
}

