/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class AnlysisClientHelper {
    public static void setSpineRange(KDSpinner sp, int minVal, int maxVal) {
        Integer n2;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        try {
            n2 = new Integer(maxVal);
            nm.setMaximum(n2);
            if (n2 < 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException n2) {
            // empty catch block
        }
        try {
            n2 = new Integer(minVal);
            nm.setMinimum(n2);
            if (n2 > 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        AnlysisClientHelper.setSpineRange(sp, min, max);
    }

    public static int[] getLastPeriod(RptPeriodTypeEnum t, int last) {
        Calendar c = Calendar.getInstance();
        if (t.getValue() == 3) {
            c.set(2, c.get(2) - (last - 1));
        } else if (t.getValue() == 4) {
            c.set(2, c.get(2) - (last * 3 - 1));
        } else if (t.getValue() == 6) {
            c.set(2, c.get(2) - (last * 12 - 1));
        }
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    public static void exportBookContent(File file, SpreadContext sc) throws Exception {
        if (sc == null) {
            return;
        }
        Book _book = sc.getBook();
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    _kdsCell.setValue((Object)_cell.getValue());
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    public static void checkAnlysisCanStart(CoreUI ui) throws EASBizException, BOSException {
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        if (!"true".equals(isSupportOtherDS)) {
            MsgBox.showError((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Query_Param_Is_False"));
            SysUtil.abort();
        }
    }

    public static void setPopMenuVisible(SpreadContext sc) {
        sc.getPopMenuManager().getItem("MenuItem_Copy").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Cut").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Paste").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_SelectablePaste").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Insert").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Delete").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Comment").setAction(null);
        sc.getPopMenuManager().getItem("MenuItem_Comment").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Comment").setVisible(false);
        sc.getPopMenuManager().getItem("MenuItem_HyperLink").setAction(null);
        sc.getPopMenuManager().getItem("MenuItem_HyperLink").setVisible(false);
        sc.getPopMenuManager().getItem("MenuItem_HyperLink").setVisible(false);
        sc.getPopMenuManager().getItem("MenuItem_ChartProperty").setEnabled(false);
        sc.getPopMenuManager().getItem("MenuItem_Style").setEnabled(true);
    }
}

