/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAutoItemBusinessFacade;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAutoItemItemCenterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataForItemCenter;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowDynItemName;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEntityInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowItemSourceName;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.CompanyAndItemTreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ILoadSubNodeAction;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ITreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.SetTreeTable;
import com.kingdee.eas.fi.gr.cslrpt.client.util.FillTable;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AutoItemItemCenterUI
extends AbstractAutoItemItemCenterUI {
    private static final long serialVersionUID = -1607304318507852531L;
    private static final Logger logger = CoreUIObject.getLogger(AutoItemItemCenterUI.class);
    private FormulaCalcContextInfo calcContext = null;

    public AutoItemItemCenterUI() throws Exception {
        this.tblMain.checkParsed(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        if (this.getMainStatusBar() != null && this.getMainStatusBar().getStatusBar() != null) {
            this.getMainStatusBar().getStatusBar().setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        LoadItemValueByCompany loadSubNodeAction = new LoadItemValueByCompany();
        new SetTreeTable(false).exec(this.tblMain, "companyOrItem", null, loadSubNodeAction);
        this.onLoadForYearOrPeriod();
        this.calcContext = (FormulaCalcContextInfo)this.getUIContext().get(FormulaCalcContextInfo.class);
        if (this.calcContext == null) {
            throw new RuntimeException("uicontext's error!please check. ");
        }
        FastMergeUtil.setPeriodRange(this.spPeriod, this.calcContext.getPeriodType().getValue(), this.calcContext.getYear());
        int[] yearAndPeriod = FastMergeUtil.getLastCalcYearAndPeriod(null, this.calcContext.getId().toString());
        if (yearAndPeriod != null && yearAndPeriod.length == 2) {
            this.calcContext.setYear(yearAndPeriod[0]);
            this.calcContext.setPeriod(yearAndPeriod[1]);
        }
        this.loadFields();
    }

    protected void onLoadForYearOrPeriod() {
        CslRptUIUtil.setSpineRange(this.spYear, 1974, Integer.MAX_VALUE);
        CslRptUIUtil.setSpineRange(this.spPeriod, 1, 366);
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!(AutoItemItemCenterUI.this.spYear.getValue() instanceof Integer)) {
                    AutoItemItemCenterUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.year"));
                }
                AutoItemItemCenterUI.this.calcContext.setYear((Integer)AutoItemItemCenterUI.this.spYear.getValue());
                AutoItemItemCenterUI.this.loadItemValue();
            }
        });
        this.spPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!(AutoItemItemCenterUI.this.spPeriod.getValue() instanceof Integer)) {
                    AutoItemItemCenterUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.period"));
                }
                AutoItemItemCenterUI.this.calcContext.setPeriod((Integer)AutoItemItemCenterUI.this.spPeriod.getValue());
                AutoItemItemCenterUI.this.loadItemValue();
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.spYear.setValue((Object)this.calcContext.getYear(), false);
        this.spPeriod.setValue((Object)this.calcContext.getPeriod(), false);
        this.txtCurrency.setText(this.calcContext.getCurrentCurrency().getName());
        this.txtPeriodType.setText(this.calcContext.getPeriodType().getAlias());
        this.loadItemValue();
    }

    protected void loadItemValue() {
        this.tblMain.removeRows();
        LoadItemValueByCompany loadSubNodeAction = new LoadItemValueByCompany();
        ArrayList<ItemDataForItemCenter> data = new ArrayList<ItemDataForItemCenter>(1);
        int size = this.calcContext.getCompanys().size();
        for (int companyIndex = 0; companyIndex < size; ++companyIndex) {
            data.add(new ItemDataForItemCenter((OrgUnitInfo)this.calcContext.getCompanys().get(companyIndex).getCompany(), null, null, null, null));
        }
        new FillTable(this.tblMain, new String[]{"companyOrItem", "itemValue", "itemDefine"}).exec(data);
        if (this.calcContext == null) {
            return;
        }
        if (!data.isEmpty()) {
            loadSubNodeAction.exec(this.tblMain, ((ItemDataForItemCenter)data.get(0)).getRowNode(), 0);
        }
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    public class LoadItemValueByCompany
    implements ILoadSubNodeAction {
        @Override
        public boolean exec(KDTable table, ITreeTableNodeEntity rowData, int rowIndex) {
            ItemValueSet itemValues;
            DBHandler dao = new DBHandler(null);
            if (!(rowData instanceof CompanyAndItemTreeTableNodeEntity)) {
                return false;
            }
            OrgUnitInfo company = ((CompanyAndItemTreeTableNodeEntity)rowData).getCompany();
            try {
                itemValues = dao.get(IAutoItemBusinessFacade.class).queryItemValue(AutoItemItemCenterUI.this.calcContext, company);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
            ArrayList<ItemDataForItemCenter> data = new ArrayList<ItemDataForItemCenter>(itemValues.size());
            ShowEntityInfo showEntityInfo = new ShowEntityInfo(dao);
            ShowDynItemName showDynItemName = new ShowDynItemName(dao);
            ShowItemSourceName showItemSourceName = new ShowItemSourceName(dao);
            Object result = null;
            TreeSet<ItemValue> orderItemValues = new TreeSet<ItemValue>(new Comparator<ItemValue>(){

                @Override
                public int compare(ItemValue o1, ItemValue o2) {
                    return o1.getNumber().compareTo(o2.getNumber()) > 0 || o1.getNumber().compareTo(o2.getNumber()) == 0 && o1.getContext() != null && o2.getContext() != null && o1.getContext().getDataElement() > o2.getContext().getDataElement() ? 1 : -1;
                }
            });
            orderItemValues.addAll(itemValues);
            Object itemDefine = null;
            for (ItemValue itemValue : orderItemValues) {
                result = itemValue.getResult();
                if (itemValue.getResult() instanceof BigDecimal) {
                    result = ((BigDecimal)itemValue.getResult()).setScale(2, 1);
                }
                itemDefine = "ITEM".equalsIgnoreCase(itemValue.getType()) ? showEntityInfo.exec(itemValue) : showDynItemName.register(itemValue);
                data.add(new ItemDataForItemCenter(company, itemValue.getNumber(), result, itemDefine, showItemSourceName.register(itemValue.getContext().getSourceType())));
            }
            try {
                showItemSourceName.exec();
                showDynItemName.exec();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
            new FillTable(AutoItemItemCenterUI.this.tblMain, new String[]{"companyOrItem", "itemValue", "itemDefine", "itemSource"}).insert(data, rowIndex);
            rowData.setExpand(true);
            rowData.setHasLoaded(true);
            return true;
        }
    }
}

