/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ExportFileTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ExportModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractBatchExportToExcelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ExportNameRuleUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ExportNameRule;
import com.kingdee.eas.fi.gr.cslrpt.util.ReceiveFilterCondition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;

public class BatchExportToExcelUI
extends AbstractBatchExportToExcelUI {
    private RptPeriodTypeEnum periodType;
    private ExportNameRule nameRule;
    private int year;
    private int period;
    private List selectedTemplate = new ArrayList();
    private Map selectedUnit = new HashMap();
    private List selectedTemplate2 = new ArrayList();
    private Map selectedUnit2 = new HashMap();
    private HashSet idSet2 = new HashSet();
    private HashSet idSet = new HashSet();
    private int isQueryBudget;
    private boolean isTrigger = true;

    public ExportNameRule getNameRule() {
        return this.nameRule;
    }

    public BatchExportToExcelUI() throws Exception {
        this.actionRemove.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad() throws Exception {
        try {
            super.onLoad();
            this.txtNumber.setMaxLength(80);
            this.multiLangName.setMaxLength(80);
            Map ctx = this.getUIContext();
            this.isQueryBudget = (Integer)ctx.get("ISQUERYBUDGET");
            ReceiveFilterCondition condition = (ReceiveFilterCondition)ctx.get("ReceiveFilterCondition");
            if (condition != null) {
                this.periodType = condition.getPeriodType();
                this.year = condition.getYear();
                this.period = condition.getPeriod();
            }
            if (!this.getOprtState().equals("ADDNEW")) {
                this.periodType = this.editData.getPeriodType();
            }
            if (this.getOprtState().equals("ADDNEW")) {
                this.kDComboBox1.setSelectedIndex(-1);
            }
            try {
                if (this.editData.getNameRule() != null) {
                    this.nameRule = ExportNameRule.getFromString(this.editData.getNameRule());
                }
                this.initControls();
                this.initCollections();
                this.initDataCollect();
            }
            catch (Exception e) {
                this.handleException(e);
                this.abort();
            }
        }
        finally {
            this.isTrigger = true;
        }
        if (this.getUIContext().get("isNoPermissionOfEdit") != null) {
            this.btnEdit.setEnabled(false);
        }
    }

    private void initCollections() throws Exception {
        this.selectedUnit.clear();
        this.selectedTemplate2.clear();
        this.selectedTemplate.clear();
        this.selectedUnit2.clear();
        if (this.editData.getMode() == ExportModeEnum.EXPORTBYORG) {
            ExportSchemeEntryCollection entryCol = this.editData.getEntries();
            List<FullOrgUnitInfo> unitList = new ArrayList();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                TemplateInfo template;
                ExportSchemeEntryInfo entry = entryCol.get(i);
                OrgTreeInfo tree = entry.getOrgTree();
                FullOrgUnitInfo unit = entry.getOrgUnit();
                if (tree != null && unit != null) {
                    if (this.selectedUnit.containsKey(tree)) {
                        unitList = (List)this.selectedUnit.get(tree);
                    } else {
                        unitList = new ArrayList();
                        this.selectedUnit.put(tree, unitList);
                    }
                    if (!unitList.contains(unit)) {
                        unitList.add(unit);
                    }
                }
                if ((template = entry.getTemplate()) == null) continue;
                this.selectedTemplate2.add(template);
            }
            if (!this.selectedUnit.isEmpty()) {
                this.fillTable();
                if (!this.selectedTemplate2.isEmpty()) {
                    this.fillTable2();
                }
            } else {
                this.btnAdd2.setEnabled(false);
                this.btnDelete2.setEnabled(false);
            }
        } else {
            ExportSchemeEntryCollection entries = this.editData.getEntries();
            List<FullOrgUnitInfo> unitList = new ArrayList();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                ExportSchemeEntryInfo entry = entries.get(i);
                TemplateInfo template = entry.getTemplate();
                if (template != null) {
                    this.selectedTemplate.add(template);
                }
                OrgTreeInfo tree = entry.getOrgTree();
                FullOrgUnitInfo unit = entry.getOrgUnit();
                if (tree == null || unit == null) continue;
                if (this.selectedUnit2.containsKey(tree)) {
                    unitList = (List)this.selectedUnit2.get(tree);
                } else {
                    unitList = new ArrayList();
                    this.selectedUnit2.put(tree, unitList);
                }
                if (unitList.contains(unit)) continue;
                unitList.add(unit);
            }
            if (!this.selectedTemplate.isEmpty()) {
                this.fillTable();
                if (!this.selectedUnit2.isEmpty()) {
                    this.fillTable2();
                }
            } else {
                this.btnAdd2.setEnabled(false);
                this.btnDelete2.setEnabled(false);
            }
        }
    }

    private void initControls() throws Exception {
        if (this.editData.getMode().equals((Object)ExportModeEnum.EXPORTBYORG)) {
            this.radByUnit.setSelected(true);
            this.radByUnit_actionPerformed(null);
        } else {
            this.radByReport.setSelected(true);
            try {
                this.isTrigger = false;
                this.radByReport_actionPerformed(null);
            }
            finally {
                this.isTrigger = true;
            }
            this.btnAdd2.setEnabled(false);
            this.btnDelete2.setEnabled(false);
        }
        this.initComboCurrency();
        this.initComboFileType();
        this.comboPeriodType.addItem((Object)this.periodType);
        this.comboPeriodType.setSelectedItem((Object)this.periodType);
        this.cbkReceived.setSelected(this.editData.isIsReceived());
        this.cbkCommitted.setSelected(this.editData.isIsCommitted());
        this.cbkAudited.setSelected(this.editData.isIsAudited());
        this.cbkUnaudited.setSelected(this.editData.isIsUnAudited());
        this.actionSelectPath.setEnabled(true);
        if (this.editData.isIsSubFile()) {
            this.subDir.setSelected(true);
            this.kDComboBox1.setEditable(false);
            this.kDComboBox1.setEnabled(true);
            this.kDComboBox1.setSelectedIndex(this.editData.getExportType());
        } else {
            this.subDir.setSelected(false);
            this.kDComboBox1.setEditable(false);
            this.kDComboBox1.setEnabled(false);
            this.kDComboBox1.setSelectedIndex(-1);
        }
        this.subDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BatchExportToExcelUI.this.kDComboBox1.setEnabled(BatchExportToExcelUI.this.subDir.isSelected());
                if (!BatchExportToExcelUI.this.subDir.isSelected()) {
                    BatchExportToExcelUI.this.kDComboBox1.setSelectedIndex(-1);
                } else {
                    BatchExportToExcelUI.this.kDComboBox1.setSelectedIndex(0);
                }
            }
        });
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.initComboCurrency();
        this.initComboFileType();
        int index = this.editData.getExportType();
        this.kDComboBox1.setSelectedIndex(index);
    }

    private void initComboFileType() throws ParserException, EASBizException, BOSException {
        this.fileTypeComboBox.removeAllItems();
        this.fileTypeComboBox.addItem((Object)ExportFileTypeEnum.XLS);
        this.fileTypeComboBox.addItem((Object)ExportFileTypeEnum.XLSX);
        if (this.editData.getFileType() != null) {
            this.fileTypeComboBox.setSelectedItem((Object)this.editData.getFileType());
        } else {
            this.fileTypeComboBox.setSelectedItem((Object)ExportFileTypeEnum.XLS);
        }
    }

    private void initComboCurrency() throws ParserException, EASBizException, BOSException {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ICurrency ie = CurrencyFactory.getRemoteInstance();
        CurrencyCollection collection = ie.getCurrencyCollection(true);
        model.addElement(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"));
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            model.addElement((String)collection.get(i));
        }
        this.comboCurrency.setModel(model);
        if (this.editData.getCurrency() != null && this.editData.getCurrency().getId() != null) {
            String currencyId = this.editData.getCurrency().getId().toString();
            int count = this.comboCurrency.getItemCount();
            for (int i = 0; i < count; ++i) {
                CurrencyInfo cur;
                Object currency = this.comboCurrency.getItemAt(i);
                if (!(currency instanceof CurrencyInfo) || !currencyId.equals((cur = (CurrencyInfo)currency).getId().toString())) continue;
                this.comboCurrency.setSelectedIndex(i);
            }
        } else {
            this.comboCurrency.setSelectedIndex(0);
        }
    }

    protected IObjectValue createNewData() {
        this.selectedTemplate.clear();
        this.selectedUnit.clear();
        this.selectedTemplate2.clear();
        this.selectedUnit2.clear();
        this.idSet.clear();
        this.idSet2.clear();
        this.kDTable1.removeRows();
        this.kDTable2.removeRows();
        ExportSchemeInfo info = new ExportSchemeInfo();
        info.setMode(ExportModeEnum.EXPORTBYORG);
        info.setIsExportOneFile(true);
        info.setIsReceived(true);
        info.setCurrency(null);
        info.setPeriodType(this.periodType);
        return info;
    }

    @Override
    protected void radByReport_actionPerformed(ActionEvent e) throws Exception {
        super.radByReport_actionPerformed(e);
        this.kDTable1.checkParsed();
        this.kDTable1.setRefresh(false);
        this.kDTable1.removeRows();
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable1.getStyleAttributes().setLocked(true);
        ICell cell = this.kDTable1.getHeadRow(0).getCell(3);
        cell.setValue((Object)CslRptUtil.getString("RptSourceType"));
        this.kDTable1.setRefresh(true);
        this.kDTable1.repaint();
        this.selectedUnit.clear();
        this.radReport_table2();
        this.setExportOneFileEnable(true);
    }

    private void radReport_table2() {
        this.kDTable2.checkParsed();
        this.kDTable2.setRefresh(false);
        this.kDTable2.removeRows();
        this.kDTable2.getSelectManager().setSelectMode(10);
        this.kDTable2.getStyleAttributes().setLocked(true);
        ICell cell = this.kDTable2.getHeadRow(0).getCell(3);
        cell.setValue((Object)CslRptUtil.getString("OrgUnitType"));
        this.kDTable2.setRefresh(true);
        this.kDTable2.repaint();
        this.btnAdd2.setEnabled(false);
        this.btnDelete2.setEnabled(false);
        this.selectedTemplate2.clear();
    }

    @Override
    protected void radByUnit_actionPerformed(ActionEvent e) throws Exception {
        super.radByUnit_actionPerformed(e);
        this.kDTable1.checkParsed();
        this.kDTable1.setRefresh(false);
        this.kDTable1.removeRows();
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.kDTable1.getStyleAttributes().setLocked(true);
        ICell cell = this.kDTable1.getHeadRow(0).getCell(3);
        cell.setValue((Object)CslRptUtil.getString("OrgUnitType"));
        this.kDTable1.setRefresh(true);
        this.kDTable1.repaint();
        this.btnAdd2.setEnabled(false);
        this.btnDelete2.setEnabled(false);
        this.selectedTemplate.clear();
        this.idSet = new HashSet();
        this.radUnit_table2();
        try {
            if (!this.editData.isIsExportOneFile()) {
                this.isTrigger = false;
            }
            this.setExportOneFileEnable(true);
            this.exportOneFile.setSelected(this.editData.isIsExportOneFile());
        }
        finally {
            this.isTrigger = true;
        }
    }

    private void radUnit_table2() {
        this.kDTable2.checkParsed();
        this.kDTable2.setRefresh(false);
        this.kDTable2.removeRows();
        this.kDTable2.getSelectManager().setSelectMode(10);
        this.kDTable2.getStyleAttributes().setLocked(true);
        ICell cell = this.kDTable2.getHeadRow(0).getCell(3);
        cell.setValue((Object)CslRptUtil.getString("RptSourceType"));
        this.kDTable2.setRefresh(true);
        this.kDTable2.repaint();
        this.selectedUnit2.clear();
        this.idSet2 = new HashSet();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        Set ids = this.getTableExistValues(this.kDTable1);
        if (this.radByReport.isSelected()) {
            Frame owner = (Frame)ComponentUtil.getOwnerWindow((Component)((Object)this));
            KDCommonPromptDialog dlg = new KDCommonPromptDialog(owner);
            QueryAgent queryAgent = new QueryAgent();
            queryAgent.setQueryInfoPK(MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt.ExportToExcelTemplateQuery"));
            queryAgent.setEnabledMultiSelection(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            queryAgent.setSelectorCollection(sic);
            dlg.setQueryInfo(queryAgent.getQueryInfo());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (this.periodType.getValue() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.periodType.getValue())));
            }
            if (!ids.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.NOTINCLUDE));
            }
            view.setFilter(filter);
            dlg.setEntityViewInfo(view);
            dlg.setSelectorCollection(queryAgent.getSelectorCollection());
            dlg.setQueryExecutor(queryAgent.getQueryExecutor());
            dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
            dlg.setReturnValueType(queryAgent.getReturnValueType());
            dlg.show();
            if (!dlg.isCanceled()) {
                Object[] objs = (Object[])dlg.getData();
                for (int i = 0; i < objs.length; ++i) {
                    TemplateInfo info = (TemplateInfo)objs[i];
                    if (this.idSet.contains(info.getId().toString())) continue;
                    this.selectedTemplate.add(objs[i]);
                    this.idSet.add(info.getId().toString());
                }
            }
        } else {
            List time = RPTDateUtil.getRptYearAndPeriodAndDate(this.year, this.period, this.periodType);
            OrgTreeCollection collection = null;
            try {
                collection = this.isQueryBudget == 1 ? CslRptUIUtil.getHistoryOrgTreeCollection((Date)time.get(2)) : CslRptUIUtil.getOrgTreeCollection((Date)time.get(2));
            }
            catch (EASBizException e1) {
                super.handUIException((Throwable)e1);
            }
            catch (BOSException e1) {
                super.handUIException((Throwable)e1);
            }
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setOrgTrees(collection);
            f7.setMultiSelect(true);
            f7.show();
            if (!f7.isCanceled()) {
                OrgTreeInfo tree = f7.getComboTreeSelectedItem();
                List data = null;
                OrgTreeInfo tree12 = null;
                for (OrgTreeInfo tree12 : this.selectedUnit.keySet()) {
                    if (tree12 == null || !tree12.getId().equals((Object)tree.getId())) continue;
                    tree = tree12;
                }
                if (this.selectedUnit.containsKey(tree)) {
                    data = (List)this.selectedUnit.get(tree);
                } else {
                    data = new ArrayList();
                    this.selectedUnit.put(tree, data);
                }
                if (data != null) {
                    OrgUnitInfo[] objs = (OrgUnitInfo[])f7.getData();
                    List temData = this.getAllSelectedUnit(this.selectedUnit);
                    this.addNewUnits(data, temData, objs);
                }
            }
        }
        this.fillTable();
    }

    private List getAllSelectedUnit(Map selectedUnit) {
        ArrayList unitList = new ArrayList();
        for (OrgTreeInfo tempTree : selectedUnit.keySet()) {
            unitList.addAll((List)selectedUnit.get(tempTree));
        }
        return unitList;
    }

    private void addNewUnits(List treeUnits, List oldUnits, OrgUnitInfo[] newUnit) {
        for (int i = 0; i < newUnit.length; ++i) {
            String objId = newUnit[i].getId() == null ? null : newUnit[i].getId().toString();
            boolean bool = false;
            for (int j = 0; j < oldUnits.size(); ++j) {
                String objDataId;
                String string = objDataId = ((OrgUnitInfo)oldUnits.get(j)).getId() == null ? null : ((OrgUnitInfo)oldUnits.get(j)).getId().toString();
                if (objId != null && objDataId != null && (objId == null || objDataId == null || !objId.equals(objDataId))) continue;
                bool = true;
                break;
            }
            if (bool) continue;
            treeUnits.add(newUnit[i]);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        ArrayList blocks = this.kDTable1.getSelectManager().getBlocks();
        if (blocks.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                Object obj = this.kDTable1.getCell(j, 4).getValue();
                if (this.radByReport.isSelected()) {
                    TemplateInfo info = (TemplateInfo)obj;
                    this.idSet.remove(info.getId().toString());
                    this.selectedTemplate.remove(obj);
                    continue;
                }
                OrgTreeInfo tree = (OrgTreeInfo)this.kDTable1.getCell(j, 5).getValue();
                List data = (List)this.selectedUnit.get(tree);
                data.remove(obj);
                if (!data.isEmpty()) continue;
                this.selectedUnit.remove(tree);
            }
        }
        this.fillTable();
    }

    private Set getTableExistValues(KDTable tbl) {
        HashSet<Object> ids = new HashSet<Object>();
        if (tbl == null) {
            return ids;
        }
        int count = tbl.getRowCount();
        for (int i = 0; i < count; ++i) {
            ids.add(tbl.getCell(i, 0).getValue());
        }
        return ids;
    }

    private void fillTable() {
        this.kDTable1.removeRows();
        if (this.radByReport.isSelected()) {
            for (int i = 0; i < this.selectedTemplate.size(); ++i) {
                TemplateInfo info = (TemplateInfo)this.selectedTemplate.get(i);
                IRow row = this.kDTable1.addRow();
                row.getCell(0).setValue((Object)info.getId().toString());
                row.getCell(1).setValue((Object)info.getNumber());
                row.getCell(2).setValue((Object)info.getName());
                row.getCell(3).setValue((Object)info.getTemplateType());
                row.getCell(4).setValue((Object)info);
            }
        } else {
            for (OrgTreeInfo tree : this.selectedUnit.keySet()) {
                List data = (List)this.selectedUnit.get(tree);
                for (int i = 0; i < data.size(); ++i) {
                    OrgUnitInfo info = (OrgUnitInfo)data.get(i);
                    IRow row = this.kDTable1.addRow();
                    row.getCell(0).setValue((Object)info.getId().toString());
                    row.getCell(1).setValue((Object)info.getNumber());
                    row.getCell(2).setValue((Object)info.getName());
                    if (info.isIsUnion()) {
                        row.getCell(3).setValue((Object)CslRptUtil.getString("ReceiveProgressTextGroup"));
                    } else if (info.isIsCompanyOrgUnit()) {
                        row.getCell(3).setValue((Object)CslRptUtil.getString("ReceiveProgressTextCompany"));
                    }
                    row.getCell(4).setValue((Object)info);
                    row.getCell(5).setValue((Object)tree);
                }
            }
        }
        if (this.kDTable1.getRowCount() == 0) {
            this.kDTable2.removeRows();
            this.btnAdd2.setEnabled(false);
            this.btnDelete2.setEnabled(false);
            this.selectedTemplate2.clear();
            this.selectedUnit2.clear();
        } else {
            this.btnAdd2.setEnabled(true);
            this.btnDelete2.setEnabled(true);
        }
    }

    @Override
    public void actionAdd2_actionPerformed(ActionEvent e) throws Exception {
        if (this.radByUnit.isSelected()) {
            ArrayList<String> selectedIds = new ArrayList<String>();
            Set ids = this.getTableExistValues(this.kDTable2);
            for (OrgTreeInfo orgTree : this.selectedUnit.keySet()) {
                List list = (List)this.selectedUnit.get(orgTree);
                for (OrgUnitInfo unit : list) {
                    selectedIds.add(unit.getId().toString());
                }
            }
            Set templateIdSet = RPTDataServiceFactory.getRemoteInstance().getTemplateDispenseInfomationByOrgId(selectedIds);
            Frame owner = (Frame)ComponentUtil.getOwnerWindow((Component)((Object)this));
            KDCommonPromptDialog dlg = new KDCommonPromptDialog(owner);
            QueryAgent queryAgent = new QueryAgent();
            queryAgent.setQueryInfoPK(MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt.TemplateExportQuery"));
            queryAgent.setEnabledMultiSelection(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            queryAgent.setSelectorCollection(sic);
            dlg.setQueryInfo(queryAgent.getQueryInfo());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (this.periodType.getValue() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.periodType.getValue())));
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
            if (!ids.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.NOTINCLUDE));
            }
            view.setFilter(filter);
            dlg.setEntityViewInfo(view);
            dlg.setSelectorCollection(queryAgent.getSelectorCollection());
            dlg.setQueryExecutor(queryAgent.getQueryExecutor());
            dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
            dlg.setReturnValueType(queryAgent.getReturnValueType());
            dlg.show();
            if (!dlg.isCanceled()) {
                Object[] objs = (Object[])dlg.getData();
                for (int i = 0; i < objs.length; ++i) {
                    TemplateInfo info = (TemplateInfo)objs[i];
                    if (this.idSet2.contains(info.getId().toString())) continue;
                    this.selectedTemplate2.add(objs[i]);
                    this.idSet2.add(info.getId().toString());
                }
            }
        } else {
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (TemplateInfo templateInfo : this.selectedTemplate) {
                selectedIds.add(templateInfo.getId().toString());
            }
            List time = RPTDateUtil.getRptYearAndPeriodAndDate(this.year, this.period, this.periodType);
            OrgTreeCollection collection = null;
            try {
                collection = this.isQueryBudget == 1 ? CslRptUIUtil.getHistoryOrgTreeCollection((Date)time.get(2)) : CslRptUIUtil.getOrgTreeCollection((Date)time.get(2));
            }
            catch (EASBizException e1) {
                super.handUIException((Throwable)e1);
            }
            catch (BOSException e1) {
                super.handUIException((Throwable)e1);
            }
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setOrgTrees(collection);
            f7.setMultiSelect(true);
            f7.show();
            if (!f7.isCanceled()) {
                OrgTreeInfo tree = f7.getComboTreeSelectedItem();
                List data = null;
                OrgTreeInfo tree12 = null;
                for (OrgTreeInfo tree12 : this.selectedUnit2.keySet()) {
                    if (tree12 == null || !tree12.getId().equals((Object)tree.getId())) continue;
                    tree = tree12;
                }
                if (this.selectedUnit2.containsKey(tree)) {
                    data = (List)this.selectedUnit2.get(tree);
                } else {
                    data = new ArrayList();
                    this.selectedUnit2.put(tree, data);
                }
                if (data != null) {
                    OrgUnitInfo[] objs = (OrgUnitInfo[])f7.getData();
                    List temData = this.getAllSelectedUnit(this.selectedUnit2);
                    this.addNewUnits(data, temData, objs);
                }
            }
        }
        this.fillTable2();
    }

    @Override
    public void actionDelete2_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.kDTable2.getSelectManager().getBlocks();
        if (blocks.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                Object obj = this.kDTable2.getCell(j, 4).getValue();
                if (this.radByUnit.isSelected()) {
                    TemplateInfo info = (TemplateInfo)obj;
                    this.idSet2.remove(info.getId().toString());
                    this.selectedTemplate2.remove(obj);
                    continue;
                }
                OrgTreeInfo tree = (OrgTreeInfo)this.kDTable2.getCell(j, 5).getValue();
                List data = (List)this.selectedUnit2.get(tree);
                data.remove(obj);
                if (!data.isEmpty()) continue;
                this.selectedUnit2.remove(tree);
            }
        }
        this.fillTable2();
    }

    private void fillTable2() {
        this.kDTable2.removeRows();
        if (this.radByUnit.isSelected()) {
            for (int i = 0; i < this.selectedTemplate2.size(); ++i) {
                TemplateInfo info = (TemplateInfo)this.selectedTemplate2.get(i);
                IRow row = this.kDTable2.addRow();
                row.getCell(0).setValue((Object)info.getId().toString());
                row.getCell(1).setValue((Object)info.getNumber());
                row.getCell(2).setValue((Object)info.getName());
                row.getCell(3).setValue((Object)info.getTemplateType());
                row.getCell(4).setValue((Object)info);
            }
        } else {
            for (OrgTreeInfo tree : this.selectedUnit2.keySet()) {
                List data = (List)this.selectedUnit2.get(tree);
                for (int i = 0; i < data.size(); ++i) {
                    OrgUnitInfo info = (OrgUnitInfo)data.get(i);
                    IRow row = this.kDTable2.addRow();
                    row.getCell(0).setValue((Object)info.getId().toString());
                    row.getCell(1).setValue((Object)info.getNumber());
                    row.getCell(2).setValue((Object)info.getName());
                    if (info.isIsUnion()) {
                        row.getCell(3).setValue((Object)CslRptUtil.getString("ReceiveProgressTextGroup"));
                    } else if (info.isIsCompanyOrgUnit()) {
                        row.getCell(3).setValue((Object)CslRptUtil.getString("ReceiveProgressTextCompany"));
                    }
                    row.getCell(4).setValue((Object)info);
                    row.getCell(5).setValue((Object)tree);
                }
            }
        }
    }

    @Override
    public void actionNameRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionNameRule_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        if (this.nameRule != null) {
            uiContext.put((Object)"nameRule", (Object)this.nameRule);
        }
        uiContext.put((Object)"isExportOneFile", (Object)this.exportOneFile.isSelected());
        uiContext.put((Object)"isByRptExport", (Object)this.radByReport.isSelected());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExportNameRuleUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        ExportNameRuleUI ui = (ExportNameRuleUI)uiWindow.getUIObject();
        if (!ui.isCancel()) {
            this.nameRule = ui.getResult();
        }
    }

    @Override
    public void actionSelectPath_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectPath_actionPerformed(e);
        KDFileChooser chooser = new KDFileChooser();
        chooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"328_BatchExportToExcelUI"));
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog((Component)((Object)this));
        if (result == 0) {
            File file = chooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            this.txtFilePath.setText(fileName);
        }
    }

    private void storeEntries() {
        int i;
        HashMap map = new HashMap();
        ArrayList templateList = new ArrayList();
        List unitList = null;
        ExportSchemeEntryCollection entryCol = this.editData.getEntries();
        ExportSchemeEntryInfo entry = null;
        TemplateInfo template = null;
        FullOrgUnitInfo unit = null;
        OrgTreeInfo tree2 = null;
        if (this.radByReport.isSelected()) {
            map.putAll(this.selectedUnit2);
            templateList.addAll(this.selectedTemplate);
        } else {
            map.putAll(this.selectedUnit);
            templateList.addAll(this.selectedTemplate2);
        }
        ArrayList addTemplateList = new ArrayList(templateList);
        if (entryCol == null) {
            entryCol = new ExportSchemeEntryCollection();
        }
        for (i = entryCol.size() - 1; i >= 0; --i) {
            entry = entryCol.get(i);
            template = entry.getTemplate();
            tree2 = entry.getOrgTree();
            unit = entry.getOrgUnit();
            if (template != null) {
                if (!templateList.contains(template)) {
                    entryCol.removeObject(i);
                } else {
                    addTemplateList.remove(template);
                }
            }
            if (tree2 == null || unit == null) continue;
            if (map.containsKey(tree2)) {
                unitList = (List)map.get(tree2);
                ArrayList addUnitList = new ArrayList(unitList);
                if (!unitList.contains(unit)) {
                    entryCol.removeObject(i);
                    continue;
                }
                addUnitList.remove(unit);
                map.put(tree2, addUnitList);
                continue;
            }
            entryCol.removeObject(i);
        }
        if (!addTemplateList.isEmpty() || !map.isEmpty()) {
            if (entryCol == null) {
                entryCol = new ExportSchemeEntryCollection();
            }
            if (!addTemplateList.isEmpty()) {
                int size = addTemplateList.size();
                for (i = 0; i < size; ++i) {
                    entry = new ExportSchemeEntryInfo();
                    template = (TemplateInfo)addTemplateList.get(i);
                    entry.setScheme(this.editData);
                    entry.setTemplate(template);
                    entry.setOrgTree(null);
                    entry.setOrgUnit(null);
                    entryCol.add(entry);
                }
            }
            if (!map.isEmpty()) {
                FullOrgUnitInfo fullOrgUnitInfo = null;
                for (OrgTreeInfo tree2 : map.keySet()) {
                    unitList = (List)map.get(tree2);
                    int size = unitList.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        entry = new ExportSchemeEntryInfo();
                        unit = (OrgUnitInfo)unitList.get(i2);
                        if (!(unit instanceof FullOrgUnitInfo)) {
                            fullOrgUnitInfo = new FullOrgUnitInfo();
                            fullOrgUnitInfo.setId(unit.getId());
                        } else {
                            fullOrgUnitInfo = unit;
                        }
                        entry.setScheme(this.editData);
                        entry.setTemplate(null);
                        entry.setOrgTree(tree2);
                        entry.setOrgUnit(fullOrgUnitInfo);
                        entryCol.add(entry);
                    }
                }
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ExportSchemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("mode"));
        sic.add(new SelectorItemInfo("nameRule"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("entries.template.number"));
        sic.add(new SelectorItemInfo("entries.template.name"));
        sic.add(new SelectorItemInfo("entries.template.templateType"));
        sic.add(new SelectorItemInfo("entries.orgUnit.name"));
        sic.add(new SelectorItemInfo("entries.orgUnit.number"));
        sic.add(new SelectorItemInfo("entries.orgUnit.isUnion"));
        sic.add(new SelectorItemInfo("entries.orgUnit.isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("entries.orgUnit.code"));
        sic.add(new SelectorItemInfo("entries.orgUnit.englishName"));
        sic.add(new SelectorItemInfo("entries.orgTree.id"));
        sic.add(new SelectorItemInfo("entries.orgTree.name_l2"));
        sic.add(new SelectorItemInfo("entries.orgTree.number"));
        sic.add(new SelectorItemInfo("entries.orgTree.isforbudget"));
        sic.add(new SelectorItemInfo("entries.orgTree.name"));
        return sic;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        Map ctx = this.getUIContext();
        ReceiveFilterCondition condition = (ReceiveFilterCondition)ctx.get("ReceiveFilterCondition");
        if (condition != null) {
            this.periodType = condition.getPeriodType();
            this.year = condition.getYear();
            this.period = condition.getPeriod();
        }
        this.initComboCurrency();
        this.initComboFileType();
        this.comboPeriodType.addItem((Object)this.periodType);
        this.comboPeriodType.setSelectedItem((Object)this.periodType);
        this.radByReport_actionPerformed(null);
        this.btnAdd2.setEnabled(false);
        this.btnDelete2.setEnabled(false);
        if (this.editData.isIsSubFile()) {
            this.subDir.setSelected(true);
            this.kDComboBox1.setEditable(true);
            this.kDComboBox1.setEnabled(true);
            this.kDComboBox1.setSelectedIndex(this.editData.getExportType());
        } else {
            this.subDir.setSelected(false);
            this.kDComboBox1.setEditable(false);
            this.kDComboBox1.setEnabled(false);
            this.kDComboBox1.setSelectedIndex(-1);
        }
        this.selectedTemplate.clear();
        this.selectedUnit.clear();
        this.selectedTemplate2.clear();
        this.selectedUnit2.clear();
        this.kDComboBox1.setSelectedIndex(-1);
        this.kDTable1.removeRows();
        this.kDTable2.removeRows();
        this.updateUI();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("number");
        newData.setNull("name");
    }

    private void initDataCollect() throws EASBizException, BOSException {
        if (this.isQueryBudget == 1) {
            this.cbxDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
            this.cbxDataCollect.setSelectedItem((Object)DataCollectConstant.getBudgetDC());
            this.cbxDataCollect.setEditable(false);
            return;
        }
        this.cbxDataCollect.removeAllItems();
        this.cbxDataCollect.addItem((Object)DataCollectConstant.getActualDC());
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            boolean hasPermisson = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getActualDC());
            if (!hasPermisson) {
                this.cbxDataCollect.removeAllItems();
            }
            if (hasPermisson = CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getBudgetDC())) {
                this.cbxDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
                if (!StringUtils.isEmpty((String)this.editData.getDataCollectNumber()) && this.editData.getDataCollectNumber().equals("BUDGETDATA")) {
                    this.cbxDataCollect.setSelectedItem((Object)DataCollectConstant.getBudgetDC());
                }
            }
            if (this.cbxDataCollect.getItemCount() <= 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Query_No_ALLDC_Permission"));
                SysUtil.abort();
            }
        } else {
            this.contDataCollect.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSubmit_actionPerformed(ActionEvent arg0) throws Exception {
        this.verifyData();
        if (this.radByReport.isSelected()) {
            this.editData.setMode(ExportModeEnum.EXPORTBYTEMPLATE);
        } else {
            this.editData.setMode(ExportModeEnum.EXPORTBYORG);
            this.editData.setIsExportOneFile(this.exportOneFile.isSelected());
        }
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        if (this.comboCurrency.getSelectedItem() != null && this.comboCurrency.getSelectedItem().equals(selectAll)) {
            this.editData.setCurrency(null);
        }
        this.editData.setNameRule(this.nameRule.toString());
        DataCollectInfo info = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        info = info == null ? DataCollectConstant.getActualDC() : info;
        this.editData.setDataCollectNumber(info.getNumber());
        this.editData.setExportType(this.kDComboBox1.getSelectedIndex());
        this.editData.setIsQueryBudget(this.isQueryBudget);
        this.storeEntries();
        try {
            this.isTrigger = false;
            super.actionSubmit_actionPerformed(arg0);
        }
        finally {
            this.isTrigger = true;
        }
        Map ctx = this.getUIContext();
        ReceiveFilterCondition condition = (ReceiveFilterCondition)ctx.get("ReceiveFilterCondition");
        if (condition != null) {
            this.periodType = condition.getPeriodType();
            this.year = condition.getYear();
            this.period = condition.getPeriod();
        }
        this.initComboCurrency();
        this.initComboFileType();
        this.comboPeriodType.addItem((Object)this.periodType);
        this.comboPeriodType.setSelectedItem((Object)this.periodType);
        if (this.editData.isIsSubFile()) {
            this.subDir.setSelected(true);
            this.kDComboBox1.setEditable(true);
            this.kDComboBox1.setEnabled(true);
            this.kDComboBox1.setSelectedIndex(this.editData.getExportType());
        } else {
            this.subDir.setSelected(false);
            this.kDComboBox1.setEditable(false);
            this.kDComboBox1.setEnabled(false);
            this.kDComboBox1.setSelectedIndex(-1);
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.kDComboBox1.setSelectedIndex(-1);
            ExportModeEnum mode = this.editData.getMode();
            if (2 == mode.getValue()) {
                this.radByUnit_actionPerformed(null);
            } else {
                this.radByReport_actionPerformed(null);
            }
            this.btnAdd2.setEnabled(false);
            this.btnDelete2.setEnabled(false);
        }
        this.updateUI();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    public void verifyData() throws Exception {
        File file;
        String path;
        super.verifyData();
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("Msg_NumberNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.multiLangName.getSelectedItem().toString())) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("Msg_NameNull"));
            SysUtil.abort();
        }
        if (this.selectedUnit.isEmpty() && this.selectedTemplate.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("SelectOrgUnitOrTemplate"));
            SysUtil.abort();
        }
        if (this.nameRule == null || this.nameRule.getOrder() == null) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("NameRuleIsNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(path = this.txtFilePath.getText()))) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("FilePathIsInvalid"));
            SysUtil.abort();
        }
        if ((file = new File(path)).exists()) {
            if (!file.isDirectory()) {
                MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("FilePathIsInvalid"));
                SysUtil.abort();
            }
        } else {
            file.mkdir();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
        this.kDComboBox2.setVisible(false);
    }

    @Override
    public void storeFields() {
        this.editData.setSyncOldValue(true);
        super.storeFields();
        this.editData.setSyncOldValue(false);
    }

    @Override
    protected void exportOneFile_itemStateChanged(ItemEvent e) throws Exception {
        this.setSubDirEnabel();
        if (this.isTrigger) {
            if (this.exportOneFile.isSelected()) {
                if (this.nameRule == null) {
                    this.nameRule = new ExportNameRule();
                } else {
                    this.nameRule.clearSelected();
                }
                this.nameRule.setOperator(" ");
                this.nameRule.setHasUnitNumber(true);
                this.nameRule.getOrder().put(0, 1);
            } else if (this.nameRule != null) {
                this.nameRule.clearSelected();
                if (this.radByReport.isSelected()) {
                    this.nameRule.setHasTemplateNumber(true);
                    this.nameRule.getOrder().put(0, 3);
                }
            }
        }
    }

    private void setExportOneFileEnable(boolean isEnable) {
        this.exportOneFile.setEditable(isEnable);
        this.exportOneFile.setEnabled(isEnable);
        if (!isEnable) {
            this.exportOneFile.setSelected(false);
        }
        this.setSubDirEnabel();
    }

    private void setSubDirEnabel() {
        if (this.exportOneFile.isEnabled()) {
            this.subDir.setEnabled(!this.exportOneFile.isSelected());
            this.kDComboBox1.setEnabled(!this.exportOneFile.isSelected());
        } else {
            this.subDir.setEnabled(true);
            this.kDComboBox1.setEnabled(true);
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        try {
            if (owner instanceof ListUI && OprtState.EDIT.equals(this.getOprtState())) {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.destroyWindow();
    }
}

