/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextManager;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import java.util.Date;
import java.util.Map;
import java.util.Observable;

public final class CSLContextHelper {
    public static ICSLContext getCSLContext() {
        return CSLContext.getInstance();
    }

    public static ICSLContext getCSLContext(Map param) throws Exception {
        CSLContext cslContext = new CSLContext();
        Integer periodType = (Integer)param.get("PeriodType");
        Integer iYear = (Integer)param.get("Year");
        Integer iPeriod = (Integer)param.get("Period");
        String orgTreeID = (String)param.get("KEY_CUR_ORGBOUND_ID");
        String orgUnitID = (String)param.get("KEY_CUR_ORGBOUNDGROUP_ID");
        Date curRptDate = (Date)param.get("KEY_CUR_RPTDATE");
        cslContext.setCurRptPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        cslContext.setCurRptYear(iYear);
        cslContext.setCurRptPeriod(iPeriod);
        cslContext.setCurOrgBound(OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectStringPK(orgTreeID)));
        cslContext.setCurOrgGroup(FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectStringPK(orgUnitID)));
        cslContext.setCurReportDate(curRptDate);
        if (param.containsKey("KEY_CUR_DATA_COLLECT")) {
            cslContext.setCurDataCollect((DataCollectInfo)param.get("KEY_CUR_DATA_COLLECT"));
        } else {
            DataCollectInfo defaultDataCollectInfo = DataCollectFactory.getRemoteInstance().getDataCollectInfo("select * where number ='ACTUALDATA'");
            cslContext.setCurDataCollect(defaultDataCollectInfo);
        }
        return cslContext;
    }

    public static CSLSysParamanager getSysParamanager() {
        return CSLSysParamanager.getInstance();
    }

    public static boolean isInitialized(Map uiContext) {
        return CSLContextManager.getInstance().isInitialized(uiContext);
    }

    public static void registUIObject(ICSLContextUI uiObject) {
        CSLContextManager.getInstance().registUIObject(uiObject);
    }

    public static void unRegistUIObject(ICSLContextUI uiObject) {
        CSLContextManager.getInstance().unRegistUIObject(uiObject);
    }

    public static void showContextUI(Map uiContext) {
        CSLContextManager.getInstance().showContextUI(uiContext);
    }

    public static void update(Observable o, CoreUI uiObject) {
        if (o instanceof CSLContextManager) {
            CSLContextManager.getInstance().closeCSLUI(uiObject);
        }
    }

    public static EntityViewInfo updateCslCtxFilter(ICSLContext ctx, EntityViewInfo mainQuery, String number) throws BOSException {
        OrgUnitInfo uif = ctx.getCurOrgGroup();
        if (number == null) {
            number = CslRptUIUtil.getCompanyStructureNumber(ctx.getCurOrgBound(), uif);
        }
        if (mainQuery.getFilter() != null && mainQuery.getFilter().getFilterItems().size() > 0 && !mainQuery.getFilter().toString().equals("")) {
            FilterItemCollection filters = mainQuery.getFilter().getFilterItems();
            for (FilterItemInfo element : filters) {
                if (element.getPropertyName().equals("orgBound.id")) {
                    element.setCompareValue((Object)ctx.getCurOrgBound().getId().toString());
                    continue;
                }
                if (element.getPropertyName().equals("periodType")) {
                    element.setCompareValue((Object)new Integer(ctx.getCurRptPeriodType().getValue()));
                    continue;
                }
                if (element.getPropertyName().equals("year")) {
                    element.setCompareValue((Object)new Integer(ctx.getCurRptYear()));
                    continue;
                }
                if (element.getPropertyName().equals("period")) {
                    element.setCompareValue((Object)new Integer(ctx.getCurRptPeriod()));
                    continue;
                }
                if (element.getPropertyName().equals("structure.longNumber") && element.getCompareType().equals((Object)CompareType.EQUALS)) {
                    element.setCompareValue((Object)number);
                    continue;
                }
                if (!element.getPropertyName().equals("structure.longNumber") || !element.getCompareType().equals((Object)CompareType.LIKE)) continue;
                element.setCompareValue((Object)(number + "!%"));
            }
        }
        return mainQuery;
    }

    public static EntityViewInfo updateCslCtxFilter(EntityViewInfo mainQuery, String number) throws BOSException {
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        return CSLContextHelper.updateCslCtxFilter(ctx, mainQuery, number);
    }
}

