/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportAnlysisFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnlysisClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLTitleColF7;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CSLReportAnlysisFilterUI
extends AbstractCSLReportAnlysisFilterUI {
    public static final String ORG_IDS = "orgIDS";
    public static final String CURRENCY_NUMBER = "currencyNumber";
    public static final String CURRENCY_ID = "currencyId";
    public static final String PERIOD_TYPE = "periodType";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String DATA_ELEMENT_NUMBER = "dataElementNumber";
    public static final String DATA_COLLECT_NUMBER = "dataCollectNumber";
    public static final String TEMPLATE_ID = "templateId";
    public static final String ORG_NUMBERS = "orgNumberS";
    public static final String ORG_NAMES = "orgNames";
    public static final String TREE_NUMBER = "treeNumber";
    public static final String TREE_ID = "treeId";
    public static final String TITLE_COL = "title_col";
    public static final String ITEM_COL = "item_col";
    public static final String BEGIN_YEAR = "begin_year";
    public static final String BEGIN_PERIOD = "begin_period";
    public static final String END_YEAR = "end_year";
    public static final String END_PERIOD = "end_period";
    public static final String RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource";
    private static final long serialVersionUID = 6391197576133987683L;
    private static final Logger logger = CoreUIObject.getLogger(CSLReportAnlysisFilterUI.class);
    protected Object ui = null;
    private IOrgStructure iStruct;
    private ICompanyOrgUnit iCompanyOrgUnit;

    public CSLReportAnlysisFilterUI() throws Exception {
    }

    public CSLReportAnlysisFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FILTERPARAM") : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return param;
    }

    public Object getFilterObject(CustomerParams cp) {
        return this.getFilterObject(cp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        if (cp == null || param == null) {
            return;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(param);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!StringUtils.isEmpty((String)key)) {
            cp.addCustomerParam(key, Base64.encodeBytes(objByte));
        } else {
            cp.addCustomerParam("FILTERPARAM", Base64.encodeBytes(objByte));
        }
    }

    public void setFilterObject(CustomerParams cp, Object param) {
        this.setFilterObject(cp, param, null);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        OrgTreeInfo tree = (OrgTreeInfo)this.comboOrgBound.getSelectedItem();
        cp.addCustomerParam(TREE_ID, tree.getId().toString());
        cp.addCustomerParam(TREE_NUMBER, tree.getNumber());
        if (this.prmtOrgUnit.getData() != null) {
            Object[] objs = (Object[])this.prmtOrgUnit.getData();
            String orgNumberS = "";
            String orgNames = "";
            String orgIDS = "";
            for (int i = 0; i < objs.length; ++i) {
                orgNumberS = orgNumberS + ((OrgUnitInfo)objs[i]).getNumber() + ";";
                orgNames = orgNames + ((OrgUnitInfo)objs[i]).getName() + ";";
                orgIDS = orgIDS + ((OrgUnitInfo)objs[i]).getId() + ";";
            }
            if (orgNumberS.length() > 0) {
                orgNumberS = orgNumberS.substring(0, orgNumberS.length() - 1);
                orgNames = orgNames.substring(0, orgNames.length() - 1);
                orgIDS = orgIDS.substring(0, orgIDS.length() - 1);
            }
            cp.addCustomerParam(ORG_NUMBERS, orgNumberS);
            cp.addCustomerParam(ORG_NAMES, orgNames);
            cp.addCustomerParam(ORG_IDS, orgIDS);
        }
        if (this.prmtTemplate.getData() != null) {
            TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
            cp.addCustomerParam(TEMPLATE_ID, template.getId().toString());
            int templateType = template.getTemplateType().getValue();
            if (templateType == 3 || templateType == 4) {
                cp.addCustomerParam(SOURCE_TYPE, "SUM");
            } else if (templateType == 5) {
                cp.addCustomerParam(SOURCE_TYPE, "CONSOLIDATION");
            } else if (templateType == 6) {
                cp.addCustomerParam(SOURCE_TYPE, "COMMITREPORT");
            }
            cp.putInt(PERIOD_TYPE, template.getPeriodType().getValue());
        }
        cp.addCustomerParam(ITEM_COL, this.prmtItemCol.getValue().toString());
        cp.addCustomerParam(TITLE_COL, this.prmtTitleCol.getValue() == null ? null : this.prmtTitleCol.getValue().toString());
        cp.putInt(BEGIN_YEAR, Integer.parseInt(this.spBeginYear.getValue().toString()));
        cp.putInt(BEGIN_PERIOD, Integer.parseInt(this.spBeginPeriod.getValue().toString()));
        cp.putInt(END_YEAR, Integer.parseInt(this.spEndYear.getValue().toString()));
        cp.putInt(END_PERIOD, Integer.parseInt(this.spEndPeriod.getValue().toString()));
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        cp.addCustomerParam(CURRENCY_ID, currency.getId().toString());
        cp.addCustomerParam(CURRENCY_NUMBER, currency.getNumber());
        DataCollectInfo dataCollectInfo = (DataCollectInfo)this.comboDataCollect.getSelectedItem();
        cp.addCustomerParam(DATA_COLLECT_NUMBER, dataCollectInfo.getNumber());
        if (this.prmtDataElement.getData() != null) {
            cp.addCustomerParam(DATA_ELEMENT_NUMBER, ((DataElementInfo)this.prmtDataElement.getData()).getNumber());
        }
        FilterParam filterParam = null;
        filterParam = cp.getCustomerParam("FILTERPARAM") == null ? this.createNewFilterParam() : (FilterParam)this.getFilterObject(cp);
        this.setFilterObject(cp, filterParam);
        return cp;
    }

    public void clear() {
        this.initTemplate(null, null);
        this.initTitleColF7();
        this.initAnlysisColF7();
        this.initYearAndPeriod(3);
        try {
            this.initOrgTreeCbx();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        this.prmtOrgUnit.setEnabled(false);
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        this.fillTemplate(cp);
        this.setStringToComponent(cp, this.prmtItemCol, ITEM_COL);
        this.setStringToComponent(cp, this.prmtTitleCol, TITLE_COL);
        this.setIntToComponent(cp, this.spBeginYear, BEGIN_YEAR);
        this.setIntToComponent(cp, this.spBeginPeriod, BEGIN_PERIOD);
        this.setIntToComponent(cp, this.spEndYear, END_YEAR);
        this.setIntToComponent(cp, this.spEndPeriod, END_PERIOD);
        this.fillOrgTree(cp);
        this.fillOrgUnit(cp);
        this.fillCurrency(cp);
        this.fillDataCollect(cp);
        this.fillDataElement(cp);
    }

    private void fillOrgTree(CustomerParams cp) {
        String treeId = cp.getCustomerParam(TREE_ID);
        if (treeId == null || treeId.trim().length() == 0) {
            return;
        }
        OrgTreeInfo tree = null;
        for (int i = 0; i < this.comboOrgBound.getItemCount(); ++i) {
            tree = (OrgTreeInfo)this.comboOrgBound.getItemAt(i);
            if (!tree.getId().toString().equals(treeId)) continue;
            this.comboOrgBound.setSelectedIndex(i);
        }
    }

    private void fillCurrency(CustomerParams cp) {
        String currencyId = cp.getCustomerParam(CURRENCY_ID);
        if (currencyId == null || currencyId.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getItemAt(i);
            if (!currencyId.equals(currency.getId().toString())) continue;
            this.comboCurrency.setSelectedIndex(i);
            break;
        }
    }

    private void fillDataCollect(CustomerParams cp) {
        String dataCollectNumber = cp.getCustomerParam(DATA_COLLECT_NUMBER);
        if (dataCollectNumber == null || dataCollectNumber.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.comboDataCollect.getItemCount(); ++i) {
            DataCollectInfo dataCollect = (DataCollectInfo)this.comboDataCollect.getItemAt(i);
            if (!dataCollectNumber.equals(dataCollect.getNumber())) continue;
            this.comboDataCollect.setSelectedIndex(i);
            break;
        }
    }

    private void fillDataElement(CustomerParams cp) {
        String dataElementNumber = cp.getCustomerParam(DATA_ELEMENT_NUMBER);
        if (dataElementNumber == null || dataElementNumber.trim().length() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataElementNumber));
        view.setFilter(filter);
        DataElementCollection dataElementColl = null;
        try {
            dataElementColl = DataElementFactory.getRemoteInstance().getDataElementCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (dataElementColl != null && dataElementColl.size() > 0) {
            this.prmtDataElement.setData((Object)dataElementColl.get(0));
        }
    }

    private void fillTemplate(CustomerParams cp) {
        String templateId = cp.getCustomerParam(TEMPLATE_ID);
        if (templateId == null || templateId.trim().length() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("templateType"));
        view.getSelector().add(new SelectorItemInfo(PERIOD_TYPE));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateId));
        view.setFilter(filter);
        TemplateCollection temColl = null;
        try {
            temColl = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (temColl != null && temColl.size() > 0) {
            this.prmtTemplate.setData((Object)temColl.get(0));
        }
    }

    private void fillOrgUnit(CustomerParams cp) {
        String orgNumberS = cp.getCustomerParam(ORG_NUMBERS);
        String treeId = cp.getCustomerParam(TREE_ID);
        if (orgNumberS == null || orgNumberS.trim().length() == 0) {
            return;
        }
        String[] strs = orgNumberS.split(";");
        HashSet<String> orgNumberSet = new HashSet<String>();
        for (int i = 0; i < strs.length; ++i) {
            orgNumberSet.add(strs[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.getSelector().add(new SelectorItemInfo("unit.longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.number", orgNumberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("longNumber");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        try {
            OrgStructureCollection orgColl = this.getOrgStructInterface().getOrgStructureCollection(view);
            OrgUnitInfo[] orgs = new OrgUnitInfo[orgColl.size()];
            for (int i = 0; i < orgColl.size(); ++i) {
                orgs[i] = orgColl.get(i).getUnit();
            }
            this.prmtOrgUnit.setData((Object)orgs);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void setIntToComponent(CustomerParams cp, KDSpinner sp, String key) {
        if (cp != null && cp.getCustomerParamsHashMap().containsKey(key)) {
            sp.setValue((Object)new Integer(cp.getInt(key)));
        }
    }

    public void setStringToComponent(CustomerParams cp, KDBizPromptBox box, String key) {
        if (cp != null && cp.getCustomerParamsHashMap().containsKey(key)) {
            box.setValue((Object)cp.getCustomerParam(key));
        }
    }

    protected FilterParam createNewFilterParam() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTemplate(null, null);
        this.initTitleColF7();
        this.initAnlysisColF7();
        this.initYearAndPeriod(3);
        this.initOrgTreeCbx();
        this.prmtOrgUnit.setEnabled(false);
        this.initDataCollect();
        this.initCurrency();
    }

    private void initDataCollect() throws BOSException, EASBizException {
        if (CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getBudgetDC())) {
            this.comboDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
        }
        if (CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getActualDC())) {
            this.comboDataCollect.addItem((Object)DataCollectConstant.getActualDC());
        }
    }

    private void setYearAndPeriodEnabled(boolean a) {
        this.spBeginYear.setEnabled(a);
        this.spBeginPeriod.setEnabled(a);
        this.spEndYear.setEnabled(a);
        this.spEndPeriod.setEnabled(a);
    }

    private void initCurrency() throws BOSException, EASBizException {
        String baseCurrencyID = null;
        CompanyOrgUnitCollection rootCompanyColl = this.getCompanyOrgUnitInterface().getCompanyOrgUnitCollection("select baseCurrency.id where id = '00000000-0000-0000-0000-000000000000CCE7AED4'");
        if (rootCompanyColl != null && !rootCompanyColl.isEmpty()) {
            baseCurrencyID = rootCompanyColl.get(0).getBaseCurrency().getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"11111111-1111-1111-1111-111111111111DEB58FDC", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"22222222-2222-2222-2222-222222222222DEB58FDC", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        CurrencyCollection currencyColl = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        for (int i = 0; i < currencyColl.size(); ++i) {
            this.comboCurrency.addItem((Object)currencyColl.get(i));
            if (!currencyColl.get(i).getId().toString().equals(baseCurrencyID)) continue;
            this.comboCurrency.setSelectedIndex(i);
        }
    }

    private void initYearAndPeriod(int periodTypeValue) {
        this.setYearAndPeriodEnabled(false);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        AnlysisClientHelper.setSpineRange(this.spBeginYear, 1901, 2099);
        AnlysisClientHelper.setSpineRange(this.spEndYear, 1901, 2099);
        AnlysisClientHelper.setPeriodRange(this.spBeginPeriod, periodTypeValue, year);
        AnlysisClientHelper.setPeriodRange(this.spEndPeriod, periodTypeValue, year);
        int[] period1 = AnlysisClientHelper.getLastPeriod(RptPeriodTypeEnum.getEnum((int)periodTypeValue), 1);
        int[] period2 = AnlysisClientHelper.getLastPeriod(RptPeriodTypeEnum.getEnum((int)periodTypeValue), 2);
        this.spBeginYear.setValue((Object)new Integer(period2[0]));
        this.spEndYear.setValue((Object)new Integer(period1[0]));
        this.spBeginPeriod.setValue((Object)new Integer(period2[1]));
        this.spEndPeriod.setValue((Object)new Integer(period1[1]));
        this.setYearAndPeriodEnabled(true);
    }

    private void initOrgTreeCbx() throws BOSException {
        int i;
        this.comboOrgBound.removeAllItems();
        TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        if (template != null) {
            periodType = template.getPeriodType();
        }
        int year = (Integer)this.spEndYear.getValue();
        int period = (Integer)this.spEndPeriod.getValue();
        List time1 = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType);
        OrgTreeCollection collection1 = null;
        OrgTreeCollection collection = new OrgTreeCollection();
        try {
            collection1 = CslRptUIUtil.getOrgTreeCollection((Date)time1.get(2));
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (collection1 == null || collection1.isEmpty()) {
            return;
        }
        for (i = 0; i < collection1.size(); ++i) {
            collection.add(collection1.get(i));
        }
        if (collection == null) {
            return;
        }
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            OrgTreeInfo orgTreeInfo = collection.get(i);
            this.comboOrgBound.addItem((Object)orgTreeInfo);
        }
    }

    public IOrgStructure getOrgStructInterface() throws BOSException {
        if (this.iStruct == null) {
            this.iStruct = OrgStructureFactory.getRemoteInstance();
        }
        return this.iStruct;
    }

    public ICompanyOrgUnit getCompanyOrgUnitInterface() throws BOSException {
        if (this.iCompanyOrgUnit == null) {
            this.iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        }
        return this.iCompanyOrgUnit;
    }

    @Override
    protected void comboOrgBound_itemStateChanged(ItemEvent e) throws Exception {
        super.comboOrgBound_itemStateChanged(e);
        this.prmtOrgUnit.setData(null);
        if (this.comboOrgBound.getItemCount() == 0) {
            this.prmtOrgUnit.setEnabled(false);
            return;
        }
        OrgTreeInfo orgTree = (OrgTreeInfo)this.comboOrgBound.getSelectedItem();
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setTreeID(orgTree.getId().toString());
        try {
            f7.filterUnitSql(UnionF7Helper.getQueryOrgUnitIDSql((String)orgTree.getId().toString(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        }
        catch (Exception e1) {
            super.handUIException((Throwable)e1);
        }
        f7.setMultiSelect(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setEditable(false);
        this.prmtOrgUnit.setEnabled(true);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
    }

    private void initTemplate(String treeid, List orgIdList) {
        this.prmtTemplate.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RptTemplateForAnlysisQuery");
        this.prmtTemplate.setData(null);
        this.prmtTemplate.setDisplayFormat("$name$");
        this.prmtTemplate.setEditFormat("$number$");
        this.prmtTemplate.setEditable(false);
    }

    @Override
    protected void prmtTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTemplate_dataChanged(e);
        this.prmtItemCol.setData(null);
        this.prmtTitleCol.setData(null);
        this.initTitleColF7();
        this.initAnlysisColF7();
        if (this.prmtTemplate.getData() == null) {
            this.initYearAndPeriod(3);
        } else {
            this.initYearAndPeriod(((TemplateInfo)this.prmtTemplate.getData()).getPeriodType().getValue());
        }
        this.initOrgTreeCbx();
    }

    public boolean verify() {
        int period2;
        if (this.prmtTemplate.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SelectTemplate"));
            return false;
        }
        if (this.prmtItemCol.getData() == null || this.prmtItemCol.getData().toString().length() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SelectItemCol"));
            return false;
        }
        int year1 = (Integer)this.spBeginYear.getValue();
        int year2 = (Integer)this.spEndYear.getValue();
        int period1 = (Integer)this.spBeginPeriod.getValue();
        if (year1 * 100 + period1 >= year2 * 100 + (period2 = ((Integer)this.spEndPeriod.getValue()).intValue())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"BeginLaterEnd"));
            return false;
        }
        if (this.prmtOrgUnit.getData() == null || ((OrgUnitInfo[])this.prmtOrgUnit.getData()).length == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SelectOrg"));
            return false;
        }
        return true;
    }

    private void initTitleColF7() {
        CSLTitleColF7 titleF7 = null;
        if (this.prmtTemplate.getData() != null) {
            TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
            titleF7 = new CSLTitleColF7((IUIObject)this, template.getId().toString(), true);
        } else {
            titleF7 = new CSLTitleColF7((IUIObject)this, null, true);
        }
        this.prmtTitleCol.setSelector((KDPromptSelector)titleF7);
    }

    private void initAnlysisColF7() {
        CSLTitleColF7 titleF7 = null;
        if (this.prmtTemplate.getData() != null) {
            TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
            titleF7 = new CSLTitleColF7((IUIObject)this, template.getId().toString(), false);
        } else {
            titleF7 = new CSLTitleColF7((IUIObject)this, null, false);
        }
        this.prmtItemCol.setSelector((KDPromptSelector)titleF7);
    }

    @Override
    protected void spBeginPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.spBeginPeriod_stateChanged(e);
        if (!this.spBeginPeriod.isEnabled()) {
            return;
        }
        this.initOrgTreeCbx();
    }

    @Override
    protected void spBeginYear_stateChanged(ChangeEvent e) throws Exception {
        super.spBeginYear_stateChanged(e);
        if (!this.spBeginYear.isEnabled()) {
            return;
        }
        this.initOrgTreeCbx();
    }

    @Override
    protected void spEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.spEndPeriod_stateChanged(e);
        if (!this.spEndPeriod.isEnabled()) {
            return;
        }
        this.initOrgTreeCbx();
    }

    @Override
    protected void spEndYear_stateChanged(ChangeEvent e) throws Exception {
        super.spEndYear_stateChanged(e);
        if (!this.spEndYear.isEnabled()) {
            return;
        }
        this.initOrgTreeCbx();
    }
}

