/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ReportInterfaceSourceTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportExportFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CSLReportExportFilterUI
extends AbstractCSLReportExportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportExportFilterUI.class);
    private static final String SELECT_ALL = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    private EntityViewInfo viewInfo = null;
    private FilterInfo filterInfo = null;
    private OrgTreeInfo orgBound = null;
    private static final int MONTHLY_INDEX = 2;
    private boolean isLock = false;
    boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private boolean hasMoved = false;

    public CSLReportExportFilterUI() throws Exception {
        this.combPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CSLReportExportFilterUI.this.refreshContainer();
            }
        });
    }

    private void initControl() {
        this.spinPeriod.setEnabled(false);
        this.spinYear.setEnabled(false);
        this.bizPrmptOrgUnit.setEditable(false);
        this.prmptCurrency.setRequired(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"341_CSLReportExportFilterUI"));
        this.kdcOrgBound.setSelector((KDPromptSelector)f7);
        this.kdcOrgBound.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    CSLReportExportFilterUI.this.listOrgBound_actionPerformed(null);
                }
                catch (Exception e) {
                    CSLReportExportFilterUI.this.handleException(e);
                }
            }
        });
        this.viewInfo = (EntityViewInfo)this.getUIContext().get("EntityViewInfo");
        this.filterInfo = this.viewInfo.getFilter();
        this.orgBound = (OrgTreeInfo)this.getUIContext().get("OrgBound");
        this.refreshOrgBound();
        this.refreshCompany();
        Date date = CslRptUIUtil.getLastPeriodDate(new Date());
        this.refreshTimeInfo(date);
        this.combPeriodType.setSelectedIndex(2);
        this.kdcOrgBound.setEditable(false);
        this.templateF7.setEnabled(false);
        this.templateF7.getQueryAgent().setEnabledMultiSelection(true);
        this.templateF7.setEnabledMultiSelection(true);
        this.templateF7.setDisplayFormat("$name$");
        this.templateF7.setEditFormat("$name$");
        this.templateF7.setCommitFormat("$number$");
        this.templateF7.setEditable(false);
        this.bizPrmptOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (CSLReportExportFilterUI.this.bizPrmptOrgUnit.getData() == null) {
                        CSLReportExportFilterUI.this.templateF7.setEnabled(false);
                        return;
                    }
                    OrgUnitInfo[] orgs = (OrgUnitInfo[])CSLReportExportFilterUI.this.bizPrmptOrgUnit.getData();
                    if (orgs == null || orgs.length == 0) {
                        CSLReportExportFilterUI.this.templateF7.setEnabled(false);
                        return;
                    }
                    CSLReportExportFilterUI.this.templateF7.setEnabled(true);
                    CSLReportExportFilterUI.this.templateF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.TemplateExportQuery");
                    ArrayList<String> selectedIds = new ArrayList<String>();
                    for (int i = 0; i < orgs.length; ++i) {
                        selectedIds.add(orgs[i].getId().toString());
                    }
                    Set templateIdSet = RPTDataServiceFactory.getRemoteInstance().getTemplateDispenseInfomationByOrgId(selectedIds);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    if (((RptPeriodTypeEnum)CSLReportExportFilterUI.this.combPeriodType.getSelectedItem()).getValue() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(((RptPeriodTypeEnum)CSLReportExportFilterUI.this.combPeriodType.getSelectedItem()).getValue())));
                    }
                    filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)"3,4,5,6,8,10,11,13", CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    CSLReportExportFilterUI.this.templateF7.setEntityViewInfo(view);
                }
                catch (Exception e) {
                    CSLReportExportFilterUI.this.handleException(e);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        this.refreshCompany();
        if (this.kdcOrgBound.getValue() != null) {
            OrgTreeInfo orgTree = (OrgTreeInfo)this.kdcOrgBound.getValue();
            this.orgBound.setName(orgTree.getName());
            this.bizPrmptOrgUnit.setData(null);
        }
    }

    @Override
    protected void rptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLock) {
            return;
        }
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    @Override
    protected void listPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.datePikerRptDate.getSqlDate());
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.combPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.spinYear.setValue((Object)new Integer(times.get(0).toString()));
        this.spinPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.isLock = true;
        this.datePikerRptDate.setValue(times.get(2));
        this.isLock = false;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.bizPrmptOrgUnit.getData() == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"Select_OrgUnit");
            MsgBox.showInfo((String)strErr);
            SysUtil.abort();
        }
        this.saveFilterInfo();
        this.getUIWindow().close();
        this.destroyWindow();
    }

    public void saveFilterInfo() {
        StringBuffer maskString = new StringBuffer();
        int index = 0;
        if (this.combPeriodType.getSelectedItem() != null && !this.combPeriodType.getSelectedItem().equals(SELECT_ALL)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.combPeriodType.getSelectedItem();
            FilterItemInfo filterItemPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemPeriodType);
            if (index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            Integer year = (Integer)this.spinYear.getValue();
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)year, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            if (++index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            Integer period = (Integer)this.spinPeriod.getValue();
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)period, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
            if (++index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            ++index;
        }
        if (this.prmptCurrency.getValue() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.prmptCurrency.getValue();
            FilterItemInfo filterItemCurrency = new FilterItemInfo("currency.number", (Object)currency.getNumber(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            if (index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            ++index;
        }
        if (this.kdcOrgBound.getValue() != null) {
            OrgTreeInfo orgBound = (OrgTreeInfo)this.kdcOrgBound.getValue();
            FilterItemInfo filterItemOrgBound = new FilterItemInfo("OrgTree.id", (Object)orgBound.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemOrgBound);
            if (index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            ++index;
        }
        if (this.bizPrmptOrgUnit.getData() != null) {
            OrgUnitInfo[] obj = (OrgUnitInfo[])this.bizPrmptOrgUnit.getData();
            maskString.append(" and  ( ");
            for (int i = 0; i < obj.length; ++i) {
                String id = obj[i].getId().toString();
                if (i != 0) {
                    maskString.append(" or ");
                }
                maskString.append(" ( ");
                FilterItemInfo filterItemFullOrgUnit = new FilterItemInfo("FullOrgUnit.id", (Object)id, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemFullOrgUnit);
                maskString.append(" #" + index + " ");
                FilterItemInfo filterItemOrgUnit = new FilterItemInfo("OrgUnit.id", (Object)id, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemOrgUnit);
                maskString.append("and #" + ++index + " ");
                maskString.append(" ) ");
                ++index;
            }
            maskString.append(" ) ");
        }
        if (this.combSourceType.getSelectedItem() != null) {
            maskString.append(" AND ((");
            this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(8)));
            maskString.append("#" + index + " ");
            this.filterInfo.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)new Integer(1)));
            if (++index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
            if (++index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + ") or (");
            ++index;
            HashSet<Integer> sourceTypeSet = new HashSet<Integer>();
            ReportInterfaceSourceTypeEnum sourceType = (ReportInterfaceSourceTypeEnum)((Object)this.combSourceType.getSelectedItem());
            if (sourceType.getValue() == 1) {
                sourceTypeSet.add(new Integer(7));
                sourceTypeSet.add(new Integer(1));
                sourceTypeSet.add(new Integer(2));
                sourceTypeSet.add(new Integer(10));
                sourceTypeSet.add(new Integer(11));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", sourceTypeSet, CompareType.INCLUDE));
                maskString.append("#" + index + " ");
                ++index;
            } else if (sourceType.getValue() == 2) {
                sourceTypeSet.add(new Integer(7));
                sourceTypeSet.add(new Integer(1));
                sourceTypeSet.add(new Integer(10));
                sourceTypeSet.add(new Integer(3));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", sourceTypeSet, CompareType.INCLUDE));
                maskString.append("#" + index + " ");
                ++index;
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
            if (index != 0) {
                maskString.append("and ");
            }
            maskString.append("#" + index + " ");
            ++index;
            maskString.append(" )) ");
        }
        if (this.templateF7.getData() != null) {
            Object[] templates = (Object[])this.templateF7.getData();
            HashSet<String> templateGroupIdSet = new HashSet<String>();
            for (int i = 0; i < templates.length; ++i) {
                TemplateInfo templateInfo = (TemplateInfo)templates[i];
                templateGroupIdSet.add(templateInfo.getGroup());
            }
            if (templateGroupIdSet.size() > 0) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("template.group", templateGroupIdSet, CompareType.INCLUDE));
                maskString.append("and ");
                maskString.append("#" + index + " ");
                ++index;
            }
        }
        this.filterInfo.setMaskString(maskString.toString());
    }

    private void refreshOrgBound() throws EASBizException, BOSException {
    }

    private void refreshCompany() throws BOSException {
        OrgTreeInfo orgTreeInfo = null;
        if (this.kdcOrgBound.getValue() != null) {
            this.bizPrmptOrgUnit.setValue(null);
            orgTreeInfo = (OrgTreeInfo)this.kdcOrgBound.getValue();
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            String strNumber = orgTreeInfo.getNumber();
            if (strNumber == null || strNumber.length() == 0) {
                String strErr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"pleaseSelectOrgTree");
                MsgBox.showInfo((String)strErr);
                return;
            }
            f7.setTreeID(orgTreeInfo.getId().toString());
            f7.setMultiSelect(true);
            this.bizPrmptOrgUnit.setSelector((KDPromptSelector)f7);
            this.bizPrmptOrgUnit.setEnabled(true);
        } else {
            this.bizPrmptOrgUnit.setEnabled(false);
        }
    }

    private int[][] getOldLocation() {
        int[][] points = new int[][]{{10, 50}, {10, 80}, {290, 110}, {10, 150}, {10, 180}};
        return points;
    }

    private void refreshContainer() {
        if (this.isMergeByFiscalPeriod) {
            RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.combPeriodType.getSelectedItem();
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.DAILY) || periodTypeEnum.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
                this.kDLabelContainer3.setVisible(true);
                if (this.hasMoved) {
                    this.kDLabelContainer4.setLocation(this.getOldLocation()[1][0], this.getOldLocation()[1][1]);
                    this.kDLabelContainer7.setLocation(this.getOldLocation()[2][0], this.getOldLocation()[2][1]);
                    this.kDLabelContainer1.setLocation(this.getOldLocation()[3][0], this.getOldLocation()[3][1]);
                    this.kDLabelContainer2.setLocation(this.getOldLocation()[4][0], this.getOldLocation()[4][1]);
                    this.hasMoved = false;
                    this.spinYear.setEnabled(false);
                    this.spinPeriod.setEnabled(false);
                }
                CslRptUIUtil.setSpineRange(this.spinYear, 1900, 9999);
                FiscalPeriodHelper.setSpineRangeByPeriodType(this.spinPeriod, periodTypeEnum);
            } else {
                this.kDLabelContainer3.setVisible(false);
                if (!this.hasMoved) {
                    this.kDLabelContainer4.setLocation(this.getOldLocation()[0][0], this.getOldLocation()[0][1]);
                    this.kDLabelContainer7.setLocation(this.getOldLocation()[1][0], this.getOldLocation()[1][1]);
                    this.kDLabelContainer1.setLocation(this.getOldLocation()[2][0], this.getOldLocation()[2][1]);
                    this.kDLabelContainer2.setLocation(this.getOldLocation()[3][0], this.getOldLocation()[3][1]);
                    this.hasMoved = true;
                    this.spinYear.setEnabled(true);
                    this.spinYear.setEditable(true);
                    this.spinPeriod.setEnabled(true);
                    this.spinPeriod.setEditable(true);
                }
                CslRptUIUtil.setSpineRange(this.spinYear, FiscalPeriodHelper.YearSpineRange[0], FiscalPeriodHelper.YearSpineRange[1]);
                FiscalPeriodHelper.setSpineRangeByPeriodType(this.spinPeriod, periodTypeEnum);
            }
        }
    }
}

