/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportExportListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportExportFilterUI;
import com.kingdee.eas.fi.rpt.client.ReportExporter;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSLReportExportListUI
extends AbstractCSLReportExportListUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportExportListUI.class);
    protected String COL_CSLREPORT_ID = "id";
    protected String COL_SELECT = "select";
    protected String COL_ORGUNIT_NAME = "orgUnit.name";
    protected String COL_ORGUNIT_NUMBER = "orgUnit.number";
    protected String COL_SOURCETYPE = "sourceType";
    protected String COL_CSLREPORT_NAME = "name";
    protected String COL_CSLREPORT_NUMBER = "number";
    protected String COL_TEMPLATE_NUMBER = "template.number";
    protected String COL_TEMPLATE_NAME = "template.name";
    protected String COL_CECURRENCY_NAME = "currency.name";
    protected String COL_YEAR = "year";
    protected String COL_PERIOD = "period";
    protected String COL_COMMITTEDSTATUS = "committedStatus";
    private IMetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"CSLReportQuery");
    private EntityViewInfo viewInfo = new EntityViewInfo();
    private FilterInfo filterInfo = new FilterInfo();
    private OrgTreeInfo orgBound = new OrgTreeInfo();
    private Boolean select = true;
    private Boolean unSelect = false;

    public CSLReportExportListUI() throws Exception {
        this.viewInfo.setFilter(this.filterInfo);
        this.viewInfo.getSorter().add(new SorterItemInfo("orgUnit.number"));
        this.setSelectors(this.viewInfo.getSelector());
    }

    private void initControl() {
        this.labSum.setVisible(false);
        this.labSumValue.setVisible(false);
        this.labOrgBound.setText(this.orgBound.getName());
        this.labOrgBound.setSize(new Dimension(400, 19));
        this.kdtExportPath.setVisible(false);
        this.labExportPath.setVisible(false);
        this.btnChoosePath.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.showFilterUI();
        int size = this.filterInfo.getFilterItems().size();
        if (size == 0) {
            SysUtil.abort();
        }
        super.onLoad();
        this.initControl();
        this.loadReportData();
    }

    private void showFilterUI() throws UIException {
        UIContext uiContext = null;
        uiContext = this.getUIWindow() == null ? new UIContext(this.getUIContext().get("OwnerWindow")) : new UIContext((Object)this);
        uiContext.put((Object)"EntityViewInfo", (Object)this.viewInfo);
        uiContext.put((Object)"OrgBound", (Object)this.orgBound);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CSLReportExportFilterUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private void loadReportData() throws BOSException {
        this.kdtMain.checkParsed();
        this.kdtMain.removeRows();
        this.kdtMain.getStyleAttributes().setLocked(true);
        this.kdtMain.getColumn(this.COL_SELECT).getStyleAttributes().setLocked(false);
        this.kdtMain.getSelectManager().setSelectMode(2);
        IQueryExecutor queryExecutor = this.getQueryExecutor(this.queryPK, this.viewInfo);
        IRowSet rs = queryExecutor.executeQuery();
        try {
            while (rs.next()) {
                IRow curRow = this.kdtMain.addRow();
                curRow.getCell(this.COL_CSLREPORT_ID).setValue((Object)rs.getString(this.COL_CSLREPORT_ID));
                curRow.getCell(this.COL_SELECT).setValue((Object)true);
                curRow.getCell(this.COL_ORGUNIT_NAME).setValue((Object)rs.getString(this.COL_ORGUNIT_NAME));
                curRow.getCell(this.COL_ORGUNIT_NUMBER).setValue((Object)rs.getString(this.COL_ORGUNIT_NUMBER));
                curRow.getCell(this.COL_SOURCETYPE).setValue((Object)rs.getString(this.COL_SOURCETYPE));
                curRow.getCell(this.COL_CSLREPORT_NAME).setValue((Object)rs.getString(this.COL_CSLREPORT_NAME));
                curRow.getCell(this.COL_CSLREPORT_NUMBER).setValue((Object)rs.getString(this.COL_CSLREPORT_NUMBER));
                curRow.getCell(this.COL_TEMPLATE_NAME).setValue((Object)rs.getString(this.COL_TEMPLATE_NAME));
                curRow.getCell(this.COL_TEMPLATE_NUMBER).setValue((Object)rs.getString(this.COL_TEMPLATE_NUMBER));
                curRow.getCell(this.COL_CECURRENCY_NAME).setValue((Object)rs.getString(this.COL_CECURRENCY_NAME));
                curRow.getCell(this.COL_YEAR).setValue((Object)new Integer(rs.getInt(this.COL_YEAR)));
                curRow.getCell(this.COL_PERIOD).setValue((Object)new Integer(rs.getShort(this.COL_PERIOD)));
                curRow.getCell(this.COL_COMMITTEDSTATUS).setValue((Object)rs.getString(this.COL_COMMITTEDSTATUS));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isAutoIgnoreDuplicatedRow = true;
        return exec;
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
            this.kdtMain.getRow(i).getCell(this.COL_SELECT).setValue((Object)this.select);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
            this.kdtMain.getRow(i).getCell(this.COL_SELECT).setValue((Object)this.unSelect);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        ReportExporter exporter = new ReportExporter();
        exporter.setWithJiuQiReportType(this.withReportTypeCheckBox.isSelected());
        exporter.setWithPeriod(this.withPeriodCheckBox.isSelected());
        exporter.setWithYear(this.withYearCheckBox1.isSelected());
        exporter.exceport((Component)((Object)this), this.getSelectIds());
        this.getUIWindow().close();
        this.destroyWindow();
    }

    private String[] getSelectIds() {
        ArrayList<Object> reportIdList = new ArrayList<Object>();
        int rowCount = this.kdtMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Boolean isSelect = (Boolean)this.kdtMain.getRow(i).getCell(this.COL_SELECT).getValue();
            if (!isSelect.booleanValue()) continue;
            reportIdList.add(this.kdtMain.getRow(i).getCell(this.COL_CSLREPORT_ID).getValue());
        }
        String[] reportIds = new String[reportIdList.size()];
        for (int i = 0; i < reportIdList.size(); ++i) {
            reportIds[i] = (String)reportIdList.get(i);
        }
        return reportIds;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.destroyWindow();
    }

    @Override
    protected void btnChoosePath_actionPerformed(ActionEvent e) throws Exception {
        super.btnChoosePath_actionPerformed(e);
        String currentDirectoryPath = null;
        KDFileChooser cuz = new KDFileChooser(currentDirectoryPath);
        cuz.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.ReportProcessUI_Export"));
        cuz.setFileSelectionMode(1);
        if (cuz.showSaveDialog((Component)((Object)this)) == 0) {
            File file = cuz.getSelectedFile();
            String name = file.getName();
            if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
                MsgBox.showWarning((String)(name + "\n" + RptUtil.getReportResource((String)"invalidFileName")));
            } else if (file != null) {
                String path = file.getAbsolutePath();
                this.kdtExportPath.setText(path);
            }
        }
    }

    public void setSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("FullOrgUnit.id"));
        sic.add(new SelectorItemInfo("FullOrgUnit.name"));
        sic.add(new SelectorItemInfo("FullOrgUnit.number"));
        sic.add(new SelectorItemInfo("OrgTree.id"));
    }
}

