/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLAnlysisTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnalysisFilterParam;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisObjectFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportAnlysisObject;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLReportPerformAnalysisListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnalysisFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.AnlysisClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportAnalysisMainUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLReportPerformAnalysisMainUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.AnalysisFilterCondition;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.ColorChangeListener;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CSLReportPerformAnalysisListUI
extends AbstractCSLReportPerformAnalysisListUI
implements ColorChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(CSLReportPerformAnalysisListUI.class);
    DefaultKingdeeTreeNode rootNode = null;
    private CommonQueryDialog conditionDialog = null;
    private AnalysisFilterUI conditionPanel = null;
    private FilterInfo currentFilter = null;
    private ICSLReportAnlysisObject iAnlysis;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAnalysis.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.menuItemAnalysis.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.treeMain.setSelectionNode(this.rootNode);
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, "GR_CSL_SupportOtherDS");
        if ("true".equals(isSupportOtherDS)) {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect").getStyleAttributes().setHided(true);
        }
    }

    protected void checkDataCollectPermission() throws BOSException, EASBizException {
        AnlysisClientHelper.checkAnlysisCanStart((CoreUI)this);
        if (!CSLPermissionUtil.hasDataCollectPermission(null, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), DataCollectConstant.getBudgetDC())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Query_No_BGDC_Permission"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.filterQuery();
    }

    private void filterQuery() throws Exception {
        this.execQuery();
    }

    protected void initTree() throws Exception {
        this.initOrgTree();
    }

    private void initOrgTree() throws Exception {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
        if (treeInfo != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
            FullOrgUnitInfo preOrgUnit = this.getOrgUnitInfo(selectNode);
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setTreeID(treeInfo.getId().toString());
            f7.setMultiSelect(false);
            TreeModel model = f7.buildTreeModel(OrgViewType.UNIONDEBT, treeInfo, null);
            this.treeMain.setModel(model);
            UnionF7Helper.addTreeWillExpandListener((KDTree)this.treeMain, (OrgTreeInfo)treeInfo, (UnionF7Helper.UnionF7)f7);
            this.rootNode = (DefaultKingdeeTreeNode)model.getRoot();
            if (preOrgUnit == null) {
                this.treeMain.setSelectionNode(this.rootNode);
            } else {
                DefaultKingdeeTreeNode curNode = null;
                FullOrgUnitInfo curOrgUnit = null;
                Enumeration e = this.rootNode.breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    curNode = (DefaultKingdeeTreeNode)e.nextElement();
                    curOrgUnit = this.getOrgUnitInfo(curNode);
                    if (curOrgUnit == null || !preOrgUnit.getNumber().equalsIgnoreCase(curOrgUnit.getNumber())) continue;
                    this.treeMain.setSelectionNode(curNode);
                    break;
                }
            }
        } else {
            this.treeMain.setModel(null);
        }
    }

    private FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode treeNode) {
        Object obj = null;
        FullOrgUnitInfo orgUnit = null;
        OrgStructureInfo structureInfo = null;
        if (treeNode != null && (obj = treeNode.getUserObject()) != null && obj instanceof OrgStructureInfo) {
            structureInfo = (OrgStructureInfo)obj;
            orgUnit = structureInfo.getUnit();
        }
        if (orgUnit != null && orgUnit.getNumber() == null) {
            try {
                FullOrgUnitInfo orgUnit1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select number where id='" + orgUnit.getId().toString() + "'");
                orgUnit.setNumber(orgUnit1.getNumber());
            }
            catch (Exception e) {
                orgUnit.setNumber(structureInfo.getLongNumber());
            }
        }
        return orgUnit;
    }

    private void initCbxMain() throws BOSException {
        AnalysisFilterCondition filterCondition = this.getFilterCondition();
        List time = RPTDateUtil.getRptYearAndPeriodAndDate(filterCondition.getYear(), filterCondition.getPeriod(), filterCondition.getPeriodType());
        OrgTreeCollection collection = null;
        try {
            collection = CslRptUIUtil.getOrgTreeCollection((Date)time.get(2));
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (collection == null) {
            return;
        }
        OrgTreeInfo select = (OrgTreeInfo)this.cbxMain.getModel().getSelectedItem();
        String[] ids = new String[collection.size()];
        DefaultComboBoxModel<OrgTreeInfo> model = new DefaultComboBoxModel<OrgTreeInfo>();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            OrgTreeInfo orgTreeInfo = collection.get(i);
            model.addElement(orgTreeInfo);
            ids[i] = orgTreeInfo.getId().toString();
            if (select == null || !orgTreeInfo.getNumber().equals(select.getNumber())) continue;
            model.setSelectedItem(orgTreeInfo);
        }
        this.cbxMain.setModel(model);
    }

    private AnalysisFilterCondition getFilterCondition() {
        AnalysisFilterCondition condition = new AnalysisFilterCondition();
        FilterItemCollection itemCollection = this.mainQuery.getFilter().getFilterItems();
        int index = 0;
        while (index < itemCollection.size()) {
            FilterItemInfo filterItemInfo;
            if ((filterItemInfo = itemCollection.get(index++)).getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodTypeInt = (Integer)filterItemInfo.getCompareValue();
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)periodTypeInt);
                condition.setPeriodType(periodType);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                Integer year = (Integer)filterItemInfo.getCompareValue();
                condition.setYear(year);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                Integer period = (Integer)filterItemInfo.getCompareValue();
                condition.setPeriod(period);
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("committedStatus")) continue;
            Integer queryStatusValue = (Integer)filterItemInfo.getCompareValue();
            CommittedStatusEnum queryStatus = CommittedStatusEnum.getEnum((int)queryStatusValue);
            condition.setQueryStatus(queryStatus);
        }
        Object orgTree = this.cbxMain.getSelectedItem();
        condition.setOrgBoundId(orgTree == null ? null : ((OrgTreeInfo)orgTree).getId().toString());
        condition.setIncludeSub(this.chkIncludeChild.isSelected());
        return condition;
    }

    private void refreshOrgBound() throws Exception {
        this.initCbxMain();
        this.initTree();
    }

    private CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "CSLReportPerformAnalysisQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"30_CSLReportPerformAnalysisListUI");
            this.conditionDialog.setTitle(MessageFormat.format(msg, this.resHelper.getString("this.title")));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.conditionDialog;
    }

    private AnalysisFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new AnalysisFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = CSLReportPerformAnalysisListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.getConditionDialog().show()) {
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                this.currentFilter = this.mainQuery.getFilter();
                this.refreshOrgBound();
            } else {
                this.abort();
            }
        } else {
            if (this.mainQuery != null) {
                this.currentFilter = this.mainQuery.getFilter();
            }
            this.refreshOrgBound();
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    @Override
    public void actionAnalysis_actionPerformed(ActionEvent e) throws Exception {
        this.showAnlysisMainUI(CSLReportPerformAnalysisMainUI.class.getName(), OprtState.EDIT);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.showAnlysisMainUI(CSLReportPerformAnalysisMainUI.class.getName(), OprtState.VIEW);
    }

    protected void showAnlysisMainUI(String uiName, String operState) throws UIException {
        this.checkSelected();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(activeRowIndex);
        CSLReportAnalysisFilterParam filterParam = this.getFilterParam(row);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"time", (Object)(System.currentTimeMillis() + ""));
        uiContext.put((Object)"DirectFilterParam", (Object)filterParam);
        CSLReportAnalysisMainUI.isNeedToDelOldWin(uiContext, uiName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, operState);
        uiWindow.show();
    }

    protected CSLReportAnalysisFilterParam getFilterParam(IRow row) {
        CSLReportAnalysisFilterParam filterParam = new CSLReportAnalysisFilterParam();
        Object orgUnitID = row.getCell("orgUnit.id").getValue();
        filterParam.setOrgUnitId(orgUnitID.toString());
        Object orgUnitNumber = row.getCell("orgUnit.number").getValue();
        filterParam.setOrgUnitNumber(orgUnitNumber.toString());
        Object report = row.getCell("id").getValue();
        filterParam.setReportId(report.toString());
        String treeID = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getId().toString();
        filterParam.setOrgTreeId(treeID);
        String treeNumber = ((OrgTreeInfo)this.cbxMain.getSelectedItem()).getNumber();
        filterParam.setOrgTreeNumber(treeNumber);
        Object srcCurrencyNum = row.getCell("sourceCurrencyNum").getValue();
        filterParam.setSourceCurrencyNumber(srcCurrencyNum.toString());
        Object srcCurrencyId = row.getCell("sourceCurrencyID").getValue();
        filterParam.setSourceCurrencyId(srcCurrencyId.toString());
        Object convertCurrencyNumber = row.getCell("currencyNum").getValue();
        filterParam.setConvertCurrencyNumber(convertCurrencyNumber.toString());
        Object convertCurrencyId = row.getCell("currencyID").getValue();
        filterParam.setConvertCurrencyId(convertCurrencyId.toString());
        String year = row.getCell("year").getValue().toString();
        filterParam.setYear(Integer.parseInt(year));
        String period = row.getCell("period").getValue().toString();
        filterParam.setPeriod(Integer.parseInt(period));
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)((BizEnumValueInfo)row.getCell("periodType").getValue()).getInt());
        filterParam.setPeriodType(periodType);
        RptSrcTypeEnum sourceType = RptSrcTypeEnum.getEnum((int)((BizEnumValueInfo)row.getCell("sourceType").getValue()).getInt());
        filterParam.setSourceType(sourceType.getName());
        filterParam.setAnalysisType(CSLAnlysisTypeEnum.PerformAnlysis);
        return filterParam;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.treeMain.getSelectionPath() != null) {
            FilterInfo filter = viewInfo.getFilter();
            if (filter == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            try {
                OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cbxMain.getSelectedItem();
                String treeID = orgTreeInfo.getId().toString();
                String treeNumber = orgTreeInfo.getNumber();
                String structLongNumber = ((OrgStructureInfo)((DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent()).getUserObject()).getLongNumber();
                Set orgIdSet = this.getAnlysisInteface().getOrgsInTree(treeID, structLongNumber, this.chkIncludeChild.isSelected());
                FilterItemCollection coll = new FilterItemCollection();
                coll.add(new FilterItemInfo("orgUnit.id", (Object)orgIdSet, CompareType.INCLUDE));
                coll.add(new FilterItemInfo("tree.number", (Object)treeNumber));
                this.replaceFilterItems(viewInfo.getFilter(), coll);
                this.replaceDisplayAll(viewInfo.getFilter().getFilterItems());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    private void replaceDisplayAll(FilterItemCollection items) {
        if (items == null) {
            return;
        }
        FilterItemInfo info = null;
        for (int i = 0; i < items.size(); ++i) {
            info = items.get(i);
            if (!info.getPropertyName().trim().equals("committedStatus") || !info.getCompareValue().toString().equals("0")) continue;
            info.setCompareType(CompareType.NOTEQUALS);
            items.clear();
        }
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemCollection items) {
        if (filter == null || items == null) {
            return;
        }
        if (!items.isEmpty()) {
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                this.replaceFilterItems(filter, (FilterItemInfo)iter.next());
            }
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            for (int i = 0; i < fiCol.size(); ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim()) || !fiInfo.getCompareType().toString().equals(item.getCompareType().toString())) continue;
                if (item.getCompareType().toString().equals("=")) {
                    fiInfo.setCompareType(item.getCompareType());
                    fiInfo.setCompareValue(item.getCompareValue());
                } else if (item.getCompareType().toString().equals("like")) {
                    fiInfo.setCompareType(item.getCompareType());
                    fiInfo.setCompareValue(item.getCompareValue());
                } else if (item.getCompareType().toString().equals("in")) {
                    fiInfo.setCompareType(item.getCompareType());
                    fiInfo.setCompareValue(item.getCompareValue());
                }
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    public ICSLReportAnlysisObject getAnlysisInteface() throws BOSException {
        if (this.iAnlysis == null) {
            this.iAnlysis = CSLReportAnlysisObjectFactory.getRemoteInstance();
        }
        return this.iAnlysis;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        this.tblMain.refresh();
        this.selectFirstRow();
    }

    @Override
    public void actionColorScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionColorScheme_actionPerformed(e);
    }

    public void colorChanged(Map newColors) {
    }
}

