/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaEvent;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class CSLTableScanner {
    public static final int CSLTABLESCANNER_AREAINDEX_ROW1 = 0;
    public static final int CSLTABLESCANNER_AREAINDEX_COL1 = 1;
    public static final int CSLTABLESCANNER_AREAINDEX_ROW2 = 2;
    public static final int CSLTABLESCANNER_AREAINDEX_COL2 = 3;
    private ItemFormulaEvent invokeObject = null;

    public CSLTableScanner(ItemFormulaEvent event) {
        this.invokeObject = event;
    }

    public void scanTables(List sheets) {
        this._scans(sheets, null);
    }

    public void scanTables(List sheets, String areaString) {
        this._scans(sheets, areaString);
    }

    public void scanTable(RptSheet sheet, String areaString) {
        if (areaString.trim().length() == 0) {
            this.scanTable(sheet);
        } else {
            String[] areas = areaString.split(",", 0);
            if (areas.length == 4) {
                this._scan(sheet, Integer.parseInt(areas[0]), Integer.parseInt(areas[1]), Integer.parseInt(areas[2] + 1), Integer.parseInt(areas[3] + 1));
            } else {
                this.scanTable(sheet);
            }
        }
    }

    public void scanTable(RptSheet sheet) {
        if (sheet == null) {
            return;
        }
        KDTable table = sheet.getTable();
        if (table == null) {
            return;
        }
        this._scan(sheet, 0, 0, table.getExpandedRowCount(), table.getExpandedColumnCount());
    }

    private void _scans(List sheets, String areaString) {
        if (sheets == null) {
            return;
        }
        RptSheet sheet = null;
        Iterator itor = sheets.iterator();
        while (!this.invokeObject.isStopBubble() && itor.hasNext()) {
            sheet = (RptSheet)itor.next();
            if (areaString == null) {
                this.scanTable(sheet);
                continue;
            }
            this.scanTable(sheet, areaString);
        }
    }

    private void _scan(RptSheet sheet, int rowStartIndex, int colStartIndex, int rowCount, int colCount) {
        if (sheet == null) {
            return;
        }
        KDTable table = sheet.getTable();
        if (table == null) {
            return;
        }
        int row = -1;
        row = rowCount;
        int col = -1;
        col = colCount;
        CSLReportGroupEnum rptCls = null;
        RptSheetParamInfo sheetParams = sheet.getParams();
        if (sheetParams == null) {
            return;
        }
        rptCls = sheet.getParams().getReportClass();
        IRow r = null;
        ICell c = null;
        for (int i = rowStartIndex; i < row; ++i) {
            r = table.getRow(i);
            for (int j = colStartIndex; j < col; ++j) {
                c = r.getCell(j);
                this._analyzeCell(table, c, rptCls);
                if (!this.invokeObject.isStopBubble()) continue;
                return;
            }
        }
    }

    private void _analyzeCell(KDTable table, ICell c, CSLReportGroupEnum rptCls) {
        if (rptCls == null) {
            return;
        }
        if (rptCls.getValue() == 1) {
            if (c.getUserObject() == null) {
                return;
            }
            this._analyzeCellByPoint(c, rptCls);
        } else if (rptCls.getValue() == 10) {
            ICell cx = table.getRow(0).getCell(c.getColumnIndex());
            ICell cy = table.getRow(c.getRowIndex()).getCell(0);
            RptCell rptCellX = (RptCell)cx.getUserObject();
            RptCell rptCellY = (RptCell)cy.getUserObject();
            if (rptCellX == null || rptCellY == null) {
                return;
            }
            ItemFormula fx = rptCellX.getItemFormula();
            ItemFormula fy = rptCellY.getItemFormula();
            if (fx == null || fy == null || fx.getExt("ItemNumber") == null || fy.getExt("CompanyId") == null) {
                return;
            }
            this._analyzeCellByXY("ItemNumber", fx.getExt("ItemNumber").toString().trim(), "CompanyId", fy.getExt("CompanyId").toString().trim(), c, rptCls);
        }
    }

    private void _analyzeCellByXY(String xKey, String xValue, String yKey, String yValue, ICell c, CSLReportGroupEnum rptCls) {
        ItemFormula event = new ItemFormula();
        event.putExt(xKey, xValue.toString().trim());
        event.putExt(yKey, yValue.toString().trim());
        event.setReportClass(String.valueOf(rptCls.getValue()));
        event.setValue(this._getValue(c));
        event.setInvokeObject(this.invokeObject);
        this._bubbleFormula(event);
    }

    private void _analyzeCellByPoint(ICell c, CSLReportGroupEnum rptCls) {
        RptCell rptCell = (RptCell)c.getUserObject();
        if (rptCell == null || rptCell.getItemFormula() == null) {
            return;
        }
        ItemFormula event = (ItemFormula)rptCell.getItemFormula().clone();
        if (event != null && event.getFormula() != null) {
            event.setReportClass(String.valueOf(rptCls.getValue()));
            event.setValue(this._getValue(c));
            event.setInvokeObject(this.invokeObject);
            this._bubbleFormula(event);
        }
    }

    private void _bubbleFormula(ItemFormula event) {
        this.invokeObject.bubbleFormula(event);
    }

    private BigDecimal _getValue(ICell c) {
        BigDecimal value = null;
        try {
            value = new BigDecimal(c.getValue().toString());
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }
}

