/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.message.MAGroupEntryCollection;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupOrgFacadeFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLK3TemplateFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLK3TemplateInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLSchemeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLK3Template;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostMan;
import com.kingdee.eas.fi.gr.cslrpt.MessagePostManManager;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.SchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCSLTemplateExportSelectUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLUploadConfigUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SchemeEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLImportUtility;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.gr.cslrpt.util.ExtensionFileFilter;
import com.kingdee.eas.fi.gr.cslrpt.util.FTPUpDown;
import com.kingdee.eas.fi.gr.cslrpt.util.IEqualable;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class CSLTemplateExportSelectUI
extends AbstractCSLTemplateExportSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLTemplateExportSelectUI.class);
    public static final String EXPORTCONFIG = "ExportConfig";
    public static final String EXPORTCONFIG_FILE_PATH = "ExportConfig_ItemFile_Path";
    public static final String EXPORTCONFIG_FTP_SERVERIP = "ExportConfig_ItemFTP_ServerIP";
    public static final String EXPORTCONFIG_FTP_SERVERDIR = "ExportConfig_ItemFTP_ServerDIR";
    public static final String EXPORTCONFIG_FTP_LOGINNAME = "ExportConfig_ItemFTP_LoginName";
    public static final String EXPORTCONFIG_FTP_PASSWORD = "ExportConfig_ItemFTP_Password";
    public static final String EXPORTCONFIG_FTP_FROMLOCAL = "ExportConfig_ItemFTP_IsFromLocal";
    public static final String EXPORTCONFIG_MAIL_MAILGROUP = "ExportConfig_ITemMail_MailGroup";
    public static final String EXPORTCONFIG_MAIL_FROMLOCAL = "ExportConfig_ItemMail_IsFromLocal";
    public static final String EXPORTCONFIG_MAIL_CHECK = "ExportConfig_ItemMail_CHECK";
    private static final String RESOURECE = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    public static final String DefaultDirectory = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "gamania";
    private String CompanySelectSchemeID = "";
    private String CompanyRelaSelectSchemeID = "";
    private ArrayList Model_SourceTemplates = new ArrayList();
    private ArrayList Model_Companys = new ArrayList();
    private HashMap Model_Company_Templates = new HashMap();
    private ArrayList Model_RelaCompanys = new ArrayList();
    private ArrayList Model_Currencys = new ArrayList();
    private List interCompanys = new ArrayList();
    private HashMap ExportConfigMap = new HashMap();
    private ArrayList removesTemplates = new ArrayList();
    private NewCompanyF7 companyF7 = null;
    private ICSLK3Template iCSLK3Template = null;
    private MessagePostManManager msgMng;
    private volatile int ExportCount = 0;

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        File dir = new File(DefaultDirectory);
        if (dir.exists()) {
            CSLIOUtils.deleteDirectory(dir);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            File dir = new File(DefaultDirectory);
            if (dir.exists()) {
                CSLIOUtils.deleteDirectory(dir);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionExportFile_actionPerformed(ActionEvent e) throws Exception {
        File fileLocal;
        super.actionExportFile_actionPerformed(e);
        String file = (String)this.ExportConfigMap.get(EXPORTCONFIG_FILE_PATH);
        if (StringUtils.isEmpty((String)file)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURECE, (String)"NO_LOCALHOST_FOLDER"));
            SysUtil.abort();
        }
        if (!(fileLocal = new File(file)).exists()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"422_CSLUploadConfigUI"));
            SysUtil.abort();
        }
        ArrayList result = this.doExport(file);
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)RESOURECE, (String)"EXPORT"));
        resultStr.append("\n\r\n\r");
        if (result.size() > 0) {
            resultStr.append(EASResource.getString((String)RESOURECE, (String)"SUCEESS_EXPORT_TEMPLATE")).append("\n\r");
            resultStr.append(StringUtils.arrayToString((Object[])result.toArray(), (String)",\n\r"));
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"31_CSLTemplateExportSelectUI");
            resultStr.append("\n\r" + MessageFormat.format(msg, result.size()));
            resultStr.append("\n\r");
            String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"32_CSLTemplateExportSelectUI");
            resultStr.append(MessageFormat.format(msg2, file));
        } else {
            resultStr.append(EASResource.getString((String)RESOURECE, (String)"TEMPLATE_EXPORT_ERROR"));
        }
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)RESOURECE, (String)"LOCALHOST_EXPORT_RESULT"));
        SimpleNotePad.showMessageByModel(utx, resultStr.toString());
    }

    private ArrayList doExport(String file) throws IOException {
        this.saveModels();
        this.checkBeforeExport();
        ArrayList result = this.export(file);
        return result;
    }

    @Override
    public void actionConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfig_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)EXPORTCONFIG, (Object)this.ExportConfigMap);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CSLUploadConfigUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    private void loadLastedConfig() throws Exception {
        SchemeCollection filePathSchemes = (SchemeCollection)((Object)this.msgMng.getItemValue("loadLastedConfig"));
        Iterator iter = filePathSchemes.iterator();
        while (iter.hasNext()) {
            SchemeInfo element = (SchemeInfo)iter.next();
            HashMap pathMap = (HashMap)element.getAdapterObject(CSLSchemeTypeEnum.SAVEPATH);
            if (pathMap == null || !CSLUploadConfigUI.class.getName().equalsIgnoreCase((String)pathMap.get("relateUI"))) continue;
            this.ExportConfigMap.put(EXPORTCONFIG_FILE_PATH, pathMap.get("relatePath"));
        }
        SchemeCollection serverSchemes = SchemeFactory.getRemoteInstance().getSchemeCollection("where type = 3");
        Iterator iter2 = serverSchemes.iterator();
        while (iter2.hasNext()) {
            SchemeInfo scheme = (SchemeInfo)iter2.next();
            Object config = null;
            if (scheme == null || !((config = scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY)) instanceof HashMap)) continue;
            HashMap s = (HashMap)config;
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_SERVERIP, s.get("serverAddress").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_SERVERDIR, s.get("serverDirectory").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_LOGINNAME, s.get("serverLoginName").toString());
            this.ExportConfigMap.put(EXPORTCONFIG_FTP_PASSWORD, s.get("serverLoginPassword").toString());
            if (s.get("EXPORTCONFIG_FTP_FROMLOCAL") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_FTP_FROMLOCAL, Boolean.valueOf(s.get("EXPORTCONFIG_FTP_FROMLOCAL").toString()));
            } else {
                this.ExportConfigMap.put(EXPORTCONFIG_FTP_FROMLOCAL, false);
            }
            if (s.get("EXPORTCONFIG_MAIL_FROMLOCAL") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_FROMLOCAL, Boolean.valueOf(s.get("EXPORTCONFIG_MAIL_FROMLOCAL").toString()));
            } else {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_FROMLOCAL, false);
            }
            if (s.get("EXPORTCONFIG_MAIL_CHECK") != null) {
                this.ExportConfigMap.put(EXPORTCONFIG_MAIL_CHECK, Boolean.valueOf(s.get("EXPORTCONFIG_MAIL_CHECK").toString()));
                break;
            }
            this.ExportConfigMap.put(EXPORTCONFIG_MAIL_CHECK, false);
            break;
        }
    }

    @Override
    public void actionExportFTP_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        super.actionExportFTP_actionPerformed(e);
        FTPUpDown ftp = null;
        try {
            ftp = new FTPUpDown((String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), "", (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_LOGINNAME), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_PASSWORD));
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"342_CSLReportImportUI"));
            SysUtil.abort();
        }
        ArrayList result = null;
        boolean isFromLocal = (Boolean)this.ExportConfigMap.get(EXPORTCONFIG_FTP_FROMLOCAL);
        if (!isFromLocal) {
            result = this.doExport(DefaultDirectory);
        }
        Object[] files = this.getUploadFiles(isFromLocal);
        for (int i = 0; i < files.length; ++i) {
            ftp.uploadFile(files[i].getAbsolutePath(), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR));
        }
        File dir = new File(DefaultDirectory);
        if (!isFromLocal && dir.exists()) {
            CSLIOUtils.deleteDirectory(dir);
        }
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"397_CSLTemplateExportSelectUI") + "\n\r\n\r");
        if (result != null && result.size() > 0) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"33_CSLTemplateExportSelectUI");
            String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"99_CSLTemplateExportSelectUI");
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"398_CSLTemplateExportSelectUI")).append("\n\r").append(StringUtils.arrayToString((Object[])result.toArray(), (String)",\n\r")).append("\n\r" + MessageFormat.format(msg, result.size())).append("\n\r").append(MessageFormat.format(msg2, (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR)));
        } else if (result == null && files.length > 0) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"33_CSLTemplateExportSelectUI");
            String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"99_CSLTemplateExportSelectUI");
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"399_CSLTemplateExportSelectUI")).append("\n\r").append(CSLIOUtils.arrayToString(files, "getName", ",\n\r")).append("\n\r" + MessageFormat.format(msg, files.length)).append("\n\r").append(MessageFormat.format(msg2, (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERIP), (String)this.ExportConfigMap.get(EXPORTCONFIG_FTP_SERVERDIR)));
        } else {
            resultStr.append(EASResource.getString((String)RESOURECE, (String)"TEMPLATE_EXPORT_ERROR"));
        }
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"400_CSLTemplateExportSelectUI"));
        SimpleNotePad.showMessageByModel(utx, resultStr.toString());
    }

    private File[] getUploadFiles(boolean isFromLocal) {
        File[] files;
        File dir = new File(DefaultDirectory);
        if (isFromLocal) {
            dir = new File((String)this.ExportConfigMap.get(EXPORTCONFIG_FILE_PATH));
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"354_CSLReportImportUI"));
            SysUtil.abort();
        }
        if ((files = dir.listFiles(new ExtensionFileFilter("dnf"))) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"401_CSLTemplateExportSelectUI"));
            SysUtil.abort();
        }
        return files;
    }

    @Override
    public void actionExportMAIL_actionPerformed(ActionEvent e) throws Exception {
        HashMap attachmentMap;
        boolean isFromLocal;
        super.actionExportMAIL_actionPerformed(e);
        ArrayList list = (ArrayList)this.ExportConfigMap.get(EXPORTCONFIG_MAIL_MAILGROUP);
        if (list == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"402_CSLTemplateExportSelectUI"));
            SysUtil.abort();
        }
        if (!(isFromLocal = ((Boolean)this.ExportConfigMap.get(EXPORTCONFIG_FTP_FROMLOCAL)).booleanValue())) {
            ArrayList arrayList = this.doExport(DefaultDirectory);
        }
        if ((attachmentMap = this.getCompanyDNFAttachmentMap(isFromLocal)).size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"403_CSLTemplateExportSelectUI"));
            SysUtil.abort();
        }
        StringBuffer resultStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"404_CSLTemplateExportSelectUI"));
        resultStr.append("\n\r\n\r");
        String result = null;
        HashMap receiversMap = this.getCompanyReceiversMap(list);
        if (receiversMap.size() == 0) {
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"405_CSLTemplateExportSelectUI") + "\n\r" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"406_CSLTemplateExportSelectUI") + "\n\r");
        } else {
            Set companyKey = attachmentMap.keySet();
            Iterator iter = companyKey.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                if (receiversMap.containsKey(element)) continue;
                iter.remove();
            }
            if (attachmentMap.size() == 0) {
                resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"407_CSLTemplateExportSelectUI"));
                resultStr.append("\n\r");
            } else {
                result = CSLK3TemplateFactory.getRemoteInstance().deliverTemplate(attachmentMap, receiversMap);
            }
        }
        File dir = new File(DefaultDirectory);
        if (!isFromLocal && dir.exists()) {
            try {
                CSLIOUtils.deleteDirectory(dir);
            }
            catch (IOException iter) {
                // empty catch block
            }
        }
        if (result != null) {
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"408_CSLTemplateExportSelectUI")).append("\n\r" + result + "\n\r");
        } else {
            resultStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"409_CSLTemplateExportSelectUI"));
        }
        UIContext utx = new UIContext((Object)this);
        utx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"410_CSLTemplateExportSelectUI"));
        SimpleNotePad.showMessageByModel(utx, resultStr.toString());
    }

    private HashMap getCompanyReceiversMap(ArrayList list) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        for (MAGroupInfo mAGroupInfo : list) {
            String orgUnitID = MAGroupOrgFacadeFactory.getRemoteInstance().getCompanyOrgUnit(mAGroupInfo.getOrgUnit());
            FullOrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitID));
            ArrayList<String> receivers = new ArrayList<String>();
            MAGroupEntryCollection entries = mAGroupInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                PersonInfo personInfo;
                if (entries.get(i).getPersonnel() == null || (personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(entries.get(i).getPersonnel().getId()))) == null || StringUtils.isEmpty((String)personInfo.getEmail())) continue;
                receivers.add(personInfo.getEmail());
            }
            if (receivers.size() == 0) continue;
            map.put(company.getNumber(), receivers);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getCompanyDNFAttachmentMap(boolean isFromLocal) throws FileNotFoundException, IOException {
        File[] files = this.getUploadFiles(isFromLocal);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            int length = files[i].getName().length();
            try (FileInputStream fileInputStream = new FileInputStream(files[i]);){
                byte[] data = CSLIOUtils.toByteArray(fileInputStream);
                result.put(files[i].getName().substring(0, length - 4), data);
                continue;
            }
        }
        return result;
    }

    private void saveModels() {
        this.Model_Currencys.clear();
        CurrencyInfo currency = new CurrencyInfo();
        int currencyCount = this.tblCurrency.getRowCount();
        for (int i = 0; i < currencyCount; ++i) {
            IRow iRow = this.tblCurrency.getRow(i);
            if (Boolean.FALSE.equals(iRow.getCell("isSelect").getValue())) continue;
            currency = (CurrencyInfo)currency.clone();
            currency.setId(BOSUuid.read((String)iRow.getCell("id").getValue().toString()));
            currency.setName(iRow.getCell("name").getValue().toString());
            currency.setNumber(iRow.getCell("number").getValue().toString());
            this.Model_Currencys.add(currency);
        }
        this.Model_RelaCompanys.clear();
        OrgUnitInfo orgUnit = null;
        int orgCount = this.tblRelaCompany.getRowCount();
        for (int i = 0; i < orgCount; ++i) {
            orgUnit = (OrgUnitInfo)this.tblRelaCompany.getRow(i).getUserObject();
            this.Model_RelaCompanys.add(orgUnit);
        }
    }

    protected void resetExportCount() {
        this.ExportCount = 0;
    }

    protected int getExportCount() {
        return this.ExportCount;
    }

    protected void addStepExportCount() {
        ++this.ExportCount;
    }

    private ArrayList export(String exportDir) throws IOException {
        File dir;
        File defaultDir;
        if (DefaultDirectory.equalsIgnoreCase(exportDir) && (defaultDir = new File(DefaultDirectory)).exists()) {
            CSLIOUtils.deleteDirectory(defaultDir);
        }
        if (!(dir = new File(exportDir)).exists()) {
            dir.mkdirs();
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList templates = null;
        DNFFile dnf = null;
        String version = null;
        try {
            version = ClientVersionUtil.getCommonLibVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (OrgUnitInfo element : this.Model_Companys) {
            boolean flag;
            templates = (ArrayList)this.Model_Company_Templates.get(element.getId().toString());
            if (templates == null || templates.isEmpty()) continue;
            dnf = new DNFFile(element, templates, this.Model_Currencys, this.Model_RelaCompanys);
            dnf.setEASVersion(version);
            StringBuffer file = new StringBuffer(exportDir).append(System.getProperty("file.separator")).append(element.getNumber().trim()).append(".dnf");
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"34_CSLTemplateExportSelectUI");
            if (new File(file.toString()).exists() && MsgBox.showConfirm2((String)MessageFormat.format(msg, file)) != 0 || !(flag = dnf.export(file.toString(), DNFFile.getDNF_PASSWORD()))) continue;
            result.add(element.getName());
        }
        return result;
    }

    private void checkBeforeExport() {
        if (this.Model_Company_Templates.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURECE, (String)"CURRENT_COMPANY_NO_DATA"));
            SysUtil.abort();
        }
    }

    private boolean checkDirectoryName(String name) {
        if (name.matches(".*[\\>|\\<|\\||\\:|\\?|\\*|\\/|\\\\|\"].*")) {
            return false;
        }
        File file = new File(name);
        return file.isDirectory();
    }

    @Override
    protected void btnCompanyDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanyDelete_actionPerformed(e);
        this.deleteSelectRows(this.tblCompany);
        this.constructionTemplateModel();
        this.tblCompany_tableSelectChanged(null);
    }

    @Override
    protected void btnCompanyImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanyImport_actionPerformed(e);
        Object obj = null;
        obj = this.openCompanyF7();
        if (obj != null && obj instanceof Object[]) {
            this.bindingOrgUnitToTable(this.tblCompany, (OrgUnitInfo[])obj);
        }
        this.constructionTemplateModel();
        this.tblCompany_tableSelectChanged(null);
    }

    private void checkSchemeSelect(KDComboBox comb) {
        if (comb.getSelectedItem() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"345_CSLReportImportUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCompanySetDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySetDelete_actionPerformed(e);
        this.checkSchemeSelect(this.comboCompanySet);
        SchemeInfo selectInfo = (SchemeInfo)this.comboCompanySet.getSelectedItem();
        SchemeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(selectInfo.getId()));
        this.comboCompanySet.removeItem((Object)selectInfo);
        this.comboRelaCompanySet.removeItem((Object)selectInfo);
    }

    @Override
    protected void btnCompanySetSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySetSave_actionPerformed(e);
        String[] ids = this.getSelectCompanyIDList(this.tblCompany);
        if (this.openCompanySchemeEditUI(ids, this.CompanySelectSchemeID)) {
            this.handleRpc();
            this.refreshTargetCompanyScheme();
        }
    }

    private String[] getSelectCompanyIDList(KDTable table) {
        int tableCount = table.getRowCount();
        if (tableCount < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"344_CSLReportImportUI"));
            SysUtil.abort();
        }
        String[] ids = new String[tableCount];
        IRow iRow = null;
        OrgUnitInfo info = null;
        for (int i = 0; i < tableCount; ++i) {
            iRow = table.getRow(i);
            info = (OrgUnitInfo)iRow.getUserObject();
            ids[i] = info.getId().toString();
        }
        return ids;
    }

    private boolean openCompanySchemeEditUI(String[] compnayIDs, String selectSchemeID) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Scheme_AdapterType", (Object)CSLSchemeTypeEnum.EXPORTCOMPANY);
        uiContext.put((Object)"Scheme_AdapterObject", (Object)compnayIDs);
        uiContext.put((Object)"Scheme_SelectSchemeID", (Object)selectSchemeID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SchemeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        return ((SchemeEditUI)uiWindow.getUIObject()).isSuccess();
    }

    @Override
    protected void btnRelaCompanyDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnRelaCompanyDelete_actionPerformed(e);
        this.deleteSelectRows(this.tblRelaCompany);
    }

    @Override
    protected void btnRelaCompanyImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnRelaCompanyImport_actionPerformed(e);
        Object obj = null;
        obj = this.openCompanyF7();
        if (obj != null && obj instanceof Object[]) {
            this.bindingOrgUnitToTable(this.tblRelaCompany, (Object[])obj);
        }
    }

    @Override
    protected void btnRelaCompanySetDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnRelaCompanySetDelete_actionPerformed(e);
        this.checkSchemeSelect(this.comboRelaCompanySet);
        SchemeInfo selectInfo = (SchemeInfo)this.comboRelaCompanySet.getSelectedItem();
        SchemeFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(selectInfo.getId()));
        this.interCompanys.clear();
        this.comboRelaCompanySet.removeItem((Object)selectInfo);
        this.comboCompanySet.removeItem((Object)selectInfo);
    }

    @Override
    protected void btnRelaCompanySetSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnRelaCompanySetSave_actionPerformed(e);
        String[] ids = this.getSelectCompanyIDList(this.tblRelaCompany);
        if (this.openCompanySchemeEditUI(ids, this.CompanyRelaSelectSchemeID)) {
            this.handleRpc();
            this.refreshRelaCompanyScheme();
        }
    }

    @Override
    protected void btnTemplateDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnTemplateDelete_actionPerformed(e);
        this.deleteSelectRows(this.tblTemplateSource);
        this.constructionTemplateModel();
        this.tblCompany_tableSelectChanged(null);
    }

    @Override
    protected void btnTemplateImport_actionPerformed(ActionEvent e) throws Exception {
        super.btnTemplateImport_actionPerformed(e);
        Object obj = null;
        this.removesTemplates.clear();
        ArrayList<Object> addTemplates = new ArrayList<Object>();
        obj = this.openTemplateF7();
        if (obj != null && obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            for (int i = 0; i < objs.length; ++i) {
                if (CSLImportUtility.checkDuplicate(this.Model_SourceTemplates, new IEqualable(){

                    @Override
                    public boolean isEqual(Object obj1, Object obj2) {
                        TemplateInfo info1 = (TemplateInfo)obj1;
                        TemplateInfo info2 = (TemplateInfo)obj2;
                        boolean equals = info1.getId().toString().equals(info2.getId().toString());
                        if (!equals && info1.getGroup().equals(info2.getGroup())) {
                            String id = "";
                            for (int i = 0; i < CSLTemplateExportSelectUI.this.tblTemplateSource.getRowCount(); ++i) {
                                id = CSLTemplateExportSelectUI.this.tblTemplateSource.getRow(i).getCell("id").getValue().toString();
                                if (!id.equals(((TemplateInfo)obj1).getId().toString())) continue;
                                CSLTemplateExportSelectUI.this.tblTemplateSource.checkParsed();
                                CSLTemplateExportSelectUI.this.tblTemplateSource.removeRow(i);
                                break;
                            }
                            CSLTemplateExportSelectUI.this.removesTemplates.add(obj1);
                        }
                        return equals;
                    }
                }, objs[i])) continue;
                this.Model_SourceTemplates.add(objs[i]);
                addTemplates.add(objs[i]);
            }
            if (this.removesTemplates.size() > 0) {
                this.Model_SourceTemplates.removeAll(this.removesTemplates);
            }
            this.buildK3TemplateInfo(objs);
            this.bindingTemplateToTable(this.tblTemplateSource, addTemplates);
            this.constructionTemplateModel();
            this.tblCompany_tableSelectChanged(null);
        } else {
            this.constructionTemplateModel();
        }
    }

    private void buildK3TemplateInfo(Object[] obj) throws BOSException, EASBizException {
        this.getCSLK3TemplateFactory();
        for (int i = 0; i < obj.length; ++i) {
            TemplateInfo info = (TemplateInfo)obj[i];
            if (!this.iCSLK3Template.exists("where sourceTemplate.id = '" + info.getId() + "'")) continue;
            info.setData(((CSLK3TemplateInfo)this.iCSLK3Template.getValue("where sourceTemplate.id = '" + info.getId() + "'")).getData());
        }
    }

    private ICSLK3Template getCSLK3TemplateFactory() throws BOSException {
        if (this.iCSLK3Template == null) {
            this.iCSLK3Template = CSLK3TemplateFactory.getRemoteInstance();
        }
        return this.iCSLK3Template;
    }

    @Override
    protected void tblCompany_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblCompany_tableSelectChanged(e);
        if (this.tblTemplateTarget.getRowCount() > 0) {
            this.tblTemplateTarget.removeRows();
        }
        if (this.tblCompany.getSelectManager().size() > 0) {
            int row = this.tblCompany.getSelectManager().get().getBeginRow();
            if (row == -1) {
                return;
            }
            String companyId = (String)this.tblCompany.getRow(row).getCell("id").getValue();
            List templates = (List)this.Model_Company_Templates.get(companyId);
            this.bindingTemplateToTable(this.tblTemplateTarget, templates);
        }
    }

    @Override
    protected void comboCompanySet_actionPerformed(ActionEvent e) throws Exception {
        super.comboCompanySet_actionPerformed(e);
        this.tblCompany.removeRows();
        this.Model_Companys.clear();
        SchemeInfo scheme = (SchemeInfo)((KDComboBox)e.getSource()).getModel().getSelectedItem();
        if (scheme != null) {
            this.importScheme(this.tblCompany, scheme);
            this.constructionTemplateModel();
            this.tblCompany_tableSelectChanged(null);
        }
    }

    private void importScheme(KDTable table, SchemeInfo scheme) throws DocumentException, IOException, BOSException, EASBizException {
        Object[] ids = (Object[])scheme.getAdapterObject(CSLSchemeTypeEnum.EXPORTCOMPANY);
        String str = StringUtils.arrayToString((Object[])ids, (String)",");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str, CompareType.INCLUDE));
        EntityViewInfo entityInfo = new EntityViewInfo();
        entityInfo.setFilter(filter);
        entityInfo.getSelector().add(new SelectorItemInfo("id"));
        entityInfo.getSelector().add(new SelectorItemInfo("name"));
        entityInfo.getSelector().add(new SelectorItemInfo("number"));
        entityInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(entityInfo);
        this.bindingOrgUnitToTable(table, companys.toArray());
    }

    @Override
    protected void comboRelaCompanySet_actionPerformed(ActionEvent e) throws Exception {
        super.comboRelaCompanySet_actionPerformed(e);
        this.tblRelaCompany.removeRows();
        SchemeInfo scheme = (SchemeInfo)((KDComboBox)e.getSource()).getModel().getSelectedItem();
        if (scheme != null) {
            this.interCompanys.clear();
            this.importScheme(this.tblRelaCompany, scheme);
        }
    }

    private Object openTemplateF7() {
        Frame frame = (Frame)Util.getComponent((Component)((Object)this), (String)UINewFrame.class.getName());
        KDCommonPromptDialog dialog = new KDCommonPromptDialog(frame, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"414_CSLTemplateExportSelectUI"));
        QueryInfo queryInfo = Util.getQueryInfo((String)"com.kingdee.eas.fi.gr.cslrpt.CSLTemplateExportQuery");
        dialog.setQueryInfo(queryInfo);
        dialog.setEnabledMultiSelection(true);
        dialog.show();
        Object obj = dialog.getData();
        if (obj instanceof Object[] && ((Object[])obj).length != 0) {
            return obj;
        }
        return null;
    }

    private Object openCompanyF7() {
        this.companyF7.show();
        Object obj = this.companyF7.getData();
        if (obj instanceof Object[] && ((Object[])obj).length != 0) {
            return obj;
        }
        return null;
    }

    private void initalRelaCompanyTable() throws Exception {
        DefaultTreeModel model = CslOrgTreeUtil.getCompanyF7TreeModel();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)model.getRoot();
        DefaultKingdeeTreeNode curNode = null;
        FullOrgUnitInfo curOrgUnit = null;
        HashSet<BOSUuid> orgSet = new HashSet<BOSUuid>();
        Enumeration e = rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            curNode = (DefaultKingdeeTreeNode)e.nextElement();
            curOrgUnit = this.getOrgUnitInfo(curNode);
            if (curOrgUnit == null) continue;
            orgSet.add(curOrgUnit.getId());
        }
        if (!orgSet.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
            EntityViewInfo entityInfo = new EntityViewInfo();
            entityInfo.setFilter(filter);
            entityInfo.getSelector().add(new SelectorItemInfo("id"));
            entityInfo.getSelector().add(new SelectorItemInfo("name"));
            entityInfo.getSelector().add(new SelectorItemInfo("number"));
            entityInfo.getSelector().add(new SelectorItemInfo("longNumber"));
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(entityInfo);
            if (this.tblRelaCompany.getRowCount() == 0) {
                this.interCompanys.clear();
            }
            this.bindingOrgUnitToTable(this.tblRelaCompany, companys.toArray());
        }
    }

    private FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode treeNode) {
        Object obj = null;
        FullOrgUnitInfo orgUnit = null;
        if (treeNode != null && (obj = treeNode.getUserObject()) != null && obj instanceof OrgStructureInfo) {
            orgUnit = ((OrgStructureInfo)obj).getUnit();
        }
        return orgUnit;
    }

    private void initialCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        f7.setMultiSelect(true);
        f7.setNeedAddOrgRange(false);
        this.companyF7 = f7;
    }

    private void bindingOrgUnitToTable(KDTable table, Object[] obj) throws EASBizException, BOSException {
        block3: {
            IRow iRow;
            block2: {
                table.checkParsed();
                iRow = null;
                if (table != this.tblRelaCompany) break block2;
                for (int i = 0; i < obj.length; ++i) {
                    OrgUnitInfo info = (OrgUnitInfo)obj[i];
                    if (CSLImportUtility.checkDuplicate(this.interCompanys, new IEqualable(){

                        @Override
                        public boolean isEqual(Object obj1, Object obj2) {
                            OrgUnitInfo info1 = (OrgUnitInfo)obj1;
                            OrgUnitInfo info2 = (OrgUnitInfo)obj2;
                            return info1.getLongNumber().trim().equalsIgnoreCase(info2.getLongNumber().trim());
                        }
                    }, info)) continue;
                    iRow = table.addRow();
                    iRow.setUserObject((Object)info);
                    iRow.getCell("id").setValue((Object)info.getId().toString());
                    iRow.getCell("number").setValue((Object)info.getNumber());
                    iRow.getCell("name_l1").setValue((Object)info.getName(LocaleUtils.getLocale((String)"L1")));
                    iRow.getCell("name_l2").setValue((Object)info.getName(LocaleUtils.getLocale((String)"L2")));
                    iRow.getCell("name_l3").setValue((Object)info.getName(LocaleUtils.getLocale((String)"L3")));
                    this.interCompanys.add(info);
                }
                break block3;
            }
            if (table != this.tblCompany) break block3;
            for (int i = 0; i < obj.length; ++i) {
                OrgUnitInfo info = (OrgUnitInfo)obj[i];
                if (CSLImportUtility.checkDuplicate(this.Model_Companys, new IEqualable(){

                    @Override
                    public boolean isEqual(Object obj1, Object obj2) {
                        OrgUnitInfo info1 = (OrgUnitInfo)obj1;
                        OrgUnitInfo info2 = (OrgUnitInfo)obj2;
                        return info1.getLongNumber().equalsIgnoreCase(info2.getLongNumber());
                    }
                }, info)) continue;
                iRow = table.addRow();
                iRow.setUserObject((Object)info);
                iRow.getCell("id").setValue((Object)info.getId().toString());
                iRow.getCell("number").setValue((Object)info.getNumber());
                iRow.getCell("name").setValue((Object)info.getName());
                this.Model_Companys.add(info);
            }
        }
    }

    private void constructionTemplateModel() throws BOSException, EASBizException {
        this.Model_Company_Templates.clear();
        if (this.Model_SourceTemplates.size() == 0 || this.Model_Companys.size() == 0) {
            return;
        }
        TempletDispenseCollection col = null;
        RptSheetParamCollection paraCol = null;
        ArrayList<TemplateInfo> value = null;
        ITempletDispense itd = TempletDispenseFactory.getRemoteInstance();
        IRptSheetParam iRSP = RptSheetParamFactory.getRemoteInstance();
        for (OrgUnitInfo orgUnit : this.Model_Companys) {
            Iterator iterator = this.Model_SourceTemplates.iterator();
            while (iterator.hasNext()) {
                TemplateInfo element = (TemplateInfo)((TemplateInfo)iterator.next()).clone();
                col = itd.getTempletDispenseCollection("where company.id = '" + orgUnit.getId().toString() + "' and dispenseSrcID = '" + element.getId().toString() + "' ");
                if (col == null || col.size() == 0) continue;
                value = (ArrayList<TemplateInfo>)this.Model_Company_Templates.get(orgUnit.getId().toString());
                if (value == null) {
                    value = new ArrayList<TemplateInfo>();
                    this.Model_Company_Templates.put(orgUnit.getId().toString(), value);
                }
                element.put("CSL_PROPERTY_ISALLOWCHANGE", (Object)col.get(0).isIsAllowChgTemplet());
                paraCol = iRSP.getRptSheetParamCollection("where report = '" + element.getId().toString() + "'");
                if (paraCol != null && paraCol.size() != 0) {
                    element.getSheetParam().addCollection(paraCol);
                }
                value.add(element);
            }
        }
    }

    private void bindingTemplateToTable(KDTable table, List templates) throws EASBizException, BOSException {
        if (templates == null || templates.isEmpty()) {
            return;
        }
        table.checkParsed();
        IRow iRow = null;
        for (TemplateInfo info : templates) {
            iRow = table.addRow();
            iRow.setUserObject((Object)info);
            iRow.getCell("id").setValue((Object)info.getId().toString());
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("name").setValue((Object)info.getName());
            iRow.getCell("versionNumber").setValue((Object)info.getVersionNumber());
            iRow.getCell("periodType").setValue((Object)info.getPeriodType());
            iRow.getCell("templateType").setValue((Object)info.getTemplateType());
            iRow.getCell("isIncludeOtherDC").setValue((Object)new Boolean(info.isIncludeOtherDC()));
        }
        table.getColumn("isIncludeOtherDC").getStyleAttributes().setLocked(true);
    }

    private void checkSelected(KDTable table) {
        if (table.getSelectManager().size() == 0 || table.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private ArrayList getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex;
                if (j == -1 || list.contains(tempIndex = new Integer(j))) continue;
                list.add(tempIndex);
            }
        }
        return list;
    }

    private void deleteSelectRows(KDTable table) throws EASBizException, BOSException {
        this.checkSelected(table);
        ArrayList list = this.getSelectedRows(table);
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            this.deleteCacheModel(table, (Integer)index[i - 1]);
            table.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    private void deleteCacheModel(KDTable table, int i) throws EASBizException, BOSException {
        Object obj = table.getRow(i).getUserObject();
        if (table == this.tblTemplateSource) {
            this.Model_SourceTemplates.remove(obj);
            this.delectTargetTableRow(obj);
        }
        if (table == this.tblCompany) {
            this.Model_Companys.remove(obj);
            this.Model_Company_Templates.remove(obj);
        }
        if (table == this.tblRelaCompany) {
            this.interCompanys.remove(obj);
        }
    }

    private void delectTargetTableRow(Object obj) {
        int rowCount = this.tblTemplateTarget.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.tblTemplateTarget.getRow(i);
            if (!obj.equals(iRow.getUserObject())) continue;
            this.tblTemplateTarget.removeRow(i);
            return;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initialControl();
        this.initialCompanyF7();
        this.refreshCurrency();
        this.handleRpc();
        this.refreshTargetCompanyScheme();
        this.refreshRelaCompanyScheme();
        this.initalRelaCompanyTable();
        this.initialExportConfig();
        this.loadLastedConfig();
    }

    private void handleRpc() throws EASBizException, BOSException {
        if (this.msgMng == null) {
            this.msgMng = new MessagePostManManager("CSLTEMPLATEEXPORTEXPORTSELECTUI");
        }
        this.msgMng.addMessage(new MessagePostMan("refreshTargetCompanyScheme", "where type = 1"));
        this.msgMng.addMessage(new MessagePostMan("loadLastedConfig", "where type = 2 and number = '" + CSLUploadConfigUI.class.getName() + "' "));
        this.msgMng = RpcHandleFacadeFactory.getRemoteInstance().getRpcZipData(this.msgMng);
    }

    private void refreshCurrency() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"GLC", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"GRC", CompareType.NOTEQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        this.setDataObject((IObjectValue)viewInfo);
    }

    private void initialExportConfig() {
        this.ExportConfigMap.put(EXPORTCONFIG_FTP_FROMLOCAL, Boolean.FALSE);
        this.ExportConfigMap.put(EXPORTCONFIG_MAIL_FROMLOCAL, Boolean.FALSE);
    }

    private void initialControl() throws BOSException {
        this.btnExportFile.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExportFTP.setIcon(EASResource.getIcon((String)"imgTbtn_impress"));
        this.btnExportMAIL.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.btnConfig.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnCompanySetSave.setText(null);
        this.btnCompanySetDelete.setText(null);
        this.btnRelaCompanySetSave.setText(null);
        this.btnRelaCompanySetDelete.setText(null);
        this.btnCompanySetSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCompanySetDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRelaCompanySetSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRelaCompanySetDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.tblCompany.getSelectManager().setSelectMode(10);
        this.tblRelaCompany.getSelectManager().setSelectMode(10);
        this.tblTemplateSource.getSelectManager().setSelectMode(10);
        this.tblTemplateTarget.getSelectManager().setSelectMode(10);
        this.tblCurrency.getSelectManager().setSelectMode(10);
    }

    private void refreshTargetCompanyScheme() throws BOSException {
        SchemeCollection schemes = (SchemeCollection)((Object)this.msgMng.getItemValue("refreshTargetCompanyScheme"));
        this.comboCompanySet.removeAllItems();
        this.comboCompanySet.addItems(schemes.toArray());
        this.comboCompanySet.getModel().setSelectedItem(null);
        if (!StringUtils.isEmpty((String)this.CompanySelectSchemeID)) {
            Iterator iter = schemes.iterator();
            while (iter.hasNext()) {
                SchemeInfo element = (SchemeInfo)iter.next();
                if (!this.CompanySelectSchemeID.equals(element.getNumber())) continue;
                this.comboCompanySet.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    private void refreshRelaCompanyScheme() throws BOSException {
        SchemeCollection schemes = (SchemeCollection)((Object)this.msgMng.getItemValue("refreshTargetCompanyScheme"));
        this.comboRelaCompanySet.removeAllItems();
        this.comboRelaCompanySet.addItems(schemes.toArray());
        this.comboRelaCompanySet.getModel().setSelectedItem(null);
        if (!StringUtils.isEmpty((String)this.CompanyRelaSelectSchemeID)) {
            Iterator iter = schemes.iterator();
            while (iter.hasNext()) {
                SchemeInfo element = (SchemeInfo)iter.next();
                if (!this.CompanyRelaSelectSchemeID.equals(element.getNumber())) continue;
                this.comboRelaCompanySet.getModel().setSelectedItem(element);
                break;
            }
        }
    }

    class ExportThread
    extends Thread {
        private DNFFile dnf = null;
        private String file = null;

        public ExportThread(DNFFile dnf, String file) {
            this.dnf = dnf;
            this.file = file;
        }

        @Override
        public void run() {
            boolean flag = this.dnf.export(this.file, DNFFile.getDNF_PASSWORD());
            if (flag) {
                CSLTemplateExportSelectUI.this.addStepExportCount();
                CSLTemplateExportSelectUI.this.setMessageText(this.file + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"413_CSLTemplateExportSelectUI"));
                CSLTemplateExportSelectUI.this.showMessage();
            }
        }
    }
}

