/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCaliAdjustFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class CaliAdjustFilterUI
extends AbstractCaliAdjustFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CaliAdjustFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IAdjustMode iAdjustMode = null;
    private ICSLContext ctx = null;

    public CaliAdjustFilterUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.ctx = CSLContextHelper.getCSLContext();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.cbxPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.cbxPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
        this.cbxPeriodType.setEnabled(false);
        this.cbxAdjustMode.addItem((Object)this.selectAll);
        this.cbxAdjustMode.setSelectedIndex(0);
        this.cbxCurrency.addItem((Object)this.selectAll);
        this.cbxCurrency.setSelectedIndex(0);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0);
        CurrencyCollection currencyCollection = null;
        AdjustModeCollection adjustModeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            if (this.iAdjustMode == null) {
                this.iAdjustMode = AdjustModeFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(true);
            adjustModeCollection = this.iAdjustMode.getAdjustModeCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cbxCurrency.addItem((Object)currencyCollection.get(i));
                this.cbxSourceCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        if (adjustModeCollection != null && adjustModeCollection.size() > 0) {
            for (int i = 0; i < adjustModeCollection.size(); ++i) {
                this.cbxAdjustMode.addItem((Object)adjustModeCollection.get(i));
            }
        }
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            f7.setMultiSelect(false);
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            MergeModeEnum mergeType = CslRptUtil.getMergeMode(CSLContextHelper.getCSLContext().getCurOrgBound());
            if (MergeModeEnum.ORDINAL.equals((Object)mergeType)) {
                f7.filterUnitSql(UnionF7Helper.getMergeModeOrgUnitIDSql((String)this.ctx.getCurOrgBound().getId().toString(), (String)this.ctx.getCurOrgGroup().getId().toString(), (MergeModeEnum)mergeType));
            }
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setSupportedEmpty(true);
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        try {
            FilterItemInfo filterItem0 = new FilterItemInfo("orgBound.id", (Object)this.ctx.getCurOrgBound().getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
            FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)new Integer(this.ctx.getCurRptYear()), CompareType.EQUALS);
            FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)new Integer(this.ctx.getCurRptPeriod()), CompareType.EQUALS);
            String dataCollectNumber = this.ctx.getCurDataCollect().getNumber();
            if (dataCollectNumber == null || dataCollectNumber.length() == 0) {
                dataCollectNumber = "ACTUALDATA";
            }
            FilterItemInfo filterItem4 = new FilterItemInfo("dataCollect.number", (Object)dataCollectNumber, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem1);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem3);
            sbFormula.append(" and #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(filterItem4);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.cbxAdjustMode.getSelectedItem() != null && !this.cbxAdjustMode.getSelectedItem().equals(this.selectAll)) {
            String adjustModeId = ((AdjustModeInfo)this.cbxAdjustMode.getSelectedItem()).getId().toString();
            FilterItemInfo filterItemAdjustMode = new FilterItemInfo("adjustMode.id", (Object)adjustModeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemAdjustMode);
            sbFormula.append(" and #" + formulaIndex++);
        }
        try {
            OrgUnitInfo uif;
            if (this.bizPrmtCompany.getData() != null) {
                uif = (OrgUnitInfo)this.bizPrmtCompany.getData();
                String companyId = uif.getId().toString();
                FilterItemInfo filterItemCompany = new FilterItemInfo("orgUnit.id", (Object)companyId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCompany);
                sbFormula.append("  and  #" + formulaIndex++);
            } else {
                uif = this.ctx.getCurOrgGroup();
                String number = CslRptUIUtil.getCompanyStructureNumber(this.ctx.getCurOrgBound(), uif);
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%"), CompareType.LIKE));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)number, CompareType.EQUALS));
                int mergeMode = CslRptUtil.getMergeMode(this.ctx.getCurOrgBound()).getValue();
                if (1 == mergeMode) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("structure.longNumber", (Object)(number + "!%!%"), CompareType.NOTLIKE));
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ")  and #" + formulaIndex++);
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
                }
            }
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        try {
            this.cbxPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.cbxAdjustMode.setSelectedItem((Object)this.selectAll);
        this.bizPrmtCompany.setData(null);
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.cbxCurrency.setSelectedItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block6: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            String currencyId;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                try {
                    this.cbxPeriodType.setSelectedItem((Object)this.ctx.getCurRptPeriodType());
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                this.cbxPeriodType.setEnabled(false);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("adjustMode.id")) {
                String adjustModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxAdjustMode.getItemCount(); ++j) {
                    AdjustModeInfo adjustModeInfo = (AdjustModeInfo)this.cbxAdjustMode.getItemAt(j);
                    if (!adjustModeInfo.getId().toString().equals(adjustModeId)) continue;
                    this.cbxAdjustMode.setSelectedIndex(j);
                    continue block6;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block6;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j);
                    continue block6;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit.id")) {
                String companyId = (String)filterItemInfo.getCompareValue();
                try {
                    OrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.bizPrmtCompany.setData((Object)companyInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) continue;
            BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
            if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                this.txtCreditFrom.setValue((Object)credit);
                continue;
            }
            this.txtCreditTo.setValue((Object)credit);
        }
    }
}

