/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICheckFormula;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemCheckFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCheckFormulaUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;

public class CheckFormulaUI
extends AbstractCheckFormulaUI
implements ICSLContextUI {
    private ICurrency iCurrency = null;
    private IRPTItemCheckFormula iCheckFormula = null;
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes";
    private Boolean select = true;
    private Boolean unSelect = false;
    private ICheckFormula iCheck = null;

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            this.initWorkButton();
            CSLContextHelper.registUIObject(this);
            this.tblCompany.checkParsed();
            this.tblCurrency.checkParsed();
            this.tblCheckFormula.checkParsed();
            this.addCurrencyToTable(this.getCurrencyCollection(), this.tblCurrency);
            this.addCheckFormulaToTable(this.getCheckFormulaCollection(), this.tblCheckFormula);
        } else {
            SysUtil.abort();
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return pk;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectCompany.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnSelectAllCurrency.setText(null);
        this.btnClearCurrency.setText(null);
        this.btnSelectAllCurrency.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearCurrency.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAllCheckFormula.setText(null);
        this.btnClearCheckFormula.setText(null);
        this.btnSelectAllCheckFormula.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearCheckFormula.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private RPTItemCheckFormulaCollection getCheckFormulaCollection() throws BOSException {
        if (this.iCheckFormula == null) {
            this.iCheckFormula = RPTItemCheckFormulaFactory.getRemoteInstance();
        }
        EntityViewInfo view = new EntityViewInfo();
        return this.iCheckFormula.getRPTItemCheckFormulaCollection(view);
    }

    private CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        if (this.iCurrency == null) {
            this.iCurrency = CurrencyFactory.getRemoteInstance();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        return this.iCurrency.getCurrencyCollection(viewInfo, true);
    }

    private void addCurrencyToTable(CurrencyCollection currencys, KDTable table) {
        table.removeRows();
        if (currencys != null) {
            int count = currencys.size();
            for (int i = 0; i < count; ++i) {
                CurrencyInfo currency = currencys.get(i);
                IRow r = table.addRow();
                r.getCell(0).setValue((Object)currency.getId());
                r.getCell(1).setValue((Object)this.unSelect);
                r.getCell(2).setValue((Object)currency.getNumber());
                r.getCell(3).setValue((Object)currency.getName());
                r.getCell(4).setValue((Object)currency);
            }
        }
    }

    private void addCheckFormulaToTable(RPTItemCheckFormulaCollection formulas, KDTable table) {
        table.removeRows();
        if (formulas != null) {
            int count = formulas.size();
            for (int i = 0; i < count; ++i) {
                RPTItemCheckFormulaInfo formula = formulas.get(i);
                IRow r = table.addRow();
                r.getCell(0).setValue((Object)formula.getId());
                r.getCell(1).setValue((Object)this.unSelect);
                r.getCell(2).setValue((Object)formula.getNumber());
                r.getCell(3).setValue((Object)formula.getName());
                r.getCell(4).setValue((Object)formula.getLFormula());
                r.getCell(5).setValue((Object)formula.getOperateSymbol());
                r.getCell(6).setValue((Object)formula.getRFormula());
                r.getCell(7).setValue((Object)formula);
            }
        }
    }

    @Override
    public void actionSelectAllCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllCurrency_actionPerformed(e);
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            IRow row = this.tblCurrency.getRow(i);
            row.getCell(1).setValue((Object)this.select);
        }
    }

    @Override
    public void actionClearCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearCurrency_actionPerformed(e);
        for (int i = 0; i < this.tblCurrency.getRowCount(); ++i) {
            IRow row = this.tblCurrency.getRow(i);
            row.getCell(1).setValue((Object)this.unSelect);
        }
    }

    @Override
    public void actionSelectAllCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllCheckFormula_actionPerformed(e);
        for (int j = 0; j < this.tblCheckFormula.getRowCount(); ++j) {
            IRow row = this.tblCheckFormula.getRow(j);
            row.getCell(1).setValue((Object)this.select);
        }
    }

    @Override
    public void actionClearCheckFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearCheckFormula_actionPerformed(e);
        for (int j = 0; j < this.tblCheckFormula.getRowCount(); ++j) {
            IRow row = this.tblCheckFormula.getRow(j);
            row.getCell(1).setValue((Object)this.unSelect);
        }
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectCompany_actionPerformed(e);
        Object[] orgArray = CslRptUIUtil.showOrgUnitSubTree((IUIObject)this, this.ctx.getCurOrgBound(), this.ctx.getCurOrgGroup(), 3, true);
        if (orgArray == null) {
            return;
        }
        this.tblCompany.removeRows();
        int count = orgArray.length;
        for (int i = 0; i < count; ++i) {
            OrgUnitInfo company = (OrgUnitInfo)orgArray[i];
            IRow row = this.tblCompany.addRow();
            row.getCell(0).setValue((Object)company.getId());
            row.getCell(1).setValue((Object)company.getNumber());
            row.getCell(2).setValue((Object)company.getName());
            row.getCell(3).setValue((Object)company);
        }
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect;
        IRow row;
        int i;
        super.actionCheck_actionPerformed(e);
        ArrayList<String> currencyCollection = new ArrayList<String>();
        ArrayList<String> checkFormulaCollection = new ArrayList<String>();
        ArrayList<String> orgUnitCollection = new ArrayList<String>();
        if (this.tblCompany.getRowCount() == 0) {
            String resName1 = "Select_OrgUnit";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName1));
            return;
        }
        int n = this.tblCompany.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.tblCompany.getRow(i);
            orgUnitCollection.add(row.getCell(0).getValue().toString());
        }
        n = this.tblCurrency.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.tblCurrency.getRow(i);
            isSelect = (Boolean)row.getCell(1).getValue();
            if (!isSelect) continue;
            currencyCollection.add(row.getCell(0).getValue().toString());
        }
        if (currencyCollection.size() == 0) {
            String resName2 = "Select_Currency";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName2));
            return;
        }
        n = this.tblCheckFormula.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.tblCheckFormula.getRow(i);
            isSelect = (Boolean)row.getCell(1).getValue();
            if (!isSelect) continue;
            checkFormulaCollection.add(row.getCell(0).getValue().toString());
        }
        if (checkFormulaCollection.size() == 0) {
            String resName3 = "Select_CheckFormula";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)resName3));
            return;
        }
        if (this.iCheck == null) {
            this.iCheck = CheckFormulaFactory.getRemoteInstance();
        }
        String result = "";
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"String", (Object)result);
        IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getResultUIName(), (Map)uiContext, null);
        uiWindow1.show();
    }

    private String getResultUIName() {
        return SimpleNotePad.class.getName();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public boolean destroyWindow() {
        CSLContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }
}

