/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CopyCSLHisDataRecordStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CopyCSLHisDataReportStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CopyCSLHisDataResultStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCopyCSLHisDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CopyCSLHisDataFilterCondition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CopyCSLHisDataFilterUI
extends AbstractCopyCSLHisDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CopyCSLHisDataFilterUI.class);
    private ICSLContext ctx = null;
    private RptPeriodTypeEnum curRptPeriodType = null;
    private CurrencyInfo currencyInfo = null;
    private List yearAndPeriod = null;
    private CopyCSLHisDataFilterCondition condition = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isSupport13Period = false;
    private PeriodCollection periods = null;

    public CopyCSLHisDataFilterUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.ctx = CSLContextHelper.getCSLContext();
        this.repDate.setEditable(false);
        this.curRptPeriodType = this.ctx.getCurRptPeriodType();
        int curRptYear = this.ctx.getCurRptYear();
        int curRptPeriod = this.ctx.getCurRptPeriod();
        boolean[] param = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = param[0];
        this.isSupport13Period = param[1];
        this.periods = this.isMergeByFiscalPeriod ? FiscalPeriodHelper.getPeriodCollection(null, this.ctx.getCurOrgBound()) : null;
        this.yearAndPeriod = FiscalPeriodHelper.getRptYearAndPeriodAndDate(this.periods, curRptYear, curRptPeriod, this.curRptPeriodType.getValue(), 0, -1, this.isMergeByFiscalPeriod);
        if (this.isMergeByFiscalPeriod && this.curRptPeriodType.getValue() != 1 && this.curRptPeriodType.getValue() != 2) {
            this.spYear.setEnabled(true);
            this.spPeriod.setEnabled(true);
            this.repDate.setEnabled(false);
            FiscalPeriodHelper.setYearSpineRange(this.periods, this.spYear, false);
            FiscalPeriodHelper.setPeriodSpineRange(this.periods, (Integer)this.yearAndPeriod.get(0), this.curRptPeriodType, this.spPeriod, false, this.isMergeByFiscalPeriod);
            this.initListeners();
        } else {
            this.spYear.setEnabled(false);
            this.spPeriod.setEnabled(false);
            this.repDate.setEnabled(true);
        }
        CslClientHelper.initCurrencyToCombox((JComboBox)this.cbxCurrency, true, false);
        this.currencyInfo = (CurrencyInfo)this.cbxCurrency.getSelectedItem();
        this.cbxReportStatus.addItems(CopyCSLHisDataReportStatusEnum.getEnumList().toArray());
        this.cbxRecordStatus.addItems(CopyCSLHisDataRecordStatusEnum.getEnumList().toArray());
        this.cbxResultStatus.addItems(CopyCSLHisDataResultStatusEnum.getEnumList().toArray());
        this.initUI();
        this.condition = new CopyCSLHisDataFilterCondition();
        this.condition.setPeriodType(this.curRptPeriodType);
        this.condition.setMergeMode(CslRptUtil.getMergeMode(this.ctx.getCurOrgBound()));
        this.condition.setCurrentYear(this.ctx.getCurRptYear());
        this.condition.setCurrentPeriod(this.ctx.getCurRptPeriod());
        this.condition.setCurrentTreeInfo(this.ctx.getCurOrgBound());
        this.condition.setCurrentOrgUnitInfo(this.ctx.getCurOrgGroup());
        this.condition.setDataCollectInfo(this.ctx.getCurDataCollect());
    }

    private void initListeners() {
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CopyCSLHisDataFilterUI.this.setDate();
            }
        });
        this.spPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CopyCSLHisDataFilterUI.this.setDate();
            }
        });
    }

    private void setDate() {
        try {
            Date date = FiscalPeriodHelper.getRptDate(this.periods, (int)((Integer)this.spYear.getValue()), (int)((Integer)this.spPeriod.getValue()), this.curRptPeriodType, this.isMergeByFiscalPeriod);
            this.repDate.setValue((Object)date, false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.curRptPeriodType.getValue())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("repDate", this.repDate.getValue()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("year", this.spYear.getValue()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("period", this.spPeriod.getValue()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("currentyId", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("reportStatus", (Object)new Integer(((CopyCSLHisDataReportStatusEnum)((Object)this.cbxReportStatus.getSelectedItem())).getValue())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("recordStatus", (Object)new Integer(((CopyCSLHisDataRecordStatusEnum)((Object)this.cbxRecordStatus.getSelectedItem())).getValue())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("resultStatus", (Object)new Integer(((CopyCSLHisDataResultStatusEnum)((Object)this.cbxResultStatus.getSelectedItem())).getValue())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckGroupRpt", (Object)new Boolean(this.chkGroupRpt.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckSumRpt", (Object)new Boolean(this.chkSumRpt.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckAdjust", (Object)new Boolean(this.chkAdjust.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckElimination", (Object)new Boolean(this.chkElimination.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckMnsRpt", (Object)new Boolean(this.chkMnsRpt.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckCslRpt", (Object)new Boolean(this.chkCslRpt.isSelected())));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCheckAllOrgUnit", (Object)new Boolean(this.chkAllOrgUnit.isSelected())));
        StringBuffer maskString = new StringBuffer();
        int size = this.filterInfo.getFilterItems().size();
        for (int index = 0; index < size; ++index) {
            maskString.append("#").append(index);
            if (index + 1 == size) continue;
            maskString.append(" and ");
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public CopyCSLHisDataFilterCondition getFilterCondition() {
        this.condition.setYear((Integer)this.spYear.getValue());
        this.condition.setPeriod((Integer)this.spPeriod.getValue());
        this.condition.setCurrentyId(((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
        this.condition.setReportStatus((CopyCSLHisDataReportStatusEnum)((Object)this.cbxReportStatus.getSelectedItem()));
        this.condition.setRecordStatus((CopyCSLHisDataRecordStatusEnum)((Object)this.cbxRecordStatus.getSelectedItem()));
        this.condition.setResultStatus((CopyCSLHisDataResultStatusEnum)((Object)this.cbxResultStatus.getSelectedItem()));
        this.condition.setCheckGroupRpt(this.chkGroupRpt.isSelected());
        this.condition.setCheckSumRpt(this.chkSumRpt.isSelected());
        this.condition.setCheckAdjust(this.chkAdjust.isSelected());
        this.condition.setCheckElimination(this.chkElimination.isSelected());
        this.condition.setCheckMnsRpt(this.chkMnsRpt.isSelected());
        this.condition.setCheckCslRpt(this.chkCslRpt.isSelected());
        this.condition.setCheckAllOrgUnit(this.chkAllOrgUnit.isSelected());
        try {
            String orgTreeId = "";
            if (this.repDate.getTimestamp() != null) {
                orgTreeId = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(this.ctx.getCurOrgBound().getNumber(), this.repDate.getTimestamp());
            }
            String structureLongNumber = "";
            structureLongNumber = StringUtils.isEmpty((String)orgTreeId) || orgTreeId.equals(this.ctx.getCurOrgBound().getId().toString()) ? CslRptUIUtil.getCompanyStructureNumber(this.ctx.getCurOrgBound(), this.ctx.getCurOrgGroup()) : CslRptUIUtil.getLongNumberByTreeAndUnit(orgTreeId, this.ctx.getCurOrgBound(), this.ctx.getCurOrgGroup());
            this.condition.setFromOrgTreeId(orgTreeId);
            this.condition.setStructureLongNumber(structureLongNumber);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        return this.condition;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        int size = currentFilterItemCollection.size();
        block0: for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            if (propertyName.equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                if (periodType.intValue() == this.curRptPeriodType.getValue()) continue;
                MsgBox.showWarning((String)CslRptUtil.getStringWithFormat("com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", "85copyCSLHisDataFilterUI", new String[]{RptPeriodTypeEnum.getEnum((int)periodType).getAlias()}));
                this.clear();
                return;
            }
            if (propertyName.equalsIgnoreCase("repDate")) {
                this.repDate.setValue((Object)((Date)filterItemInfo.getCompareValue()), false);
                continue;
            }
            if (propertyName.equalsIgnoreCase("year")) {
                this.spYear.setValue((Object)((Integer)filterItemInfo.getCompareValue()), false);
                continue;
            }
            if (propertyName.equalsIgnoreCase("period")) {
                this.spPeriod.setValue((Object)((Integer)filterItemInfo.getCompareValue()), false);
                if (this.isMergeByFiscalPeriod) continue;
                this.setPeriod();
                continue;
            }
            if (propertyName.equalsIgnoreCase("currentyId")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                CurrencyInfo currencyInfo = null;
                for (int j = 0; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("reportStatus")) {
                Integer reportStatus = (Integer)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxReportStatus.getItemCount(); ++j) {
                    if (((CopyCSLHisDataReportStatusEnum)((Object)this.cbxReportStatus.getItemAt(j))).getValue() != reportStatus.intValue()) continue;
                    this.cbxReportStatus.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("recordStatus")) {
                Integer recordStatus = (Integer)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxRecordStatus.getItemCount(); ++j) {
                    if (((CopyCSLHisDataRecordStatusEnum)((Object)this.cbxRecordStatus.getItemAt(j))).getValue() != recordStatus.intValue()) continue;
                    this.cbxRecordStatus.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("resultStatus")) {
                Integer resultStatus = (Integer)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxResultStatus.getItemCount(); ++j) {
                    if (((CopyCSLHisDataResultStatusEnum)((Object)this.cbxResultStatus.getItemAt(j))).getValue() != resultStatus.intValue()) continue;
                    this.cbxResultStatus.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckGroupRpt")) {
                this.chkGroupRpt.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckSumRpt")) {
                this.chkSumRpt.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckAdjust")) {
                this.chkAdjust.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckElimination")) {
                this.chkElimination.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckMnsRpt")) {
                this.chkMnsRpt.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (propertyName.equalsIgnoreCase("isCheckCslRpt")) {
                this.chkCslRpt.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
                continue;
            }
            if (!propertyName.equalsIgnoreCase("isCheckAllOrgUnit")) continue;
            this.chkAllOrgUnit.setSelected((Integer)filterItemInfo.getCompareValue() == 1);
        }
    }

    public void clear() {
        super.clear();
        this.initUI();
    }

    private void initUI() {
        this.spYear.setValue(this.yearAndPeriod.get(0), false);
        this.spPeriod.setValue(this.yearAndPeriod.get(1), false);
        this.repDate.setValue(this.yearAndPeriod.get(2), false);
        this.cbxCurrency.setSelectedItem((Object)this.currencyInfo);
        this.cbxReportStatus.setSelectedItem((Object)CopyCSLHisDataReportStatusEnum.AUDITED);
        this.cbxRecordStatus.setSelectedItem((Object)CopyCSLHisDataRecordStatusEnum.AUDITED);
        this.cbxResultStatus.setSelectedItem((Object)CopyCSLHisDataResultStatusEnum.UNAUDITED);
        this.chkGroupRpt.setVisible(false);
        this.chkSumRpt.setSelected(true);
        this.chkAdjust.setSelected(true);
        this.chkElimination.setSelected(true);
        this.chkMnsRpt.setSelected(true);
        this.chkCslRpt.setSelected(true);
        this.chkAllOrgUnit.setSelected(false);
        if (!this.isMergeByFiscalPeriod) {
            this.setPeriod();
        }
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        super.repDate_dataChanged(e);
        List list = RPTDateUtil.getRptPeriod((Date)this.repDate.getValue(), this.curRptPeriodType);
        this.spYear.setValue(list.get(0));
        this.spPeriod.setValue(list.get(1));
        this.repDate.setValue(list.get(2), false);
        this.setPeriod();
    }

    private void setPeriod() {
        int period = (Integer)this.spPeriod.getValue();
        if ((period == 12 || period == 13) && 3 == this.curRptPeriodType.getValue() && this.isSupport13Period) {
            this.spPeriod.setEnabled(true);
            CslRptUIUtil.setSpineRange(this.spPeriod, 12, 13, false);
        } else {
            this.spPeriod.setEnabled(false);
        }
    }
}

