/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalYearPeriodDateTmp;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCopyGroupRptHisDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CopyGroupRptHisDataFilterUI
extends AbstractCopyGroupRptHisDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CopyGroupRptHisDataFilterUI.class);
    private String selectAll = null;
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private ICSLContext ctx = null;
    RptPeriodTypeEnum periodType;
    int year = 0;
    int period = 0;
    private String selectCompanyId;
    FiscalYearPeriodDateTmp fiscalRefCtrl;

    public String getSelectCompanyId() {
        return this.selectCompanyId;
    }

    public void setSelectCompanyId(String selectCompanyId) {
        this.selectCompanyId = selectCompanyId;
    }

    public CopyGroupRptHisDataFilterUI() throws Exception {
        this.init(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void init(boolean isAddListener) throws Exception {
        this.ctx = CSLContextHelper.getCSLContext();
        this.fiscalRefCtrl = new FiscalYearPeriodDateTmp(this.ctx.getCurOrgBound(), this.ctx.getCurRptPeriodType(), this.repDate, this.spYear, this.spPeriod);
        this.periodType = this.ctx.getCurRptPeriodType();
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        this.fiscalRefCtrl.initTimeCtrlValAndStatusByContextAndPrePeriod(this.ctx, (CoreUIObject)this, null, true, isAddListener);
        this.cbxCurrency.removeAllItems();
        CslClientHelper.initCurrencyToCombox((JComboBox)this.cbxCurrency, true, true);
        try {
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(this.ctx.getCurOrgGroup().getId().toString());
            f7.setTreeID(this.ctx.getCurOrgBound().getId().toString());
            MergeModeEnum mergeType = CslRptUtil.getMergeMode(CSLContextHelper.getCSLContext().getCurOrgBound());
            if (MergeModeEnum.ORDINAL.equals((Object)mergeType)) {
                f7.filterUnitSql(UnionF7Helper.getMergeModeOrgUnitIDSql((String)this.ctx.getCurOrgBound().getId().toString(), (String)this.ctx.getCurOrgGroup().getId().toString(), (MergeModeEnum)mergeType));
            }
            f7.setMultiSelect(false);
            f7.setCtrlUnitPK(this.ctx.getCurOrgBound().getCU());
            this.bizPrmtCompany.setSelector((KDPromptSelector)f7);
            this.bizPrmtCompany.setEditable(false);
            if (!StringUtils.isEmpty((String)this.getSelectCompanyId())) {
                OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectStringPK(this.getSelectCompanyId()));
                this.bizPrmtCompany.setData((Object)orgUnitInfo);
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.prmtTemplate.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.TemplateForCopyGroupRptHisDataQuery");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        filterItems.add(new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
        filterItems.add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        this.prmtTemplate.setEntityViewInfo(view);
        this.prmtTemplate.getQueryAgent().setSelectorCollection(view.getSelector());
        this.prmtTemplate.setDisplayFormat("$number$--$name$");
        this.prmtTemplate.setEditFormat("$number$");
        this.prmtTemplate.setEditable(false);
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItem((Object)this.selectAll);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.NORMAL);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT);
        this.comboSourceType.addItem((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        this.comboSourceType.setSelectedIndex(1);
        this.comboAuditStatus.removeAllItems();
        this.comboAuditStatus.addItem((Object)this.selectAll);
        this.comboAuditStatus.addItem((Object)AuditedStatusEnum.AUDITED);
        this.comboAuditStatus.addItem((Object)AuditedStatusEnum.UNAUDITED);
        this.comboAuditStatus.setSelectedIndex(1);
        this.comboCommitStatus.removeAllItems();
        this.comboCommitStatus.addItem((Object)"");
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.COMMITTED);
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.UNCOMMITTED);
        this.comboCommitStatus.addItem((Object)CommittedStatusEnum.GROUPCOMMITTED);
        this.comboCommitStatus.setSelectedIndex(0);
        this.chkIncludeHisTemplateRpt.setEnabled(false);
        this.refreshTimeInfo((Date)this.repDate.getValue());
    }

    public FilterInfo getFilterInfo() {
        Object obj;
        FilterItemInfo filterItemCurrency;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        try {
            String orgTreeId = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(this.ctx.getCurOrgBound().getNumber(), this.repDate.getTimestamp());
            if (orgTreeId == null) {
                orgTreeId = "";
            }
            FilterItemInfo filterItem0 = new FilterItemInfo("tree.id", (Object)orgTreeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)this.ctx.getCurDataCollect().getNumber(), CompareType.EQUALS));
            sbFormula.append(" and #" + formulaIndex++);
            if (this.bizPrmtCompany.getData() != null) {
                OrgUnitInfo company = (OrgUnitInfo)this.bizPrmtCompany.getData();
                FilterItemInfo filterCompany = new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterCompany);
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        if (this.spYear.getValue() != null) {
            FilterItemInfo filterYear = new FilterItemInfo("year", (Object)((Integer)this.spYear.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterYear);
            sbFormula.append(" and #" + formulaIndex++);
            this.year = (Integer)this.spYear.getValue();
        }
        if (this.spPeriod.getValue() != null) {
            FilterItemInfo filterPeriod = new FilterItemInfo("period", (Object)((Integer)this.spPeriod.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriod);
            sbFormula.append(" and #" + formulaIndex++);
            this.period = (Integer)this.spPeriod.getValue();
        }
        try {
            if (this.ctx.getCurRptPeriodType() != null) {
                FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterPeriodType);
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        } else if (this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)this.selectAll, CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.prmtTemplate.getData() != null) {
            TemplateInfo template = (TemplateInfo)this.prmtTemplate.getData();
            FilterItemInfo filterItem = null;
            if (this.chkIncludeHisTemplateRpt.isSelected()) {
                String group = template.getGroup();
                filterItem = new FilterItemInfo("template.group", (Object)group);
            } else {
                filterItem = new FilterItemInfo("template.id", (Object)template.getId().toString());
            }
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboSourceType.getSelectedItem() != null) {
            obj = this.comboSourceType.getSelectedItem();
            if (obj instanceof RptSrcTypeEnum) {
                RptSrcTypeEnum srcType = (RptSrcTypeEnum)obj;
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(srcType.getValue())));
                sbFormula.append(" and #" + formulaIndex++);
            } else {
                HashSet<Integer> srcTypeSet = new HashSet<Integer>();
                srcTypeSet.add(new Integer(1));
                srcTypeSet.add(new Integer(10));
                srcTypeSet.add(new Integer(13));
                this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", srcTypeSet, CompareType.INCLUDE));
                sbFormula.append(" and #" + formulaIndex++);
            }
        }
        if (this.comboAuditStatus.getSelectedItem() != null && (obj = this.comboAuditStatus.getSelectedItem()) instanceof AuditedStatusEnum) {
            AuditedStatusEnum auditStatus = (AuditedStatusEnum)obj;
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(auditStatus.getValue())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboCommitStatus.getSelectedItem() != null && (obj = this.comboCommitStatus.getSelectedItem()) instanceof CommittedStatusEnum) {
            CommittedStatusEnum commitStatus = (CommittedStatusEnum)obj;
            this.filterInfo.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)new Integer(commitStatus.getValue())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        this.prmtTemplate.setData(null);
        try {
            this.init(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        int rYear = 0;
        int rPeriod = 0;
        boolean isAuditStatusSelAll = true;
        boolean isCommStatusSelAll = true;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("date")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                this.repDate.setValue((Object)new Date(time.getTime()));
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                Integer iYear = (Integer)filterItemInfo.getCompareValue();
                this.spYear.setValue((Object)iYear);
                rYear = iYear;
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                Integer iPeriod = (Integer)filterItemInfo.getCompareValue();
                this.spPeriod.setValue((Object)iPeriod);
                rPeriod = iPeriod;
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                if (currencyId.equals(this.selectAll)) {
                    this.cbxCurrency.setSelectedItem((Object)this.selectAll);
                } else {
                    for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                        CurrencyInfo currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                        if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                        this.cbxCurrency.setSelectedIndex(j);
                        break;
                    }
                }
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("company.id")) {
                String companyId = (String)filterItemInfo.getCompareValue();
                try {
                    OrgUnitInfo companyInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.bizPrmtCompany.setData((Object)companyInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("template.id")) {
                String templateId = (String)filterItemInfo.getCompareValue();
                try {
                    TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectStringPK(templateId));
                    this.prmtTemplate.setData((Object)templateInfo);
                    this.chkIncludeHisTemplateRpt.setSelected(false);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("template.group")) {
                String group = (String)filterItemInfo.getCompareValue();
                try {
                    String oql = "select * where group = '" + group + "' and versionStatus = 1";
                    TemplateCollection templateInfoCol = TemplateFactory.getRemoteInstance().getTemplateCollection(oql);
                    if (templateInfoCol.size() > 0) {
                        this.prmtTemplate.setData((Object)templateInfoCol.get(0));
                    }
                    this.chkIncludeHisTemplateRpt.setSelected(true);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceType")) {
                if (filterItemInfo.getCompareValue() instanceof Integer) {
                    Integer srcType = (Integer)filterItemInfo.getCompareValue();
                    RptSrcTypeEnum srcTypeEnum = RptSrcTypeEnum.getEnum((int)srcType);
                    this.comboSourceType.setSelectedItem((Object)srcTypeEnum);
                } else {
                    this.comboSourceType.setSelectedItem((Object)this.selectAll);
                }
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditedStatus")) {
                Integer auditStatus = (Integer)filterItemInfo.getCompareValue();
                AuditedStatusEnum auditStatusEnum = AuditedStatusEnum.getEnum((int)auditStatus);
                this.comboAuditStatus.setSelectedItem((Object)auditStatusEnum);
                isAuditStatusSelAll = false;
            } else if (filterItemInfo.getPropertyName().equalsIgnoreCase("committedStatus")) {
                Integer commitStatus = (Integer)filterItemInfo.getCompareValue();
                CommittedStatusEnum commitStatusEnum = CommittedStatusEnum.getEnum((int)commitStatus);
                this.comboCommitStatus.setSelectedItem((Object)commitStatusEnum);
                isCommStatusSelAll = false;
            }
            if (isAuditStatusSelAll) {
                this.comboAuditStatus.setSelectedItem((Object)this.selectAll);
            }
            if (isCommStatusSelAll) {
                this.comboCommitStatus.setSelectedItem((Object)"");
            }
            if (this.periodType == null || rYear == 0 || rPeriod == 0) continue;
            this.repDate.setValue((Object)RPTDateUtil.getPeriodLastDate(rYear, rPeriod, this.periodType));
        }
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        if (this.periodType == null || newDate == null) {
            return;
        }
        if (this.fiscalRefCtrl != null && this.fiscalRefCtrl.isMergeByFiscalPeriod()) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, this.periodType);
        newDate = (Date)times.get(2);
        this.repDate.setValue((Object)newDate);
        this.spYear.setValue((Object)new Integer(times.get(0).toString()));
        if (this.spPeriod.getValue() != null) {
            Integer Period = (Integer)this.spPeriod.getValue();
            if (!(RPTDateUtil.isYearLastPeriod(newDate, RptPeriodTypeEnum.MONTHLY) && this.fiscalRefCtrl.isSupport13Period() && RptPeriodTypeEnum.MONTHLY.equals((Object)this.periodType) && Period == 13)) {
                this.spPeriod.setValue((Object)new Integer(times.get(1).toString()));
            }
        }
        this.spPeriod.setEnabled(false);
        CslRptUtil.refresh13PeriodInCsl(this.periodType, this.ctx.getCurDataCollect().getNumber(), newDate, this.spPeriod, this.ctx.getCurRptPeriod(), this.fiscalRefCtrl.isSupport13Period());
    }

    @Override
    protected void prmtTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTemplate_dataChanged(e);
        if (e.getNewValue() != null) {
            this.chkIncludeHisTemplateRpt.setEnabled(true);
        } else {
            this.chkIncludeHisTemplateRpt.setEnabled(false);
            this.chkIncludeHisTemplateRpt.setSelected(false);
        }
    }

    @Override
    protected void bizPrmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPrmtCompany_dataChanged(e);
        if (e.getNewValue() != null) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)e.getNewValue();
            String orgId = orgUnit.getId().toString();
            String curOrgBoundId = this.ctx.getCurOrgBound().getId().toString();
            String oql = "select dispenseSrcID where orgBound.id = '" + curOrgBoundId + "' and company.id = '" + orgId + "'";
            TempletDispenseCollection dispenseCollection = TempletDispenseFactory.getRemoteInstance().getTempletDispenseCollection(oql);
            HashSet<String> tempIds = new HashSet<String>();
            int n = dispenseCollection.size();
            for (int i = 0; i < n; ++i) {
                TempletDispenseInfo dispenseInfo = dispenseCollection.get(i);
                tempIds.add(dispenseInfo.getDispenseSrcID());
            }
            if (tempIds.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                viewInfo.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", tempIds, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.ctx.getCurRptPeriodType().getValue())));
                filter.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
                this.prmtTemplate.setEntityViewInfo(viewInfo);
                this.prmtTemplate.setData(null);
                this.prmtTemplate.setRefresh(true);
                this.prmtTemplate.setUseCacheObject(false);
            }
        }
    }

    @Override
    protected void prmtTemplate_willShow(SelectorEvent e) throws Exception {
        super.prmtTemplate_willShow(e);
        if (this.bizPrmtCompany.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            SysUtil.abort();
        }
    }

    public boolean verify() {
        if (this.bizPrmtCompany.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_CompanyNull"));
            return false;
        }
        if (this.repDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString("inputRptDate"));
            return false;
        }
        return true;
    }
}

