/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCopyGroupRptHisDataListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CopyGroupRptHisDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CopyGroupRptHisDataListUI
extends AbstractCopyGroupRptHisDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(CopyGroupRptHisDataListUI.class);
    private boolean isSupportOtherDS;
    CommonQueryDialog conditionDialog = null;
    CopyGroupRptHisDataFilterUI conditionPanel = null;
    private boolean isMergeByFiscalPeriod;
    private PeriodCollection periods = null;
    private boolean isSupport13Period = false;
    ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    int selectYear = 0;
    int selectPeriod = 0;

    public CopyGroupRptHisDataListUI() throws Exception {
        boolean[] value = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = value[0];
        this.isSupportOtherDS = value[1];
        this.isSupport13Period = value[2];
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNo.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCopyCreate.setIcon(EASResource.getIcon((String)"imgTbtn_copycreate"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isSupportOtherDS) {
            this.tblMain.getColumn("dataCollect.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("dataCollect.name").getStyleAttributes().setHided(true);
        }
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.hideButton();
        this.menuBar.setVisible(false);
        this.menuBar.setEnabled(false);
        this.tblMain.checkParsed(false);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("year").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("period").getStyleAttributes().setHided(true);
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.fmtPeriod(i);
        }
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int irow = e.getLastRow();
                for (int i = e.getFirstRow(); i <= irow; ++i) {
                    CopyGroupRptHisDataListUI.this.fmtPeriod(i);
                }
                CopyGroupRptHisDataListUI.this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
                CopyGroupRptHisDataListUI.this.tblMain.getColumn("year").getStyleAttributes().setHided(true);
                CopyGroupRptHisDataListUI.this.tblMain.getColumn("period").getStyleAttributes().setHided(true);
            }
        });
        CslRptUIUtil.setRelationDiagramVisible((CoreUI)this);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public static String scrambReportPeriod(Object periodType, Object year, Object period, Object date) {
        String s = null;
        int type = -1;
        if (periodType == null) {
            return s;
        }
        if (periodType instanceof BizEnumValueInfo) {
            type = ((BizEnumValueInfo)periodType).getInt();
        } else if (periodType instanceof RptPeriodTypeEnum) {
            type = ((RptPeriodTypeEnum)periodType).getValue();
        }
        switch (type) {
            case 1: {
                int yearInt = (Integer)year;
                int periodInt = (Integer)period;
                Calendar cal = Calendar.getInstance();
                cal.set(yearInt, 0, 0);
                cal.add(5, periodInt);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                s = sdf.format(cal.getTime());
                break;
            }
            case 2: {
                s = year.toString() + RptUtil.getResourceSince51((String)"Yearthen") + period.toString() + RptUtil.getResourceSince51((String)"Week");
                break;
            }
            case 3: {
                s = year.toString() + RptUtil.getResourceSince51((String)"Yearthen") + period.toString() + RptUtil.getResourceSince51((String)"Period");
                break;
            }
            case 4: {
                s = year.toString() + RptUtil.getResourceSince51((String)"Yearthen") + period.toString() + RptUtil.getResourceSince51((String)"Quarterly");
                break;
            }
            case 5: {
                s = year.toString() + RptUtil.getResourceSince51((String)"Year") + ((Integer)period == 1 ? RptUtil.getResourceSince51((String)"Up") : RptUtil.getResourceSince51((String)"Down")) + RptUtil.getResourceSince51((String)"Halfyear");
                break;
            }
            case 6: {
                s = year.toString() + RptUtil.getResourceSince51((String)"Year");
                break;
            }
        }
        return s;
    }

    public void hideButton() {
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnView.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setEnabled(false);
        this.btnLocate.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPageSetup.setEnabled(false);
        this.btnPageSetup.setVisible(false);
        this.btnVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.btnVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        this.btnTraceDown.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.btnCopyTo.setEnabled(false);
        this.btnCopyTo.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnDelVoucher.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceUp.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.btnNextPerson.setEnabled(false);
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnCopyCreate.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectNo.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setVisible(true);
        this.btnMultiapprove.setVisible(false);
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        try {
            FilterItemCollection fic = filter.getFilterItems();
            int[] prePeriod = this.getPrePeriod();
            this.selectYear = prePeriod[0];
            this.selectPeriod = prePeriod[1];
            Date rptDate = FiscalPeriodHelper.getRptDate(this.periods, prePeriod[0], prePeriod[1], this.cslCtx.getCurRptPeriodType(), this.isMergeByFiscalPeriod);
            String orgTreeId = UnionVersionControllerFacadeFactory.getRemoteInstance().getID(this.cslCtx.getCurOrgBound().getNumber().toString(), new Timestamp(rptDate.getTime()));
            fic.add(new FilterItemInfo("tree.id", (Object)orgTreeId, CompareType.EQUALS));
            fic.add(new FilterItemInfo("year", (Object)new Integer(prePeriod[0]), CompareType.EQUALS));
            fic.add(new FilterItemInfo("period", (Object)new Integer(prePeriod[1]), CompareType.EQUALS));
            fic.add(new FilterItemInfo("periodType", (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()), CompareType.EQUALS));
            fic.add(new FilterItemInfo("dataCollectNumber", (Object)this.cslCtx.getCurDataCollect().getNumber(), CompareType.EQUALS));
            String selectCompanyId = (String)this.getUIContext().get("selectCompanyId");
            boolean isGrouping = (Boolean)this.getUIContext().get("companyisIsGrouping");
            if (isGrouping && this.cslCtx.getCurOrgGroup().getId().toString().equals(selectCompanyId)) {
                HashMap<String, String> params = new HashMap<String, String>(4);
                params.put("treeId", this.cslCtx.getCurOrgBound().getId().toString());
                params.put("unitId", selectCompanyId);
                Set companys = RPTDataServiceFactory.getRemoteInstance().getExpandCompanys(params);
                if (companys != null && companys.size() > 0) {
                    fic.add(new FilterItemInfo("company.id", (Object)companys, CompareType.INCLUDE));
                }
            } else {
                fic.add(new FilterItemInfo("company.id", (Object)selectCompanyId, CompareType.EQUALS));
            }
            CurrencyInfo naturalCurrency = CslClientHelper.getCUNaturalCurrency();
            if (naturalCurrency != null) {
                String naturalCurrencyId = naturalCurrency.getId().toString();
                fic.add(new FilterItemInfo("currency.id", (Object)naturalCurrencyId));
            }
            fic.add(new FilterItemInfo("sourceType", (Object)new Integer(1)));
            fic.add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
            fic.add(new FilterItemInfo("convertStatus", (Object)new Integer(0), CompareType.EQUALS));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        return view;
    }

    private int[] getPrePeriod() throws BOSException, EASBizException {
        int iPeriod;
        int iYear;
        int[] yearAndPeriod;
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(null, this.cslCtx.getCurOrgBound());
        }
        if ((yearAndPeriod = FiscalPeriodHelper.getPrevYearAndPeriod(this.periods, iYear = this.cslCtx.getCurRptYear(), iPeriod = this.cslCtx.getCurRptPeriod(), this.cslCtx.getCurRptPeriodType(), this.isMergeByFiscalPeriod, this.isSupport13Period)) != null && yearAndPeriod.length == 2) {
            return yearAndPeriod;
        }
        return new int[]{iYear, iPeriod};
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog conditionDialog1 = null;
        try {
            conditionDialog1 = this.getConditionDialog();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"No_FilterUI"));
        }
        return conditionDialog1;
    }

    public CopyGroupRptHisDataFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CopyGroupRptHisDataFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        String selectCompanyId = (String)this.getUIContext().get("selectCompanyId");
        this.conditionPanel.setSelectCompanyId(selectCompanyId);
        return this.conditionPanel;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)new Boolean(true));
        }
    }

    @Override
    public void actionSelectNo_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectNo_actionPerformed(e);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionCopyCreate_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String id;
            Object value = this.tblMain.getRow(i).getCell("select").getValue();
            if (value == null || !value.equals(new Boolean(true)) || list.contains(id = this.tblMain.getRow(i).getCell("id").getValue().toString())) continue;
            list.add(id);
        }
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"chooseAtLeastOneRecord"));
            SysUtil.abort();
        }
        if (this.getConditionPanel().year != 0 && this.getConditionPanel().period != 0) {
            this.selectYear = this.getConditionPanel().year;
            this.selectPeriod = this.getConditionPanel().period;
        }
        if (this.selectYear == this.cslCtx.getCurRptYear() && this.selectPeriod == this.cslCtx.getCurRptPeriod()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"cannotCopyCurPeriodRpt"));
            SysUtil.abort();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("year", new Integer(this.cslCtx.getCurRptYear()));
        paramMap.put("period", new Integer(this.cslCtx.getCurRptPeriod()));
        paramMap.put("orgTreeId", this.cslCtx.getCurOrgBound().getId().toString());
        Map resultMap = CslReportFactory.getRemoteInstance().copyHisRpt(list, paramMap);
        if (resultMap != null && !resultMap.isEmpty()) {
            boolean hasNoDespMsg;
            Integer c = (Integer)resultMap.get("sucessCount");
            List fl = (List)resultMap.get("faultRptList");
            List noTempDespList = (List)resultMap.get("noTempDespList");
            boolean hasDupMsg = fl != null && fl.size() > 0;
            boolean bl = hasNoDespMsg = noTempDespList != null && noTempDespList.size() > 0;
            if (c > 0) {
                this.refresh(e);
            }
            if (hasDupMsg || hasNoDespMsg) {
                StringBuffer sb = new StringBuffer();
                sb.append(c);
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyRptSuccess"));
                if (hasDupMsg) {
                    sb.append("<br><br>");
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyResultDup"));
                    sb.append("<br><br>");
                    for (String s : fl) {
                        sb.append(s);
                        sb.append("<br>");
                    }
                }
                if (hasNoDespMsg) {
                    sb.append("<br><br>");
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyResultNoTempDesp"));
                    sb.append("<br><br>");
                    for (String s : noTempDespList) {
                        sb.append(s);
                        sb.append("<br>");
                    }
                }
                UIContext uiCtx = new UIContext((Object)this);
                uiCtx.put((Object)"String", (Object)sb.toString());
                uiCtx.put((Object)"reportSystem", (Object)new Boolean(true));
                if (sb.toString().length() > 0) {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                    ((ShowEditorPanelUI)uiWindow.getUIObject()).setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyRptResultUITitle"));
                    uiWindow.show();
                }
            } else {
                this.setNextMessageText(this.getMainStatusBar().getMsgLabel().getText());
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"24_CopyGroupRptHisDataListUI");
                this.setMessageText(MessageFormat.format(msg, c));
                this.showMessage();
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0 && e.getClickCount() == 2 && e.getRowIndex() > -1) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (row != null && row.getCell("select") != null) {
                Boolean value = (Boolean)row.getCell("select").getValue();
                row.getCell("select").setValue((Object)new Boolean(value == false));
            }
        } else {
            int i;
            ArrayList<String> listID = new ArrayList<String>();
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    Object value = this.tblMain.getRow(i).getCell("select").getValue();
                    if (value == null || !value.equals(new Boolean(true))) continue;
                    String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
                    listID.add(id);
                }
            }
            super.tblMain_tableClicked(e);
            if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
                    if (id == null || !listID.contains(id)) continue;
                    this.tblMain.getRow(i).getCell("select").setValue((Object)true);
                }
            }
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        try {
            if (owner instanceof ListUI) {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return super.destroyWindow();
    }

    private void fmtPeriod(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = null;
        Object value = null;
        ICell type = row.getCell("periodType");
        cell = row.getCell("yearPeriod");
        if (type == null || cell == null) {
            return;
        }
        value = type.getValue();
        if (value != null && value instanceof BizEnumValueInfo) {
            Object y = row.getCell("year").getValue();
            Object p = row.getCell("period").getValue();
            String s = CopyGroupRptHisDataListUI.scrambReportPeriod(value, y, p, row.getCell("yearPeriod").getValue());
            cell.setValue((Object)s);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = CopyGroupRptHisDataListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.getConditionDialog().show()) {
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                FilterInfo filter = this.mainQuery.getFilter();
                FilterItemCollection itemCollection = filter.getFilterItems();
                FilterItemInfo companyFilterItemInfo = this.getFilterItemInfo(itemCollection, "company.id");
                if (companyFilterItemInfo != null) {
                    String companyId = (String)companyFilterItemInfo.getCompareValue();
                    OrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    if (company != null && company.isIsGrouping() && this.cslCtx.getCurOrgGroup().getId().toString().equals(company.getId().toString())) {
                        FilterItemInfo filterItemInfo2 = this.getFilterItemInfo(itemCollection, "tree.id");
                        String orgTreeId = filterItemInfo2 == null ? "" : (String)filterItemInfo2.getCompareValue();
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("treeId", orgTreeId);
                        params.put("unitId", company.getId().toString());
                        Set companys = RPTDataServiceFactory.getRemoteInstance().getExpandCompanys(params);
                        if (companys != null && companys.size() > 0) {
                            companyFilterItemInfo.setCompareType(CompareType.INCLUDE);
                            companyFilterItemInfo.setCompareValue((Object)companys);
                        }
                    }
                }
                this.mainQuery.setFilter(filter);
                SorterItemCollection coll = this.mainQuery.getSorter();
                if (coll == null && coll.size() == 0) {
                    coll.add(new SorterItemInfo("sourceType"));
                    coll.add(new SorterItemInfo("template.number"));
                    this.mainQuery.setSorter(coll);
                }
                this.doQuery(this.conditionDialog);
                this.tblMain.removeRows();
            } else {
                SysUtil.abort();
            }
        }
    }

    private FilterItemInfo getFilterItemInfo(FilterItemCollection collection, String compareExpr) {
        for (int i = 0; i < collection.size(); ++i) {
            FilterItemInfo filterItemInfo = collection.get(i);
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase(compareExpr)) continue;
            return filterItemInfo;
        }
        return null;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"CopyHisGroupRptQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setWidth(455);
            this.conditionDialog.setHeight(300);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.CopyGroupRptHisDataListUI");
        }
        return this.conditionDialog;
    }
}

