/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CslClientHelper {
    private static final Logger logger = Logger.getLogger(CslClientHelper.class);

    public static CurrencyInfo getCUNaturalCurrency() {
        return CslRptUtil.getCUNaturalCurrency(null);
    }

    public static void initCurrencyToCombox(JComboBox cmbxCurrency, boolean selNatural, boolean contailAll) {
        CurrencyInfo naturalCurrency;
        String naturalCurrencyId = null;
        if (selNatural && (naturalCurrency = CslClientHelper.getCUNaturalCurrency()) != null) {
            naturalCurrencyId = naturalCurrency.getId().toString();
        }
        CslClientHelper.initCurrencyToCombox(cmbxCurrency, naturalCurrencyId, contailAll);
    }

    public static void initCurrencyToCombox(JComboBox cmbxCurrency, String selCurrencyId, boolean contailAll) {
        block4: {
            if (contailAll) {
                cmbxCurrency.addItem(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"));
            }
            try {
                CurrencyCollection currencies = CslRptUIUtil.getCurrencyCollection(true);
                int original = cmbxCurrency.getItemCount();
                for (int i = 0; i < currencies.size(); ++i) {
                    cmbxCurrency.addItem(currencies.get(i));
                    if (!currencies.get(i).getId().toString().equals(selCurrencyId)) continue;
                    cmbxCurrency.setSelectedIndex(i + original);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                if (!(e instanceof AbortException)) break block4;
                SysUtil.abort();
            }
        }
    }

    public static void initCurrencyCombox(JComboBox cmbxCurrency) throws EASBizException, BOSException {
        String naturalCurrencyId = null;
        CurrencyInfo naturalCurrency = CslClientHelper.getMaintainCUNaturalCurrency();
        if (naturalCurrency != null) {
            naturalCurrencyId = naturalCurrency.getId().toString();
        }
        CslClientHelper.initCurrencyToCombox(cmbxCurrency, naturalCurrencyId, false);
    }

    public static CurrencyInfo getMaintainCUNaturalCurrency() throws BOSException, EASBizException {
        FullOrgUnitInfo fullOrgUnitInfo = null;
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        ObjectStringPK pk = new ObjectStringPK(company.getId().toString());
        SelectorItemCollection selectorCU = new SelectorItemCollection();
        selectorCU.add(new SelectorItemInfo("maintainCU.id"));
        FullOrgUnitInfo fullOrgUnitInfo2 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk, selectorCU);
        if (fullOrgUnitInfo2 != null && fullOrgUnitInfo2.getMaintainCU() != null && fullOrgUnitInfo2.getMaintainCU().getId() != null) {
            ObjectStringPK pkCU = new ObjectStringPK(fullOrgUnitInfo2.getMaintainCU().getId().toString());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("partFI.id"));
            selector.add(new SelectorItemInfo("partFI.baseCurrency.id"));
            selector.add(new SelectorItemInfo("partFI.baseCurrency.number"));
            selector.add(new SelectorItemInfo("partFI.baseCurrency.name"));
            selector.add(new SelectorItemInfo("partFI.baseCurrency.precision"));
            fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pkCU, selector);
            return fullOrgUnitInfo.getPartFI().getBaseCurrency();
        }
        return CslClientHelper.getCUNaturalCurrency();
    }

    public static void initDataElementCombox(KDComboBox combo, boolean isIncludeEmpty, boolean isIncludeUnUsed, boolean isIncludeAll) {
        CslClientHelper.initDataElementCombox(combo, isIncludeEmpty, isIncludeUnUsed, true, isIncludeAll);
    }

    public static void initDataElementCombox(KDComboBox combo, boolean isIncludeEmpty, boolean isIncludeUnUsed, boolean firstRemoveAll, boolean isIncludeAll) {
        DataElementCollection dataElements = null;
        String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
        String resName = "SelectAll";
        String selectAll = EASResource.getString((String)resClassName, (String)resName);
        if (firstRemoveAll) {
            combo.removeAllItems();
        }
        if (isIncludeAll) {
            combo.addItem((Object)selectAll);
            combo.setSelectedItem((Object)selectAll);
        }
        if (isIncludeEmpty) {
            DataElementInfo nullInfo = new DataElementInfo();
            combo.addItem((Object)nullInfo);
            combo.setSelectedItem((Object)nullInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        if (!isIncludeUnUsed) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isUsedElim", (Object)Boolean.TRUE));
        }
        try {
            CslGradeManageUtil.filteData((FilterInfo)view.getFilter(), (String)"trackRecordCreator.id", (String)DataElementListUI.class.getName(), null);
            dataElements = DataElementFactory.getRemoteInstance().getDataElementCollection(view);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        if (!CslClientHelper.isEmpty(dataElements)) {
            combo.addItems(dataElements.toArray());
        }
    }

    public static void mergeCheckBox(KDTable tblMain, String columnName, int left, int right, int mergeMode) {
        if (tblMain == null) {
            return;
        }
        int size = tblMain.getRowCount();
        int top = 0;
        int bottom = 0;
        KDTMergeManager mm = tblMain.getMergeManager();
        String previousdId = "";
        for (int i = 0; i < size; ++i) {
            IRow row = tblMain.getRow(i);
            if (row == null || row.getCell(columnName) == null) continue;
            String tempId = (String)row.getCell(columnName).getValue();
            if (previousdId.equals("")) {
                previousdId = tempId;
            }
            if (tempId.equalsIgnoreCase(previousdId) || i == 0 || top == bottom) {
                ++bottom;
            } else {
                mm.mergeBlock(top, left, bottom - 1, right, mergeMode);
                top = bottom++;
                previousdId = tempId;
            }
            if (i != size - 1) continue;
            mm.mergeBlock(top, left, bottom - 1, right, mergeMode);
        }
    }

    public static void mergeCheckBox(KDTable tblMain, String columnName, int left, int right) {
        CslClientHelper.mergeCheckBox(tblMain, columnName, left, right, 4);
    }

    public static boolean isEmpty(Object o) {
        return o == null || o.toString() == null || o.toString().trim().length() == 0;
    }

    public static void setPrecision(int iCurrencyPrecision, IRow row, String key) {
        BigDecimal amount = null;
        amount = (BigDecimal)row.getCell(key).getValue();
        if (amount == null || amount.compareTo(BigDecimal.valueOf(0L)) == 0) {
            row.getCell(key).setValue(null);
        } else {
            amount = amount.setScale(iCurrencyPrecision, 4);
            row.getCell(key).setValue((Object)amount);
            row.getCell(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void setPrecision(int iCurrencyPrecision, IRow row, int rowIndex) {
        BigDecimal amount = null;
        amount = (BigDecimal)row.getCell(rowIndex).getValue();
        if (amount == null || amount.compareTo(BigDecimal.valueOf(0L)) == 0) {
            row.getCell(rowIndex).setValue(null);
        } else {
            amount = amount.setScale(iCurrencyPrecision, 4);
            row.getCell(rowIndex).setValue((Object)amount);
            row.getCell(rowIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static int handleIntColumnForDB(IRow row, int columnIndex) {
        if (row.getCell(columnIndex) != null && row.getCell(columnIndex).getValue() instanceof Integer) {
            return (Integer)row.getCell(columnIndex).getValue();
        }
        if (row.getCell(columnIndex) != null && row.getCell(columnIndex).getValue() instanceof BigDecimal) {
            return ((BigDecimal)row.getCell(columnIndex).getValue()).intValue();
        }
        if (row.getCell(columnIndex) != null) {
            Object obj = row.getCell(columnIndex).getValue();
            int ret = -1;
            try {
                ret = Integer.parseInt(obj.toString());
            }
            catch (Exception e) {
                ret = -1;
            }
            return ret;
        }
        return -1;
    }

    public static int handleIntColumnForDB(IRow row, String colName) {
        if (row.getCell(colName) != null && row.getCell(colName).getValue() instanceof Integer) {
            return (Integer)row.getCell(colName).getValue();
        }
        if (row.getCell(colName) != null && row.getCell(colName).getValue() instanceof BigDecimal) {
            return ((BigDecimal)row.getCell(colName).getValue()).intValue();
        }
        if (row.getCell(colName) != null) {
            Object obj = row.getCell(colName).getValue();
            int ret = -1;
            try {
                ret = Integer.parseInt(obj.toString());
            }
            catch (Exception e) {
                ret = -1;
            }
            return ret;
        }
        return -1;
    }

    public static int handleIntColumnForDB(ICell cell) {
        if (cell == null) {
            return -1;
        }
        if (cell.getValue() instanceof Integer) {
            return (Integer)cell.getValue();
        }
        if (cell.getValue() instanceof BigDecimal) {
            return ((BigDecimal)cell.getValue()).intValue();
        }
        return -1;
    }

    public static ArrayList getSelectedConditionalIdValues(ArrayList ids, KDTable tblMain, String cellName, String compareVal, String keyFieldName, String allErrorMsg, boolean sysAbort) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        ArrayList<String> removeIds = new ArrayList<String>();
        if (selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                Object cellVal;
                int rowIndex = selectRows[i];
                IRow row = tblMain.getRow(rowIndex);
                if (row == null || (cellVal = row.getCell(cellName).getValue()) == null || cellVal.equals(compareVal)) continue;
                String cellStr = (String)row.getCell(keyFieldName).getValue();
                removeIds.add(cellStr);
            }
            ids.removeAll(removeIds);
            if (ids.size() == 0) {
                MsgBox.showInfo((String)allErrorMsg);
                if (sysAbort) {
                    SysUtil.abort();
                }
            }
        }
        return ids;
    }
}

