/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptImportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptXlsImporter;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CslRptImportUI
extends AbstractCslRptImportUI {
    CslRptXlsImporter importer = null;
    File currentDir = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnOpen.setIcon(EASResource.getIcon((String)"imgTbtn_open"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importexcel"));
        this.actionImport.setEnabled(false);
        this.paneMain.setDividerLocation(0.5);
        this.initTree(this.treeSource);
        this.initTree(this.treeDestination);
    }

    private void initTree(KDTree tree) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        tree.removeAllChildrenFromParent((MutableTreeNode)root);
        root.setText(CslRptUtil.getString("CslRptImportNoDirSelected"));
        root.setTextColor(Color.GRAY);
        root.setCustomIcon(null);
        root.setCustomClosedIcon(null);
        root.setCustomOpenIcon(null);
        ((KingdeeTreeUI)tree.getUI()).resetSize();
        tree.setShowsRootHandles(true);
        tree.expandAllNodes(true, (TreeNode)root);
        tree.setShowCheckBox(false);
        tree.setSyncChecked(true);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.importer != null) {
            this.importer.executeImport();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)CslRptUtil.getString("CslRptImportOKTitle"));
            SimpleNotePad.showMessageByModel(ctx, this.importer.getStat());
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        if (this.currentDir != null) {
            fc.setCurrentDirectory(this.currentDir);
        }
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(CslRptUtil.getString("CslRptImportSelectRoot"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            this.currentDir = fc.getSelectedFile();
            this.actionRefresh.actionPerformed(e);
            this.actionImport.setEnabled(true);
        }
    }

    private void updateUI(File dir) throws Exception {
        if (!dir.isDirectory()) {
            return;
        }
        boolean isMultiMode = false;
        if (this.getUIContext().containsKey("KEY_MULTI_MODE")) {
            isMultiMode = true;
        }
        this.importer = new CslRptXlsImporter(dir, this.treeSource, this.treeDestination, isMultiMode);
        this.importer.refreshSource();
        this.importer.refreshDestination();
        this.importer.match();
        ((KingdeeTreeUI)this.treeSource.getUI()).resetSize();
        ((KingdeeTreeUI)this.treeDestination.getUI()).resetSize();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentDir != null) {
            this.updateUI(this.currentDir);
        }
    }
}

