/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptItemDataFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptItemF7;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CslRptItemDataFilterUI
extends AbstractCslRptItemDataFilterUI
implements ChangeListener {
    private static final Logger logger = Logger.getLogger(CslRptItemDataFilterUI.class);
    ICSLContext cslCtx = CSLContextHelper.getCSLContext();
    String selectAll = CslRptUtil.getString("CslRptItemDataNameAll");
    String selectItem = CslRptUtil.getString("CslRptItemDataNameItem");
    String selectElim = CslRptUtil.getString("CslRptItemDataNameElim");
    String selectAdju = CslRptUtil.getString("CslRptItemDataNameAdjust");
    private CslRptItemF7 cslRptItemF7UI = new CslRptItemF7((IUIObject)this);
    private boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private PeriodCollection periodCollection = null;

    public CslRptItemDataFilterUI() throws Exception {
        this.initUI();
    }

    public FilterInfo getFilterInfo() {
        Calendar calendar;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
            this.filterInfo.setMaskString(null);
        }
        if (this.bizCompany.getData() != null) {
            OrgUnitInfo company = (OrgUnitInfo)this.bizCompany.getData();
            FilterItemInfo filterCompany = new FilterItemInfo("orgUnit", (Object)company.getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterCompanyNumber = new FilterItemInfo("orgUnitNumber", (Object)company.getNumber().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            this.filterInfo.getFilterItems().add(filterCompanyNumber);
        } else {
            FilterItemInfo defaultOrgBound = new FilterItemInfo("defaultOrgBound", (Object)"defaultOrgBound", CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(defaultOrgBound);
        }
        if (this.comboItemType.getSelectedItem() != null && !this.comboItemType.getSelectedItem().equals(this.selectAll)) {
            ReportClassInfo itemType = (ReportClassInfo)this.comboItemType.getSelectedItem();
            FilterItemInfo filterItemType = new FilterItemInfo("reportClass", (Object)itemType.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemType);
        }
        if (this.dpkDate.getValue() != null) {
            Date startDate = (Date)this.dpkDate.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            Timestamp startTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterStartDate = new FilterItemInfo("lastUpdateTime", (Object)startTime, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterStartDate);
        }
        if (this.dpkDateTo.getValue() != null) {
            Date endDate = (Date)this.dpkDateTo.getValue();
            calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            Timestamp endTime = new Timestamp(calendar.getTimeInMillis());
            FilterItemInfo filterEndDate = new FilterItemInfo("lastUpdateTime", (Object)endTime, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterEndDate);
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(this.selectAll)) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            FilterItemInfo filterCurrency = new FilterItemInfo("currency", (Object)currency.getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterCurrencyNumber = new FilterItemInfo("currencyNumber", (Object)currency.getNumber().toString(), CompareType.EQUALS);
            FilterItemInfo filterCurrencyName = new FilterItemInfo("currencyName", (Object)currency.getName(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrency);
            this.filterInfo.getFilterItems().add(filterCurrencyNumber);
            this.filterInfo.getFilterItems().add(filterCurrencyName);
        }
        if (this.comboTargetCurrency.getSelectedItem() != null && !this.comboTargetCurrency.getSelectedItem().equals(this.selectAll)) {
            CurrencyInfo tcurrency = (CurrencyInfo)this.comboTargetCurrency.getSelectedItem();
            FilterItemInfo filterTargetCurrency = new FilterItemInfo("targetCurrency", (Object)tcurrency.getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterTargetCurrencyNumber = new FilterItemInfo("targetCurrencyNumber", (Object)tcurrency.getNumber().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterTargetCurrency);
            this.filterInfo.getFilterItems().add(filterTargetCurrencyNumber);
        }
        if (this.bizItem.getData() != null) {
            RPTItemInfo item = (RPTItemInfo)this.bizItem.getData();
            FilterItemInfo filterItem = new FilterItemInfo("item", (Object)item.getNumber(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            FilterItemInfo filterItemForID = new FilterItemInfo("itemForID", (Object)item.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemForID);
        }
        if (this.bizItemTo.getData() != null) {
            RPTItemInfo itemTo = (RPTItemInfo)this.bizItemTo.getData();
            FilterItemInfo filterItemTo = new FilterItemInfo("itemTo", (Object)itemTo.getNumber(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            FilterItemInfo filterItemToForID = new FilterItemInfo("itemToForID", (Object)itemTo.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemToForID);
        }
        Integer level = (Integer)this.spnLevel.getValue();
        FilterItemInfo filterItemLevel = new FilterItemInfo("itemLevel", (Object)level);
        this.filterInfo.getFilterItems().add(filterItemLevel);
        Integer levelTo = (Integer)this.spnLevelTo.getValue();
        FilterItemInfo filterItemLevelTo = new FilterItemInfo("itemLevelTo", (Object)levelTo);
        this.filterInfo.getFilterItems().add(filterItemLevelTo);
        if (this.comboType.getSelectedItem() != null) {
            Integer iSelectType = new Integer(0);
            Object selectType = this.comboType.getSelectedItem();
            if (selectType.equals(this.selectAll)) {
                iSelectType = new Integer(1);
            } else if (selectType.equals(this.selectItem)) {
                iSelectType = new Integer(2);
            } else if (selectType.equals(this.selectElim)) {
                iSelectType = new Integer(3);
            } else if (selectType.equals(this.selectAdju)) {
                iSelectType = new Integer(4);
            }
            FilterItemInfo filterType = new FilterItemInfo("type", (Object)iSelectType, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterType);
        }
        if (this.comboPeriodType.getSelectedItem() != null && !this.comboPeriodType.getSelectedItem().equals(this.selectAll)) {
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            FilterItemInfo filterPeriodType = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterPeriodType);
        }
        if (this.comboIsAdjusted.getSelectedItem() != null && !this.comboIsAdjusted.getSelectedItem().equals(this.selectAll)) {
            AdjustStatusEnum isAdjusted = (AdjustStatusEnum)((Object)this.comboIsAdjusted.getSelectedItem());
            FilterItemInfo filterAdjust = new FilterItemInfo("isAdjusted", (Object)new Integer(isAdjusted.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterAdjust);
        }
        if (this.comboElim.getSelectedItem() != null && !this.comboElim.getSelectedItem().equals(this.selectAll)) {
            CslDataSrcTypeEnum dataSrc = (CslDataSrcTypeEnum)((Object)this.comboElim.getSelectedItem());
            FilterItemInfo filterDataSrc = new FilterItemInfo("dataSrc", (Object)new Integer(dataSrc.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterDataSrc);
        }
        if (this.bizDataType.getValue() != null) {
            DataElementInfo dataElement = (DataElementInfo)this.bizDataType.getValue();
            FilterItemInfo filterDataElement = new FilterItemInfo("dataElement", (Object)new Integer(dataElement.getInterSeq()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterDataElement);
        }
        int valueType = this.btnMoney.isSelected() ? 1 : 2;
        FilterItemInfo filterValueType = new FilterItemInfo("valueType", (Object)new Integer(valueType), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterValueType);
        FilterItemInfo filterShowNull = new FilterItemInfo("showNull", (Object)(!this.btnIsShowNull.isSelected() ? 1 : 0), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterShowNull);
        FilterItemInfo filterShowSum = new FilterItemInfo("showSum", (Object)this.btnIsShowSum.isSelected(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(filterShowSum);
        FilterItemInfo item = new FilterItemInfo("isShowFreezeItem", (Object)new Boolean(this.isShowFreezeItem.isSelected()));
        this.filterInfo.getFilterItems().add(item);
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        ItemDataCondition condition = new ItemDataCondition();
        CurrencyInfo tmpCurrency = null;
        try {
            OrgTreeInfo orgBound = this.cslCtx.getCurOrgBound();
            condition.setOrgTreeNumber(orgBound.getId().toString());
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        if (this.bizCompany.getData() != null) {
            OrgUnitInfo company = (OrgUnitInfo)this.bizCompany.getData();
            ArrayList<String> companys = new ArrayList<String>();
            companys.add(company.getId().toString());
            condition.setOrgUnit(companys);
        }
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        Date date = (Date)this.dpkDate.getValue();
        Date dateTo = (Date)this.dpkDateTo.getValue();
        if (!this.comboPeriodType.getSelectedItem().equals(this.selectAll)) {
            periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
            condition.setRptPeriodType(periodType.getValue());
            if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodType)) {
                try {
                    condition.setRptYearStart(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                    condition.setRptYearEnd(this.cslCtx.getCurRptYear());
                    condition.setRptPeriodStart(this.cslCtx.getCurRptPeriod());
                }
                catch (BOSException e) {
                    logger.error((Object)"FiscalPeriodCondition", (Throwable)e);
                }
            } else {
                int[] yearAndPeriodStart = RPTDateUtil.getPeriod(date, periodType);
                int[] yearAndPeriodEnd = RPTDateUtil.getPeriod(dateTo, periodType);
                condition.setRptYearStart(yearAndPeriodStart[0]);
                condition.setRptPeriodStart(yearAndPeriodStart[1]);
                condition.setRptYearEnd(yearAndPeriodEnd[0]);
                condition.setRptPeriodStart(yearAndPeriodEnd[1]);
            }
        }
        if (!this.comboCurrency.getSelectedItem().equals(this.selectAll)) {
            CurrencyInfo currency;
            tmpCurrency = currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            condition.setCurrency(currency.getId().toString());
        }
        if (!this.comboTargetCurrency.getSelectedItem().equals(this.selectAll)) {
            CurrencyInfo targetCurrency = (CurrencyInfo)this.comboTargetCurrency.getSelectedItem();
            condition.setTargetCurrency(targetCurrency.getNumber());
        }
        if (this.bizItem.getData() != null) {
            RPTItemInfo itemStart = (RPTItemInfo)this.bizItem.getData();
            condition.setItemNumberStart(itemStart.getNumber());
        }
        if (this.bizItemTo.getData() != null) {
            RPTItemInfo itemEnd = (RPTItemInfo)this.bizItemTo.getData();
            condition.setItemNumberEnd(itemEnd.getNumber());
        }
        int itemStartLevel = Integer.parseInt(this.spnLevel.getValue().toString());
        int itemEndLevel = Integer.parseInt(this.spnLevelTo.getValue().toString());
        condition.setItemNumberLevelStart(itemStartLevel);
        condition.setItemNumberLevelEnd(itemEndLevel);
        if (!this.comboIsAdjusted.getSelectedItem().equals(this.selectAll)) {
            AdjustStatusEnum adjustStatus = (AdjustStatusEnum)((Object)this.comboIsAdjusted.getSelectedItem());
            condition.setIsAdjusted(adjustStatus.getValue() == 1);
        }
        if (!this.comboElim.getSelectedItem().equals(this.selectAll)) {
            CslDataSrcTypeEnum dataSrc = (CslDataSrcTypeEnum)((Object)this.comboElim.getSelectedItem());
            condition.setDataSource(dataSrc.getValue());
        }
        if (this.bizDataType.getValue() != null) {
            DataElementInfo dataElement = (DataElementInfo)this.bizDataType.getValue();
            condition.setDataElement(dataElement.getInterSeq());
        }
        int valueType = 0;
        if (this.btnMoney.isSelected()) {
            valueType = 1;
        } else if (this.btnQuantity.isSelected()) {
            valueType = 2;
        }
        condition.setValueType(valueType);
        boolean isShowZero = this.btnIsShowNull.isSelected();
        condition.setIsAllowAmountZero(isShowZero);
        boolean isShowSum = this.btnIsShowSum.isSelected();
        String selectType = (String)this.comboType.getSelectedItem();
        Integer iSelectType = null;
        if (selectType.equals(this.selectAll)) {
            iSelectType = new Integer(1);
        } else if (selectType.equals(this.selectItem)) {
            iSelectType = new Integer(2);
        } else if (selectType.equals(this.selectElim)) {
            iSelectType = new Integer(3);
        } else if (selectType.equals(this.selectAdju)) {
            iSelectType = new Integer(4);
        }
        HashMap<String, Object> extCondition = new HashMap<String, Object>();
        extCondition.put("isShowSum", isShowSum);
        extCondition.put("dataType", iSelectType);
        if (tmpCurrency != null) {
            extCondition.put("currencyName", tmpCurrency.getName());
        } else {
            extCondition.put("currencyName", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"369_CslRptItemDataFilterUI"));
        }
        condition.setIsShowFreezeItem(this.isShowFreezeItem.isSelected());
        this.getUIContext().put("condition", condition);
        this.getUIContext().put("extCondition", extCondition);
        return super.getCustomerParams();
    }

    public boolean destroyWindow() {
        this.getCustomerParams();
        return super.destroyWindow();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        try {
            this.clearUI();
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
        super.loadData(entityViewInfo);
        boolean isDataAll = true;
        boolean isAdjustAll = true;
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block11: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            Integer value;
            Integer v;
            RPTItemInfo item;
            String itemID;
            ReportClassInfo tmpInfo;
            int j;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgUnit")) {
                String companyID = (String)filterItemInfo.getCompareValue();
                ObjectUuidPK pk = new ObjectUuidPK(companyID);
                try {
                    OrgUnitInfo company = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)pk);
                    if (company == null) continue;
                    this.bizCompany.setData((Object)company);
                }
                catch (EASBizException e) {
                    super.handUIException((Throwable)e);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportClass")) {
                String reportClassID = (String)filterItemInfo.getCompareValue();
                for (j = 0; j < this.comboItemType.getItemCount(); ++j) {
                    if (this.comboItemType.getItemAt(j).equals(this.selectAll) || !(tmpInfo = (ReportClassInfo)this.comboItemType.getItemAt(j)).getId().toString().equalsIgnoreCase(reportClassID)) continue;
                    this.comboItemType.setSelectedItem((Object)tmpInfo);
                    continue block11;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("lastUpdateTime")) {
                Date time = (Date)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.dpkDate.setValue((Object)new Date(time.getTime()));
                    continue;
                }
                this.dpkDateTo.setValue((Object)new Date(time.getTime()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency")) {
                String currencyID = (String)filterItemInfo.getCompareValue();
                for (j = 0; j < this.comboCurrency.getItemCount(); ++j) {
                    if (this.comboCurrency.getItemAt(j).equals(this.selectAll) || !(tmpInfo = (CurrencyInfo)this.comboCurrency.getItemAt(j)).getId().toString().equalsIgnoreCase(currencyID)) continue;
                    this.comboCurrency.setSelectedItem((Object)tmpInfo);
                    continue block11;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("targetCurrency")) {
                String targetCurrencyID = (String)filterItemInfo.getCompareValue();
                for (j = 0; j < this.comboTargetCurrency.getItemCount(); ++j) {
                    if (this.comboTargetCurrency.getItemAt(j).equals(this.selectAll) || !(tmpInfo = (CurrencyInfo)this.comboTargetCurrency.getItemAt(j)).getId().toString().equalsIgnoreCase(targetCurrencyID)) continue;
                    this.comboTargetCurrency.setSelectedItem((Object)tmpInfo);
                    continue block11;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemForID")) {
                itemID = (String)filterItemInfo.getCompareValue();
                ObjectUuidPK pk = new ObjectUuidPK(itemID);
                try {
                    item = RPTItemFactory.getRemoteInstance().getRPTItemInfo((IObjectPK)pk);
                    if (item == null) continue;
                    this.bizItem.setData((Object)item);
                }
                catch (EASBizException e) {
                    super.handUIException((Throwable)e);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemToForID")) {
                itemID = (String)filterItemInfo.getCompareValue();
                ObjectUuidPK pk = new ObjectUuidPK(itemID);
                try {
                    item = RPTItemFactory.getRemoteInstance().getRPTItemInfo((IObjectPK)pk);
                    if (item == null) continue;
                    this.bizItemTo.setData((Object)item);
                }
                catch (EASBizException e) {
                    super.handUIException((Throwable)e);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevel")) {
                Integer level = (Integer)filterItemInfo.getCompareValue();
                this.spnLevel.setValue((Object)level);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemLevelTo")) {
                Integer levelTo = (Integer)filterItemInfo.getCompareValue();
                this.spnLevelTo.setValue((Object)levelTo);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("type")) {
                Integer iSelectType = (Integer)filterItemInfo.getCompareValue();
                if (iSelectType == 1) {
                    this.comboType.setSelectedItem((Object)this.selectAll);
                    continue;
                }
                if (iSelectType == 2) {
                    this.comboType.setSelectedItem((Object)this.selectItem);
                    continue;
                }
                if (iSelectType == 3) {
                    this.comboType.setSelectedItem((Object)this.selectElim);
                    continue;
                }
                if (iSelectType != 4) continue;
                this.comboType.setSelectedItem((Object)this.selectAdju);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                Integer periodType = (Integer)filterItemInfo.getCompareValue();
                this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)periodType));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isAdjusted")) {
                Integer adjust = (Integer)filterItemInfo.getCompareValue();
                this.comboIsAdjusted.setSelectedItem((Object)AdjustStatusEnum.getEnum(adjust));
                isAdjustAll = false;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataSrc")) {
                Integer dataSrc = (Integer)filterItemInfo.getCompareValue();
                this.comboElim.setSelectedItem((Object)CslDataSrcTypeEnum.getEnum(dataSrc));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElement")) {
                Integer dataElement = (Integer)filterItemInfo.getCompareValue();
                this.bizDataType.setValue((Object)DataElementProvider.getDataElementInfo(dataElement));
                isDataAll = false;
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("valueType")) {
                Integer valueType = (Integer)filterItemInfo.getCompareValue();
                if (valueType == 1) {
                    this.btnMoney.setSelected(true);
                    continue;
                }
                this.btnQuantity.setSelected(true);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("showNull")) {
                v = (Integer)filterItemInfo.getCompareValue();
                this.btnIsShowNull.setSelected(v == 0);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("showSum")) {
                v = (Integer)filterItemInfo.getCompareValue();
                this.btnIsShowSum.setSelected(v == 1);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("isShowFreezeItem") || (value = (Integer)filterItemInfo.getCompareValue()) == null) continue;
            this.isShowFreezeItem.setSelected(value == 1);
        }
        if (isAdjustAll) {
            this.comboIsAdjusted.setSelectedItem((Object)this.selectAll);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isMergeByFiscalPeriod && this.periodCollection == null) {
            try {
                this.periodCollection = FiscalPeriodHelper.getPeriodCollection(null, this.cslCtx.getCurOrgBound());
            }
            catch (Exception e) {
                logger.error((Object)"FiscalperiodCollection", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        this.clearUI();
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    logger.info((Object)CslRptItemDataFilterUI.this.comboPeriodType.getSelectedItem().toString());
                } else {
                    try {
                        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)CslRptItemDataFilterUI.this.comboPeriodType.getSelectedItem();
                        if (periodType == null) {
                            periodType = CslRptItemDataFilterUI.this.cslCtx.getCurRptPeriodType();
                        }
                        if (FiscalPeriodHelper.isMergeByFiscalPeriod(CslRptItemDataFilterUI.this.isMergeByFiscalPeriod, periodType)) {
                            return;
                        }
                        Date date = CslRptItemDataFilterUI.this.dpkDateTo.getSqlDate();
                        if (date == null) {
                            date = new Date();
                        }
                        List timesList = RPTDateUtil.getRptPeriod(date, periodType);
                        CslRptItemDataFilterUI.this.dpkDateTo.setValue(timesList.get(2));
                        int year = (Integer)timesList.get(0);
                        int period = (Integer)timesList.get(1);
                        Date firstDate = RPTDateUtil.getPeriodFirstDate(year, period, periodType);
                        CslRptItemDataFilterUI.this.dpkDate.setValue((Object)firstDate);
                    }
                    catch (BOSException e1) {
                        CslRptItemDataFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    private void clearUI() throws BOSException {
        this.bizCompany.setData(null);
        this.bizItem.setData(null);
        this.bizItemTo.setData(null);
        this.comboCurrency.setSelectedItem((Object)this.selectAll);
        this.comboElim.setSelectedItem((Object)this.selectAll);
        this.comboItemType.setSelectedItem((Object)this.selectAll);
        if (this.comboPeriodType != null) {
            // empty if block
        }
        this.comboPeriodType.setSelectedItem((Object)this.cslCtx.getCurRptPeriodType());
        this.comboTargetCurrency.setSelectedItem((Object)this.selectAll);
        this.comboType.setSelectedItem((Object)this.selectAll);
        this.spnLevel.setValue((Object)new Integer(1));
        this.spnLevelTo.setValue((Object)new Integer(1));
        this.btnMoney.setSelected(true);
        this.btnIsShowNull.setSelected(true);
        this.btnIsShowSum.setSelected(false);
        this.dpkDate.setValue((Object)FiscalPeriodHelper.getPeriodFirstDate(this.cslCtx.getCurRptYear(), this.cslCtx.getCurRptPeriod(), this.cslCtx.getCurRptPeriodType(), this.periodCollection, this.isMergeByFiscalPeriod));
        this.dpkDateTo.setValue((Object)this.cslCtx.getCurReportDate());
        if (this.isMergeByFiscalPeriod) {
            this.comboPeriodType.setEnabled(false);
            this.dpkDate.setEnabled(false);
            this.dpkDateTo.setEnabled(false);
        }
        this.spnLevel.addChangeListener((ChangeListener)this);
        this.spnLevelTo.addChangeListener((ChangeListener)this);
    }

    public void clear() {
        super.clear();
        try {
            this.clearUI();
        }
        catch (BOSException e1) {
            super.handUIException((Throwable)e1);
        }
    }

    private void initUI() throws EASBizException, BOSException {
        this.comboElim.addItem((Object)this.selectAll);
        this.comboItemType.addItem((Object)this.selectAll);
        this.bizDataType.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.DataElementQuery");
        this.bizDataType.setEditFormat("$number$");
        this.bizDataType.setDisplayFormat("$name$");
        this.bizDataType.setEditable(true);
        this.bizDataType.setRequired(false);
        this.bizDataType.setCommitFormat("$number$");
        try {
            CslGradeManageUtil.setDataElementF7GMFilter((KDBizPromptBox)this.bizDataType, null, (boolean)true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.comboIsAdjusted.removeItem((Object)AdjustStatusEnum.CALIADJUSTED);
        this.comboType.addItem((Object)this.selectAll);
        this.comboType.addItem((Object)this.selectItem);
        this.comboType.addItem((Object)this.selectElim);
        this.comboType.addItem((Object)this.selectAdju);
        OrgTreeInfo orgTreeInfo = null;
        orgTreeInfo = this.cslCtx.getCurOrgBound();
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
        f7.setTreeID(orgTreeInfo.getId().toString());
        f7.setRootUnitID(this.cslCtx.getCurOrgGroup().getId().toString());
        f7.setCtrlUnitPK(orgTreeInfo.getCU());
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.bizCompany.setSelector((KDPromptSelector)f7);
        try {
            this.comboItemType.addItems(ReportClassFactory.getRemoteInstance().getReportClassCollection(CslGradeManageUtil.filterRptItemTypeGradeManage(null, null)).toArray());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Object[] currency = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true).toArray();
        this.comboCurrency.addItems(currency);
        this.comboCurrency.addItem((Object)this.selectAll);
        this.comboTargetCurrency.addItems(currency);
        this.comboTargetCurrency.addItem((Object)this.selectAll);
        this.bizItem.setSelector((KDPromptSelector)this.cslRptItemF7UI);
        this.bizItemTo.setSelector((KDPromptSelector)this.cslRptItemF7UI);
    }

    private boolean verifyInput() {
        return true;
    }

    @Override
    public void actionComboTypeChanged_actionPerformed(ActionEvent e) throws Exception {
        super.actionComboTypeChanged_actionPerformed(e);
        if (this.comboType.getSelectedItem().equals(this.selectElim)) {
            this.comboElim.removeAllItems();
            this.comboElim.addItem((Object)this.selectAll);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
            this.comboElim.addItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
        } else {
            this.comboElim.removeAllItems();
            this.comboElim.addItem((Object)this.selectAll);
            this.comboElim.addItems(CslDataSrcTypeEnum.getEnumList().toArray());
            this.comboElim.removeItem((Object)CslDataSrcTypeEnum.ELIMDEBIT);
            this.comboElim.removeItem((Object)CslDataSrcTypeEnum.ELIMCREDIT);
        }
    }

    @Override
    public void actionComboElimChanged_actionPerformed(ActionEvent e) throws Exception {
        super.actionComboElimChanged_actionPerformed(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer numberBegin = (Integer)this.spnLevel.getValue();
        Integer numberEnd = (Integer)this.spnLevelTo.getValue();
        int iNumberBegin = numberBegin;
        int iNumberEnd = numberEnd;
        if (e.getSource() == this.spnLevel) {
            if (numberBegin == null || numberEnd == null) {
                try {
                    throw new ReportException(ReportException.INIT_DATA_ERROR);
                }
                catch (ReportException e1) {
                    logger.error((Object)"ReportException.INIT_DATA_ERROR", (Throwable)e1);
                }
            } else if (iNumberBegin <= 0) {
                this.spnLevel.setValue((Object)new Integer(1));
            } else if (iNumberEnd < iNumberBegin) {
                this.spnLevelTo.setValue((Object)new Integer(iNumberBegin));
            }
        } else if (e.getSource() == this.spnLevelTo) {
            if (numberBegin == null || numberEnd == null) {
                try {
                    throw new ReportException(ReportException.INIT_DATA_ERROR);
                }
                catch (ReportException e1) {
                    logger.error((Object)"ReportException.INIT_DATA_ERROR", (Throwable)e1);
                }
            } else if (iNumberEnd <= 0) {
                this.spnLevelTo.setValue((Object)new Integer(1));
            } else if (iNumberEnd < iNumberBegin) {
                this.spnLevelTo.setValue((Object)new Integer(iNumberBegin));
            }
        }
    }
}

