/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslTplKey;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CslRptKey {
    private String companyNumber = null;
    private RptPeriodTypeEnum periodType = null;
    private Integer year = null;
    private Integer period = null;
    private String currencyNumber = null;
    private static List listInstances = new ArrayList();
    private static Map companyIndex = new HashMap();
    private static Map periodTypeIndex = new HashMap();
    private static Map yearIndex = new HashMap();
    private static Map periodIndex = new HashMap();
    private static Map currencyIndex = new HashMap();

    private CslRptKey(String companyNumber, RptPeriodTypeEnum periodType, Integer year, Integer period, String currencyNumber) {
        this.companyNumber = companyNumber;
        this.periodType = periodType;
        this.year = year;
        this.period = period;
        this.currencyNumber = currencyNumber;
        listInstances.add(this);
        if (!companyIndex.containsKey(companyNumber)) {
            companyIndex.put(companyNumber, new HashSet());
        }
        ((Set)companyIndex.get(companyNumber)).add(this);
        if (!periodTypeIndex.containsKey(periodType)) {
            periodTypeIndex.put(periodType, new HashSet());
        }
        ((Set)periodTypeIndex.get(periodType)).add(this);
        if (!yearIndex.containsKey(year)) {
            yearIndex.put(year, new HashSet());
        }
        ((Set)yearIndex.get(year)).add(this);
        if (!periodIndex.containsKey(period)) {
            periodIndex.put(period, new HashSet());
        }
        ((Set)periodIndex.get(period)).add(this);
        if (!currencyIndex.containsKey(currencyNumber)) {
            currencyIndex.put(currencyNumber, new HashSet());
        }
        ((Set)currencyIndex.get(currencyNumber)).add(this);
    }

    public static CslRptKey getInstance(String companyNumber, RptPeriodTypeEnum periodType, Integer year, Integer period, String currencyNumber) throws BOSException {
        if (companyNumber == null || periodType == null || year == null || period == null || currencyNumber == null) {
            throw new BOSException("Company, period type, year, period or currency cannot be null!");
        }
        CslRptKey result = CslRptKey.getKey(companyNumber, periodType, year, period, currencyNumber);
        if (result == null) {
            result = new CslRptKey(companyNumber, periodType, year, period, currencyNumber);
        }
        return result;
    }

    private static CslRptKey getKey(String companyNumber, RptPeriodTypeEnum periodType, Integer year, Integer period, String currencyNumber) {
        if (companyNumber == null || periodType == null || year == null || period == null || currencyNumber == null) {
            throw new RuntimeException("Company, period type, year, period or currency cannot be null!");
        }
        if (companyIndex.containsKey(companyNumber) && periodTypeIndex.containsKey(periodType) && yearIndex.containsKey(year) && periodIndex.containsKey(period) && currencyIndex.containsKey(currencyNumber)) {
            Set set;
            Set companySet = (Set)companyIndex.get(companyNumber);
            Set periodTypeSet = (Set)periodTypeIndex.get(periodType);
            Set yearSet = (Set)companyIndex.get(year);
            Set periodSet = (Set)companyIndex.get(period);
            Set currencySet = (Set)companyIndex.get(currencyNumber);
            if (companySet != null && periodTypeSet != null && yearSet != null && periodSet != null && currencySet != null && (set = CslRptUtil.join(CslRptUtil.join(CslRptUtil.join(CslRptUtil.join(companySet, periodTypeSet), yearSet), periodSet), currencySet)).size() == 1) {
                return (CslRptKey)set.iterator().next();
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CslRptKey) {
            CslRptKey key = (CslRptKey)obj;
            return this.getCompanyNumber().equals(key.getCompanyNumber()) && this.getCurrencyNumber().equals(key.getCurrencyNumber()) && this.getPeriod().equals(key.getPeriod()) && this.getPeriodType().equals((Object)key.getPeriodType()) && this.getYear().equals(key.getYear());
        }
        return false;
    }

    public boolean equalsTpl(CslTplKey key) {
        if (key == null) {
            return false;
        }
        return this.getCompanyNumber().equals(key.getCompanyNumber()) && this.getPeriodType().equals((Object)key.getPeriodType());
    }

    public int hashCode() {
        return (this.companyNumber + this.periodType + this.year + this.period + this.currencyNumber).hashCode();
    }

    public String toString() {
        return "<<Company:" + this.companyNumber + ", periodType:" + this.periodType + ", year:" + this.year + ", period:" + this.period + ", Currency:" + this.currencyNumber + ">>";
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public RptPeriodTypeEnum getPeriodType() {
        return this.periodType;
    }

    public Integer getYear() {
        return this.year;
    }
}

