/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslRptSummitedStatusListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CheckFormulaUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptGroupCommitUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Observable;

public class CslRptSummitedStatusListUI
extends AbstractCslRptSummitedStatusListUI
implements ICSLContextUI {
    private CommonQueryDialog dialog = null;

    public CslRptSummitedStatusListUI() throws Exception {
        this.initUI();
    }

    private void initUI() {
        this.btnSummit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnUnSummit.setIcon(EASResource.getIcon((String)"imgTbtn_unsubmit"));
        this.btnSummitByTime.setIcon(EASResource.getIcon((String)"imgTbtn_timingrefer"));
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnFilter.setText("");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            CSLContextHelper.registUIObject(this);
            this.actionSummitByTime.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionAddNew.setEnabled(false);
            this.actionAddNew.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionView.setEnabled(true);
            this.actionView.setVisible(true);
            this.actionLocate.setVisible(false);
            this.actionLocate.setEnabled(false);
            this.actionQuery.setVisible(false);
            this.actionQuery.setEnabled(false);
            this.initFindUI();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return CslRptGroupCommitUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceType"));
        CslReportInfo report = (CslReportInfo)CslReportFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())), sic);
        String editName = null;
        editName = report.getSourceType() == RptSrcTypeEnum.NORMAL ? GroupRptEditUI.class.getName() : CslRptEditUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
        this.refresh(e);
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        this.initFindUI();
    }

    @Override
    public void actionSummitByTime_actionPerformed(ActionEvent e) throws Exception {
        super.actionSummitByTime_actionPerformed(e);
    }

    @Override
    public void actionSummit_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow;
        UIContext uiContext;
        super.actionSummit_actionPerformed(e);
        if (MsgBox.showConfirm2((Component)((Object)this), (String)CslRptUtil.getString("CslRptSummittedNeedCheck")) == 0) {
            uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(CheckFormulaUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            this.refresh(e);
        }
        uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(CslRptGroupCommitUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionUnSummit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSummit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isUnCommit", (Object)true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(CslRptGroupCommitUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    protected void initFindUI() throws Exception {
        CommonQueryDialog commonQD = this.getQueryDialog();
        if (commonQD != null && commonQD.show()) {
            try {
                EntityViewInfo view = commonQD.getEntityViewInfoResult();
                FilterInfo filter = view.getFilter();
                FilterItemCollection fic = filter.getFilterItems();
                StringBuffer sbNewMask = new StringBuffer();
                int n = fic.size();
                fic.add(new FilterItemInfo("orgTree.id", (Object)CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString()));
                if (n == 0) {
                    sbNewMask.append("#0");
                } else {
                    sbNewMask = sbNewMask.append(filter.getMaskString()).append(" and #").append(n++);
                }
                ICSLContext ctx = CSLContextHelper.getCSLContext();
                String curOrgGrpNumber = CslRptUIUtil.getCompanyStructureNumber(ctx.getCurOrgBound(), ctx.getCurOrgGroup());
                fic.add(new FilterItemInfo("orgStructure.longNumber", (Object)(curOrgGrpNumber + "!%"), CompareType.LIKE));
                fic.add(new FilterItemInfo("orgStructure.longNumber", (Object)curOrgGrpNumber, CompareType.EQUALS));
                int n2 = ++n;
                int n3 = ++n;
                sbNewMask.append(" and (#" + n2 + " or #" + n3 + ")");
                fic.add(new FilterItemInfo("period", (Object)new Integer(CSLContextHelper.getCSLContext().getCurRptPeriod())));
                int n4 = ++n;
                sbNewMask = sbNewMask.append(" and #").append(n4);
                fic.add(new FilterItemInfo("year", (Object)new Integer(CSLContextHelper.getCSLContext().getCurRptYear())));
                int n5 = ++n;
                ++n;
                sbNewMask = sbNewMask.append(" and #").append(n5);
                filter.setMaskString(sbNewMask.toString());
                this.mainQuery = view;
                this.execQuery();
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        } else {
            SysUtil.abort();
        }
    }

    public CommonQueryDialog getQueryDialog() {
        if (this.dialog == null) {
            try {
                this.dialog = new CommonQueryDialog();
                this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
                this.dialog.setParentUIClassName("com.kingdee.eas.fi.gr.cslrpt.client.CslRptSummitedStatusListUI");
                this.dialog.setQueryObjectPK(this.mainQueryPK);
                CslRptUIUtil.standardFilterUI(this.dialog, this);
                this.dialog.setShowFilter(true);
                this.dialog.setShowSorter(true);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.dialog;
    }
}

