/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DispenseSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ITempletDispense;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractCslTemplateDispenseUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class CslTemplateDispenseUI
extends AbstractCslTemplateDispenseUI {
    protected static final String REPORT_FIELDINFO_TREENUMBER = "FTreeNumber";
    protected static final String REPORT_FIELDINFO_TREENAME = "FTreeName";
    protected static final String REPORT_FIELDINFO_UNITNUMBER = "FUnitNumber";
    protected static final String REPORT_FIELDINFO_UNITNAME = "FUnitName";
    protected static final String REPORT_FIELDINFO_SOURCETEMPNUMBER = "FSourceTmpNumber";
    protected static final String REPORT_FIELDINFO_SOURCETEMPNAME = "FSourceTmpName";
    protected static final String REPORT_FIELDINFO_TARGETTEMPNUMBER = "FTargetTmpNumber";
    protected static final String REPORT_FIELDINFO_TARGETTEMPNAME = "FTargetTmpName";
    protected static final String REPORT_FIELDINFO_ITEMFORMULA = "FItemFormula";
    protected static final String REPORT_FIELDINFO_TEMPLATETYPE = "FTemplateType";
    protected static final String REPORT_FIELDINFO_PERIODTYPE = "FPeriodType";
    private TemplateInfo templateInfo = null;
    private ITempletDispense templetDispense;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParament();
        this.loadOrgBound();
        this.setUITitle(this.getUITitle() + " - " + this.templateInfo.getTemplateType().toString());
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void okAction_actionPerformed(ActionEvent e) throws Exception {
        super.okAction_actionPerformed(e);
        this.templetDispense = TempletDispenseFactory.getRemoteInstance();
        ArrayList selectedBound = this.getSelectedOrgBounds();
        if (selectedBound == null || selectedBound.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NoFindOrgBound"));
            SysUtil.abort();
        }
        ArrayList assignedBounds = this.getAssignedOrgBounds(this.templateInfo.getId().toString(), selectedBound);
        ArrayList unAssignedBoundIDs = new ArrayList();
        if (assignedBounds != null && assignedBounds.size() > 0) {
            for (int i = 0; i < selectedBound.size(); ++i) {
                Object bound = selectedBound.get(i);
                if (assignedBounds.contains(bound)) continue;
                unAssignedBoundIDs.add(bound);
            }
        } else {
            unAssignedBoundIDs = selectedBound;
        }
        if (unAssignedBoundIDs.size() != 0) {
            try {
                this.checkTemplateItemDup(unAssignedBoundIDs, this.templateInfo.getId().toString());
                this.submitTempletDispense(unAssignedBoundIDs, this.templateInfo.getId().toString());
            }
            catch (BOSException e1) {
                super.handUIException((Throwable)e1);
            }
            catch (EASBizException e2) {
                super.handUIException((Throwable)e2);
            }
        }
        MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_Success"), this.templateInfo.getName()));
        this.destroyWindow();
    }

    private ArrayList getAssignedOrgBounds(String templateID, ArrayList selectedBound) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        HashSet selectedBounds = CslRptUtil.AryListToHashSet(selectedBound);
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("dispenseSrcID", (Object)templateID));
        fic.add(new FilterItemInfo("orgBound.id", (Object)selectedBounds, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
        TempletDispenseCollection tmpdiscoll = this.templetDispense.getTempletDispenseCollection(view);
        ArrayList<String> result = new ArrayList<String>();
        if (tmpdiscoll != null && tmpdiscoll.size() > 0) {
            int n = tmpdiscoll.size();
            for (int i = 0; i < n; ++i) {
                TempletDispenseInfo info = tmpdiscoll.get(i);
                result.add(info.getOrgBound().getId().toString());
            }
        }
        return result;
    }

    private OrgTreeCollection getOrgTreeCollection() throws EASBizException, BOSException {
        return CslRptUIUtil.getOrgTreeCollection();
    }

    private ArrayList getSelectedOrgBounds() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.tblOrgTree.getRowCount(); ++i) {
            IRow curRow = this.tblOrgTree.getRow(i);
            boolean isSelected = (Boolean)curRow.getCell("select").getValue();
            if (!isSelected) continue;
            result.add(curRow.getCell("id").getValue().toString());
        }
        return result;
    }

    private void checkTemplateItemDup(ArrayList boundIDs, String string) throws BOSException {
        String report = null;
        report = CslTemplateDispenseUI.getReportString(this.templetDispense.checkCslTemplateDispense(boundIDs, string), true);
        if (report == null || report.length() == 0) {
            return;
        }
        SimpleNotePad.showMessageByModel(new UIContext((Object)this), report);
        SysUtil.abort();
    }

    protected static String getReportString(IRowSet rs, boolean isCslTemplet) {
        if (rs == null) {
            return "";
        }
        StringBuffer report = new StringBuffer();
        ArrayList<String> listParams = new ArrayList<String>(3);
        int index = 0;
        StringBuffer keyString = new StringBuffer();
        HashMap<String, String> ls = new HashMap<String, String>();
        Object[] params = null;
        String line = null;
        String pattern1 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult1");
        String pattern2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult2");
        String pattern3 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult3");
        String pattern4 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult4");
        String pattern5 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckResult5");
        String explain = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Template_AsignCsl_CheckExplain");
        try {
            while (rs.next()) {
                keyString = new StringBuffer();
                if (!isCslTemplet) {
                    keyString.append(rs.getString(REPORT_FIELDINFO_UNITNUMBER));
                    keyString.append("!");
                    keyString.append(rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER));
                } else {
                    keyString.append(rs.getString(REPORT_FIELDINFO_TREENUMBER));
                    keyString.append("!");
                    keyString.append(rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER));
                }
                if (index == 0) {
                    params = new Object[]{rs.getString(REPORT_FIELDINFO_SOURCETEMPNUMBER), rs.getString(REPORT_FIELDINFO_SOURCETEMPNAME)};
                    line = MessageFormat.format(pattern1, params);
                    report.append(line);
                    report.append(explain).append("\r\n");
                }
                if (isCslTemplet && !ls.containsKey(keyString.toString()) || !isCslTemplet && index == 0) {
                    params = new Object[]{rs.getString(REPORT_FIELDINFO_TREENUMBER), rs.getString(REPORT_FIELDINFO_TREENAME)};
                    line = MessageFormat.format(pattern2, params);
                    report.append(line);
                }
                if (!isCslTemplet && !ls.containsKey(keyString.toString())) {
                    params = new Object[]{rs.getString(REPORT_FIELDINFO_UNITNUMBER), rs.getString(REPORT_FIELDINFO_UNITNAME)};
                    line = MessageFormat.format(pattern3, params);
                    report.append(line);
                }
                if (!ls.containsKey(keyString.toString())) {
                    params = new Object[]{rs.getString(REPORT_FIELDINFO_TARGETTEMPNUMBER), rs.getString(REPORT_FIELDINFO_TARGETTEMPNAME)};
                    line = MessageFormat.format(pattern4, params);
                    report.append(line);
                }
                listParams.clear();
                listParams.add(rs.getString("FTrgtSheetname"));
                listParams.add(rs.getString("fTrgtCellName"));
                listParams.add(rs.getString(REPORT_FIELDINFO_ITEMFORMULA));
                params = new Object[]{rs.getString(REPORT_FIELDINFO_ITEMFORMULA)};
                line = MessageFormat.format(pattern5, listParams.toArray());
                report.append(line);
                report.append(" \r\n");
                if (!ls.containsKey(keyString.toString())) {
                    ls.put(keyString.toString(), "");
                }
                ++index;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        listParams.clear();
        listParams = null;
        String result = report.toString().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        return result;
    }

    private void initParament() {
        this.templateInfo = (TemplateInfo)this.getUIContext().get("template");
    }

    private void loadOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection otc = this.getOrgTreeCollection();
        int count = otc.size();
        this.tblOrgTree.checkParsed();
        this.tblOrgTree.getSelectManager().setSelectMode(2);
        this.tblOrgTree.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblOrgTree.getColumn(3).getStyleAttributes().setLocked(true);
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblOrgTree.addRow();
            row.getCell(0).setValue((Object)otc.get(i).getId());
            row.getCell(1).setValue((Object)false);
            row.getCell(2).setValue((Object)otc.get(i).getNumber());
            row.getCell(3).setValue((Object)otc.get(i).getName());
            row.getCell(4).setValue((Object)otc.get(i));
        }
    }

    private void submitTempletDispense(ArrayList unAssignedBoundIDs, String templateID) throws EASBizException, BOSException {
        for (Object tmpObj : unAssignedBoundIDs) {
            String orgBoundID;
            if (tmpObj == null || !(tmpObj instanceof String) || (orgBoundID = (String)tmpObj).trim().length() <= 0) continue;
            TempletDispenseInfo tmpInfo = new TempletDispenseInfo();
            tmpInfo.setDispenseSrcID(this.templateInfo.getId().toString());
            tmpInfo.setSourceType(DispenseSrcTypeEnum.RPTTEMPLET);
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.setId(BOSUuid.read((String)orgBoundID));
            tmpInfo.setOrgBound(orgTree);
            this.templetDispense.addnew((CoreBaseInfo)tmpInfo);
        }
    }
}

