/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CyconvtDataElementMappingFactory;
import com.kingdee.eas.fi.gr.cslrpt.CyconvtDataElementMappingInfo;
import com.kingdee.eas.fi.gr.cslrpt.SysDataElementEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDataElementMappintListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class DataElementMappintListUI
extends AbstractDataElementMappintListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataElementMappintListUI.class);
    private static final Object[] SYS_DATAELEMENTS = SysDataElementEnum.getEnumList().toArray();
    private static final String SYSDATAELEMENT = "mappingRela.sysDataElement";
    private boolean selfGradeOnly = false;
    private OrgUnitInfo company = null;

    public DataElementMappintListUI() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.company = SysContext.getSysContext().getCurrentOrgUnit();
        this.addTblDataFillListener();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSelfAndAllSwitch.setIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
        this.btnUpdateMaintainOrg.setIcon(EASResource.getIcon((String)"imgTbtn_organigerlist"));
        this.tblMain.getColumn(SYSDATAELEMENT).getStyleAttributes().setLocked(false);
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (DataElementMappintListUI.this.tblMain.getColumn(e.getColumnIndex()) != null && DataElementMappintListUI.SYSDATAELEMENT.equals(DataElementMappintListUI.this.tblMain.getColumn(e.getColumnIndex()).getKey())) {
                    DataElementMappintListUI.this.addComboBoxToTable(e);
                }
            }
        });
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        CslGradeManageUtil.showBtnByCurrentOrg((KDWorkButton)this.btnUpdateMaintainOrg);
    }

    private void addTblDataFillListener() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                DataElementMappintListUI.this.fillTable(e);
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    private void addComboBoxToTable(KDTActiveCellEvent e) {
        KDComboBox comboBox = new KDComboBox();
        comboBox.addItem((Object)"");
        comboBox.addItems(SYS_DATAELEMENTS);
        if (!this.tblMain.getCell(e.getRowIndex(), "trackRecordCreatorid").getValue().equals(this.company.getId().toString())) {
            comboBox.setEnabled(false);
        }
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
        ICell cell = this.tblMain.getCell(e.getRowIndex(), e.getColumnIndex());
        SysDataElementEnum value = this.getEnumValueFromCell(cell);
        if (value != null) {
            comboBox.setSelectedItem((Object)value);
        }
        cell.setEditor((ICellEditor)editor);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CyconvtDataElementMappingFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int confirm;
        ArrayList<CyconvtDataElementMappingInfo> dataMappings = new ArrayList<CyconvtDataElementMappingInfo>();
        HashSet<Object> savedNumber = new HashSet<Object>();
        int rowCount = this.tblMain.getRowCount();
        boolean hasUnMappedItem = false;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell cell = row.getCell(SYSDATAELEMENT);
            SysDataElementEnum value = this.getEnumValueFromCell(cell);
            if (value != null) {
                Object number = row.getCell("number").getValue();
                if (number == null || savedNumber.contains(number)) continue;
                CyconvtDataElementMappingInfo mappingInfo = new CyconvtDataElementMappingInfo();
                mappingInfo.put("mappingRela.number", number);
                mappingInfo.setSysDataElement(value);
                dataMappings.add(mappingInfo);
                savedNumber.add(number);
                continue;
            }
            hasUnMappedItem = true;
        }
        if (hasUnMappedItem && (confirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NO_MAPPED_DATAELMENT"))) != 0) {
            this.abort();
        }
        try {
            CyconvtDataElementMappingFactory.getRemoteInstance().saveAll(dataMappings);
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
            this.abort();
        }
        this.showSaveSuccess();
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.clearCache();
        super.actionRefresh_actionPerformed(e);
    }

    private void clearCache() {
        ICacheService svc = CacheServiceFactory.getInstance();
        svc.discardType(new BOSObjectType("B9E6C0CE"));
    }

    private SysDataElementEnum getEnumValueFromCell(ICell cell) {
        SysDataElementEnum value = null;
        if (cell.getValue() != null && cell.getValue() instanceof SysDataElementEnum) {
            value = (SysDataElementEnum)((Object)cell.getValue());
        } else if (cell.getValue() != null && cell.getValue() instanceof BizEnumValueInfo) {
            BizEnumValueInfo bizEnumInfo = (BizEnumValueInfo)cell.getValue();
            for (SysDataElementEnum sysDataElementEnum : SysDataElementEnum.getEnumList()) {
                if (!sysDataElementEnum.getAlias().equals(bizEnumInfo.getAlias())) continue;
                value = sysDataElementEnum;
                break;
            }
        }
        return value;
    }

    private void showSaveSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.showMessage();
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg((String)"T_CSL_DataElement", (String)"FTrackRecordCreatorID", (ArrayList)this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        boolean find = false;
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)DataElementListUI.class.getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData((FilterInfo)filterInfo, (String)"trackRecordCreator.id", (String)DataElementListUI.class.getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }
}

