/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDiffTableListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.DiffTableEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.DiffTableProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DiffTableListUI
extends AbstractDiffTableListUI
implements ICSLContextUI {
    private static final Logger logger = Logger.getLogger(DiffTableListUI.class);
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    CommonQueryDialog conditionDialog = null;
    GroupRptFilterUI conditionPanel = null;
    private FilterInfo currentFilter = null;

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt", (String)"DiffTableRptQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            CslRptUIUtil.standardFilterUI(this.conditionDialog, this);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(DiffTableListUI.class.getName());
        }
        return this.conditionDialog;
    }

    public GroupRptFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new GroupRptFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            CSLContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 5);
        this.btnBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnBatchUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemBatchAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemBatchUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return DiffTableEditUI.class.getName();
    }

    protected String getObjectUpdateId() {
        return super.getSelectedKeyValue();
    }

    protected CslReportInfo getReportInfo(String reportID) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), this.getSelectors());
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    private void openCheck(CslReportInfo report) {
        if (report.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsGroupCommited"));
            SysUtil.abort();
        }
        if (report.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AUDITTED_REPORT_CANNOT_MODIFY"));
            SysUtil.abort();
        }
        if (PublishedStatusEnum.PUBLISHED.equals((Object)report.getPublishedStatus())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsPublished"));
            SysUtil.abort();
        }
        super.requestObjectLock(this.getObjectUpdateId());
    }

    private void openReport(String state) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        CslReportInfo report = this.getReportInfo(id);
        if (OprtState.EDIT.equals(state)) {
            this.openCheck(report);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        String processUI = DiffTableProcessUI.class.getName();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, state);
        window.show();
    }

    public void refreshOnClose(IUIWindow uiWindow) {
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        WindowAdapter listenerForEditWindow = null;
        listenerForEditWindow = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                try {
                    if (SysContext.getSysContext().getSessionID() != null) {
                        DiffTableListUI.this.setLocatePre(false);
                        DiffTableListUI.this.refresh(null);
                        DiffTableListUI.this.setLocatePre(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        window.addWindowListener(listenerForEditWindow);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.EDIT);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = DiffTableListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.conditionDialog == null) {
                this.conditionDialog = this.initCommonQueryDialog();
            }
            if (this.conditionDialog.show()) {
                this.doQuery(this.conditionDialog);
                this.mainQuery = this.conditionDialog.getEntityViewInfoResult();
                this.currentFilter = this.mainQuery.getFilter();
            } else {
                SysUtil.abort();
            }
        } else if (this.mainQuery != null) {
            this.currentFilter = this.mainQuery.getFilter();
        }
        this.filterQuery();
        String format = CslRptUIUtil.getNationalTimeFormatString();
        if (format != null) {
            this.tblMain.getColumn("year").getStyleAttributes().setNumberFormat("@");
            this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(format);
            this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
        }
    }

    private void filterQuery() throws Exception {
        FilterInfo filter;
        FilterItemCollection fic;
        int periodType = this.ctx.getCurRptPeriodType().getValue();
        int year = this.ctx.getCurRptYear();
        int period = this.ctx.getCurRptPeriod();
        String orgBoundId = this.ctx.getCurOrgBound().getId().toString();
        String orgUnitId = this.ctx.getCurOrgGroup().getId().toString();
        if (this.currentFilter == null) {
            this.currentFilter = new FilterInfo();
        }
        if ((fic = (filter = (FilterInfo)this.currentFilter.clone()).getFilterItems()) == null) {
            fic = new FilterItemCollection();
        }
        StringBuffer maskString = new StringBuffer();
        int index = fic.size();
        if (filter.getMaskString() != null) {
            maskString.append("(" + filter.getMaskString() + ")");
        }
        fic.add(new FilterItemInfo("orgTree.id", (Object)orgBoundId, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("periodType", (Object)new Integer(periodType), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("year", (Object)new Integer(year), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("period", (Object)new Integer(period), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("dataCollectNumber", (Object)this.ctx.getCurDataCollect().getNumber(), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        String ms = maskString.toString();
        if (ms.startsWith(" and ")) {
            ms = ms.substring(" and ".length());
        }
        filter.setMaskString(ms);
        this.mainQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().get() != null && this.tblMain.getSelectManager().get().getMode() == 8) {
            this.checkSelected();
            if (!this.confirmRemove()) {
                return;
            }
            RealModeIDList selectIDs = new RealModeIDList();
            ArrayList ids = this.getSelectedIdValues();
            String removeID = null;
            for (int i = 0; i < ids.size(); ++i) {
                selectIDs.add((String)ids.get(i));
            }
            StringBuffer errorDetailMSG = new StringBuffer();
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            String s1 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_0");
            String s2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_1");
            for (int i = selectIDs.size() - 1; i >= 0; --i) {
                try {
                    this.setOprtState("REMOVE");
                    this.pubFireVOChangeListener(selectIDs.getLastID());
                }
                catch (Throwable ex) {
                    errorDetailMSG.append(s1);
                    errorDetailMSG.append(i + 1);
                    errorDetailMSG.append(s2);
                    errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                    errorDetailMSG.append("\n");
                    continue;
                }
                try {
                    removeID = selectIDs.getLastID();
                    this.runRemove((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectIDs.getLastID())));
                    this.pubFireVOChangeListener(selectIDs.getLastID());
                    this.tblMain.removeRow(i);
                    removeID = selectIDs.getLastID();
                    continue;
                }
                catch (ObjectNotFoundException onfe) {
                    logger.error((Object)"ObjectNotFoundException", (Throwable)onfe);
                    EASBizException ex = new EASBizException(EASBizException.CHECKEXIST);
                    errorDetailMSG.append(s1);
                    errorDetailMSG.append(i + 1);
                    errorDetailMSG.append(s2);
                    errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)ex));
                    errorDetailMSG.append("\n");
                    continue;
                }
                catch (Throwable e1) {
                    logger.error((Object)"Throwable", e1);
                    errorDetailMSG.append(s1);
                    errorDetailMSG.append(i + 1);
                    errorDetailMSG.append(s2);
                    errorDetailMSG.append(ExceptionMessageUtility.getMessage((Throwable)e1));
                    errorDetailMSG.append("\n");
                    continue;
                }
                finally {
                    try {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener(selectIDs.getLastID());
                        selectIDs.remove(removeID, true);
                    }
                    catch (Throwable e1) {
                        logger.error((Object)"Throwable", e1);
                    }
                }
            }
            if (errorDetailMSG.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.afterRemove();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    protected ArrayList getSelectedIdValues() {
        if (this.tblMain.getSelectManager().get() != null && this.tblMain.getSelectManager().get().getMode() == 8) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id;
                ICell cell = this.tblMain.getRow(i).getCell(this.getKeyFieldName());
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if (list.contains(id = cell.getValue().toString())) continue;
                list.add(id);
            }
            return list;
        }
        return super.getSelectedIdValues();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.VIEW);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            if (this.btnView.isVisible() && this.btnView.isEnabled()) {
                this.actionView_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.FI_GR_CSLREPORT;
    }

    @Override
    public void actionBatchAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        CslRptUIUtil.batchAudit(this, this.tblMain, list);
    }

    @Override
    public void actionBatchUnAudit_actionPerformed(ActionEvent e) throws Exception {
        String s;
        String oql;
        List list = this.getSelectedIdValues();
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean isFirst = true;
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            if (!isFirst) {
                ids.append(",");
            }
            ids.append("'").append(id).append("'");
            isFirst = false;
        }
        ISumRptRela is = SumRptRelaFactory.getRemoteInstance();
        if (is.exists(oql = " where reportId in (" + ids.toString() + ")") && MsgBox.showConfirm2((Component)((Object)this), (String)(s = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"428_DiffTableListUI"))) == 2) {
            return;
        }
        list = CslReportFactory.getRemoteInstance().getAuditedReportIds(list);
        if (list == null || list.isEmpty()) {
            return;
        }
        CslRptUIUtil.batchUnAudit(this, this.tblMain, list);
    }
}

