/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.BackedReportFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDiffTableProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.cslrpt.client.report.DiffTableMenuManager;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLIOUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportStyleCover;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.CSLCommentsCollection;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;

public class DiffTableProcessUI
extends AbstractDiffTableProcessUI
implements ICSLContextUI {
    private String currentFilePath = null;

    public DiffTableProcessUI() throws Exception {
        this.setReportStyleCover(new ReportStyleCover(){

            public TemplateCollection GetCanUseTemplateSet() throws Exception {
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gr.cslrpt", "SumTemplateQuery"));
                exec.option().isAutoTranslateEnum = true;
                int index = 1;
                Map mapLinkOpenParam = (Map)DiffTableProcessUI.this.getUIContext().get("KEY_LINKOPENRPT_PARAM");
                ICSLContext cslCtx = null;
                cslCtx = mapLinkOpenParam != null ? CSLContextHelper.getCSLContext(mapLinkOpenParam) : CSLContextHelper.getCSLContext();
                exec.setParameter(index++, (Object)(cslCtx.getCurOrgBound() == null ? "" : cslCtx.getCurOrgBound().getId().toString()));
                exec.setParameter(index++, (Object)(cslCtx.getCurRptPeriodType() == null ? new Integer(-10000) : new Integer(cslCtx.getCurRptPeriodType().getValue())));
                exec.setParameter(index++, (Object)(cslCtx.getCurOrgGroup() == null ? "" : cslCtx.getCurOrgGroup().getId().toString()));
                EntityViewInfo querySumTemplateQuery = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                querySumTemplateQuery.setFilter(filter);
                index = filter.getFilterItems().size();
                StringBuffer maskString = new StringBuffer();
                if (filter.getMaskString() == null || filter.getMaskString().length() == 0) {
                    maskString.append(" #").append(index++);
                } else {
                    maskString.append(filter.getMaskString());
                    maskString.append(" And #").append(index++);
                }
                filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(8)));
                filter.setMaskString(maskString.toString());
                querySumTemplateQuery.setFilter(filter);
                exec.setObjectView(querySumTemplateQuery);
                IRowSet rowSet = exec.executeQuery();
                TemplateCollection templates = new TemplateCollection();
                while (rowSet.next()) {
                    String id = rowSet.getString("Template.id");
                    TemplateInfo template = new TemplateInfo();
                    template.setId(BOSUuid.read((String)id));
                    templates.add(template);
                }
                return templates;
            }
        });
        this.setMenuStrategy((IMenuStrategy)new DiffTableMenuManager());
        this.setBookProvider(new CslReportProvider());
        this.setPropertyAdapter((IReportPropertyAdapter)new CSLPropertyAdapter());
        this.setVariableProvider(new IReportVariableProvider(){

            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables((String)sheetName, (RptPeriodTypeEnum)DiffTableProcessUI.this.getCslReportProvider().getCSLlReportInfo().getPeriodType());
                variables.addAll(init, false);
            }

            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setEnabled(true);
        this.menuItemCalculator.setVisible(true);
        this.actionCalculate.setEnabled(true);
        this.btnCheckFormula.setVisible(false);
        this.btnBalance.setVisible(false);
        this.btnCheck.setVisible(false);
        Map context = this.getUIContext();
        if (context.get("Owner") instanceof SumRptProcessUI) {
            this.menuItemAudit.setEnabled(false);
        }
    }

    protected void onSheetActive(Sheet sheet) {
        super.onSheetActive(sheet);
        this.miInvestCompanyFill.setVisible(false);
        this.itemCompanyFill.setVisible(false);
        this.getMenuStrategy().enableVisibleMenu("menuData/itemCheckFormula", false, false);
        this.getMenuStrategy().enableVisibleMenu("menuData/itemItemDiffer", false, false);
        this.getMenuStrategy().enableVisibleMenu("menuData/itemCheckAll", false, false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        BackedReportFacadeFactory.getRemoteInstance().saveSendBackedReport(this.getEditData().getId().toString());
        super.actionSave_actionPerformed(e);
        CSLCommentsCollection rs = CslRptUIUtil.getCSLCommentsCollection(this.getBook());
        if (rs != null) {
            rs.setReportInfo((VirtualSheetParamInfo)this.getEditData());
        }
        CslRptUIUtil.saveCSLItemPostil(rs);
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        boolean oldstate = this.getBook().isAutoCalculate();
        boolean isExe = DynaItemListener.getExeFlag();
        if (isExe) {
            DynaItemListener.setExeFlag((boolean)false);
        }
        super.actionCalculate_actionPerformed(e);
        if (isExe) {
            DynaItemListener.setExeFlag((boolean)isExe);
        }
        this.getBook().setCalculate(oldstate);
    }

    protected CslReportProvider getCslReportProvider() {
        return (CslReportProvider)this.getBookProvider();
    }

    private CslReportInfo getEditData() {
        return this.getCslReportProvider().getCSLlReportInfo();
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser(this.currentFilePath);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("");
        fc.addChoosableFileFilter(CSLIOUtils.getExcelFileFilter());
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            int i;
            File file = fc.getSelectedFile();
            String path = file.getAbsolutePath();
            this.currentFilePath = path.substring(0, path.lastIndexOf(File.separatorChar));
            KDSBook book = POIXlsReader.parse((String)path);
            if (book == null) {
                MsgBox.showError((String)CslRptUtil.getString("GroupRptProcessImportOpenFail"));
                return;
            }
            ArrayList<Sheet> rptSheetList = new ArrayList<Sheet>();
            ArrayList<String> xlsSheetList = new ArrayList<String>();
            ArrayList<Integer> matchedRptIndexList = new ArrayList<Integer>();
            ArrayList<Integer> matchedXlsIndexList = new ArrayList<Integer>();
            int n = this.getBook().getSheetCount();
            for (i = 0; i < n; ++i) {
                rptSheetList.add(this.getBook().getSheet(i));
            }
            n = book.getSheetCount();
            for (i = 0; i < n; ++i) {
                xlsSheetList.add(book.getSheet((Object)new Integer(i)).getName());
            }
            int m = rptSheetList.size();
            block2: for (i = 0; i < m; ++i) {
                int n2 = xlsSheetList.size();
                for (int j = 0; j < n2; ++j) {
                    if (!rptSheetList.get(i).toString().equals(xlsSheetList.get(j))) continue;
                    matchedRptIndexList.add(new Integer(i));
                    matchedXlsIndexList.add(new Integer(j));
                    continue block2;
                }
            }
            KDSSheet sheet = null;
            Sheet table = null;
            StringBuffer names = new StringBuffer();
            int n3 = matchedRptIndexList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                table = this.getBook().getSheet(((Integer)matchedRptIndexList.get(i2)).intValue());
                sheet = book.getSheet(matchedXlsIndexList.get(i2));
                if (i2 != 0) {
                    names.append(", ");
                }
                names.append(sheet.getName());
                CslRptUIUtil.copyData(sheet, table, 1, true);
            }
            int size = matchedRptIndexList.size();
            if (size > 0) {
                this.showRichMessage(CslRptUtil.getStringWithFormat("GroupRptProcessImportOK", new Object[]{new Integer(size), names.toString()}), EASResource.getString((String)"promotInfoBox"));
            } else {
                MsgBox.showInfo((String)CslRptUtil.getString("GroupRptProcessImportFail"));
            }
        }
    }
}

