/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaItem2ElimItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.DynaItem2ElimItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDynaItem2ElimItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractDynaItem2ElimItemUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;

public class DynaItem2ElimItemUI
extends AbstractDynaItem2ElimItemUI
implements ICSLContextUI {
    protected EntityViewInfo entityViewInfo = new EntityViewInfo();
    protected int COL_ID = 0;
    protected int COL_DYNAITEM = 1;
    protected int COL_ELIMITEM = 2;
    private IDynaItem2ElimItem id2e = DynaItem2ElimItemFactory.getRemoteInstance();
    protected Integer STATUS_ADDNEW = new Integer(1);
    protected Integer STATUS_DELETE = new Integer(2);
    protected Integer STATUS_UPDATE = new Integer(3);
    private IObjectCollection cacheDataCollection = null;
    private List deleteIdList = new ArrayList();
    private HashMap changedInfosMap = new HashMap();

    public DynaItem2ElimItemUI() throws Exception {
        this.initWorkButton();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("isCompany") == null) {
            if (CSLContextHelper.isInitialized(this.getUIContext())) {
                super.onLoad();
                CSLContextHelper.registUIObject(this);
            } else {
                SysUtil.abort();
            }
        } else if (this.getUIContext().get("isCompany") == null || ((Boolean)this.getUIContext().get("isCompany")).booleanValue()) {
            // empty if block
        }
        this.actionCalculator.setEnabled(false);
        this.actionCalculator.setVisible(false);
        this.initEntryTable();
        this.loadData();
        this.loadFromFields();
    }

    private void loadData() throws BOSException, Exception {
        this.deleteIdList.clear();
        this.cacheDataCollection = this.id2e.getCollection(this.getEntityViewInfo());
        for (DynaItem2ElimItemInfo element : this.cacheDataCollection) {
            this.deleteIdList.add(element.getId());
        }
    }

    private void saveData() throws BOSException, Exception {
        Integer status;
        for (DynaItem2ElimItemInfo element : this.changedInfosMap.keySet()) {
            status = (Integer)this.changedInfosMap.get(element);
            if (status.intValue() != this.STATUS_DELETE.intValue()) continue;
            this.id2e.delete((IObjectPK)new ObjectUuidPK(element.getId()));
        }
        for (DynaItem2ElimItemInfo element : this.changedInfosMap.keySet()) {
            status = (Integer)this.changedInfosMap.get(element);
            if (status.intValue() == this.STATUS_ADDNEW.intValue()) {
                this.id2e.addnew(element);
                continue;
            }
            if (status.intValue() != this.STATUS_UPDATE.intValue()) continue;
            this.id2e.update((IObjectPK)new ObjectUuidPK(element.getId()), element);
        }
    }

    public boolean isModify(AbstractObjectValue oldData, AbstractObjectValue editData) {
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)oldData, (AbstractObjectValue)editData);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.tblMain != null && this.tblMain.getRowCount() > 0) {
            int j = this.tblMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                RPTItemInfo obj2;
                IRow curRow = this.tblMain.getRow(i);
                RPTItemInfo obj1 = (RPTItemInfo)curRow.getCell(this.COL_DYNAITEM).getValue();
                if (obj1 == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Item_Blank"));
                    SysUtil.abort();
                }
                if ((obj2 = (RPTItemInfo)curRow.getCell(this.COL_ELIMITEM).getValue()) == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Item_Blank"));
                    SysUtil.abort();
                }
                if (!obj1.getId().equals((Object)obj2.getId())) continue;
                MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("ItemLinkWithSelf"));
                SysUtil.abort();
            }
        }
    }

    public void loadFromFields() {
        super.loadFields();
        if (this.cacheDataCollection != null && this.cacheDataCollection.size() > 0) {
            int j = this.cacheDataCollection.size();
            for (int i = 0; i < j; ++i) {
                DynaItem2ElimItemInfo dataInfo = (DynaItem2ElimItemInfo)this.cacheDataCollection.getObject(i);
                IRow curRow = this.tblMain.addRow();
                curRow.getCell(this.COL_ID).setValue((Object)dataInfo.getId().toString());
                curRow.getCell(this.COL_DYNAITEM).setValue((Object)dataInfo.getDynaItem());
                curRow.getCell(this.COL_ELIMITEM).setValue((Object)dataInfo.getElimItem());
            }
        } else if (this.cacheDataCollection != null && this.cacheDataCollection.size() == 0) {
            this.tblMain.addRow();
        }
    }

    public void storeToFields() {
        this.changedInfosMap.clear();
        if (this.tblMain != null && this.tblMain.getRowCount() > 0) {
            DynaItem2ElimItemInfo dataInfo = null;
            int j = this.tblMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                IRow curRow = this.tblMain.getRow(i);
                Object obj = curRow.getCell("id").getValue();
                dataInfo = obj != null ? (DynaItem2ElimItemInfo)((DynaItem2ElimItemInfo)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj)))).clone() : new DynaItem2ElimItemInfo();
                dataInfo.setDynaItem((RPTItemInfo)curRow.getCell(this.COL_DYNAITEM).getValue());
                dataInfo.setElimItem((RPTItemInfo)curRow.getCell(this.COL_ELIMITEM).getValue());
                if (obj == null) {
                    this.changedInfosMap.put(dataInfo, this.STATUS_ADDNEW);
                    continue;
                }
                this.deleteIdList.remove(dataInfo.getId());
                if (!this.isModify((AbstractObjectValue)dataInfo, (AbstractObjectValue)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj))))) continue;
                this.changedInfosMap.put(dataInfo, this.STATUS_UPDATE);
            }
        }
        for (BOSUuid element : this.deleteIdList) {
            this.changedInfosMap.put(this.cacheDataCollection.getObject((Object)element), this.STATUS_DELETE);
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        this.tblMain.addRow();
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelRow_actionPerformed(e);
        if (this.tblMain.getSelectManager().size() > 0) {
            this.deleteSelectedRows();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void deleteSelectedRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        Object[] index = list.toArray();
        Arrays.sort(index);
        for (int i = index.length; i > 0; --i) {
            this.tblMain.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.loadData();
        this.loadFromFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.beforeExit(e);
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.beforeExit(null);
        }
        catch (Exception e) {
            if (e instanceof AbortException) {
                return false;
            }
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    private void beforeExit(ActionEvent e) throws Exception {
        this.storeToFields();
        if (this.changedInfosMap.size() != 0) {
            if (this.cacheDataCollection.size() == 0 && this.changedInfosMap.size() == 1 && this.tblMain.getRow(0).getCell(0).getValue() == null && this.tblMain.getRow(0).getCell(1).getValue() == null) {
                return;
            }
            int status = MsgBox.showConfirm3((String)CslRptUtil.getString("D2EHintBeforeSave"));
            if (status == 2) {
                SysUtil.abort();
            } else if (status == 0) {
                this.tblMain.getEditManager().stopEditing();
                this.actionSave_actionPerformed(e);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        long startTime = System.currentTimeMillis();
        super.actionSave_actionPerformed(e);
        this.beforeStoreFields(e);
        this.storeToFields();
        try {
            this.saveData();
        }
        catch (Exception exc) {
            this.loadData();
            throw exc;
        }
        this.actionRefresh_actionPerformed(e);
        long counter = System.currentTimeMillis() - startTime;
        BigDecimal time = new BigDecimal(String.valueOf((double)counter / 1000.0)).setScale(2, 4);
        Object[] param = new Object[]{time.toString()};
        super.setMessageText(CslRptUtil.getStringWithFormat("D2ESaveOK", param));
        super.showMessage();
    }

    @Override
    public void update(Observable o, Object arg) {
        CSLContextHelper.update(o, this);
    }

    public void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject(this);
        super.disposeUIWindow();
    }

    protected EntityViewInfo getEntityViewInfo() {
        this.entityViewInfo.getSelector().clear();
        this.entityViewInfo.put("selector", (Object)this.getSelectorItemCollection());
        this.entityViewInfo.getSorter().clear();
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("dynaItem.number"));
        sorters.add(new SorterItemInfo("elimItem.number"));
        this.entityViewInfo.put("sorter", (Object)sorters);
        return this.entityViewInfo;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("dynaItem.id"));
        sic.add(new SelectorItemInfo("dynaItem.number"));
        sic.add(new SelectorItemInfo("dynaItem.name"));
        sic.add(new SelectorItemInfo("elimItem.id"));
        sic.add(new SelectorItemInfo("elimItem.number"));
        sic.add(new SelectorItemInfo("elimItem.name"));
        return sic;
    }

    private void initEntryTable() throws Exception {
        this.tblMain.checkParsed();
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemForF7Query");
        bizBoxItem.setEditFormat("$name$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        this.tblMain.getColumn(this.COL_DYNAITEM).setEditor((ICellEditor)itemEditor);
        this.tblMain.getColumn(this.COL_ELIMITEM).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$($name$)"));
        this.tblMain.getColumn(this.COL_DYNAITEM).setRenderer((IBasicRender)avr);
        this.tblMain.getColumn(this.COL_ELIMITEM).setRenderer((IBasicRender)avr);
    }
}

