/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AbstractSumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptAddedPerporty;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyCollection;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractEditSumRptVersionInfoUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class EditSumRptVersionInfoUI
extends AbstractEditSumRptVersionInfoUI {
    private static final Logger logger = CoreUIObject.getLogger(EditSumRptVersionInfoUI.class);
    private boolean isSave = false;
    private CslReportInfo curRportInfo = null;
    private String group = null;
    private SumRptAddedPerportyInfo sumRptAddedPerporty = null;

    public void onLoad() throws Exception {
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        CslReportInfo rportInfo = (CslReportInfo)this.getUIContext().get("reportInfo");
        this.curRportInfo = (CslReportInfo)rportInfo.clone();
        if (this.getUIContext().get("isSave") != null) {
            this.isSave = true;
        }
        if (this.isSave) {
            this.setUITitle(this.getUIContext().get("title").toString());
        }
        if (rportInfo != null) {
            this.group = this.getGroup(rportInfo.getId().toString());
            this.txtName.setText(rportInfo.getName());
            this.company.setData((Object)cslCtx.getCurOrgGroup());
            this.periodType.addItem((Object)cslCtx.getCurRptPeriodType());
            this.template.setDisplayFormat("$name$");
            this.template.setData((Object)rportInfo.getTemplate());
            this.currency.setData((Object)rportInfo.getCurrency());
            this.year.setText(String.valueOf(rportInfo.getYear()));
            this.period.setText(String.valueOf(rportInfo.getPeriod()));
            this.reportType.setText(rportInfo.getReportSourceType().getAlias());
            SumRptAddedPerportyCollection sumRptAddedPerportys = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyCollection("select version,remark where report='" + rportInfo.getId().toString() + "'");
            if (sumRptAddedPerportys != null && sumRptAddedPerportys.size() > 0) {
                this.sumRptAddedPerporty = sumRptAddedPerportys.get(0);
                int version = this.sumRptAddedPerporty.getVersion();
                if (version != 0) {
                    if (this.isSave) {
                        this.txtVersion.setText(this.getNextVersion(this.getMaxVersion(this.group, rportInfo.getCurrency().getId().toString())));
                    } else {
                        this.txtVersion.setText(version + "");
                        if (rportInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
                            this.kDButton1.setEnabled(false);
                        }
                    }
                }
                this.remarks.setText(this.sumRptAddedPerporty.getRemark());
            }
        }
        Object owner = this.getUIContext().get("Owner");
        if (this.isSave && (owner instanceof MnsRptProcessUI || owner instanceof SumRptProcessUI)) {
            this.actionOk_actionPerformed(null);
        }
    }

    private void verify() throws EASBizException {
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus();
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_NameNull")));
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionOk_actionPerformed(e);
        this.verify();
        ICslReport ICslRpt = CslReportFactory.getRemoteInstance();
        SumRptAddedPerportyInfo addedPerporty = new SumRptAddedPerportyInfo();
        addedPerporty.setVersion(Integer.parseInt(this.txtVersion.getText()));
        addedPerporty.setRemark(this.remarks.getText());
        addedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        addedPerporty.setGroup(this.group);
        this.curRportInfo.put("addedPerporty", addedPerporty);
        this.curRportInfo.setName(this.txtName.getText());
        if (this.isSave) {
            this.curRportInfo.setId(null);
            if (this.curRportInfo.getCommittedStatus().getValue() > 1) {
                this.curRportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
                this.curRportInfo.setCommitor(null);
                this.curRportInfo.setCommitTime(null);
            }
            if (this.curRportInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
                this.curRportInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                this.curRportInfo.setAuditor(null);
                this.curRportInfo.setAuditTime(null);
            }
            ICslRpt.addnew((CoreBaseInfo)this.curRportInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"370_CslRptUIUtil"));
        } else {
            this.curRportInfo.put("isUpdate", new Boolean(true));
            ICslRpt.update((IObjectPK)new ObjectStringPK(this.curRportInfo.getId().toString()), (CoreBaseInfo)this.curRportInfo);
        }
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof SumRptProcessUI) {
            super.disposeUIWindow();
            owner = ((SumRptProcessUI)owner).getUIContext().get("Owner");
            if (owner instanceof SumRptListUI) {
                ((SumRptListUI)owner).actionRefresh_actionPerformed(e);
            }
        } else if (owner instanceof MnsRptProcessUI && (owner = ((MnsRptProcessUI)owner).getUIContext().get("Owner")) instanceof MnsRptListUI) {
            ((MnsRptListUI)owner).actionRefresh_actionPerformed(e);
        }
    }

    @Override
    public void actionCance_actionPerformed(ActionEvent e) throws Exception {
        super.destroyWindow();
    }

    private String getGroup(String reportid) throws Exception {
        AbstractSumRptAddedPerportyInfo addedPerporty = null;
        String group = Uuid.create().toString();
        ISumRptAddedPerporty iAddedPerporty = SumRptAddedPerportyFactory.getRemoteInstance();
        SumRptAddedPerportyCollection addedPerportys = iAddedPerporty.getSumRptAddedPerportyCollection("where report='" + reportid + "'");
        if (addedPerportys != null && addedPerportys.size() > 0) {
            addedPerporty = addedPerportys.get(0);
        }
        if (addedPerporty == null) {
            SumRptAddedPerportyInfo curAddedPerporty = new SumRptAddedPerportyInfo();
            curAddedPerporty.setId(null);
            curAddedPerporty.setVersion(1);
            curAddedPerporty.setReport(reportid);
            curAddedPerporty.setGroup(group);
            curAddedPerporty.setIsSupportGroup(IsSupportGroupReportEnum.SUPPORT);
            iAddedPerporty.addnew(curAddedPerporty);
        } else if (StringUtils.isEmpty((String)addedPerporty.getGroup())) {
            addedPerporty.setGroup(group);
            iAddedPerporty.update((IObjectPK)new ObjectStringPK(addedPerporty.getId().toString()), (SumRptAddedPerportyInfo)addedPerporty);
        } else {
            group = addedPerporty.getGroup();
        }
        return group;
    }

    private String getNextVersion(int curVersion) {
        if (curVersion == 0) {
            return curVersion + "";
        }
        return curVersion + 1 + "";
    }

    private int getMaxVersion(String group, String currencyId) throws Exception {
        ISumRptAddedPerporty iAddedPerporty = SumRptAddedPerportyFactory.getRemoteInstance();
        return iAddedPerporty.getMaxVersion(group, currencyId);
    }

    public boolean isModify() {
        if (!this.txtName.getText().equals(this.curRportInfo.getName())) {
            return true;
        }
        if (!this.remarks.getText().equals(this.sumRptAddedPerporty.getRemark())) {
            return !StringUtils.isEmpty((String)this.remarks.getText()) || !StringUtils.isEmpty((String)this.sumRptAddedPerporty.getRemark());
        }
        return false;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SumRptAddedPerportyFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.curRportInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) {
            this.actionOk_actionPerformed(e);
        } else {
            this.disposeUIWindow();
        }
    }
}

