/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.HandleModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimControlFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ElimControlFilterUI
extends AbstractElimControlFilterUI {
    private boolean hasLoadInitData;
    private ICSLContext cslCtx = null;
    private String AdjElimRes = "com.kingdee.eas.fi.gr.cslrpt.AdjElimCtrlResource";

    public ElimControlFilterUI() throws Exception {
        this.initComponent();
    }

    public ElimControlFilterUI(ICSLContext cslCtx) throws Exception {
        this.cslCtx = cslCtx;
        this.initComponent();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.cslCtx = CSLContextHelper.getCSLContext();
        }
        return this.cslCtx;
    }

    public void initComponent() throws Exception {
        for (int i = 1; i <= 6; ++i) {
            this.cbxPeriodType.addItem((Object)RptPeriodTypeEnum.getEnum((int)i));
        }
        this.cbxPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
        this.cbxPeriodType.setEnabled(false);
        this.comboHandleType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.gr.cslrpt.HandleModeEnum").toArray());
        this.comboType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"));
        this.comboType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum").toArray());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CslGradeManageUtil.filterElimModeGradeManage((EntityViewInfo)viewInfo, null);
        EliminationModeCollection collection = EliminationModeFactory.getRemoteInstance().getEliminationModeCollection(viewInfo);
        EliminationModeInfo info = new EliminationModeInfo();
        this.comboElimMode.addItem((Object)info);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                this.comboElimMode.addItem((Object)collection.get(i));
            }
        }
        this.initDate();
    }

    private void initDate() throws Exception {
        int[] yp = RPTDateUtil.getRptYearAndPeriod(this.getCSLContext().getCurRptYear(), this.getCSLContext().getCurRptPeriod(), this.getCSLContext().getCurRptPeriodType().getValue(), 0, -1);
        Date periodDate = RPTDateUtil.getPeriodLastDate(yp[0], yp[1], this.getCSLContext().getCurRptPeriodType());
        this.kDSpYear.setEnabled(false);
        this.kDSpPeriod.setEnabled(false);
        this.rptDate.setValue((Object)periodDate);
        this.refreshTimeInfo(periodDate);
    }

    @Override
    protected void cbxPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.refreshTimeInfo(this.rptDate.getSqlDate());
    }

    @Override
    protected void repDate_dataChanged(DataChangeEvent e) throws Exception {
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    private void refreshTimeInfo(Date newDate) throws BOSException {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(newDate, p);
        this.kDSpYear.setValue((Object)new Integer(times.get(0).toString()));
        this.kDSpPeriod.setValue((Object)new Integer(times.get(1).toString()));
        this.rptDate.setValue(times.get(2));
        this.setPeriodForJT13(times);
    }

    private void setPeriodForJT13(List times) throws BOSException {
        String dataCollectNumber;
        DataCollectInfo dataCollect = this.getCSLContext().getCurDataCollect();
        String string = dataCollectNumber = dataCollect != null ? dataCollect.getNumber() : "ACTUALDATA";
        if (dataCollectNumber.equals("ACTUALDATA")) {
            CslRptUtil.setPeriodForJT13(times, (Date)this.rptDate.getValue(), (RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem(), this.kDSpPeriod, this.getCSLContext().getCurRptPeriod());
        } else {
            this.kDSpPeriod.setEnabled(false);
            this.kDSpPeriod.setValue((Object)new Integer(times.get(1).toString()));
            CslRptUIUtil.setSpineRange(this.kDSpPeriod, 0, 365);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException, Exception {
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        this.pp.setString("treeID", this.getCSLContext().getCurOrgBound().getId().toString());
        this.pp.setString("orgUnitID", this.getCSLContext().getCurOrgGroup().getId().toString());
        MergeModeEnum mergeType = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound());
        this.pp.setString("mergeType", String.valueOf(mergeType.getValue()));
        this.pp.setString("company", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this.pp.setObject("dataCollect", this.getCSLContext().getCurDataCollect());
        this.pp.setString("periodType", String.valueOf(this.getCSLContext().getCurRptPeriodType().getValue()));
        for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
            if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != this.getCSLContext().getCurRptPeriodType().getValue()) continue;
            this.cbxPeriodType.setSelectedIndex(j);
        }
        this.initDate();
        this.pp.setString("year", this.kDSpYear.getValue().toString());
        this.pp.setString("period", this.kDSpPeriod.getValue().toString());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
        this.pp.setObject("rptDate", dateFormat.format(this.rptDate.getValue()));
        this.pp.setString("curYear", "0");
        this.pp.setString("curPeriod", "0");
        if (this.comboElimMode.getSelectedItem() != null && ((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId() != null) {
            this.pp.setString("elimMode", ((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString());
        }
        if (this.comboType.getSelectedItem() != null && !this.comboType.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"))) {
            this.pp.setInt("type", ((ElimTypeEnum)((Object)this.comboType.getSelectedItem())).getValue());
        }
        if (this.comboHandleType.getSelectedItem() != null && !this.comboHandleType.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"))) {
            this.pp.setInt("handleType", ((HandleModeEnum)((Object)this.comboHandleType.getSelectedItem())).getValue());
        }
    }

    private void fillDataToUI() throws Exception {
        if (this.pp.containsKey("periodType")) {
            int periodType = Integer.parseInt(this.pp.getString("periodType"));
            for (int j = 0; j < this.cbxPeriodType.getItemCount(); ++j) {
                if (((RptPeriodTypeEnum)this.cbxPeriodType.getItemAt(j)).getValue() != periodType) continue;
                this.cbxPeriodType.setSelectedIndex(j);
                break;
            }
        }
        if (this.pp.containsKey("year")) {
            int year = Integer.valueOf(this.pp.getString("year"));
            this.kDSpYear.setValue((Object)new Integer(year));
        }
        if (this.pp.containsKey("period")) {
            int period = Integer.valueOf(this.pp.getString("period"));
            this.kDSpPeriod.setValue((Object)new Integer(period));
        }
        if (this.pp.containsKey("rptDate")) {
            Date date = new SimpleDateFormat("yy-MM-dd").parse(this.pp.getObject("rptDate").toString());
            this.rptDate.setValue((Object)date);
        }
        if (this.pp.containsKey("handleType")) {
            int handleType2 = Integer.valueOf(this.pp.getString("handleType"));
            HandleModeEnum handleModeEnum = HandleModeEnum.getEnum(handleType2);
            this.comboElimMode.setSelectedItem((Object)handleModeEnum);
        }
        if (this.pp.containsKey("elimMode")) {
            String elimModeId = this.pp.getString("elimMode");
            for (int i = 0; i < this.comboElimMode.getItemCount(); ++i) {
                EliminationModeInfo elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(i);
                if (elimMode == null || !elimModeId.equals(elimMode.getId())) continue;
                this.comboElimMode.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public Object getParam() {
        return this.getCustomCondition();
    }

    @Override
    public RptProperties getCustomCondition() {
        SimpleDateFormat dateFormat;
        if (this.pp == null) {
            this.pp = new RptProperties();
        }
        Integer selectyear = new Integer(this.kDSpYear.getValue().toString());
        Integer selectperiod = new Integer(this.kDSpPeriod.getValue().toString());
        int defaultyear = selectyear;
        int defaultPeriod = selectperiod;
        try {
            defaultyear = this.getCSLContext().getCurRptYear();
            defaultPeriod = this.getCSLContext().getCurRptPeriod();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (selectyear > defaultyear || selectyear == defaultyear && selectperiod >= defaultPeriod) {
            if ("true".equals(this.pp.getString("ListUIIsopened"))) {
                if (this.pp.getString("year") != null) {
                    this.kDSpYear.setValue((Object)Integer.valueOf(this.pp.getString("year")));
                }
                if (this.pp.getString("period") != null) {
                    this.kDSpPeriod.setValue((Object)Integer.valueOf(this.pp.getString("period")));
                }
                dateFormat = new SimpleDateFormat("yy-MM-dd");
                try {
                    this.rptDate.setValue((Object)dateFormat.parse(this.pp.getObject("rptDate").toString()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.AdjElimRes, (String)"Period_Error"));
            SysUtil.abort();
        }
        try {
            this.pp.setString("treeID", this.getCSLContext().getCurOrgBound().getId().toString());
            this.pp.setString("orgUnitID", this.getCSLContext().getCurOrgGroup().getId().toString());
            MergeModeEnum mergeType = CslRptUtil.getMergeMode(this.getCSLContext().getCurOrgBound());
            this.pp.setString("mergeType", String.valueOf(mergeType.getValue()));
            this.pp.setString("company", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            this.pp.setObject("dataCollect", this.getCSLContext().getCurDataCollect());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.pp.setString("periodType", String.valueOf(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue()));
        this.pp.setString("year", this.kDSpYear.getValue().toString());
        this.pp.setString("period", this.kDSpPeriod.getValue().toString());
        dateFormat = new SimpleDateFormat("yy-MM-dd");
        this.pp.setObject("rptDate", dateFormat.format(this.rptDate.getValue()));
        this.pp.setString("curYear", "0");
        this.pp.setString("curPeriod", "0");
        this.pp.setString("ListUIIsopened", "true");
        if (this.comboElimMode.getSelectedItem() != null) {
            if (((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId() != null) {
                this.pp.setString("elimMode", ((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString());
            } else {
                this.pp.remove("elimMode");
            }
        }
        if (this.comboHandleType.getSelectedItem() != null && !this.comboHandleType.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"))) {
            this.pp.setInt("handleType", ((HandleModeEnum)((Object)this.comboHandleType.getSelectedItem())).getValue());
        } else {
            this.pp.remove("handleType");
        }
        if (this.comboType.getSelectedItem() != null && !this.comboType.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll"))) {
            this.pp.setInt("type", ((ElimTypeEnum)((Object)this.comboType.getSelectedItem())).getValue());
        } else {
            this.pp.remove("type");
        }
        return this.pp;
    }

    @Override
    public void setParam(Object condition) {
        this.setCustomCondition((RptProperties)condition);
    }

    @Override
    public void setCustomCondition(RptProperties ac) {
        this.pp = ac;
        try {
            this.fillDataToUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.pp = null;
        this.clearUI();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItem;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        if (this.cbxPeriodType.getSelectedItem() != null) {
            String periodType = String.valueOf(((RptPeriodTypeEnum)this.cbxPeriodType.getSelectedItem()).getValue());
            filterItem = new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.kDSpYear.getValue() != null) {
            String year = this.kDSpYear.getValue().toString();
            filterItem = new FilterItemInfo("year", (Object)year, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.kDSpPeriod.getValue() != null) {
            String period = this.kDSpPeriod.getValue().toString();
            filterItem = new FilterItemInfo("period", (Object)period, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.rptDate.getValue() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
            String date = dateFormat.format(this.rptDate.getValue());
            FilterItemInfo filterItem2 = new FilterItemInfo("date", (Object)date, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem2);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboElimMode.getSelectedItem() != null && ((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId() != null) {
            String elimMode = ((EliminationModeInfo)this.comboElimMode.getSelectedItem()).getId().toString();
            filterItem = new FilterItemInfo("elimMode", (Object)elimMode, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboHandleType.getSelectedItem() != null) {
            String handleType2 = String.valueOf(this.comboHandleType.getSelectedIndex());
            filterItem = new FilterItemInfo("handleType", (Object)handleType2, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.comboType.getSelectedItem() != null) {
            String type = String.valueOf(this.comboType.getSelectedIndex());
            filterItem = new FilterItemInfo("type", (Object)type, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem);
            sbFormula.append(" and #" + formulaIndex++);
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            String year;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                String periodType = (String)filterItemInfo.getCompareValue();
                RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((int)Integer.valueOf(periodType));
                this.cbxPeriodType.setSelectedItem((Object)periodTypeEnum);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                year = (String)filterItemInfo.getCompareValue();
                this.kDSpYear.setValue((Object)Integer.valueOf(year));
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                year = (String)filterItemInfo.getCompareValue();
                this.kDSpPeriod.setValue((Object)Integer.valueOf(year));
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("date")) {
                String dateStr = (String)filterItemInfo.getCompareValue();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
                try {
                    Date date = dateFormat.parse(dateStr);
                    this.rptDate.setValue((Object)date, false);
                }
                catch (ParseException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("elimMode")) {
                String elimModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.comboElimMode.getItemCount(); ++j) {
                    EliminationModeInfo elimMode;
                    if (this.comboElimMode.getItemAt(j) == null || ((EliminationModeInfo)this.comboElimMode.getItemAt(j)).getId() == null || (elimMode = (EliminationModeInfo)this.comboElimMode.getItemAt(j)) == null || !elimModeId.equals(elimMode.getId().toString())) continue;
                    this.comboElimMode.setSelectedIndex(j);
                    break;
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("handleType")) {
                String handleTypeStr = (String)filterItemInfo.getCompareValue();
                this.comboHandleType.setSelectedIndex(Integer.valueOf(handleTypeStr).intValue());
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("type")) continue;
            String type = (String)filterItemInfo.getCompareValue();
            this.comboType.setSelectedIndex(Integer.valueOf(type).intValue());
        }
        this.getCustomCondition();
    }

    private void clearUI() {
        try {
            this.cbxPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
            this.initDate();
            this.comboElimMode.setSelectedIndex(0);
            this.comboHandleType.setSelectedIndex(0);
            this.comboType.setSelectedIndex(0);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

