/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestDataMaintainCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestDataMaintainFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestDataMaintainInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestDataMaintain;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestDataMaintainEditUI;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ElimInvestDataMaintainEditUI
extends AbstractElimInvestDataMaintainEditUI {
    private static final long serialVersionUID = -1602518885734660435L;
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestDataMaintainEditUI.class);
    private java.util.Date lastChangeDate;
    private BigDecimal lastHonorSum = new BigDecimal("0");
    private String memory = "";
    private ElimInvestDataMaintainCollection col = null;
    private IElimInvestDataMaintain iinvestData = null;
    BigDecimal zero = new BigDecimal("0.00");

    @Override
    public void loadFields() {
        super.loadFields();
        this.showEditBtnByCreateOrg();
    }

    private void showEditBtnByCreateOrg() {
        String CurrentCreateOrgID;
        if ("ADDNEW".equals(this.getOprtState())) {
            return;
        }
        String CurrentOrgID = this.editData.getTrackRecordCreator().getId().toString();
        if (!CurrentOrgID.equals(CurrentCreateOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        java.util.Date investDate = this.editData.getInvestDate();
        this.editData.setSyncOldValue(true);
        this.editData.setInvestDate(RPTDateUtil.getBeginOfDay(investDate));
        this.editData.setCreatorUnit(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this.addCreateOrg();
        this.editData.setSyncOldValue(false);
    }

    private void addCreateOrg() {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("creatorUnit"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("company.*"));
        } else {
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("targetCompany.*"));
        } else {
            sic.add(new SelectorItemInfo("targetCompany.id"));
            sic.add(new SelectorItemInfo("targetCompany.number"));
            sic.add(new SelectorItemInfo("targetCompany.name"));
        }
        sic.add(new SelectorItemInfo("investDate"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("accumulationFound"));
        sic.add(new SelectorItemInfo("unsharedProfit"));
        sic.add(new SelectorItemInfo("surplusFound"));
        sic.add(new SelectorItemInfo("otherItem"));
        sic.add(new SelectorItemInfo("treasuryShares"));
        sic.add(new SelectorItemInfo("commonRiskReserve"));
        sic.add(new SelectorItemInfo("paidInCapital"));
        sic.add(new SelectorItemInfo("specialReserve"));
        sic.add(new SelectorItemInfo("foreignCurrencyTransDiff"));
        sic.add(new SelectorItemInfo("otherRITools"));
        sic.add(new SelectorItemInfo("otherComplexProceeds"));
        sic.add(new SelectorItemInfo("investEquity"));
        sic.add(new SelectorItemInfo("honor"));
        sic.add(new SelectorItemInfo("honorSum"));
        sic.add(new SelectorItemInfo("trackRecordCreator"));
        return sic;
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo curCompany;
        BOSUuid id;
        super.onLoad();
        CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtCompany, (boolean)false, (boolean)true, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.prmtCompany.setEditable(true);
        CompanyF7Helper.initCompanyBizUnitF7((KDBizPromptBox)this.prmtTargetCompany, (boolean)false, (boolean)true, null);
        this.prmtTargetCompany.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem);
        CurrencyCollection currencies = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
        BOSUuid bOSUuid = id = this.editData.getCurrency() != null ? this.editData.getCurrency().getId() : null;
        if (id == null && (curCompany = SysContext.getSysContext().getCurrentFIUnit()) != null && curCompany.getBaseCurrency() != null) {
            id = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId();
        }
        int i = 0;
        for (CurrencyInfo currency : currencies) {
            this.comboCurrency.addItem((Object)currency);
            if (currency.getId().equals((Object)id)) {
                this.comboCurrency.setSelectedIndex(i);
            }
            ++i;
        }
        this.setComponentRequired();
        this.initEvent();
        this.loadLastSumDatas();
        this.isAllowModifyBtn();
    }

    private void setComponentRequired() {
        this.prmtCompany.setRequired(true);
        this.prmtTargetCompany.setRequired(true);
        this.pkInvestDate.setRequired(true);
        this.comboCurrency.setRequired(true);
    }

    private void initEvent() {
        this.txtHonor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ElimInvestDataMaintainEditUI.this.txtHonor_dataChanged(e);
                }
                catch (Exception exc) {
                    ElimInvestDataMaintainEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ElimInvestDataMaintainEditUI.this.prmtCompany_dataChanged(e);
                }
                catch (Exception e1) {
                    ElimInvestDataMaintainEditUI.this.handUIException(e1);
                }
            }
        });
        this.prmtTargetCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ElimInvestDataMaintainEditUI.this.prmtTargetCompany_dataChanged(e);
                }
                catch (Exception e1) {
                    ElimInvestDataMaintainEditUI.this.handUIException(e1);
                }
            }
        });
        this.comboCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElimInvestDataMaintainEditUI.this.beforeActionPerformed(e);
                try {
                    ElimInvestDataMaintainEditUI.this.comboCurrency_actionPerformed(e);
                }
                catch (Exception exc) {
                    ElimInvestDataMaintainEditUI.this.handUIException(exc);
                }
                finally {
                    ElimInvestDataMaintainEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.pkInvestDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ElimInvestDataMaintainEditUI.this.memory = "";
                ElimInvestDataMaintainEditUI.this.loadLastSumDatas();
            }
        });
        this.txtPaidInCapital.setSupportedEmpty(true);
        this.txtTreasuryShares.setSupportedEmpty(true);
        this.txtCommonRiskReserve.setSupportedEmpty(true);
        this.txtSpecialReserve.setSupportedEmpty(true);
        this.txtOtherItem.setSupportedEmpty(true);
        this.txtAccumulationFound.setSupportedEmpty(true);
        this.txtSurplusFound.setSupportedEmpty(true);
        this.txtUnsharedProfit.setSupportedEmpty(true);
        this.txtForeignCurrencyTransDiff.setSupportedEmpty(true);
        this.txtHonor.setSupportedEmpty(true);
        this.txtOtherRITools.setSupportedEmpty(true);
        this.txtOtherComplexProceeds.setSupportedEmpty(true);
        this.txtInvestEquity.setSupportedEmpty(true);
    }

    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.loadLastSumDatas();
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.loadLastSumDatas();
    }

    protected void prmtTargetCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.loadLastSumDatas();
    }

    private void txtHonor_dataChanged(DataChangeEvent e) {
        BigDecimal honor = this.txtHonor.getBigDecimalValue() != null ? this.txtHonor.getBigDecimalValue() : new BigDecimal(0.0);
        this.txtHonorSum.setValue((Object)honor.add(this.lastHonorSum));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.loadLastSumDatas();
        this.txtHonor_dataChanged(null);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtHonorSum.setEditable(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCancelCancel.setVisible(false);
    }

    protected IObjectValue createNewData() {
        ElimInvestDataMaintainInfo info = new ElimInvestDataMaintainInfo();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            info.setCurrency((CurrencyInfo)this.getUIContext().get("unitCurrency"));
        }
        info.setInvestDate(new java.util.Date());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimInvestDataMaintainFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.loadLastSumDatas();
        if (this.lastChangeDate != null && !DateTimeUtils.dayBefore((java.util.Date)this.lastChangeDate, (java.util.Date)this.editData.getInvestDate())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_InvestDateError")));
        }
        if (this.txtRemark.getText() != null && this.txtRemark.getText().length() > 255) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"452_ElimInvestDataMaintainEditUI")));
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.pkInvestDate.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_ChangeDateIsNull")));
        }
        if (this.prmtCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_CompanyIsNull")));
        }
        if (this.prmtTargetCompany.getData() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_TargetCompanyIsNull")));
        }
        if (((CompanyOrgUnitInfo)this.prmtCompany.getData()).getName().equalsIgnoreCase(((CompanyOrgUnitInfo)this.prmtTargetCompany.getData()).getName())) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_InvestDay_CompanyIsRepeat")));
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Currency_Blank")));
        }
        boolean ishaveItemVal = false;
        BigDecimal zero = new BigDecimal(0.0);
        if (this.hasInputValue(this.txtPaidInCapital)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtTreasuryShares)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtCommonRiskReserve)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtSpecialReserve)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtOtherItem)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtAccumulationFound)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtSurplusFound)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtUnsharedProfit)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtForeignCurrencyTransDiff)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtHonor)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtOtherRITools)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtOtherComplexProceeds)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal && this.hasInputValue(this.txtInvestEquity)) {
            ishaveItemVal = true;
        } else if (!ishaveItemVal) {
            this.txtAccumulationFound.setValue(null);
            this.txtHonor.setValue(null);
            this.txtOtherItem.setValue(null);
            this.txtSurplusFound.setValue(null);
            this.txtUnsharedProfit.setValue(null);
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"453_ElimInvestDataMaintainEditUI")));
        }
    }

    private boolean hasInputValue(KDFormattedTextField text) {
        return text.getBigDecimalValue() != null && text.getBigDecimalValue().compareTo(this.zero) != 0;
    }

    private void loadLastSumDatas() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (this.prmtCompany.getData() != null && this.prmtTargetCompany.getData() != null && this.comboCurrency.getSelectedItem() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            CompanyOrgUnitInfo targetCompany = (CompanyOrgUnitInfo)this.prmtTargetCompany.getData();
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            Date investDate = this.pkInvestDate.getSqlDate();
            try {
                if (this.iinvestData == null) {
                    this.iinvestData = ElimInvestDataMaintainFactory.getRemoteInstance();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("select id,investDate,honorSum ");
                buffer.append(" where company.id = '");
                buffer.append(company.getId().toString());
                buffer.append("' and targetCompany.id = '");
                buffer.append(targetCompany.getId().toString());
                buffer.append("' and currency.id = '");
                buffer.append(currency.getId().toString());
                if (!"ADDNEW".equals(this.getOprtState()) && investDate != null) {
                    buffer.append("' and investDate < '");
                    buffer.append(investDate);
                }
                buffer.append("' order by investDate desc");
                if (this.memory.equals("")) {
                    this.memory = buffer.toString();
                    this.col = this.iinvestData.getElimInvestDataMaintainCollection(buffer.toString());
                } else if (!this.memory.equals("") && !this.memory.equals(buffer.toString())) {
                    this.col = this.iinvestData.getElimInvestDataMaintainCollection(buffer.toString());
                }
                Iterator iter = this.col.iterator();
                if (iter.hasNext()) {
                    ElimInvestDataMaintainInfo info = (ElimInvestDataMaintainInfo)iter.next();
                    this.lastHonorSum = info.getHonorSum() != null ? info.getHonorSum() : new BigDecimal(0.0);
                    this.lastChangeDate = info.getInvestDate();
                    return;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.lastHonorSum = new BigDecimal(0.0);
        this.lastChangeDate = null;
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.isAllowModifyBtn();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.isAllowModifyBtn();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.isAllowModifyBtn();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.isAllowModifyBtn();
    }

    private void isAllowModifyBtn() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            if (this.isSameOrgUnit()) {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
        } else if (this.getOprtState().equals(OprtState.EDIT) && !this.isSameOrgUnit()) {
            this.actionRemove.setEnabled(false);
        }
    }

    private boolean isSameOrgUnit() {
        String unitId = this.editData.getCreatorUnit();
        return unitId != null && unitId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String creatorUnit = this.editData.getCreatorUnit();
        OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
        if (creatorUnit == null || !creatorUnit.equals(company.getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"455_ElimInvestDataMaintainListUI"));
            SysUtil.abort();
            return;
        }
        super.actionRemove_actionPerformed(e);
    }
}

