/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.IElimInvestRate;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestRateEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateSelectF7Dialog;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ElimInvestRateEditUI
extends AbstractElimInvestRateEditUI {
    private static final int IS_LATEST = 1;
    private static final long serialVersionUID = 4727414241966683335L;
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestRateEditUI.class);
    private ICSLContext ctx = null;
    private String orgBoundId = null;
    private IElimInvestRate IElimInvestRate = null;
    private OrgTreeInfo orgBound = null;
    private int rptYear;
    private RptPeriodTypeEnum rptPeriodType = null;
    private int rptPeriod;
    private Date reportDate = null;
    private OrgUnitInfo orgUnit = null;
    private Date oldDate = null;
    private KDBizPromptBox PromptCompany = null;
    private MergeModeEnum mergeMode = null;
    private FullOrgUnitInfo topUnitHoldingCompany = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initTable() throws Exception {
        this.kDTCompany.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    ElimInvestRateEditUI.this.kdtEntrysChanged(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    ElimInvestRateEditUI.this.handUIException(exc);
                }
            }
        });
        this.kDTCompany.checkParsed();
        this.PromptCompany = new KDBizPromptBox();
        this.initPrmtCompany(this.PromptCompany, 1);
        KDTDefaultCellEditor companyCellEditor = new KDTDefaultCellEditor((IKDEditor)this.PromptCompany);
        this.kDTCompany.getColumn("company").setEditor((ICellEditor)companyCellEditor);
        this.PromptCompany.setDisplayFormat("$number$");
        this.PromptCompany.setEditable(false);
        ObjectValueRender kdtkDTCompanyRender = new ObjectValueRender();
        kdtkDTCompanyRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTCompany.getColumn("company").setRenderer((IBasicRender)kdtkDTCompanyRender);
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setPrecision(13);
        KDTDefaultCellEditor rateEditor = new KDTDefaultCellEditor((JTextField)formatField);
        formatField.setDataType(1);
        this.kDTCompany.getColumn("rate").setEditor((ICellEditor)rateEditor);
        this.kDTCompany.getColumn("rate").getStyleAttributes().setNumberFormat("%R-{#0.#############}f");
        this.kDTCompany.getColumn("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setPrecision(13);
        rateEditor = new KDTDefaultCellEditor((JTextField)formatField);
        formatField.setDataType(1);
        this.kDTCompany.getColumn("equivRate").setEditor((ICellEditor)rateEditor);
        this.kDTCompany.getColumn("equivRate").getStyleAttributes().setNumberFormat("%R-{#0.#############}f");
        this.kDTCompany.getColumn("equivRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDPromptBox promptTemplate = new KDPromptBox();
        TemplateSelectF7Dialog templateSelectF7Dialog = new TemplateSelectF7Dialog((IUIObject)this);
        templateSelectF7Dialog.setMultiSelect(true);
        promptTemplate.setSelector((KDPromptSelector)templateSelectF7Dialog);
        promptTemplate.setVisible(true);
        promptTemplate.setEditable(false);
        promptTemplate.setEnabled(true);
        KDTDefaultCellEditor templateCellEditor = new KDTDefaultCellEditor((IKDEditor)promptTemplate);
        this.kDTCompany.getColumn("template").setEditor((ICellEditor)templateCellEditor);
        promptTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox promptBox = (KDPromptBox)e.getSource();
                TemplateSelectF7Dialog templateSelectF7Dialog = (TemplateSelectF7Dialog)promptBox.getSelector();
                UIContext uiContext = new UIContext();
                uiContext.put((Object)"template", promptBox.getValue());
                templateSelectF7Dialog.setUiContext(uiContext);
            }
        });
        promptTemplate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDPromptBox promptTemplateBox = (KDPromptBox)e.getSource();
                Object data = promptTemplateBox.getData();
                if ("removeAll".equals(data)) {
                    promptTemplateBox.setData(null);
                }
            }
        });
        this.PromptCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object data = ElimInvestRateEditUI.this.PromptCompany.getData();
                if (data instanceof CompanyOrgUnitInfo) {
                    FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                    CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)data;
                    orgUnit.setId(companyOrgUnitInfo.getId());
                    orgUnit.setNumber(companyOrgUnitInfo.getNumber());
                    orgUnit.setName(companyOrgUnitInfo.getName());
                    ElimInvestRateEditUI.this.PromptCompany.setData((Object)orgUnit);
                } else if (data instanceof OrgStructureInfo) {
                    ElimInvestRateEditUI.this.PromptCompany.setData((Object)((OrgStructureInfo)data).getUnit());
                }
            }
        });
        KDTextField textField = new KDTextField();
        textField.setMaxLength(80);
        this.kDTCompany.getColumn("description").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kDTCompany.getColumn("rate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kDTCompany.getColumn("equivRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.kDTCompany.putBindContents("editData", new String[]{"id", "company", "rate", "equivRate", "template", "description", "year", "period", "periodtype", "orgBound.id", "orgUnit.id", "isLatest", "isMonthLatest", "isClearCompany"});
        this.registerBindings();
    }

    private void kdtEntrysChanged(int rowIndex, int colIndex) {
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        if (!"ADDNEW".equals(this.getOprtState())) {
            this.initTableData(dataObject);
        }
        super.setDataObject(ov);
        this.editData = (ElimInvestRateInfo)ov;
        this.oldDate = this.editData.getDate();
    }

    private void initTableData(IObjectValue dataObject) {
        ElimInvestRateInfo elimInvestRateInfo = (ElimInvestRateInfo)dataObject;
        FullOrgUnitInfo OrgUnitInfo2 = elimInvestRateInfo.getTargetCompany();
        this.orgUnit = elimInvestRateInfo.getOrgUnit();
        if (null == OrgUnitInfo2) {
            return;
        }
        String targetCompId = OrgUnitInfo2.getId().toString();
        IElimInvestRate IElimInvestRate2 = null;
        try {
            IElimInvestRate2 = ElimInvestRateFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add("company.id");
            selectorItemCollection.add("company.number");
            selectorItemCollection.add("company.name");
            selectorItemCollection.add("template");
            selectorItemCollection.add("rate");
            selectorItemCollection.add("equivRate");
            selectorItemCollection.add("description");
            selectorItemCollection.add("year");
            selectorItemCollection.add("period");
            selectorItemCollection.add("periodType");
            selectorItemCollection.add("rptDate");
            selectorItemCollection.add("orgBound.id");
            selectorItemCollection.add("orgUnit.id");
            selectorItemCollection.add("orgUnit.number");
            selectorItemCollection.add("orgUnit.name");
            selectorItemCollection.add("isLatest");
            selectorItemCollection.add("isMonthLatest");
            selectorItemCollection.add("isClearCompany");
            viewInfo.setSelector(selectorItemCollection);
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBoundId));
            filterInfo.getFilterItems().add(new FilterItemInfo("targetCompany", (Object)targetCompId));
            filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)this.reportDate));
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("isLatest", (Object)new Integer(1)));
            ElimInvestRateCollection elimInvestRateCollection = IElimInvestRate2.getElimInvestRateCollection(viewInfo);
            elimInvestRateInfo.setEntries(elimInvestRateCollection);
        }
        catch (BOSException bosEx) {
            this.handUIException(bosEx);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("VIEW".equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.lockUIForViewStatus();
        } else {
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnFirst.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnAddNew.setEnabled(false);
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
            this.actionAddLine_actionPerformed(null);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnAddNew.setEnabled(true);
            if (this.getUIContext().get("isChange") != null) {
                this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Change"));
            } else {
                this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
            }
            this.prmtTargetCompany.setEditable(false);
            this.prmtTargetCompany.setEnabled(false);
        }
        if (0 == this.mergeMode.getValue()) {
            this.kDTCompany.getColumn("company").getStyleAttributes().setLocked(true);
        }
    }

    private void init() throws Exception {
        Map thsiCtx = this.getUIContext();
        ListUI curObj = (ListUI)thsiCtx.get("Owner");
        Map uiContext = curObj.getUIContext();
        if (uiContext != null) {
            this.ctx = uiContext.containsKey("ctx") ? (ICSLContext)uiContext.get("ctx") : CSLContextHelper.getCSLContext();
        }
        this.orgBoundId = this.ctx.getCurOrgBound().getId().toString();
        this.IElimInvestRate = ElimInvestRateFactory.getRemoteInstance();
        this.orgBound = this.ctx.getCurOrgBound();
        this.rptYear = this.ctx.getCurRptYear();
        this.rptPeriodType = this.ctx.getCurRptPeriodType();
        this.rptPeriod = this.ctx.getCurRptPeriod();
        this.reportDate = this.ctx.getCurReportDate();
        this.orgUnit = this.ctx.getCurOrgGroup();
        this.initPrmtCompany(this.prmtTargetCompany, 3);
        this.prmtTargetCompany.setDisplayFormat("$name$");
        this.prmtTargetCompany.setCommitFormat("$number$");
        this.prmtTargetCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object data = ElimInvestRateEditUI.this.prmtTargetCompany.getData();
                if (data instanceof CompanyOrgUnitInfo) {
                    FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
                    CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)data;
                    orgUnit.setId(companyOrgUnitInfo.getId());
                    orgUnit.setNumber(companyOrgUnitInfo.getNumber());
                    orgUnit.setName(companyOrgUnitInfo.getName());
                    ElimInvestRateEditUI.this.prmtTargetCompany.setData((Object)orgUnit);
                } else if (data instanceof OrgStructureInfo) {
                    ElimInvestRateEditUI.this.prmtTargetCompany.setData((Object)((OrgStructureInfo)data).getUnit());
                }
            }
        });
        this.initTable();
        this.mergeMode = CslRptUtil.getMergeMode(this.orgBound);
        if (0 == this.mergeMode.getValue()) {
            this.initTopUnit();
        }
    }

    private void initTopUnit() throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureCollection col = iStruct.getOrgStructureCollection("select id, unit.*,unit.partUnionGroup.* where parent = null and tree.id = '" + this.orgBound.getId().toString() + "'");
        if (null == col || 0 == col.size()) {
            return;
        }
        OrgStructureInfo structureInfo = col.get(0);
        FullOrgUnitInfo unit = structureInfo.getUnit();
        if (unit.getPartUnionGroup().getStockControlCompany() == null) {
            throw new ReportException(ReportException.HOLDING_COMPANY_NULL, new Object[]{unit.getName()});
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + unit.getPartUnionGroup().getStockControlCompany().getId() + "'");
        this.topUnitHoldingCompany = new FullOrgUnitInfo();
        this.topUnitHoldingCompany.setId(company.getId());
        this.topUnitHoldingCompany.setName(company.getName());
    }

    private void registerBindings() {
        this.dataBinder.registerBinding("entries.id", BOSUuid.class, (Component)this.kDTCompany, "id.text");
        this.dataBinder.registerBinding("entries", ElimInvestRateInfo.class, (Component)this.kDTCompany, "userObject");
        this.dataBinder.registerBinding("entries.company", OrgUnitInfo.class, (Component)this.kDTCompany, "company.text");
        this.dataBinder.registerBinding("entries.rate", BigDecimal.class, (Component)this.kDTCompany, "rate.text");
        this.dataBinder.registerBinding("entries.equivRate", BigDecimal.class, (Component)this.kDTCompany, "equivRate.text");
        this.dataBinder.registerBinding("entries.template", String.class, (Component)this.kDTCompany, "template.text");
        this.dataBinder.registerBinding("entries.description", String.class, (Component)this.kDTCompany, "description.text");
        this.dataBinder.registerBinding("entries.year", BigDecimal.class, (Component)this.kDTCompany, "year.text");
        this.dataBinder.registerBinding("entries.period", BigDecimal.class, (Component)this.kDTCompany, "period.text");
        this.dataBinder.registerBinding("entries.periodType", RptPeriodTypeEnum.class, (Component)this.kDTCompany, "periodtype.text");
        this.dataBinder.registerBinding("entries.orgBound.id", String.class, (Component)this.kDTCompany, "orgbound.text");
        this.dataBinder.registerBinding("entries.orgUnit.id", String.class, (Component)this.kDTCompany, "orgunit.text");
        this.dataBinder.registerBinding("entries.isLatest", String.class, (Component)this.kDTCompany, "isLatest.text");
        this.dataBinder.registerBinding("entries.isLatest", String.class, (Component)this.kDTCompany, "isMonthLatest.text");
        this.dataBinder.registerBinding("entries.isClearCompany", String.class, (Component)this.kDTCompany, "isClearCompany.text");
    }

    private void initPrmtCompany(KDBizPromptBox prompt, int selectMode) throws Exception {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setTreeID(this.orgBoundId);
        f7.setMultiSelect(false);
        f7.setNeedAddOrgRange(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        prompt.setSelector((KDPromptSelector)f7);
        prompt.setEditable(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.setEditDataEntries();
        }
        if (null == this.prmtTargetCompany.getValue()) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TargetCompany_IsNull")));
        }
        if (null == this.pkDate.getValue()) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Effact_Date_Null")));
        }
        Date curDate = (Date)this.pkDate.getValue();
        if (curDate.after(this.reportDate)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"456_ElimInvestRateEditUI")));
        }
        if (this.oldDate != null) {
            boolean isLessEqualThanHistoryMaxDate;
            java.sql.Date newDate = this.pkDate.getSqlDate();
            boolean isChange = this.getUIContext().get("isChange") != null;
            int dateCompareVal = newDate.compareTo(this.oldDate);
            if (isChange && dateCompareVal <= 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_EffectDate_Latest")));
            }
            if (dateCompareVal < 0 && (isLessEqualThanHistoryMaxDate = this.isLessEqualThanHistoryMaxDate(newDate))) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_EffectDate_MustGreatThanHistoryDate")));
            }
        }
        Iterator iter = this.editData.getEntries().iterator();
        ElimInvestRateInfo elimInvestRateInfo = null;
        ArrayList<String> companyList = new ArrayList<String>();
        BigDecimal sumRate = new BigDecimal("0");
        BigDecimal sumEquivRate = new BigDecimal("0");
        boolean isNullFromEquivRate = false;
        while (iter.hasNext()) {
            elimInvestRateInfo = (ElimInvestRateInfo)iter.next();
            if (null == elimInvestRateInfo.get("company")) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Company_NotNull")));
            }
            FullOrgUnitInfo company = null;
            if (elimInvestRateInfo.get("company") instanceof CompanyOrgUnitInfo) {
                company = new FullOrgUnitInfo();
                company.setId(((CompanyOrgUnitInfo)elimInvestRateInfo.get("company")).getId());
            } else {
                company = elimInvestRateInfo.getCompany();
            }
            if (company.getId().toString().equals(((OrgUnitInfo)this.prmtTargetCompany.getValue()).getId().toString())) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Company_Self")));
            }
            if (companyList.contains(company.getId().toString())) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Company_Repeat")));
            }
            companyList.add(company.getId().toString());
            if (null == elimInvestRateInfo.getRate()) {
                // empty if block
            }
            if (elimInvestRateInfo.getRate() != null && (elimInvestRateInfo.getRate().doubleValue() < 0.0 || elimInvestRateInfo.getRate().doubleValue() > 100.0)) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"457_ElimInvestRateEditUI")));
            }
            BigDecimal equivRate = elimInvestRateInfo.getEquivRate();
            isNullFromEquivRate = equivRate == null;
            if (!isNullFromEquivRate && (elimInvestRateInfo.getEquivRate().doubleValue() <= 0.0 || elimInvestRateInfo.getEquivRate().doubleValue() > 100.0)) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"458_ElimInvestRateEditUI")));
            }
            if (elimInvestRateInfo.getBigDecimal("rate") != null) {
                sumRate = sumRate.add(elimInvestRateInfo.getBigDecimal("rate"));
            }
            sumEquivRate = sumEquivRate.add(isNullFromEquivRate ? new BigDecimal("0") : equivRate);
        }
        if (this.kDTCompany.getRowCount() < 1) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Company_NotNull")));
        }
        if (sumRate.doubleValue() < 0.0 || sumRate.doubleValue() > 100.0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Rate_Rule")));
        }
        if (sumEquivRate.doubleValue() < 0.0 || sumEquivRate.doubleValue() > 100.0) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_EquivRate_Rule")));
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtTargetCompany.getData();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.orgBoundId));
            filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)this.reportDate));
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
            filterInfo.getFilterItems().add(new FilterItemInfo("targetCompany.id", (Object)orgUnitInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
            if (this.IElimInvestRate.exists(filterInfo)) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Invest_Repeat")));
            }
        }
    }

    private void setEditDataEntries() {
        int rowCount = this.kDTCompany.getRowCount();
        IRow tableRow = null;
        this.editData.getEntries().clear();
        for (int i = 0; i < rowCount; ++i) {
            tableRow = this.kDTCompany.getRow(i);
            ElimInvestRateInfo elimInvestRateInfo2 = (ElimInvestRateInfo)this.createNewData();
            if (tableRow.getCell("id").getValue() != null) {
                elimInvestRateInfo2.setId((BOSUuid)tableRow.getCell("id").getValue());
            }
            elimInvestRateInfo2.setCompany((FullOrgUnitInfo)tableRow.getCell("company").getValue());
            if (tableRow.getCell("rate").getValue() != null && !"".equals(tableRow.getCell("rate").getValue())) {
                elimInvestRateInfo2.setRate(new BigDecimal(tableRow.getCell("rate").getValue().toString()));
            }
            if (tableRow.getCell("equivRate").getValue() != null && !"".equals(tableRow.getCell("equivRate").getValue())) {
                elimInvestRateInfo2.setEquivRate(new BigDecimal(tableRow.getCell("equivRate").getValue().toString()));
            }
            elimInvestRateInfo2.setTemplate((String)tableRow.getCell("template").getValue());
            elimInvestRateInfo2.setDescription((String)tableRow.getCell("description").getValue());
            elimInvestRateInfo2.setIsClearCompany((Boolean)tableRow.getCell("isClearCompany").getValue());
            this.editData.getEntries().add(elimInvestRateInfo2);
        }
    }

    private boolean isLessEqualThanHistoryMaxDate(Date newDatePara) throws EASBizException, BOSException {
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.prmtTargetCompany.getData();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        items.add(new FilterItemInfo("orgBound.id", (Object)this.orgBoundId));
        items.add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnit.getId().toString()));
        items.add(new FilterItemInfo("targetCompany.id", (Object)orgUnitInfo.getId().toString()));
        items.add(new FilterItemInfo("period", (Object)new Integer(this.rptPeriod)));
        items.add(new FilterItemInfo("year", (Object)new Integer(this.rptYear)));
        items.add(new FilterItemInfo("isLatest", (Object)false));
        items.add(new FilterItemInfo("date", (Object)newDatePara, CompareType.GREATER_EQUALS));
        return this.IElimInvestRate.exists(filterInfo);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.btnRemoveLine.setEnabled(true);
        this.addLine(this.kDTCompany);
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData();
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            try {
                boolean isEdit;
                boolean bl = isEdit = this.getOprtState().equals(OprtState.EDIT) && this.getUIContext().get("isChange") == null;
                if (isEdit) {
                    Map<String, ElimInvestRateInfo> existHisInvestRates;
                    ArrayList<String> ids = new ArrayList<String>();
                    for (int m = indexArr.length - 1; m >= 0; --m) {
                        int rowIndex = Integer.parseInt(String.valueOf(indexArr[m]));
                        IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                        if (((ElimInvestRateInfo)detailData).getId() == null || !BigDecimal.ZERO.equals(((ElimInvestRateInfo)detailData).getRate())) continue;
                        ids.add(((ElimInvestRateInfo)detailData).getId().toString());
                    }
                    if (!ids.isEmpty() && (existHisInvestRates = CslRptUIUtil.getExistHisInvestRates(ids)) != null && !existHisInvestRates.isEmpty()) {
                        MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"existHisRateCantDel"), existHisInvestRates.values().iterator().next().getCompany().getName()));
                        SysUtil.abort();
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                this.handUIException(ex);
                SysUtil.abort();
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kDTCompany);
        if (this.kDTCompany.getRowCount() == 0) {
            FocusTraversalPolicy policy = null;
            Object container = null;
            Component initComponent = null;
            if (this.getFocusTraversalPolicy() != null && this.getFocusTraversalPolicy() instanceof UIFocusTraversalPolicy) {
                policy = this.getFocusTraversalPolicy();
                container = this;
                Component[] traverComponent = ((UIFocusTraversalPolicy)policy).getComponents();
                for (int i = 0; i < traverComponent.length; ++i) {
                    if (traverComponent[i] != this.kDTCompany) continue;
                    initComponent = traverComponent[i];
                    break;
                }
                if (initComponent == null) {
                    initComponent = policy.getLastComponent((Container)container);
                    initComponent.requestFocusInWindow();
                } else if (initComponent != null) {
                    Component component = policy.getComponentBefore((Container)container, initComponent);
                    while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                        component = policy.getComponentBefore((Container)container, component);
                    }
                    component.requestFocusInWindow();
                }
            } else if (policy == null) {
                if (this.getUIWindow() instanceof Dialog) {
                    policy = ((Dialog)this.uiWindow).getFocusTraversalPolicy();
                    container = (Dialog)this.uiWindow;
                } else if (this.getUIWindow() instanceof Window) {
                    policy = ((Window)this.uiWindow).getFocusTraversalPolicy();
                    container = (Window)this.uiWindow;
                }
                if (policy != null) {
                    try {
                        Component component = policy.getComponentBefore((Container)container, (Component)this.kDTCompany);
                        while (!(component instanceof IKDTextComponent) || !component.isEnabled()) {
                            component = policy.getComponentBefore((Container)container, component);
                        }
                        component.requestFocusInWindow();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        List idNewList = null;
        ElimInvestRateCollection elimColl = this.editData.getEntries();
        for (int i = 0; i < elimColl.size(); ++i) {
            if (!BigDecimal.ZERO.equals(elimColl.get(i).getRate())) continue;
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"elimRateZero"), elimColl.get(i).getCompany().getName()));
                return;
            }
            if (!this.getOprtState().equals(OprtState.EDIT) || this.getUIContext().get("isChange") != null) continue;
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(elimColl.get(i).getId().toString());
            Map<String, ElimInvestRateInfo> existHisInvestRates = CslRptUIUtil.getExistHisInvestRates(ids);
            if (existHisInvestRates != null && !existHisInvestRates.isEmpty()) continue;
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"elimRateZero"), elimColl.get(i).getCompany().getName()));
            return;
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            idNewList = this.IElimInvestRate.addNewElimInvestRate((IObjectValue)this.editData);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            idNewList = this.getUIContext().get("isChange") != null ? this.IElimInvestRate.addNewElimInvestRate((IObjectValue)this.editData) : this.IElimInvestRate.updateElimInvestRate((IObjectValue)this.editData);
            this.setDataObject((IObjectValue)this.editData);
        }
        if (idNewList != null) {
            for (Object pk : idNewList) {
                this.idList.add(pk.toString());
            }
        }
        if (null == this.getUIContext().get("isChange")) {
            this.showMessageForStatus();
            this.showSubmitSuccess();
        } else {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ElimInvestRate_Change_Success"));
            this.setIsShowTextOnly(true);
            this.showMessage();
        }
        this.setSave(true);
        this.setSaved(true);
        if (this.chkMenuItemSubmitAndAddNew.isSelected() && this.chkMenuItemSubmitAndAddNew.isVisible() && OprtState.ADDNEW.equals(this.getOprtState())) {
            this.afterSubmitAddNew();
            this.actionAddLine_actionPerformed(null);
            this.initOldData((IObjectValue)this.editData);
            return;
        }
        this.setOprtState(OprtState.EDIT);
        if (this.getUIContext().get("isChange") != null) {
            this.getUIContext().put("isChange", null);
        }
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void afterSubmitAddNew() {
        this.setOprtState(OprtState.ADDNEW);
        if (this.isSubmitLoad()) {
            this.setDataObject(this.createNewData());
            this.loadFields();
        }
        this.initScrollButtons();
        this.setDefaultFocused();
        this.appendFootRow(null);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.prmtTargetCompany.setEnabled(true);
        this.kDTCompany.removeRows();
        this.actionAddLine_actionPerformed(null);
    }

    protected IObjectValue createNewData() {
        ElimInvestRateInfo elimInvestRateInfo = new ElimInvestRateInfo();
        elimInvestRateInfo.setDate(new Date());
        elimInvestRateInfo.setYear(this.rptYear);
        elimInvestRateInfo.setRptDate(this.reportDate);
        elimInvestRateInfo.setPeriod(this.rptPeriod);
        elimInvestRateInfo.setPeriodType(this.rptPeriodType);
        elimInvestRateInfo.setOrgBound(this.orgBound);
        elimInvestRateInfo.setOrgUnit((FullOrgUnitInfo)this.orgUnit);
        elimInvestRateInfo.setIsLatest(true);
        if (this.mergeMode.getValue() == 0) {
            elimInvestRateInfo.setCompany(this.topUnitHoldingCompany);
        }
        return elimInvestRateInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElimInvestRateFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        return sic;
    }
}

