/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractElimInvestRateHisListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElimInvestRateHisListUI
extends AbstractElimInvestRateHisListUI {
    private static final Logger logger = CoreUIObject.getLogger(ElimInvestRateHisListUI.class);
    private ICSLContext ctx = CSLContextHelper.getCSLContext();
    private String selectId = null;

    private void setTableStyle() {
        this.tblMain.getColumn("date").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void onLoad() throws Exception {
        Map thsiCtx = this.getUIContext();
        ListUI curObj = (ListUI)thsiCtx.get("Owner");
        Map uiContext = curObj.getUIContext();
        if (uiContext != null) {
            if (uiContext.containsKey("ctx")) {
                this.ctx = (ICSLContext)uiContext.get("ctx");
                if (uiContext.containsKey("selectIds")) {
                    this.selectId = (String)((List)uiContext.get("selectIds")).get(0);
                    ElimInvestRateInfo info = ElimInvestRateFactory.getRemoteInstance().getElimInvestRateInfo("select orgUnit where id='" + this.selectId + "'");
                    ((CSLContext)this.ctx).setCurOrgGroup((OrgUnitInfo)info.getOrgUnit());
                }
            } else {
                this.ctx = CSLContextHelper.getCSLContext();
            }
        }
        super.onLoad();
        this.groupTableRow();
        this.setTableStyle();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        int rptPeriod = 0;
        RptPeriodTypeEnum periodType = null;
        try {
            rptPeriod = this.ctx.getCurRptPeriod();
            periodType = this.ctx.getCurRptPeriodType();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ElimInvestRate.period", (Object)new Integer(rptPeriod)));
            return filter;
        }
        return null;
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("targetCompany.name").setGroup(true);
        this.tblMain.getColumn("date").setGroup(true);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        String orgBoundId = null;
        Date rptDate = null;
        String orgUnitId = null;
        try {
            orgBoundId = this.ctx.getCurOrgBound().getId().toString();
            orgUnitId = this.ctx.getCurOrgGroup().getId().toString();
            rptDate = this.ctx.getCurReportDate();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        String targetCompanyId = (String)this.getUIContext().get("targetCompanyId");
        try {
            exec.setParameter(1, (Object)targetCompanyId);
            exec.setParameter(2, (Object)new Timestamp(rptDate.getTime()));
            exec.setParameter(3, (Object)orgUnitId);
            exec.setParameter(4, (Object)orgBoundId);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return exec;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

